% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2.mxPBF.R
\name{mean2.mxPBF}
\alias{mean2.mxPBF}
\title{Two-sample Mean Test with Maximum Pairwise Bayes Factor}
\usage{
mean2.mxPBF(X, Y, a0 = 2, b0 = 2, gamma = 1, nthreads = 1)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{a0}{shape parameter for inverse-gamma prior.}

\item{b0}{scale parameter for inverse-gamma prior.}

\item{gamma}{non-negative variance scaling parameter.}

\item{nthreads}{number of threads for parallel execution via OpenMP.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{maximum of pairwise Bayes factor.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
\item{log.BF.vec}{vector of pairwise Bayes factors in natural log.}
}
}
\description{
Not Written Here - No Reference Yet.
}
\examples{
\dontrun{
## empirical Type 1 error with BF threshold = 10
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(100*10), ncol=10)
  Y = matrix(rnorm(200*10), ncol=10)
  
  counter[i] = ifelse(mean2.mxPBF(X,Y)$statistic > 10, 1, 0)
}

## print the result
cat(paste("\n* Example for 'mean2.mxPBF'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\concept{mean_multivariate}
