% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Projection_Directions.R
\name{Direction_fixedtuning}
\alias{Direction_fixedtuning}
\title{Constructs the projection direction with a fixed tuning parameter}
\usage{
Direction_fixedtuning(
  X,
  loading,
  mu = NULL,
  model = "linear",
  weight = NULL,
  deriv.vec = NULL
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{loading}{Loading, of length \eqn{p}}

\item{mu}{The dual tuning parameter used in the construction of the projection direction}

\item{model}{The high dimensional regression model, either \code{linear} or \code{logistic} (default = \code{linear})}

\item{weight}{The weight vector of length \eqn{n}; to be supplied if \code{model="logistic"} (default=\code{NULL} when \code{model=linear})}

\item{deriv.vec}{The first derivative vector of the logit function at \eqn{X\%*\%}(\code{init.Lasso}), of length \eqn{n} ; to be supplied if \code{model="logistic"}. Here \code{init.Lasso} is the initial Lasso estimate of the regression vector. (default = \code{NULL} when \code{model=linear})}
}
\value{
\item{proj}{The projection direction, of length \eqn{p}}
}
\description{
Constructs the projection direction, used for bias-correction, with a fixed tuning parameter
}
\examples{
n <- 100
p <- 400
X <- matrix(sample(-2:2,n*p,replace = TRUE),nrow = n,ncol = p)
resol <- 1.5
step <- 3
Est <- Direction_fixedtuning(X,loading=c(1,rep(0,(p-1))),mu=sqrt(2.01*log(p)/n)*resol^{-(step-1)})
}
