% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_linear.R
\name{ITE}
\alias{ITE}
\title{Individualized treatment effect in the high dimensional linear regression}
\usage{
ITE(
  X1,
  y1,
  X2,
  y2,
  loading,
  intercept = TRUE,
  init.Lasso1 = NULL,
  init.Lasso2 = NULL,
  lambda1 = NULL,
  lambda2 = NULL,
  mu1 = NULL,
  mu2 = NULL,
  step1 = NULL,
  step2 = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X1}{Design matrix for the first sample, of dimension \eqn{n_1} x \eqn{p}}

\item{y1}{Outcome vector for the first sample, of length \eqn{n_1}}

\item{X2}{Design matrix for the second sample, of dimension \eqn{n_2} x \eqn{p}}

\item{y2}{Outcome vector for the second sample, of length \eqn{n_2}}

\item{loading}{Loading, of length \eqn{p}}

\item{intercept}{Should intercept(s) be fitted (default = \code{TRUE})}

\item{init.Lasso1}{Initial LASSO estimator of the first regression vector (default = \code{NULL})}

\item{init.Lasso2}{Initial LASSO estimator of the second regression vector (default = \code{NULL})}

\item{lambda1}{The tuning parameter in the construction of LASSO estimator of the first regression vector (default = \code{NULL})}

\item{lambda2}{The tuning parameter in the construction of LASSO estimator of the second regression vector (default = \code{NULL})}

\item{mu1}{The dual tuning parameter used in the construction of the first projection direction (default = \code{NULL})}

\item{mu2}{The dual tuning parameter used in the construction of the second projection direction (default = \code{NULL})}

\item{step1}{The step size used to compute \code{mu1}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu1}
such that the dual optimization problem for constructing the first projection direction converges (default = \code{NULL})}

\item{step2}{The step size used to compute \code{mu2}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu2}
such that the dual optimization problem for constructing the second projection direction converges (default = \code{NULL})}

\item{resol}{The factor by which \code{mu1} (and \code{mu2}) is increased/decreased to obtain the smallest \code{mu1} (and \code{mu2})
such that the dual optimization problem for constructing the first (and the second) projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu1} (and \code{mu2}) is increased/decreased to obtain the smallest \code{mu1} (and \code{mu2})
such that the dual optimization problem for constructing the first (and the second) projection direction converges (default = 6)}

\item{alpha}{Level of significance to test the null hypothesis which claims that ITE is not above zero (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias-corrected estimator of the ITE}
\item{se}{The standard error of the bias-corrected estimator}
\item{CI}{The confidence interval for the ITE}
\item{decision}{\code{decision}\eqn{=1} implies the ITE is above zero \eqn{\newline}
\code{decision}\eqn{=0} implies the ITE is not above zero}
}
\description{
Computes the bias corrected estimator of the Individualized Treatment Effect (ITE)
and the corresponding standard error. It also constructs the confidence interval for ITE and tests
whether ITE is above zero or not. Here ITE is defined as a linear combination of the difference between two regression vectors.
}
\examples{
\donttest{
n1 <- 90
p <- 200
n2 <- 90
mu <- rep(0,p)
beta1 <- rep(0,p)
beta1[1:10] <- c(1:10)/5
beta2 <- rep(0,p)
beta2[1:5] <- c(1:5)/10
X1 <- MASS::mvrnorm(n1, mu, diag(p))
X2 <- MASS::mvrnorm(n2, mu, diag(p))
y1 <- X1\%*\%beta1 + rnorm(n1)
y2 <- X2\%*\%beta2 + rnorm(n2)
loading <- c(1,rep(0, (p-1)))
Est <- ITE(X1 = X1, y1 = y1, X2 = X2, y2 = y2,loading = loading, intercept = TRUE)
}
}
\references{
\insertRef{linlin}{SIHR}
}
