% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_logistic.R
\name{LF_logistic}
\alias{LF_logistic}
\title{Inference for the case probability or a linear combination of regression coefficients in high dimensional logistic regression.}
\usage{
LF_logistic(
  X,
  y,
  loading,
  weight = NULL,
  trans = TRUE,
  intercept.loading = TRUE,
  intercept = TRUE,
  init.coef = NULL,
  lambda = NULL,
  mu = NULL,
  step = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{y}{Outcome vector, of length \eqn{n}}

\item{loading}{Loading, of length \eqn{p}}

\item{weight}{The weight vector used for bias correction, of length \eqn{n}; if set to \code{NULL}, the weight is the inverse of the first derivative of the logit function (default = \code{NULL})}

\item{trans}{Should results for the case probability (\code{TRUE}) or the linear combination (\code{FALSE}) be reported (default = \code{TRUE})}

\item{intercept.loading}{Should intercept be included for the \code{loading} (default = \code{TRUE})}

\item{intercept}{Should intercept be fitted for the initial estimator (default = \code{TRUE})}

\item{init.coef}{Initial estimator of the regression vector (default = \code{NULL})}

\item{lambda}{The tuning parameter used in the construction of \code{init.coef} (default = \code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the projection direction (default = \code{NULL})}

\item{step}{The step size used to compute \code{mu}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = \code{NULL})}

\item{resol}{The factor by which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 6)}

\item{alpha}{Level of significance to test the null hypothesis that the case probability is less than or equal to 0.5 (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias corrected estimator of the case probability or the linear combination of regression coefficients}
\item{se}{The standard error of the bias-corrected estimator}
\item{CI}{The confidence interval for the case probability or the linear combination}
\item{decision}{\code{decision}\eqn{=1} implies the case probability is above 0.5 \eqn{\newline}
\code{decision}\eqn{=0} implies the case probability is not above 0.5}
\item{proj}{The projection direction, of length \eqn{p}}
\item{plug.in}{The plug-in estimator of the case probability or the linear combination}
}
\description{
Computes the bias corrected estimator of the case probability or the linear combination of regression coefficients in the high dimensional logistic regression model and the corresponding standard error.
It also constructs the confidence interval for the case probability or the linear combination and tests whether the case probability is above \eqn{0.5} or not.
Here case probability refers to the conditional probability of the binary response variable taking value 1 given the predictors take value \code{loading}.
}
\examples{
\donttest{
A1gen <- function(rho,p){
 A1 <- matrix(0,p,p)
 for(i in 1:p){
   for(j in 1:p){
     A1[i,j] <- rho^(abs(i-j))
   }
 }
 A1
}
n <- 100
p <- 400
mu <- rep(0,p)
rho <- 0.5
Cov <- (A1gen(rho,p))/2
beta <- rep(0,p)
beta[1:10] <- 0.5*c(1:10)/10
a0 <- 0
loading <- c(1,rep(0,(p-1)))
X <- MASS::mvrnorm(n,mu,Cov)
exp_val <- X\%*\%beta+a0
prob <- exp(exp_val)/(1+exp(exp_val))
y <- rbinom(n,1,prob)
Est <- LF_logistic(X = X, y = y, loading = loading, trans = TRUE)
}
}
\references{
\insertRef{linlog}{SIHR}
}
