% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_logistic.R
\name{ITE_Logistic}
\alias{ITE_Logistic}
\title{Inference for difference of case probabilities in high dimensional logistic regressions}
\usage{
ITE_Logistic(
  X1,
  y1,
  X2,
  y2,
  loading,
  weight = NULL,
  trans = TRUE,
  intercept = TRUE,
  intercept.loading = TRUE,
  init.coef1 = NULL,
  init.coef2 = NULL,
  lambda1 = NULL,
  lambda2 = NULL,
  mu1 = NULL,
  mu2 = NULL,
  step1 = NULL,
  step2 = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X1}{Design matrix for the first sample, of dimension \eqn{n_1} x \eqn{p}}

\item{y1}{Outcome vector for the first sample, of length \eqn{n_1}}

\item{X2}{Design matrix for the second sample, of dimension \eqn{n_2} x \eqn{p}}

\item{y2}{Outcome vector for the second sample, of length \eqn{n_2}}

\item{loading}{Loading, of length \eqn{p}}

\item{weight}{The weight vector used for bias correction, of length \eqn{n}; if set to \code{NULL}, the weight is
the inverse of the first derivative of the logit function (default = \code{NULL})}

\item{trans}{Should results for the case probability (\code{TRUE}) or the linear combination (\code{FALSE}) be reported (default = \code{TRUE})}

\item{intercept}{Should intercept(s) be fitted for the initial estimators (default = \code{TRUE})}

\item{intercept.loading}{Should intercept be included for the \code{loading} (default = \code{TRUE})}

\item{init.coef1}{Initial estimator of the first regression vector (default = \code{NULL})}

\item{init.coef2}{Initial estimator of the second regression vector (default = \code{NULL})}

\item{lambda1}{The tuning parameter in the construction of \code{init.coef1} (default = \code{NULL})}

\item{lambda2}{The tuning parameter in the construction of \code{init.coef2} (default = \code{NULL})}

\item{mu1}{The dual tuning parameter used in the construction of the first projection direction (default = \code{NULL})}

\item{mu2}{The dual tuning parameter used in the construction of the second projection direction (default = \code{NULL})}

\item{step1}{The step size used to compute \code{mu1}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu1}
such that the dual optimization problem for constructing the projection direction converges (default = \code{NULL})}

\item{step2}{The step size used to compute \code{mu2}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu2}
such that the dual optimization problem for constructing the second projection direction converges (default = \code{NULL})}

\item{resol}{The factor by which \code{mu1} (and \code{mu2}) is increased/decreased to obtain the smallest \code{mu1} (and \code{mu2})
such that the dual optimization problem for constructing the first (and the second) projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu1} (and \code{mu2}) is increased/decreased to obtain the smallest \code{mu} (and \code{mu2})
such that the dual optimization problem for constructing the first (and the second) projection direction converges (default = 6)}

\item{alpha}{Level ofsignificance to test the null hypothesis which claims that the first case probability is not greater than the second case probability (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias-corrected estimator for the difference between case probabilities or the linear combination of the difference between two regression vectors}
\item{se}{The standard error for the bias-corrected estimator}
\item{CI}{The confidence interval for the difference between case probabilities or the linear combination of the difference between two regression vectors}
\item{decision}{\code{decision}\eqn{=1} implies the first case probability or linear combination is greater than the second one\eqn{\newline}
\code{decision}\eqn{=0} implies the first case probability or linear combination is less than the second one}
}
\description{
Computes the bias corrected estimator of the difference between case probabilities or a linear combination of the difference between two regression vectors with respect to two high dimensional logistic regression models
and the corresponding standard error. It also constructs the confidence interval for the difference of case probabilities or a linear combination of the difference between the regression vectors and test
whether it is above zero or not. Here the case probability refers to the conditional probability of the binary response variable taking value 1 given the predictors are assigned to \code{loading}.
}
\examples{
\donttest{
A1gen <- function(rho,p){
A1 <- matrix(0,p,p)
for(i in 1:p){
  for(j in 1:p){
    A1[i,j] <- rho^(abs(i-j))
  }
}
A1
}
n1 <- 100
n2 <- 100
p <- 400
mu <- rep(0,p)
rho <- 0.5
Cov <- (A1gen(rho,p))/2
beta1 <- rep(0,p)
beta1[1:10] <- c(1:10)/5
beta2 <- rep(0,p)
beta2[1:5] <- c(1:5)/10
X1 <- MASS::mvrnorm(n1,mu,Cov)
X2 <- MASS::mvrnorm(n2,mu,Cov)
exp_val1 <- X1\%*\%beta1
exp_val2 <- X2\%*\%beta2
prob1 <- exp(exp_val1)/(1+exp(exp_val1))
prob2 <- exp(exp_val2)/(1+exp(exp_val2))
y1 <- rbinom(n1,1,prob1)
y2 <- rbinom(n2,1,prob2)
loading <- c(1,rep(0,(p-1)))
Est <- ITE_Logistic(X1 = X1, y1 = y1, X2 = X2, y2 = y2,loading = loading, trans = FALSE)
}
}
