% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric-measures.R
\name{PoGO}
\alias{PoGO}
\title{Percent of Goal Obtained}
\usage{
PoGO(
  A_data,
  B_data,
  condition,
  outcome,
  goal,
  baseline_phase = NULL,
  intervention_phase = NULL,
  improvement = "increase",
  confidence = 0.95
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{goal}{a numerical value indicating the goal level of behavior.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}
}
\value{
A data frame containing the estimate, standard error, and confidence
  interval.
}
\description{
Calculates the percent of goal obtained effect size index
}
\details{
The percent of goal obtained (PoGO) effect size parameter is defined
  as the ratio of the difference in the mean level of behavior during phase B
  versus during phase A to the difference between the goal level of behavior
  and the mean level of behavior during phase A, multiplied by 100.

  The standard error of PoGO is calculated based on Dunlap and Silver's
  (1986) approximation for the standard error of a ratio. The confidence
  interval for LRR is based on a large-sample (z) approximation.
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
PoGO(A_data = A, B_data = B, goal = 30)

}
\references{
Dunlap, W. P., & Silver, N. C. (1986). Confidence intervals and
  standard error for ratios of normal variables. \emph{Behavior Research
  Methods, Instruments, & Computers, 18}, 469-471. doi:\doi{10.3758/BF03201412}

  Ferron, J., Goldstein, H., Olszewski, A., & Rohrer, L. (2020). Indexing
  effects in single-case experimental designs by estimating the percent of
  goal obtained. \emph{Evidence-Based Communication Assessment and
  Intervention, 14}(1-2), 6-27. doi:\doi{10.1080/17489539.2020.1732024}

  Patrona, E., Ferron, J., Olszewski, A., Kelley, E., & Goldstein, H. (2022).
  Effects of explicit vocabulary interventions for preschoolers: An
  exploratory application of the percent of goal obtained (PoGO) effect size
  metric. \emph{Journal of Speech, Language, and Hearing Research},
  forthcoming.
}
