% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.rwm}
\alias{mcmc.rwm}
\title{[BETA VERSION] Draw MCMC samples from a model posterior using a
Random Walk Metropolis (RWM) sampler.}
\usage{
mcmc.rwm(nsim, fn, params.init, alpha = 1, covar = NULL,
  diagnostic = FALSE)
}
\arguments{
\item{nsim}{The number of samples to return.}

\item{fn}{A function that returns the log of the posterior density.}

\item{params.init}{A vector of initial parameter values.}

\item{alpha}{The amount to scale the proposal, i.e,
Xnew=Xcur+alpha*Xproposed where Xproposed is generated from a mean-zero
multivariate normal. Varying \code{alpha} varies the acceptance rate.}

\item{covar}{An optional covariance matrix which can be used to improve
the efficiency of sampling. The lower Cholesky decomposition of this
matrix is used to transform the parameter space. If the posterior is
approximately multivariate normal and \code{covar} approximates the
covariance, then the transformed parameter space will be close to
multivariate standard normal. In this case the algorithm will be more
efficient, but there will be overhead in the matrix calculations which
need to be done at each step. The default of NULL specifies to not do
this transformation.}

\item{diagnostic}{Whether to return a list of diagnostic metrics about
the chain. Useful for assessing efficiency and tuning chain.}
}
\value{
If \code{diagnostic} is FALSE (default), returns a matrix of
\code{nsim} samples from the posterior. Otherwise returns a list
containing samples ('par'), proposed samples ('par.proposed'), vector of
which proposals were accepted ('accepted'), and the total function calls
('n.calls'), which for this algorithm is \code{nsim}
}
\description{
[BETA VERSION] Draw MCMC samples from a model posterior using a
Random Walk Metropolis (RWM) sampler.
}
\details{
This algorithm does not yet contain adaptation of \code{alpha}
so some trial and error may be required for efficient sampling.
}
\seealso{
\code{\link{mcmc}}, \code{\link{mcmc.nuts}}, \code{\link{mcmc.hmc}}
}

