% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{MakeADFun}
\alias{MakeADFun}
\title{Construct objective functions with derivatives based on a compiled C++ template.}
\usage{
MakeADFun(data, parameters, map = list(), type = c("ADFun", "Fun",
  "ADGrad"[!is.null(random) || !is.null(profile)]), random = NULL,
  profile = NULL, random.start = expression(last.par.best[random]),
  hessian = FALSE, method = "BFGS", inner.method = "newton",
  inner.control = list(maxit = 1000), MCcontrol = list(doMC = FALSE, seed =
  123, n = 100), ADreport = FALSE, atomic = TRUE,
  LaplaceNonZeroGradient = FALSE, DLL = getUserDLL(),
  checkParameterOrder = TRUE, regexp = FALSE, silent = FALSE, ...)
}
\arguments{
\item{data}{List of data objects (vectors,matrices,arrays,factors,sparse matrices) required by the user template (order does not matter and un-used components are allowed).}

\item{parameters}{List of all parameter objects required by the user template (both random and fixed effects).}

\item{map}{List defining how to optionally collect and fix parameters - see details.}

\item{type}{Character vector defining which operation stacks are generated from the users template - see details.}

\item{random}{Character vector defining the random effect parameters. See also \code{regexp}.}

\item{profile}{Parameters to profile out of the likelihood (this subset will be appended to \code{random} with Laplace approximation disabled).}

\item{random.start}{Expression defining the strategy for choosing random effect initial values as function of previous function evaluations - see details.}

\item{hessian}{Calculate Hessian at optimum?}

\item{method}{Outer optimization method.}

\item{inner.method}{Inner optimization method (see function "newton").}

\item{inner.control}{List controlling inner optimization.}

\item{MCcontrol}{List controlling importance sampler (turned off by default).}

\item{ADreport}{Calculate derivatives of macro ADREPORT(vector) instead of objective_function return value?}

\item{atomic}{Allow tape to contain atomic functions?}

\item{LaplaceNonZeroGradient}{Allow Taylor expansion around non-stationary point?}

\item{DLL}{Name of shared object file compiled by user.}

\item{checkParameterOrder}{Optional check for correct parameter order.}

\item{regexp}{Match random effects by regular expressions?}

\item{silent}{Disable all tracing information?}

\item{...}{Currently unused.}
}
\value{
List with components (fn, gr, etc) suitable for calling an R optimizer, such as \code{nlminb} or \code{optim}.
}
\description{
Construct objective functions with derivatives based on the users C++ template.
}
\details{
A call to \code{MakeADFun} will return an object that, based on the users DLL code (specified through \code{DLL}), contains functions to calculate the objective function
and its gradient. The object contains the following components:
\itemize{
  \item \code{par} A default parameter.
  \item \code{fn} The likelihood function.
  \item \code{gr} The gradient function.
  \item \code{report} A function to report all variables reported with the REPORT() macro in the user template.
  \item \code{env} Environment with access to all parts of the structure.
}
and is thus ready for a call to an R optimizer, such as \code{nlminb} or \code{optim}.
Data (\code{data}) and parameters (\code{parameters}) are directly read by the user template via the macros beginning with DATA_
and PARAMETER_. The order of the PARAMETER_ macros defines the order of parameters in the final objective function.
There are no restrictions on the order of random parameters, fixed parameters or data in the template.

Optionally, a simple mechanism for collecting and fixing parameters from R is available through the \code{map} argument. A map is a named list
of factors with the following properties:
\itemize{
  \item names(map) is a subset of names(parameters).
  \item For a parameter "p" length(map$p) equals length(parameters$p).
  \item Parameter entries with NAs in the factor are fixed.
  \item Parameter entries with equal factor level are collected to a common value.
}
More advanced parameter mapping, such as collecting parameters between different vectors etc., must be implemented from the template.

Random effects are specified via the argument \code{random}: A component of the parameter list is marked as random if its name is matched
by any of the characters of the vector \code{random} (Regular expression match is performed if \code{regexp=TRUE}).
If some parameters are specified as random effects, these will
be integrated out of the objective function via the Laplace approximation. In this situation the functions \code{fn} and \code{gr}
automatically perform an optimization of random effects for each function evaluation. This is referred to as
the 'inner optimization'. Strategies for choosing initial values of the inner optimization can be controlled
via the argument \code{random.start}. The default is \code{expression(last.par.best[random])}
where \code{last.par.best} is an internal full parameter vector corresponding to the currently best
likelihood. An alternative choice could be \code{expression(last.par[random])} i.e. the random effect optimum of
the most recent - not necessarily best - likelihood evaluation. Further control of the inner optimization can
be obtained by the argument \code{inner.control} which is a list of control parameters for the inner optimizer
\code{newton}. Depending of the inner optimization problem type the following settings are recommended:
\enumerate{
  \item Quasi-convex: \code{smartsearch=TRUE} (the default).
  \item Strictly-convex: \code{smartsearch=FALSE} and \code{maxit=20}.
  \item Quadratic: \code{smartsearch=FALSE} and \code{maxit=1}.
}

Technically, the user template is processed several times by inserting
different types as template parameter, selected by argument \code{type}:
\itemize{
  \item \code{"ADFun"} Run through the template with AD-types and produce a stack of operations representing the objective function.
  \item \code{"Fun"} Run through the template with ordinary double-types.
  \item \code{"ADGrad"} Run through the template with nested AD-types and produce a stack of operations representing the objective function gradient.
}
Each of these are represented by external pointers to C++ structures available in the environment \code{env}.

Further objects in the environment \code{env}:
\itemize{
  \item \code{validpar} Function defining the valid parameter region (by default no restrictions). If an invalid
parameter is inserted \code{fn} immediately return NaN.
  \item \code{parList} Function to get the full parameter vector of random and fixed effects in a convenient
list format.
  \item \code{random} An index vector of random effect positions in the full parameter vector.
  \item \code{last.par} Full parameter of the latest likelihood evaluation.
  \item \code{last.par.best} Full parameter of the best likelihood evaluation.
  \item \code{tracepar} Trace every likelihood evaluation ?
  \item \code{tracemgc} Trace maximum gradient component of every gradient evaluation ?
  \item \code{silent} Pass 'silent=TRUE' to all try-calls ?
}

A high level of tracing information will be output by default when evaluating the objective function and gradient.
This is useful while developing a model, but may eventually become annoying. Disable all tracing by passing
\code{silent=TRUE} to the \code{MakeADFun} call.
}

