% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{data_preparation}
\alias{data_preparation}
\title{Prepare Sequence of Trial Data}
\usage{
data_preparation(
  data,
  id = "id",
  period = "period",
  treatment = "treatment",
  outcome = "outcome",
  eligible = "eligible",
  outcome_cov = ~1,
  model_var = NULL,
  switch_n_cov = ~1,
  switch_d_cov = ~1,
  first_period = NA,
  last_period = NA,
  use_weight = FALSE,
  use_censor = FALSE,
  cense = NA,
  pool_cense = FALSE,
  cense_d_cov = ~1,
  cense_n_cov = ~1,
  eligible_wts_0 = NA,
  eligible_wts_1 = NA,
  where_var = NULL,
  data_dir,
  save_weight_models = FALSE,
  glm_function = "glm",
  chunk_size = 500,
  separate_files = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing all the required columns.}

\item{id}{Name of the data column for id feature Defaults to id}

\item{period}{Name of the data column for period feature Defaults to period}

\item{treatment}{Name of the data column for treatment feature Defaults to treatment}

\item{outcome}{Name of the data column for outcome feature Defaults to outcome}

\item{eligible}{Indicator of whether or not an observation is eligible to be expanded about Defaults to eligible}

\item{outcome_cov}{A RHS formula with baseline covariates to adjust in final model}

\item{model_var}{List of Variables of interest to be used in final model.
Derived variables to use in outcome models. Typically \code{assigned_treatment} for ITT and per-protocol,
and \code{dose + dose^2} for as-treated.}

\item{switch_n_cov}{A RHS formula for modelling probability of switching treatment. Used in the numerator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{switch_d_cov}{A RHS formula for modelling probability of switching treatment. Used in the denominator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{first_period}{First time period to include as trial baseline in expanded data}

\item{last_period}{Last time period to include as trial baseline in expanded data}

\item{use_weight}{Use weights in analysis. If \code{FALSE} then no weights will be calculated.}

\item{use_censor}{Use censoring for per-protocol analysis - censor person-times once a person-trial stops taking the
initial treatment value}

\item{cense}{Censoring variable}

\item{pool_cense}{Fit pooled or separate censoring models for those treated and
those untreated at the immediately previous visit.
(default is \code{FALSE}, separate numerator and denominator models for treatment groups)}

\item{cense_d_cov}{A RHS formula for modelling probability of being censored. Used in the numerator of weight
calculation.}

\item{cense_n_cov}{A RHS formula for modelling probability of being censored. Used in the denominator of weight
calculation.}

\item{eligible_wts_0}{Eligibility criteria used in weights for model condition Am1 = 0}

\item{eligible_wts_1}{Eligibility criteria used in weights for model condition Am1 = 1}

\item{where_var}{List of variables used in where conditions used in subsetting the data used in final analysis
(where_case), the variables not included in the final model}

\item{data_dir}{Directory to model objects when \code{save_weight_models=TRUE} and
expanded data as \code{trial_i.csv}s if \code{separate_files = TRUE}.
If the specified directory does not exist it will be created. If the directory
already contains trial files an error will occur, other files may be overwritten.}

\item{save_weight_models}{Save weight models objects in \code{data_dir}.}

\item{glm_function}{Which glm function to use for the final model from \code{stats} or \code{parglm} packages}

\item{chunk_size}{Number of patients to process in one chunk when \code{separate_files = TRUE}}

\item{separate_files}{Save expanded data in separate CSV files for each trial.}

\item{quiet}{Don't print progress messages.}

\item{...}{Additional arguments passed to \code{glm_function}. This may be used to specify initial parameter estimates
or arguments to \code{control}. See \link[stats:glm]{stats::glm}, \link[parglm:parglm]{parglm::parglm} and \code{\link[parglm:parglm.control]{parglm::parglm.control()}} for more information.}
}
\value{
An object of class \code{TE_data_prep}, which can either be sampled from (\link{case_control_sampling_trials})
or directly used in a model (\link{trial_msm}).
It contains the elements
\describe{
\item{data}{the expanded trial dataset for all trial periods. If \code{separate=FALSE} a \code{data.table}, if
\code{separate=TRUE} a character vector with the file path of the expanded data as csv.}
\item{min_period}{the first trial period in the expanded data}
\item{max_period}{the last trial period in the expanded data}
\item{N}{the total number of observations in the expanded data}
\item{data_template}{a zero-row \code{data.frame} in the with the columns and attributes of the expanded data}
\item{switch_models}{a list of summaries of the models fitted for probability of switching treatment,
if \code{use_weight=TRUE}}
\item{censor_models}{a list of summaries of the models fitted for probability of censoring treatment,
if \code{use_weight=TRUE}}
}
}
\description{
This function takes the one row per time period per patient data and constructs
a dataset with the records for each period in each trial. This considerably expands
the size of the data. It takes into account the eligibility for each trial and
calculates the weight models and the weights for each time period in the expanded data.
}
\details{
The arguments \code{chunk_size} and \code{separate_files} allow for processing of large datasets that
would not fit in memory once expanded. When \code{separate_files = TRUE}, the input data are processed
in chunks of patients and saved into separate files for each trial starting period. These separate
files can be sampled to create the dataset for the modelling.
}
