% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCmodel.R
\name{UC}
\alias{UC}
\title{UC}
\usage{
UC(
  y,
  u = NULL,
  model = "?/none/?/?",
  h = NA,
  outlier = NA,
  tTest = FALSE,
  criterion = "aic",
  periods = NA,
  verbose = FALSE,
  stepwise = FALSE,
  p0 = NA,
  cLlik = TRUE,
  arma = TRUE
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{periods} should be supplied compulsorily (see below).}

\item{u}{a matrix of input time series. If 
the output wanted to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of 
model for each component. It allows two formats "trend/seasonal/irregular" or 
"trend/cycle/seasonal/irregular". The possibilities available for each component are:
\itemize{
\item Trend: ? / none / rw / irw / llt / dt; 

\item Seasonal: ? / none / equal / different;

\item Irregular: ? / none / arma(0, 0) / arma(p, q) - with p and q integer positive orders;
    
\item Cycles: ? / none / combination of positive or negative numbers. 

Positive numbers fix
the period of the cycle while negative values estimate the period taking as initial
condition the absolute value of the period supplied.
Several cycles with positive or negative values are possible
and if a question mark is included, the model test for the existence of the cycles
specified (check the examples below).
}}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{outlier}{critical level of outlier tests. If NA it does not carry out any 
outlier detection (default). A negative value indicates critical minimum t test for one run of
outlier detection after identification. A positive value indicates the critical minium
t test for outlier detection in any model during identification.}

\item{tTest}{augmented Dickey Fuller test for unit roots (TRUE / FALSE). The number of models
to search for is reduced, depending on the result of this test.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{periods}{vector of fundamental period and harmonics.}

\item{verbose}{intermediate results shown about progress of estimation (TRUE / FALSE).}

\item{stepwise}{stepwise identification procedure (TRUE / FALSE).}

\item{p0}{initial condition for parameter estimates.}

\item{cLlik}{reserved input}

\item{arma}{check for arma models for irregular components (TRUE / FALSE).}
}
\value{
An object of class \code{UComp}. See \code{UC}.
Standard methods applicable to UComp objects are print, summary, plot,
fitted, residuals, logLik, AIC, BIC, coef, predict, tsdiag.
}
\description{
Runs all relevant functions for UC modelling
}
\details{
See help of \code{UCmodel}.
}
\examples{
y <- log(AirPassengers)
m1 <- UC(y)
m1 <- UC(y, model = "llt/different/arma(0,0)")
}
\seealso{
\code{\link{UC}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}},
         \code{\link{UChp}}
}
\author{
Diego J. Pedregal
}
