% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modwt_vt.R
\name{modwt.vt.val}
\alias{modwt.vt.val}
\title{Variance Transformation Operation for Validation}
\usage{
modwt.vt.val(data, J, dwt, detrend = FALSE)
}
\arguments{
\item{data}{A list of response x and dependent variables dp.}

\item{J}{Specifies the depth of the decomposition. This must be a number less than or equal to log(length(x),2).}

\item{dwt}{A class of "modwt" data. Output from modwt.vt().}

\item{detrend}{Detrend the input time series or just center, default (F)}
}
\value{
A list of 8 elements: wf, J, boundary, x (data), dp (data), dp.n (variance transformed dp), and S (covariance matrix).
}
\description{
Variance Transformation Operation for Validation
}
\examples{
data(rain.mon)
data(obs.mon)

## response SPI - calibration
# SPI.cal <- SPI.calc(window(rain.mon, start=c(1949,1), end=c(1979,12)),sc=12)
SPI.cal <- SPEI::spi(window(rain.mon, start = c(1949, 1), end = c(1979, 12)), scale = 12)$fitted

## create paired response and predictors dataset for each station
data.list <- list()
for (id in 1:ncol(SPI.cal)) {
  x <- window(SPI.cal[, id], start = c(1950, 1), end = c(1979, 12))
  dp <- window(obs.mon, start = c(1950, 1), end = c(1979, 12))
  data.list[[id]] <- list(x = as.numeric(x), dp = matrix(dp, nrow = nrow(dp)))
}

## variance transformation - calibration
dwt.list <- lapply(data.list, function(x) {
  modwt.vt(x, wf = "d4", J = 7, boundary = "periodic", cov.opt = "auto")
})

## response SPI - validation
# SPI.val <- SPI.calc(window(rain.mon, start=c(1979,1), end=c(2009,12)),sc=12)
SPI.val <- SPEI::spi(window(rain.mon, start = c(1979, 1), end = c(2009, 12)), scale = 12)$fitted

## create paired response and predictors dataset for each station
data.list <- list()
for (id in 1:ncol(SPI.val)) {
  x <- window(SPI.val[, id], start = c(1980, 1), end = c(2009, 12))
  dp <- window(obs.mon, start = c(1980, 1), end = c(2009, 12))
  data.list[[id]] <- list(x = as.numeric(x), dp = matrix(dp, nrow = nrow(dp)))
}

# variance transformation - validation
dwt.list.val <- lapply(
  seq_along(data.list),
  function(i) modwt.vt.val(data.list[[i]], J = 7, dwt.list[[i]])
)

## plot original and reconstrcuted predictors for each station
for (i in seq_along(dwt.list.val)) {
  # extract data
  dwt <- dwt.list.val[[i]]
  x <- dwt$x # response
  dp <- dwt$dp # original predictors
  dp.n <- dwt$dp.n # variance transformed predictors

  plot.ts(cbind(x, dp))
  plot.ts(cbind(x, dp.n))
}
}
\references{
Z Jiang, A Sharma, and F Johnson. WRR
}
