% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt_vt.R
\name{dwt.vt}
\alias{dwt.vt}
\title{Variance Transformation Operation - MRA}
\usage{
dwt.vt(
  data,
  wf,
  J,
  method,
  pad,
  boundary,
  cov.opt = "auto",
  flag = "biased",
  detrend = FALSE
)
}
\arguments{
\item{data}{A list of response x and dependent variables dp.}

\item{wf}{Name of the wavelet filter to use in the decomposition.}

\item{J}{Specifies the depth of the decomposition. This must be a number less than or equal to log(length(x),2).}

\item{method}{Either "dwt" or "modwt".}

\item{pad}{The method used for extend data to dyadic size. Use "per", "zero", or "sym".}

\item{boundary}{Character string specifying the boundary condition. If boundary=="periodic" the default, then the vector you decompose is assumed to be periodic on its defined interval, if boundary=="reflection", the vector beyond its boundaries is assumed to be a symmetric reflection of itself.}

\item{cov.opt}{Options of Covariance matrix sign. Use "pos", "neg", or "auto".}

\item{flag}{Biased or Unbiased variance transformation, c("biased","unbiased").}

\item{detrend}{Detrend the input time series or just center, default (F)}
}
\value{
A list of 8 elements: wf, method, boundary, pad, x (data), dp (data), dp.n (variance trasnformed dp), and S (covariance matrix).
}
\description{
Variance Transformation Operation - MRA
}
\examples{
data(rain.mon)
data(obs.mon)

## response SPI - calibration
# SPI.cal <- SPI.calc(window(rain.mon, start=c(1949,1), end=c(1979,12)),sc=12)
SPI.cal <- SPEI::spi(window(rain.mon, start = c(1949, 1), end = c(1979, 12)), scale = 12)$fitted

## create paired response and predictors dataset for each station
data.list <- list()
for (id in seq_len(ncol(SPI.cal))) {
  x <- window(SPI.cal[, id], start = c(1950, 1), end = c(1979, 12))
  dp <- window(obs.mon, start = c(1950, 1), end = c(1979, 12))
  data.list[[id]] <- list(x = as.numeric(x), dp = matrix(dp, nrow = nrow(dp)))
}

## variance transformation
dwt.list <- lapply(data.list, function(x) {
  dwt.vt(x, wf = "d4", J = 7, method = "dwt", pad = "zero", boundary = "periodic", cov.opt = "auto")
})

## plot original and reconstrcuted predictors for each station
for (i in seq_len(length(dwt.list))) {
  # extract data
  dwt <- dwt.list[[i]]
  x <- dwt$x # response
  dp <- dwt$dp # original predictors
  dp.n <- dwt$dp.n # variance transformed predictors

  plot.ts(cbind(x, dp))
  plot.ts(cbind(x, dp.n))
}
}
\references{
Jiang, Z., Sharma, A., & Johnson, F. (2020). Refining Predictor Spectral Representation Using Wavelet Theory for Improved Natural System Modeling. Water Resources Research, 56(3), e2019WR026962.
}
