% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-crs.R
\name{validate_crs}
\alias{validate_crs}
\title{Validate CRS object}
\usage{
validate_crs(crs)
}
\arguments{
\item{crs}{a representation of a coordinate reference system.}
}
\value{
Returns a list of length 1 with an element named \code{spatialReference} which is itself
a named list.

If the provided CRS returns a valid well-known ID (WKID) \code{spatialReference} contains
a named element called \code{wkid} which is the integer value of the WKID. If the WKID
is not known but the CRS returned is a valid well-known text representation the \code{wkid} field
is \code{NA} and another field \code{wkt} contains the valid wkt.
}
\description{
Takes a representation of a CRS and ensures that it is a valid one. The CRS
is validated using \code{sf::st_crs()} if it cannot be validated, a null CRS is returned.
}
\details{
See \code{\link[sf:st_crs]{sf::st_crs()}} for more details on valid representations.
}
\examples{

# using epsg code integer or string representation
validate_crs(3857)
validate_crs("EPSG:4326")

# using a custom proj4 string
proj4string <- "+proj=longlat +datum=WGS84 +no_defs"

crs <- validate_crs(proj4string)

# using wkt2 (from above result)
crs <- validate_crs(crs$spatialReference$wkt)

}
