/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;

public class PartialSupportTree
extends TotalSupportTree {
    protected PtreeNodeTop[] startPtreeRef = null;
    protected PtreeRecord[][] startPtreeTable = null;
    protected int[] pTreeNodesOfCardinalityN = null;
    protected int[] pTreeTableMarker = null;
    private int numPtreeNodeUpdates = 0;
    private int maxPtreeGraphNodes = 0;
    private boolean outputPtreeStatsFlag = false;
    public boolean outputPtreeFlag = false;
    private boolean outputPtreeGraphFlag = false;
    private boolean okToDeletePtreeFlag = true;

    public PartialSupportTree(String[] stringArray) {
        super(stringArray);
    }

    public PartialSupportTree(AssocRuleMining assocRuleMining) {
        super(assocRuleMining);
    }

    public PartialSupportTree() {
    }

    public void createPtree() {
        int n;
        this.startPtreeRef = new PtreeNodeTop[this.numOneItemSets + 1];
        this.startPtreeTable = new PtreeRecord[this.numOneItemSets + 1][];
        this.pTreeNodesOfCardinalityN = new int[this.numOneItemSets + 1];
        this.pTreeTableMarker = new int[this.numOneItemSets + 1];
        for (n = 0; n < this.startPtreeRef.length; ++n) {
            this.startPtreeRef[n] = null;
        }
        for (n = 0; n < this.dataArray.length; ++n) {
            if (this.dataArray[n] == null) continue;
            this.addToPtreeTopLevel(this.dataArray[n]);
        }
        if (this.outputPtreeStatsFlag) {
            this.outputPtreeStats();
        }
        if (this.outputPtreeFlag) {
            this.outputPtree();
        }
        System.out.println("Creating P-tree table");
        this.createPtreeTable();
    }

    public void createPtree(JTextArea jTextArea) {
        int n;
        jTextArea.append("Generating P-tree\n");
        this.startPtreeRef = new PtreeNodeTop[this.numOneItemSets + 1];
        this.startPtreeTable = new PtreeRecord[this.numOneItemSets + 1][];
        this.pTreeNodesOfCardinalityN = new int[this.numOneItemSets + 1];
        this.pTreeTableMarker = new int[this.numOneItemSets + 1];
        for (n = 0; n < this.startPtreeRef.length; ++n) {
            this.startPtreeRef[n] = null;
        }
        for (n = 0; n < this.dataArray.length; ++n) {
            if (this.dataArray[n] == null) continue;
            this.addToPtreeTopLevel(this.dataArray[n]);
        }
        if (this.outputPtreeStatsFlag) {
            this.outputPtreeStats(jTextArea);
        }
        if (this.outputPtreeFlag) {
            this.outputPtree(jTextArea);
        }
        jTextArea.append("Creating P-tree table\n");
        this.createPtreeTable();
    }

    protected void addToPtreeTopLevel(short[] sArray) {
        short s = sArray[0];
        int n = sArray.length;
        if (n == 1) {
            if (this.startPtreeRef[s] == null) {
                this.startPtreeRef[s] = new PtreeNodeTop();
                this.pTreeNodesOfCardinalityN[1] = this.pTreeNodesOfCardinalityN[1] + 1;
            } else {
                ++this.startPtreeRef[s].support;
            }
            ++this.numPtreeNodeUpdates;
        } else {
            if (this.startPtreeRef[s] == null) {
                this.startPtreeRef[s] = new PtreeNodeTop();
                this.pTreeNodesOfCardinalityN[1] = this.pTreeNodesOfCardinalityN[1] + 1;
            } else {
                ++this.startPtreeRef[s].support;
            }
            ++this.numPtreeNodeUpdates;
            this.addToPtree(0, 2, n, this.startPtreeRef[s].childRef, this.realloc3(sArray), s, null);
        }
    }

    protected void addToPtree(int n, int n2, int n3, PtreeNode ptreeNode, short[] sArray, int n4, PtreeNode ptreeNode2) {
        if (ptreeNode == null) {
            PtreeNode ptreeNode3 = this.createPtreeNode(sArray, n3);
            this.addSupport2(n, ptreeNode3, n4, ptreeNode2);
        } else {
            switch (this.checkItemSets(sArray, ptreeNode.itemSet)) {
                case 1: {
                    ++this.numPtreeNodeUpdates;
                    ++ptreeNode.support;
                    break;
                }
                case 2: {
                    this.beforeAndSubset(n, n3, ptreeNode, sArray, n4, ptreeNode2);
                    break;
                }
                case 3: {
                    this.beforeAndNotSubset(n, n2, n3, ptreeNode, sArray, n4, ptreeNode2);
                    break;
                }
                case 4: {
                    this.afterAndSuperset(n2, n3, ptreeNode, sArray);
                    break;
                }
                case 5: {
                    this.afterAndNotSuperset(n, n2, n3, ptreeNode, sArray, n4, ptreeNode2);
                    break;
                }
            }
        }
    }

    private void beforeAndSubset(int n, int n2, PtreeNode ptreeNode, short[] sArray, int n3, PtreeNode ptreeNode2) {
        PtreeNode ptreeNode3 = this.createPtreeNode(sArray, n2);
        ptreeNode3.support += ptreeNode.support;
        ++this.numPtreeNodeUpdates;
        ptreeNode3.childRef = ptreeNode;
        this.addSupport2(n, ptreeNode3, n3, ptreeNode2);
        ptreeNode.itemSet = this.realloc4(ptreeNode.itemSet, sArray);
        this.checkSiblingBranch(ptreeNode, sArray, ptreeNode3);
    }

    private void beforeAndNotSubset(int n, int n2, int n3, PtreeNode ptreeNode, short[] sArray, int n4, PtreeNode ptreeNode2) {
        short[] sArray2 = this.checkForLeadingSubString(sArray, ptreeNode.itemSet);
        if (sArray2 != null) {
            PtreeNode ptreeNode3 = this.createPtreeNode(sArray2, sArray2.length + n2 - 1);
            ptreeNode3.support = ptreeNode.support + 1;
            this.addSupport2(n, ptreeNode3, n4, ptreeNode2);
            sArray = this.realloc4(sArray, sArray2);
            ptreeNode3.childRef = this.createPtreeNode(sArray, n3);
            ptreeNode3.childRef.siblingRef = ptreeNode;
            this.checkSiblingBranch(ptreeNode3.childRef, sArray2, ptreeNode3);
        } else {
            PtreeNode ptreeNode4 = this.createPtreeNode(sArray, n3);
            ptreeNode4.siblingRef = ptreeNode;
            this.addSupport2(n, ptreeNode4, n4, ptreeNode2);
        }
    }

    private void afterAndSuperset(int n, int n2, PtreeNode ptreeNode, short[] sArray) {
        ++this.numPtreeNodeUpdates;
        ++ptreeNode.support;
        if (ptreeNode.childRef == null) {
            PtreeNode ptreeNode2;
            ptreeNode.childRef = ptreeNode2 = this.createPtreeNode(this.realloc4(sArray, ptreeNode.itemSet), n2);
        } else {
            this.addToPtree(1, n + ptreeNode.itemSet.length, n2, ptreeNode.childRef, this.realloc4(sArray, ptreeNode.itemSet), 0, ptreeNode);
        }
    }

    private void afterAndNotSuperset(int n, int n2, int n3, PtreeNode ptreeNode, short[] sArray, int n4, PtreeNode ptreeNode2) {
        if (ptreeNode.siblingRef == null) {
            this.afterAndNotSuperset1(n, n2, n3, ptreeNode, sArray, n4, ptreeNode2);
        } else {
            this.afterAndNotSuperset2(n, n2, n3, ptreeNode, sArray, n4, ptreeNode2);
        }
    }

    private void afterAndNotSuperset1(int n, int n2, int n3, PtreeNode ptreeNode, short[] sArray, int n4, PtreeNode ptreeNode2) {
        short[] sArray2 = this.checkForLeadingSubString(sArray, ptreeNode.itemSet);
        if (sArray2 != null) {
            PtreeNode ptreeNode3 = this.createPtreeNode(sArray2, sArray2.length + n2 - 1);
            ptreeNode3.support = ptreeNode.support + 1;
            this.addSupport2(n, ptreeNode3, n4, ptreeNode2);
            ptreeNode.itemSet = this.realloc4(ptreeNode.itemSet, sArray2);
            ptreeNode3.childRef = ptreeNode;
            ptreeNode.siblingRef = this.createPtreeNode(this.realloc4(sArray, sArray2), n3);
        } else {
            ptreeNode.siblingRef = this.createPtreeNode(sArray, n3);
        }
    }

    private void afterAndNotSuperset2(int n, int n2, int n3, PtreeNode ptreeNode, short[] sArray, int n4, PtreeNode ptreeNode2) {
        short[] sArray2 = this.checkForLeadingSubString(sArray, ptreeNode.itemSet);
        if (sArray2 != null) {
            PtreeNode ptreeNode3 = this.createPtreeNode(sArray2, sArray2.length + n2 - 1);
            ptreeNode3.support = ptreeNode.support + 1;
            this.addSupport2(n, ptreeNode3, n4, ptreeNode2);
            ptreeNode.itemSet = this.realloc4(ptreeNode.itemSet, sArray2);
            ptreeNode3.childRef = ptreeNode;
            PtreeNode ptreeNode4 = ptreeNode.siblingRef;
            ptreeNode.siblingRef = this.createPtreeNode(sArray, n3);
            ptreeNode.siblingRef.siblingRef = ptreeNode4;
            this.checkSiblingBranch(ptreeNode3.childRef, sArray2, ptreeNode3);
        } else {
            this.addToPtree(2, n2, n3, ptreeNode.siblingRef, sArray, 0, ptreeNode);
        }
    }

    private void addSupport2(int n, PtreeNode ptreeNode, int n2, PtreeNode ptreeNode2) {
        switch (n) {
            case 0: {
                this.startPtreeRef[n2].childRef = ptreeNode;
                break;
            }
            case 1: {
                ptreeNode2.childRef = ptreeNode;
                break;
            }
            case 2: {
                ptreeNode2.siblingRef = ptreeNode;
                break;
            }
            default: {
                System.out.println("ERROR: Unidentified flag in addSupport\n");
            }
        }
    }

    private void checkSiblingBranch(PtreeNode ptreeNode, short[] sArray, PtreeNode ptreeNode2) {
        if (ptreeNode.siblingRef != null) {
            if (!this.isSubset(sArray, ptreeNode.siblingRef.itemSet)) {
                ptreeNode2.siblingRef = ptreeNode.siblingRef;
                ptreeNode.siblingRef = null;
            } else {
                ptreeNode.siblingRef.itemSet = this.realloc4(ptreeNode.siblingRef.itemSet, sArray);
                PtreeNode ptreeNode3 = ptreeNode.siblingRef;
                PtreeNode ptreeNode4 = ptreeNode.siblingRef.siblingRef;
                while (ptreeNode4 != null) {
                    if (!this.isSubset(sArray, ptreeNode4.itemSet)) {
                        ptreeNode2.siblingRef = ptreeNode4;
                        ptreeNode3.siblingRef = null;
                        break;
                    }
                    ptreeNode4.siblingRef.itemSet = this.realloc4(ptreeNode4.siblingRef.itemSet, sArray);
                    ptreeNode3 = ptreeNode4;
                    ptreeNode4 = ptreeNode4.siblingRef;
                }
            }
        }
    }

    protected PtreeNode createPtreeNode(short[] sArray, int n) {
        int n2 = n;
        this.pTreeNodesOfCardinalityN[n2] = this.pTreeNodesOfCardinalityN[n2] + 1;
        return new PtreeNode(sArray);
    }

    public PtreeNodeTop[] getStartOfPtree() {
        return this.startPtreeRef;
    }

    public int getNumPtreeNodes() {
        return this.calculateNumNodes(this.startPtreeRef);
    }

    public void createPtreeTable() {
        int n;
        for (n = 1; n < this.pTreeNodesOfCardinalityN.length; ++n) {
            this.startPtreeTable[n] = this.pTreeNodesOfCardinalityN[n] == 0 ? null : new PtreeRecord[this.pTreeNodesOfCardinalityN[n]];
        }
        for (n = 0; n < this.startPtreeRef.length; ++n) {
            if (this.startPtreeRef[n] == null) continue;
            short[] sArray = new short[]{(short)n};
            this.addToPtreeArray(null, sArray, this.startPtreeRef[n].support, 1);
            this.createPtreeTable2(this.startPtreeRef[n].childRef, sArray, 1);
            if (!this.okToDeletePtreeFlag) continue;
            this.startPtreeRef[n] = null;
        }
    }

    private void createPtreeTable2(PtreeNode ptreeNode, short[] sArray, int n) {
        if (ptreeNode != null) {
            int n2 = ptreeNode.itemSet.length - 1;
            int n3 = n + n2 + 1;
            this.addToPtreeArray(ptreeNode.itemSet, sArray, ptreeNode.support, n3);
            this.createPtreeTable2(ptreeNode.childRef, this.append(sArray, ptreeNode.itemSet), n3);
            if (this.okToDeletePtreeFlag) {
                ptreeNode.childRef = null;
            }
            this.createPtreeTable2(ptreeNode.siblingRef, sArray, n);
            if (this.okToDeletePtreeFlag) {
                ptreeNode.siblingRef = null;
            }
        }
    }

    private void addToPtreeArray(short[] sArray, short[] sArray2, int n, int n2) {
        this.startPtreeTable[n2][this.pTreeTableMarker[n2]] = sArray == null ? new PtreeRecord(sArray2, sArray2, n) : new PtreeRecord(sArray, this.append(sArray2, sArray), n);
        int n3 = n2;
        this.pTreeTableMarker[n3] = this.pTreeTableMarker[n3] + 1;
    }

    @Override
    public void createTotalSupportTree() {
        System.out.println("Apriori-TFP with X-Checking\nMinimum support threshold = " + this.twoDecPlaces(this.support) + "% (" + this.twoDecPlaces(this.minSupport) + " records)");
        if (this.numOneItemSets == 0) {
            return;
        }
        this.startTtreeRef = null;
        this.numFrequentSets = 0;
        this.numUpdates = 0L;
        TtreeNode.setNumberOfNodesFieldToZero();
        this.contCreateTtree();
        if (this.outputTtreeStatsFlag) {
            this.outputTtreeStats();
        }
        if (this.outputTtreeFlag) {
            this.outputTtree();
        }
    }

    @Override
    public void createTotalSupportTree(JTextArea jTextArea) {
        jTextArea.append("Apriori-TFP with X-Checking\nMinimum support threshold = " + this.twoDecPlaces(this.support) + "% (" + this.twoDecPlaces(this.minSupport) + " records)\n");
        if (this.numOneItemSets == 0) {
            return;
        }
        this.startTtreeRef = null;
        this.numFrequentSets = 0;
        this.numUpdates = 0L;
        TtreeNode.setNumberOfNodesFieldToZero();
        this.contCreateTtree();
        if (this.outputTtreeStatsFlag) {
            this.outputTtreeStats(jTextArea);
        }
        if (this.outputTtreeFlag) {
            this.outputTtree(jTextArea);
        }
    }

    @Override
    protected void contCreateTtree() {
        this.createTtreeTopLevel();
        this.generateLevel2();
        this.createTtreeLevelN();
    }

    @Override
    protected void createTtreeTopLevel2() {
        this.numLevelsInTtree = 1;
        for (int i = 1; i < this.startPtreeTable.length; ++i) {
            if (this.startPtreeTable[i] == null) continue;
            this.createTtreeTopLevel3(this.startPtreeTable[i]);
        }
        this.startPtreeTable[1] = null;
    }

    protected void createTtreeTopLevel3(PtreeRecord[] ptreeRecordArray) {
        for (int i = 0; i < ptreeRecordArray.length; ++i) {
            this.createTtreeTopLevel4(ptreeRecordArray[i].pTreeNodeLabel, ptreeRecordArray[i].support);
        }
    }

    private void createTtreeTopLevel4(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            this.startTtreeRef[sArray[i]].support += n;
            ++this.numUpdates;
        }
    }

    @Override
    protected void addSupportToTtreeLevelN(int n) {
        for (int i = n; i < this.startPtreeTable.length; ++i) {
            if (this.startPtreeTable[i] == null) continue;
            for (int j = 0; j < this.startPtreeTable[i].length; ++j) {
                this.addSupportToTtreeLevelN(n, this.startPtreeTable[i][j].pTreeNodeLabel, this.startPtreeTable[i][j].pTreeItemSet, this.startPtreeTable[i][j].support, 1, this.startTtreeRef.length);
            }
        }
        this.startPtreeTable[n] = null;
    }

    protected void addSupportToTtreeLevelN(int n, short[] sArray, short[] sArray2, int n2, int n3, int n4) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= n3 || sArray[i] >= n4 || this.startTtreeRef[sArray[i]] == null) continue;
            TtreeNode ttreeNode = this.startTtreeRef[sArray[i]];
            if (ttreeNode.childRef == null) continue;
            this.addSupportToTtreeLevelN(ttreeNode.childRef, n - 1, sArray2, n2);
        }
    }

    protected void addSupportToTtreeLevelN(TtreeNode[] ttreeNodeArray, int n, short[] sArray, int n2) {
        if (n == 1) {
            this.addSupToArrayOfTtreeNodes(ttreeNodeArray, sArray, n2);
        } else {
            this.addSupportToTtreeLevelN2(ttreeNodeArray, n, sArray, n2);
        }
    }

    protected void addSupportToTtreeLevelN2(TtreeNode[] ttreeNodeArray, int n, short[] sArray, int n2) {
        for (int i = 0; i < sArray.length && sArray[i] < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[sArray[i]] == null || ttreeNodeArray[sArray[i]].childRef == null) continue;
            TtreeNode ttreeNode = ttreeNodeArray[sArray[i]];
            this.addSupportToTtreeLevelN(ttreeNode.childRef, n - 1, sArray, n2);
        }
    }

    protected void addSupToArrayOfTtreeNodes(TtreeNode[] ttreeNodeArray, short[] sArray, int n) {
        for (int i = 0; i < sArray.length && sArray[i] < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[sArray[i]] == null) continue;
            ttreeNodeArray[sArray[i]].support += n;
            ++this.numUpdates;
        }
    }

    public int findInPtree(short[] sArray) {
        int n = 0;
        for (int i = 1; i < sArray[0] && i < this.startPtreeRef.length; ++i) {
            if (this.startPtreeRef[i] == null) continue;
            n += this.findInPtree(this.startPtreeRef[i].childRef, sArray);
        }
        if (sArray[0] < this.startPtreeRef.length && this.startPtreeRef[sArray[0]] != null) {
            n = sArray.length == 1 ? (n += this.startPtreeRef[sArray[0]].support) : (n += this.findInPtree(this.startPtreeRef[sArray[0]].childRef, this.realloc3(sArray)));
        }
        return n;
    }

    private int findInPtree(PtreeNode ptreeNode, short[] sArray) {
        if (ptreeNode == null) {
            return 0;
        }
        if (this.isEqual(sArray, ptreeNode.itemSet)) {
            return ptreeNode.support;
        }
        if (sArray[0] < ptreeNode.itemSet[0]) {
            return 0;
        }
        if (this.isSubset(sArray, ptreeNode.itemSet)) {
            if (ptreeNode.siblingRef != null) {
                return ptreeNode.support + this.findInPtree(ptreeNode.siblingRef, sArray);
            }
            return ptreeNode.support;
        }
        if (this.isSubset(ptreeNode.itemSet, sArray)) {
            if (ptreeNode.childRef != null) {
                return this.findInPtree(ptreeNode.childRef, this.realloc4(sArray, ptreeNode.itemSet));
            }
            return 0;
        }
        int n = 0;
        if (ptreeNode.siblingRef != null) {
            n = this.findInPtree(ptreeNode.siblingRef, sArray);
        }
        if (ptreeNode.childRef != null) {
            n += this.findInPtree(ptreeNode.childRef, sArray);
        }
        return n;
    }

    public void setOutputPtreeStatsFlag(boolean bl) {
        this.outputPtreeStatsFlag = bl;
    }

    public void setOutputPtreeFlag(boolean bl) {
        this.outputPtreeFlag = bl;
    }

    public void setOutputPtreeGraphFlag(boolean bl, int n) {
        this.outputPtreeGraphFlag = bl;
        this.maxPtreeGraphNodes = n;
    }

    public void setOKtoDeletePtreeFlag(boolean bl) {
        this.okToDeletePtreeFlag = bl;
    }

    public void outputPtree() {
        System.out.println("P-TREE\n------\nFormat: (NodeNumber){ItemSet} support=S");
        this.outputPtree1(this.startPtreeRef);
        System.out.println("-------------------------");
    }

    public void outputPtree1(PtreeNodeTop[] ptreeNodeTopArray) {
        int n = 1;
        for (int i = 0; i < ptreeNodeTopArray.length; ++i) {
            if (ptreeNodeTopArray[i] == null) continue;
            this.outputPtree2(i, ptreeNodeTopArray[i], n);
            ++n;
        }
    }

    private void outputPtree2(int n, PtreeNodeTop ptreeNodeTop, int n2) {
        String string = Integer.toString(n2);
        System.out.print("(" + string + ")");
        short[] sArray = new short[]{(short)n};
        this.outputItemSet(sArray);
        System.out.println("support = " + ptreeNodeTop.support);
        this.outputPtree3(ptreeNodeTop.childRef, string, 1);
    }

    private void outputPtree3(PtreeNode ptreeNode, String string, int n) {
        if (ptreeNode != null) {
            String string2;
            if (string == "start") {
                string2 = Integer.toString(n);
            } else {
                string2 = string.concat(".");
                string2 = string2.concat(Integer.toString(n));
            }
            System.out.print("(" + string2 + ")");
            this.outputItemSet(ptreeNode.itemSet);
            System.out.println("support = " + ptreeNode.support);
            this.outputPtree3(ptreeNode.childRef, string2, 1);
            this.outputPtree3(ptreeNode.siblingRef, string, ++n);
        }
    }

    public void outputPtree(JTextArea jTextArea) {
        jTextArea.append("P-TREE\n----------------\nFormat: (NodeNumber){ItemSet} support=S\n");
        this.outputPtree1(jTextArea, this.startPtreeRef);
        jTextArea.append("--------------------------\n");
    }

    public void outputPtree1(JTextArea jTextArea, PtreeNodeTop[] ptreeNodeTopArray) {
        int n = 1;
        for (int i = 0; i < ptreeNodeTopArray.length; ++i) {
            if (ptreeNodeTopArray[i] == null) continue;
            this.outputPtree2(jTextArea, i, ptreeNodeTopArray[i], n);
            ++n;
        }
    }

    private void outputPtree2(JTextArea jTextArea, int n, PtreeNodeTop ptreeNodeTop, int n2) {
        String string = Integer.toString(n2);
        jTextArea.append("(" + string + ")");
        short[] sArray = new short[]{(short)n};
        this.outputItemSet(jTextArea, sArray);
        jTextArea.append("support = " + ptreeNodeTop.support + "\n");
        this.outputPtree3(jTextArea, ptreeNodeTop.childRef, string, 1);
    }

    private void outputPtree3(JTextArea jTextArea, PtreeNode ptreeNode, String string, int n) {
        if (ptreeNode != null) {
            String string2;
            if (string == "start") {
                string2 = Integer.toString(n);
            } else {
                string2 = string.concat(".");
                string2 = string2.concat(Integer.toString(n));
            }
            jTextArea.append("(" + string2 + ")");
            this.outputItemSet(jTextArea, ptreeNode.itemSet);
            jTextArea.append("support = " + ptreeNode.support + "\n");
            this.outputPtree3(jTextArea, ptreeNode.childRef, string2, 1);
            this.outputPtree3(jTextArea, ptreeNode.siblingRef, string, ++n);
        }
    }

    public void outputPtreeStats() {
        System.out.println("P-TREE STATISTICS\n-------------------");
        System.out.println(this.calculateStorage(this.startPtreeRef) + " (Bytes) storage");
        System.out.println(this.calculateNumNodes(this.startPtreeRef) + " nodes");
        System.out.println(this.numPtreeNodeUpdates + " support value increments");
        System.out.println("-------------------------------------");
    }

    public void outputPtreeStats(JTextArea jTextArea) {
        jTextArea.append("P-TREE STATISTICS\n-----------------------------\n");
        jTextArea.append(this.calculateStorage(this.startPtreeRef) + " (Bytes) storage\n");
        jTextArea.append(this.calculateNumNodes(this.startPtreeRef) + " nodess\n");
        jTextArea.append(this.numPtreeNodeUpdates + " support value increments\n");
        jTextArea.append("-------------------------------------\n");
    }

    public void outputPtreeStorage() {
        int n = this.calculateStorage(this.startPtreeRef);
        System.out.println("P-tree storage = " + n + " (Bytes)");
    }

    private int calculateStorage(PtreeNodeTop[] ptreeNodeTopArray) {
        int n = 4;
        for (int i = 1; i < ptreeNodeTopArray.length; ++i) {
            if (ptreeNodeTopArray[i] != null) {
                n = this.calculateStorage(n, ptreeNodeTopArray[i]);
            }
            n += 4;
        }
        return n;
    }

    private int calculateStorage(int n, PtreeNodeTop ptreeNodeTop) {
        return this.calculateStorage(n += 8, ptreeNodeTop.childRef);
    }

    private int calculateStorage(int n, PtreeNode ptreeNode) {
        if (ptreeNode != null) {
            n = n + 12 + ptreeNode.itemSet.length * 2;
            n = this.calculateStorage(n, ptreeNode.childRef);
            n = this.calculateStorage(n, ptreeNode.siblingRef);
        }
        return n;
    }

    public void outputNumNodes() {
        int n = this.calculateNumNodes(this.startPtreeRef);
        System.out.println("Number of P-tree nodes = " + n);
        System.out.println("Number of P-tree updatess = " + this.numPtreeNodeUpdates);
    }

    private int calculateNumNodes(PtreeNodeTop[] ptreeNodeTopArray) {
        int n = 0;
        for (int i = 1; i < ptreeNodeTopArray.length; ++i) {
            if (ptreeNodeTopArray[i] == null) continue;
            n = 1 + this.calculateNumNodes(n, ptreeNodeTopArray[i].childRef);
        }
        return n;
    }

    private int calculateNumNodes(int n, PtreeNode ptreeNode) {
        if (ptreeNode != null) {
            ++n;
            n = this.calculateNumNodes(n, ptreeNode.childRef);
            n = this.calculateNumNodes(n, ptreeNode.siblingRef);
        }
        return n;
    }

    public void outputPtreeTable() {
        int n;
        System.out.println("P-tree Nodes of cardinality [N]: ");
        for (n = 1; n < this.pTreeNodesOfCardinalityN.length; ++n) {
            System.out.println("[" + n + "] " + this.pTreeNodesOfCardinalityN[n]);
        }
        System.out.println("Marker values on completion of P-tree table generation: ");
        for (n = 1; n < this.pTreeTableMarker.length; ++n) {
            System.out.println("[" + n + "] " + this.pTreeTableMarker[n]);
        }
        for (n = 1; n < this.startPtreeTable.length; ++n) {
            System.out.println("LEVEL = " + n);
            if (this.startPtreeTable[n] == null) {
                System.out.println("null");
                continue;
            }
            for (int i = 0; i < this.pTreeTableMarker[n]; ++i) {
                System.out.print("Node label = ");
                this.outputItemSet(this.startPtreeTable[n][i].pTreeNodeLabel);
                System.out.print(" Itemset = ");
                this.outputItemSet(this.startPtreeTable[n][i].pTreeItemSet);
                System.out.println(" sup = " + this.startPtreeTable[n][i].support);
            }
        }
    }

    public void outputPtreeTable(JTextArea jTextArea) {
        for (int i = 1; i < this.startPtreeTable.length; ++i) {
            jTextArea.append("LEVEL = " + i + "\n");
            if (this.startPtreeTable[i] == null) {
                jTextArea.append("null\n");
                continue;
            }
            for (int j = 0; j < this.pTreeTableMarker[i]; ++j) {
                jTextArea.append("Node label = ");
                this.outputItemSet(jTextArea, this.startPtreeTable[i][j].pTreeNodeLabel);
                jTextArea.append(" Itemset = ");
                this.outputItemSet(jTextArea, this.startPtreeTable[i][j].pTreeItemSet);
                jTextArea.append(" sup = " + this.startPtreeTable[i][j].support + "\n");
            }
        }
    }

    public void outputPtreeTableStats() {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < this.startPtreeTable.length; ++i) {
            int n3 = 0;
            if (this.startPtreeTable[i] == null) {
                n += 4;
            } else {
                for (int j = 0; j < this.pTreeTableMarker[i]; ++j) {
                    ++n3;
                    n = n + 4 + this.startPtreeTable[i][j].pTreeNodeLabel.length * 2;
                    n += this.startPtreeTable[i][j].pTreeItemSet.length * 2;
                }
            }
            n2 += n3;
        }
        System.out.println("P-tree Table Storage = " + n + " (" + n2 + " nodes)");
    }

    protected class PtreeRecord {
        protected short[] pTreeNodeLabel = null;
        protected short[] pTreeItemSet = null;
        protected int support = 0;

        protected PtreeRecord(short[] sArray, short[] sArray2, int n) {
            this.pTreeNodeLabel = sArray;
            this.pTreeItemSet = sArray2;
            this.support = n;
        }
    }
}

