/*
 * Decompiled with CFR 0.152.
 */
package asymmetry;

import asymmetry.Cholesky;

public class unfolding {
    double[][] X;
    double[][] Y;
    double[][] BMAT;
    double[][] diss;
    double[] rowS;
    double[] colS;
    int dim;
    int nrow;
    int ncol;

    public unfolding() {
        System.out.println("hello from unfolding " + this.ncol);
    }

    public void smacof() {
        int j;
        int i;
        this.nrow = 18;
        this.ncol = 6;
        this.dim = 2;
        this.rowS = new double[this.nrow];
        this.colS = new double[this.ncol];
        this.BMAT = new double[this.nrow][this.ncol];
        this.X = new double[this.nrow][this.dim];
        this.Y = new double[this.ncol][this.dim];
        this.diss = new double[this.nrow][this.ncol];
        for (i = 0; i < this.nrow; ++i) {
            for (j = 0; j < this.ncol; ++j) {
                this.diss[i][j] = (double)(i + j) + 0.0 * Math.random();
            }
        }
        for (i = 0; i < this.nrow; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.X[i][j] = (double)i + (double)j * 0.0 * Math.random();
            }
        }
        for (i = 0; i < this.ncol; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.Y[i][j] = (double)i + (double)j * 0.0 * Math.random();
            }
        }
    }

    public double[][] BMAT(double[][] data, double[][] X, double[][] Y, double[][] BMAT, int dim, int nrow, int ncol) {
        int j;
        int i;
        for (i = 0; i < nrow; ++i) {
            for (j = 0; j < ncol; ++j) {
                BMAT[i][j] = unfolding.distance(X, Y, dim, i, j) > 1.0E-16 ? data[i][j] / unfolding.distance(X, Y, dim, i, j) : 0.0;
            }
        }
        for (i = 0; i < nrow; ++i) {
            this.rowS[i] = 0.0;
        }
        for (i = 0; i < ncol; ++i) {
            this.colS[i] = 0.0;
        }
        for (i = 0; i < nrow; ++i) {
            for (j = 0; j < ncol; ++j) {
                int n = i;
                this.rowS[n] = this.rowS[n] + BMAT[i][j];
                int n2 = j;
                this.colS[n2] = this.colS[n2] + BMAT[i][j];
            }
        }
        return BMAT;
    }

    public double[][] updateX(double[][] BMAT, double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        int j;
        int i;
        double[][] XT = new double[nrow][dim];
        for (i = 0; i < nrow; ++i) {
            for (j = 0; j < dim; ++j) {
                XT[i][j] = this.rowS[i] * X[i][j];
            }
        }
        for (i = 0; i < nrow; ++i) {
            for (j = 0; j < dim; ++j) {
                for (int k = 0; k < ncol; ++k) {
                    double[] dArray = XT[i];
                    int n = j;
                    dArray[n] = dArray[n] - BMAT[i][k] * Y[k][j];
                }
            }
        }
        return XT;
    }

    public double[][] updateY(double[][] BMAT, double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        int j;
        int i;
        double[][] YT = new double[ncol][dim];
        for (i = 0; i < ncol; ++i) {
            for (j = 0; j < dim; ++j) {
                YT[i][j] = this.colS[i] * Y[i][j];
            }
        }
        for (i = 0; i < ncol; ++i) {
            for (j = 0; j < dim; ++j) {
                for (int k = 0; k < nrow; ++k) {
                    double[] dArray = YT[i];
                    int n = j;
                    dArray[n] = dArray[n] - BMAT[k][i] * X[k][j];
                }
            }
        }
        return YT;
    }

    public double[][] weightX(double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        double[][] V = new double[nrow][nrow];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < nrow; ++j) {
                V[i][j] = -1 / ((nrow + ncol) * ncol);
                if (i != j) continue;
                double[] dArray = V[i];
                int n = j;
                dArray[n] = dArray[n] + (double)(1 / nrow);
            }
        }
        double[][] XT = new double[nrow][dim];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < dim; ++j) {
                for (int k = 0; k < nrow; ++k) {
                    double[] dArray = XT[i];
                    int n = j;
                    dArray[n] = dArray[n] + V[i][k] * X[k][j];
                }
            }
        }
        return XT;
    }

    public void weight2(double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        for (int j = 0; j < dim; ++j) {
            int k;
            int i;
            double xs = 0.0;
            double ys = 0.0;
            for (i = 0; i < nrow; ++i) {
                xs += X[i][j];
            }
            xs /= (double)(nrow + ncol);
            for (k = 0; k < nrow; ++k) {
                X[k][j] = (X[k][j] - xs) / (double)ncol;
            }
            for (i = 0; i < ncol; ++i) {
                ys += Y[i][j];
            }
            ys /= (double)(nrow + ncol);
            for (k = 0; k < ncol; ++k) {
                Y[k][j] = (Y[k][j] - ys) / (double)nrow;
            }
        }
    }

    public double[][] weightY(double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        int i;
        double[][] V = new double[ncol][ncol];
        for (i = 0; i < ncol; ++i) {
            for (int j = 0; j < ncol; ++j) {
                V[i][j] = -1.0 / (double)((nrow + ncol) * nrow);
            }
        }
        i = 0;
        while (i < ncol) {
            double[] dArray = V[i];
            int n = i++;
            dArray[n] = dArray[n] + 1.0 / (double)ncol;
        }
        double[][] XT = new double[ncol][dim];
        for (int i2 = 0; i2 < ncol; ++i2) {
            for (int j = 0; j < dim; ++j) {
                for (int k = 0; k < ncol; ++k) {
                    double[] dArray = XT[i2];
                    int n = j;
                    dArray[n] = dArray[n] + V[i2][k] * Y[k][j];
                }
            }
        }
        return XT;
    }

    public String info() {
        String info = new String("hello from unfolding 3");
        Cholesky cd = new Cholesky((this.nrow + this.ncol) * (this.nrow + this.ncol - 1) / 2);
        for (int i = 0; i < 20; ++i) {
            this.BMAT = this.BMAT(this.diss, this.X, this.Y, this.BMAT, this.dim, this.nrow, this.ncol);
            this.X = this.updateX(this.BMAT, this.X, this.Y, this.dim, this.nrow, this.ncol);
            this.Y = this.updateY(this.BMAT, this.X, this.Y, this.dim, this.nrow, this.ncol);
            this.weight2(this.X, this.Y, this.dim, this.nrow, this.ncol);
            System.out.println(" stress  eq " + this.stress(this.diss, this.X, this.Y, this.dim, this.nrow, this.ncol) + "  " + this.X[0][0]);
        }
        return info;
    }

    public double stress(double[][] diss, double[][] X, double[][] Y, int dim, int nrow, int ncol) {
        double stress = 0.0;
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                stress += Math.pow(diss[i][j] - unfolding.distance(X, Y, dim, i, j), 2.0);
            }
        }
        return stress;
    }

    public static double distance(double[][] X, double[][] Y, int dim, int i, int j) {
        double result = 0.0;
        for (int k = 0; k < dim; ++k) {
            result += Math.pow(X[i][k] - Y[j][k], 2.0);
        }
        return Math.sqrt(result);
    }
}

