% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreCooksDistance.R
\name{scoreCooksDistance}
\alias{scoreCooksDistance}
\title{Score based on Cooks Distance}
\usage{
scoreCooksDistance(object, print = TRUE)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{print}{If TRUE progress is printed.}
}
\value{
numeric vector
}
\description{
Cook’s distance are used for estimate of the influence of an single observation.
}
\details{
Cook’s distance is a tool for identifying observations that may negatively affect the model.
They may be also used for indicating regions of the design space where it would be good to obtain more observations.
Data points indicated by Cook’s distances are worth checking for validity.

Cook’s Distances are calculated by removing the i-th observation from the data and recalculating the model.
It shows how much all the values in the model change when the i-th observation is removed.

Models of classes other than lm and glm the distances are computed directly from the definition,
so this may take a while.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
scoreCooksDistance(lm_au)


}
\seealso{
\code{\link{score}}
}
