% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_cooksdistance.R
\name{score_cooksdistance}
\alias{score_cooksdistance}
\alias{scoreCooksDistance}
\title{Score based on Cooks Distance}
\usage{
score_cooksdistance(object, verbose = TRUE)

scoreCooksDistance(object, verbose = TRUE)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{verbose}{If TRUE progress is printed.}
}
\value{
A vector of Cook's distances for each observation.

numeric vector
}
\description{
Cook’s distance are used for estimate of the influence of an single observation.
}
\details{
Cook’s distance is a tool for identifying observations that may negatively affect the model.
They may be also used for indicating regions of the design space where it would be good to obtain more observations.
Data points indicated by Cook’s distances are worth checking for validity.

Cook’s Distances are calculated by removing the i-th observation from the data and recalculating the model.
It shows how much all the values in the model change when the i-th observation is removed.

Models of classes other than lm and glm the distances are computed directly from the definition,
so this may take a while.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_cooksdistance(exp_lm)


}
\seealso{
\code{\link{score}}
}
