% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_score}
\alias{print.auditor_score}
\title{Prints of Models Scores}
\usage{
\method{print}{auditor_score}(x, ...)
}
\arguments{
\item{x}{an object \code{auditor_score} created with \code{\link{score}} function.}

\item{...}{other parameters}
}
\description{
Prints of Models Scores
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"
# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)
# create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)
# calculate score
score(exp_glm, type = "auc")

}
