% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals_outliers}
\alias{check_residuals_outliers}
\title{Checks for outliers}
\usage{
check_residuals_outliers(object, n = 5)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{n}{number of lowest and highest standardized  residuals to be presented}
}
\value{
indexes of lowest and highest standardized  residuals
}
\description{
Outlier checks
}
\examples{
dragons <- DALEX::dragons[1:100, ]
lm_model <- lm(life_length ~ ., data = dragons)
lm_audit <- audit(lm_model, data = dragons, y = dragons$life_length)
check_residuals_outliers(lm_audit)
}
