% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bain_sensitivity.R
\name{bain_sensitivity}
\alias{bain_sensitivity}
\title{Sensitivity analysis for bain}
\usage{
bain_sensitivity(x, hypothesis, fractions = 1, ...)
}
\arguments{
\item{x}{An R object containing the outcome of a statistical analysis.
Currently, the following objects can be processed: \code{lm()},
\code{t_test()}, \code{lavaan} objects created with the
\code{sem()}, \code{cfa()}, and \code{growth()} functions, and named
vector objects. See the vignette for elaborations.}

\item{hypothesis}{A character string containing the informative hypotheses
to evaluate. See the vignette for elaborations.}

\item{fractions}{A numeric vector, representing the fractions of information
in the data to be used to construct the prior distribution
(see the tutorial DOI: 10.1037/met0000201): The default value 1 denotes the
minimal fraction, 2 denotes twice the minimal fraction, etc.}

\item{...}{Additional arguments passed to \code{\link[bain]{bain}}.}
}
\value{
A \code{data.frame} of class \code{"bain_sensitivity"}.
}
\description{
Conducts a sensitivity analysis for \code{\link[bain]{bain}}.
}
\details{
The Bayes factor for equality constraints is sensitive to a
scaling factor applied to the prior distribution. The argument
\code{fraction} adjusts this scaling factor. The function
\code{bain_sensitivity}
is a wrapper for \code{\link[bain]{bain}}, which accepts a vector for the
\code{fractions} argument, and returns a list of bain results objects.
A table with a sensitivity analysis for specific statistics can be obtained
using the \code{summary()} function, which accepts the argument
\code{summary(which_stat = ...)}. The available statistics are elements of
the \code{$fit} table (Fit_eq, Com_eq, Fit_in, Com_in, Fit, Com, BF, PMPa,
and PMPb), and elements of the
\code{BFmatrix}, which can be accessed by matrix notation, e.g.:
\code{summary(bain_sens, which_stat = "BFmatrix[1,2]")}.
}
\examples{
sesamesim$site <- as.factor(sesamesim$site)
res <- lm(sesamesim$postnumb~sesamesim$site-1)
set.seed(4583)
bain_sens <- bain_sensitivity(res, "site1=site2;
                                    site2>site5",
                                    fractions = c(1,2,3))
summary(bain_sens, which_stat = "BF.c")
summary(bain_sens, which_stat = "BFmatrix[1,2]")
}
