% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binb.R
\name{metropolis}
\alias{metropolis}
\alias{iqss}
\alias{monash}
\alias{presento}
\title{Binb is not Beamer - PDF Presentation Themes}
\usage{
metropolis(toc = FALSE, slide_level = 2, incremental = FALSE,
  fig_width = 10, fig_height = 7, fig_crop = TRUE,
  fig_caption = TRUE, dev = "pdf", df_print = "default",
  fonttheme = "default", highlight = "tango", keep_tex = FALSE,
  latex_engine = "xelatex", citation_package = c("none", "natbib",
  "biblatex"), includes = NULL, md_extensions = NULL,
  pandoc_args = NULL)

iqss(toc = FALSE, slide_level = 3, incremental = FALSE,
  fig_width = 10, fig_height = 7, fig_crop = TRUE,
  fig_caption = TRUE, dev = "pdf", df_print = "default",
  fonttheme = "default", highlight = "haddock", keep_tex = FALSE,
  latex_engine = "xelatex", citation_package = c("none", "natbib",
  "biblatex"), includes = NULL, md_extensions = NULL,
  pandoc_args = NULL)

monash(toc = FALSE, slide_level = 2, incremental = FALSE,
  fig_width = 8, fig_height = 5, fig_crop = TRUE,
  fig_caption = TRUE, dev = "pdf", df_print = "default",
  fonttheme = "default", highlight = "tango", keep_tex = FALSE,
  latex_engine = "pdflatex", citation_package = c("none", "natbib",
  "biblatex"), includes = NULL, md_extensions = NULL,
  pandoc_args = NULL)

presento(toc = FALSE, slide_level = 2, incremental = FALSE,
  fig_width = 10, fig_height = 7, fig_crop = TRUE,
  fig_caption = TRUE, dev = "pdf", df_print = "default",
  fonttheme = "default", highlight = "haddock", keep_tex = FALSE,
  latex_engine = "xelatex", citation_package = c("none", "natbib",
  "biblatex"), includes = NULL, md_extensions = NULL,
  pandoc_args = NULL)
}
\arguments{
\item{toc}{A logical variable defaulting to \code{FALSE}.}

\item{slide_level}{A numeric variable defaulting to two for
\sQuote{Metropolis} and \sQuote{Monash}, and three for \sQuote{IQSS}.}

\item{incremental}{A logical variable defaulting to \code{FALSE}.}

\item{fig_width}{A numeric variable defaulting to ten.}

\item{fig_height}{A numeric variable defaulting to seven.}

\item{fig_crop}{A logical variable defaulting to \code{TRUE}.}

\item{fig_caption}{A logical variable defaulting to \code{TRUE}.}

\item{dev}{A character variable defaulting to \dQuote{pdf}.}

\item{df_print}{A character variable defaulting to \dQuote{default}.}

\item{fonttheme}{A character variable defaulting to \dQuote{default}.}

\item{highlight}{A character variable defaulting to \dQuote{tango}.}

\item{keep_tex}{A logical variable defaulting to \code{FALSE}.}

\item{latex_engine}{A character variable defaulting to \dQuote{xelatex}.}

\item{citation_package}{An optional character variable with possible value
\dQuote{none}, \dQuote{natbib} (the default), or \dQuote{biblatex}.}

\item{includes}{An optional character variable defaulting to \code{NULL}.}

\item{md_extensions}{An optional character variable defaulting to \code{NULL}.}

\item{pandoc_args}{An optional character variable defaulting to \code{NULL}.}
}
\value{
RMarkdown content processed is returned for use by the
\code{\link[rmarkdown]{render}} function but the function is invoked
for it side effect of creating the pdf file.
}
\description{
Templates for RMarkdown-based Beamer PDF presentations supporting
the \sQuote{Metropolis} style by Matthias Vogelgesang and others,
the \sQuote{IQSS} style by Ista Zahn and Gary King,
and the \sQuote{Monash} style by Rob J Hyndman.
}
\details{
Note that not all options and customizations available at the LaTeX
level are implemented or supported yet.  A number of styling options
could be exposed by setting YAML meta-data in the header for either
style. This needs more testing and documentation.
}
\section{IQSS Details}{
 We currently set \code{slide_level} to three to use
the same appearance as the LaTeX demo. This means section and sub-section headers
use one and two hash marks, new slides use three, and \dQuote{box} environments
start with four. More commonly, Beamer theme use two and work without subsections.
}

\examples{
\dontrun{
library(rmarkdown)
draft("myslides.Rmd", template="metropolis", package="binb", edit=FALSE)
setwd("myslides")       ## template creates a new subdir
render("myslides.Rmd")
}
}
\seealso{
Three other packages also offer RMarkdown interfaces to LaTeX
(or HTML) content: \code{\link[tint]{tint}} for Tufte-style pdf and html,
\code{\link[pinp]{pinp}} for two-column pdf vignettes, and
\code{\link[linl]{linl}} for LaTeX letters.
}
\author{
Dirk Eddelbuettel
}
