% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-html.R
\name{splitChapter}
\alias{splitChapter}
\title{Split a chapter based on the 'split_by' parameter.}
\usage{
splitChapter(
  configFile = NULL,
  configDir = "./config",
  mdFile = NULL,
  indexPath = "index.Rmd",
  intermediateDir = "./interim",
  outputDir = "./report",
  verbose = TRUE
)
}
\arguments{
\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{mdFile}{(optional) Path to the Markdown file containing the chapter.
If not specified, the Markdown file corresponding to the specified
\code{configFile} parameter is used.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{outputDir}{String with output directory,
('report' by default).}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
during the report execution.}
}
\value{
No return value, the Markdown files are split as specified.
}
\description{
Split a chapter based on the 'split_by' parameter.
}
\section{Extension to chapter-specific split}{

The bookdown 'split_by' parameter is extended, to support:
\itemize{
\item chapter-specific split, specified in the configuration file
of the specific chapter, via the \code{split_by} parameter
\item specification as a number (if specified within a config file), 
e.g. '0' for no split, 1' for chapter, '2' for
section, '3' for subsection, ...
\item split at section level higher than 2 (until 7)  
(if specified within a config file)
}
}

\author{
Laure Cougnaud
}
