% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-methods.R
\name{get_multi_metric_chart}
\alias{get_multi_metric_chart}
\title{Get Multi-Metric Chart}
\usage{
get_multi_metric_chart(
  experiment_keys,
  metrics = list(),
  params = list(),
  full = TRUE,
  independent = TRUE,
  api_key = NULL
)
}
\arguments{
\item{experiment_keys}{List of experiment keys.}

\item{metrics}{List of metric names to retrieve.}

\item{params}{List of parameter names to retrieve.}

\item{full}{Whether to fetch all values (up to 15,000) or a sampled subset (about 500 points).}

\item{independent}{Whether the metrics should be fetched individually or as a correlated whole
(only return values for steps for which you have values for every requested metric name).}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}
}
\description{
Get Multi-Metric Chart
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY variable defined
experiment <- "<your experiment key>"
metrics <- c("<metric1>", "<metric2>")
get_multi_metric_chart(experiment_keys = experiment, metrics = metrics)
}

}
