% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretiseData.R
\name{ctDiscretiseData}
\alias{ctDiscretiseData}
\title{Discretise long format continuous time (ctsem) data to specific timestep.}
\usage{
ctDiscretiseData(
  dlong,
  timestep,
  timecol = "time",
  idcol = "id",
  TDpredNames = NULL,
  TIpredNames = NULL
)
}
\arguments{
\item{dlong}{Long format data}

\item{timestep}{Positive real value to discretise}

\item{timecol}{Name of column containing absolute (not intervals) time information.}

\item{idcol}{Name of column containing subject id variable.}

\item{TDpredNames}{Vector of column names of any time dependent predictors}

\item{TIpredNames}{Vector of column names of any time independent predictors}
}
\value{
long format ctsem data.
}
\description{
Extends and rounds timing information so equal intervals, according to specified
timestep, are achieved. NA's are inserted in other columns as necessary,
any columns specified by TDpredNames or TIpredNames have zeroes rather than NA's
inserted (because some estimation routines do not tolerate NA's in covariates).
}
\examples{
long <- ctWideToLong(datawide=ctExample2,Tpoints=8,n.manifest=2,n.TDpred=1,
 manifestNames=c('LeisureTime','Happiness'),
 TDpredNames=c('MoneyInt'))

long <- ctDeintervalise(long)

long <- ctDiscretiseData(dlong=long, timestep = 1.1,TDpredNames=c('MoneyInt'))
}
