
###################################################

# (getMoveCube) (getSliceCube) (getRotCube) 
# (getPOMoveCube)

###################################################

# get move cubes for cubieCube representation
# code is isolated: no calls to other functions 
# all functions are internal

getMoveCube <- function(move) 
{
  out <- switch(EXPR = move,
         "U1" = ,
         "U" = list(cp = c(4L, 1L, 2L, 3L, 5L, 6L, 7L, 8L), 
                    ep = c(1L, 2L, 3L, 4L, 8L, 5L, 6L, 7L, 9L, 10L, 11L, 12L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "R1" = ,
         "R" = list(cp = c(5L, 2L, 3L, 1L, 8L, 6L, 7L, 4L), 
                    ep = c(9L, 2L, 3L, 5L, 1L, 6L, 7L, 8L, 4L, 10L, 11L, 12L), 
                    co = c(2L, 0L, 0L, 1L, 1L, 0L, 0L, 2L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "F1" = ,
         "F" = list(cp = c(2L, 6L, 3L, 4L, 1L, 5L, 7L, 8L), 
                    ep = c(6L, 10L, 3L, 4L, 5L, 2L, 7L, 8L, 9L, 1L, 11L, 12L), 
                    co = c(1L, 2L, 0L, 0L, 2L, 1L, 0L, 0L),
                    eo = c(1L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L)),
         "D1" = ,
         "D" = list(cp = c(1L, 2L, 3L, 4L, 6L, 7L, 8L, 5L), 
                    ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 10L, 11L, 12L, 9L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "L1" = ,
         "L" = list(cp = c(1L, 3L, 7L, 4L, 5L, 2L, 6L, 8L), 
                    ep = c(1L, 7L, 11L, 4L, 5L, 6L, 3L, 8L, 9L, 10L, 2L, 12L), 
                    co = c(0L, 1L, 2L, 0L, 0L, 2L, 1L, 0L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "B1" = ,
         "B" = list(cp = c(1L, 2L, 4L, 8L, 5L, 6L, 3L, 7L), 
                    ep = c(1L, 2L, 8L, 12L, 5L, 6L, 7L, 4L, 9L, 10L, 11L, 3L), 
                    co = c(0L, 0L, 1L, 2L, 0L, 0L, 2L, 1L), 
                    eo = c(0L, 0L, 1L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 1L)),
         "U'" = ,
         "U3" = list(cp = c(2L, 3L, 4L, 1L, 5L, 6L, 7L, 8L), 
                     ep = c(1L, 2L, 3L, 4L, 6L, 7L, 8L, 5L, 9L, 10L, 11L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "R'" = ,
         "R3" = list(cp = c(4L, 2L, 3L, 8L, 1L, 6L, 7L, 5L), 
                     ep = c(5L, 2L, 3L, 9L, 4L, 6L, 7L, 8L, 1L, 10L, 11L, 12L), 
                     co = c(2L, 0L, 0L, 1L, 1L, 0L, 0L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "F'" = ,
         "F3" = list(cp = c(5L, 1L, 3L, 4L, 6L, 2L, 7L, 8L), 
                     ep = c(10L, 6L, 3L, 4L, 5L, 1L, 7L, 8L, 9L, 2L, 11L, 12L), 
                     co = c(1L, 2L, 0L, 0L, 2L, 1L, 0L, 0L),
                     eo = c(1L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L)),
         "D'" = ,
         "D3" = list(cp = c(1L, 2L, 3L, 4L, 8L, 5L, 6L, 7L), 
                     ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 12L, 9L, 10L, 11L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "L'" = ,
         "L3" = list(cp = c(1L, 6L, 2L, 4L, 5L, 7L, 3L, 8L), 
                     ep = c(1L, 11L, 7L, 4L, 5L, 6L, 2L, 8L, 9L, 10L, 3L, 12L), 
                     co = c(0L, 1L, 2L, 0L, 0L, 2L, 1L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "B'" = ,
         "B3" = list(cp = c(1L, 2L, 7L, 3L, 5L, 6L, 8L, 4L), 
                     ep = c(1L, 2L, 12L, 8L, 5L, 6L, 7L, 3L, 9L, 10L, 11L, 4L), 
                     co = c(0L, 0L, 1L, 2L, 0L, 0L, 2L, 1L), 
                     eo = c(0L, 0L, 1L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 1L)),
         "U2'" = ,
         "U2" = list(cp = c(3L, 4L, 1L, 2L, 5L, 6L, 7L, 8L), 
                     ep = c(1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L, 9L, 10L, 11L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "R2'" = ,
         "R2" = list(cp = c(8L, 2L, 3L, 5L, 4L, 6L, 7L, 1L), 
                     ep = c(4L, 2L, 3L, 1L, 9L, 6L, 7L, 8L, 5L, 10L, 11L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "F2'" = ,
         "F2" = list(cp = c(6L, 5L, 3L, 4L, 2L, 1L, 7L, 8L), 
                     ep = c(2L, 1L, 3L, 4L, 5L, 10L, 7L, 8L, 9L, 6L, 11L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L),
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "D2'" = ,
         "D2" = list(cp = c(1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L), 
                     ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 11L, 12L, 9L, 10L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "L2'" = ,
         "L2" = list(cp = c(1L, 7L, 6L, 4L, 5L, 3L, 2L, 8L), 
                     ep = c(1L, 3L, 2L, 4L, 5L, 6L, 11L, 8L, 9L, 10L, 7L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "B2'" = ,
         "B2" = list(cp = c(1L, 2L, 8L, 7L, 5L, 6L, 4L, 3L), 
                     ep = c(1L, 2L, 4L, 3L, 5L, 6L, 7L, 12L, 9L, 10L, 11L, 8L),
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         stop("illegal move"))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}

# E = D'Uy' / M = L'Rx' / S = B'Fz'  
# does not include the rotation
getSliceCube <- function(move) 
{
  out <- switch(EXPR = move,
         "D'U" = ,
         "E1" = ,
         "E" = list(cp = c(4L, 1L, 2L, 3L, 8L, 5L, 6L, 7L), 
                    ep = c(1L, 2L, 3L, 4L, 8L, 5L, 6L, 7L, 12L, 9L, 10L, 11L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "L'R" = ,
         "M1" = ,
         "M" = list(cp = c(5L, 6L, 2L, 1L, 8L, 7L, 3L, 4L), 
                    ep = c(9L, 11L, 7L, 5L, 1L, 6L, 2L, 8L, 4L, 10L, 3L, 12L), 
                    co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "B'F" = ,
         "S1" = ,
         "S" = list(cp = c(2L, 6L, 7L, 3L, 1L, 5L, 8L, 4L), 
                    ep = c(6L, 10L, 12L, 8L, 5L, 2L, 7L, 3L, 9L, 1L, 11L, 4L), 
                    co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L),
                    eo = c(1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
         "DU'" = ,
         "E'" = ,
         "E3" = list(cp = c(2L, 3L, 4L, 1L, 6L, 7L, 8L, 5L), 
                     ep = c(1L, 2L, 3L, 4L, 6L, 7L, 8L, 5L, 10L, 11L, 12L, 9L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "LR'" = ,
         "M'" = ,
         "M3" = list(cp = c(4L, 3L, 7L, 8L, 1L, 2L, 6L, 5L), 
                     ep = c(5L, 7L, 11L, 9L, 4L, 6L, 3L, 8L, 1L, 10L, 2L, 12L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "BF'" = ,
         "S'" = ,
         "S3" = list(cp = c(5L, 1L, 4L, 8L, 6L, 2L, 3L, 7L), 
                     ep = c(10L, 6L, 8L, 12L, 5L, 1L, 7L, 4L, 9L, 2L, 11L, 3L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L),
                     eo = c(1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
         "D2U2" = ,
         "E2'" = ,
         "E2" = list(cp = c(3L, 4L, 1L, 2L, 7L, 8L, 5L, 6L), 
                     ep = c(1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L, 11L, 12L, 9L, 10L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "L2R2" = ,
         "M2'" = ,
         "M2" = list(cp = c(8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 
                     ep = c(4L, 3L, 2L, 1L, 9L, 6L, 11L, 8L, 5L, 10L, 7L, 12L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         "B2F2" = ,
         "S2'" = ,
         "S2" = list(cp = c(6L, 5L, 8L, 7L, 2L, 1L, 4L, 3L), 
                     ep = c(2L, 1L, 4L, 3L, 5L, 10L, 7L, 12L, 9L, 6L, 11L, 8L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L),
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
         stop("illegal move"))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}

# get one of 24 rotations
getRotCube <- function(move) 
{
  if(move < 1 || move > 24)
    stop("rotation must be an integer between 1 and 24")
  out <- switch(EXPR = move,
                #1
                list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                    ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #2
                list(cp = c(4L, 1L, 2L, 3L, 8L, 5L, 6L, 7L), 
                    ep = c(4L, 1L, 2L, 3L, 8L, 5L, 6L, 7L, 12L, 9L, 10L, 11L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #3
                list(cp = c(3L, 4L, 1L, 2L, 7L, 8L, 5L, 6L), 
                    ep = c(3L, 4L, 1L, 2L, 7L, 8L, 5L, 6L, 11L, 12L, 9L, 10L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L),
                    eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #4
                list(cp = c(2L, 3L, 4L, 1L, 6L, 7L, 8L, 5L), 
                    ep = c(2L, 3L, 4L, 1L, 6L, 7L, 8L, 5L, 10L, 11L, 12L, 9L), 
                    co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                    eo = c(1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #5
                list(cp = c(6L, 5L, 8L, 7L, 2L, 1L, 4L, 3L), 
                     ep = c(2L, 1L, 4L, 3L, 11L, 10L, 9L, 12L, 7L, 6L, 5L, 8L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #6
                list(cp = c(7L, 6L, 5L, 8L, 3L, 2L, 1L, 4L), 
                     ep = c(3L, 2L, 1L, 4L, 12L, 11L, 10L, 9L, 8L, 7L, 6L, 5L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #7
                list(cp = c(8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 
                     ep = c(4L, 3L, 2L, 1L, 9L, 12L, 11L, 10L, 5L, 8L, 7L, 6L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L),
                     eo = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #8
                list(cp = c(5L, 8L, 7L, 6L, 1L, 4L, 3L, 2L), 
                     ep = c(1L, 4L, 3L, 2L, 10L, 9L, 12L, 11L, 6L, 5L, 8L, 7L), 
                     co = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), 
                     eo = c(1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)),
                #9
                list(cp = c(1L, 5L, 6L, 2L, 4L, 8L, 7L, 3L), 
                     ep = c(5L, 9L, 11L, 7L, 6L, 1L, 10L, 2L, 8L, 4L, 12L, 3L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L)),
                #10
                list(cp = c(2L, 1L, 5L, 6L, 3L, 4L, 8L, 7L), 
                     ep = c(7L, 5L, 9L, 11L, 2L, 6L, 1L, 10L, 3L, 8L, 4L, 12L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
                #11
                list(cp = c(6L, 2L, 1L, 5L, 7L, 3L, 4L, 8L), 
                     ep = c(11L, 7L, 5L, 9L, 10L, 2L, 6L, 1L, 12L, 3L, 8L, 4L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L),
                     eo = c(1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L)),
                #12
                list(cp = c(5L, 6L, 2L, 1L, 8L, 7L, 3L, 4L), 
                     ep = c(9L, 11L, 7L, 5L, 1L, 10L, 2L, 6L, 4L, 12L, 3L, 8L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
                #13
                list(cp = c(8L, 4L, 3L, 7L, 5L, 1L, 2L, 6L), 
                     ep = c(9L, 5L, 7L, 11L, 12L, 4L, 8L, 3L, 10L, 1L, 6L, 2L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L)),
                #14
                list(cp = c(7L, 8L, 4L, 3L, 6L, 5L, 1L, 2L), 
                     ep = c(11L, 9L, 5L, 7L, 3L, 12L, 4L, 8L, 2L, 10L, 1L, 6L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
                #15
                list(cp = c(3L, 7L, 8L, 4L, 2L, 6L, 5L, 1L), 
                     ep = c(7L, 11L, 9L, 5L, 8L, 3L, 12L, 4L, 6L, 2L, 10L, 1L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L),
                     eo = c(1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L)),
                #16
                list(cp = c(4L, 3L, 7L, 8L, 1L, 2L, 6L, 5L), 
                     ep = c(5L, 7L, 11L, 9L, 4L, 8L, 3L, 12L, 1L, 6L, 2L, 10L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L)),
                #17
                list(cp = c(1L, 4L, 8L, 5L, 2L, 3L, 7L, 6L), 
                     ep = c(6L, 8L, 12L, 10L, 1L, 5L, 4L, 9L, 2L, 7L, 3L, 11L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #18
                list(cp = c(5L, 1L, 4L, 8L, 6L, 2L, 3L, 7L), 
                     ep = c(10L, 6L, 8L, 12L, 9L, 1L, 5L, 4L, 11L, 2L, 7L, 3L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #19
                list(cp = c(8L, 5L, 1L, 4L, 7L, 6L, 2L, 3L), 
                     ep = c(12L, 10L, 6L, 8L, 4L, 9L, 1L, 5L, 3L, 11L, 2L, 7L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L),
                     eo = c(0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #20
                list(cp = c(4L, 8L, 5L, 1L, 3L, 7L, 6L, 2L), 
                     ep = c(8L, 12L, 10L, 6L, 5L, 4L, 9L, 1L, 7L, 3L, 11L, 2L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #21
                list(cp = c(3L, 2L, 6L, 7L, 4L, 1L, 5L, 8L), 
                     ep = c(8L, 6L, 10L, 12L, 3L, 7L, 2L, 11L, 4L, 5L, 1L, 9L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L), 
                     eo = c(0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #22
                list(cp = c(7L, 3L, 2L, 6L, 8L, 4L, 1L, 5L), 
                     ep = c(12L, 8L, 6L, 10L, 11L, 3L, 7L, 2L, 9L, 4L, 5L, 1L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #23
                list(cp = c(6L, 7L, 3L, 2L, 5L, 8L, 4L, 1L), 
                     ep = c(10L, 12L, 8L, 6L, 2L, 11L, 3L, 7L, 1L, 9L, 4L, 5L), 
                     co = c(2L, 1L, 2L, 1L, 1L, 2L, 1L, 2L),
                     eo = c(0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)),
                #24
                list(cp = c(2L, 6L, 7L, 3L, 1L, 5L, 8L, 4L), 
                     ep = c(6L, 10L, 12L, 8L, 7L, 2L, 11L, 3L, 5L, 1L, 9L, 4L), 
                     co = c(1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L), 
                     eo = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1)))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}


getPOMoveCube <- function(move) 
{
  out <- switch(EXPR = move,
                "U1" = ,
                "U" = list(cp = c(4L, 1L, 2L, 3L, 5L, 6L, 7L, 8L), 
                           ep = c(1L, 2L, 3L, 4L, 8L, 5L, 6L, 7L, 9L, 10L, 11L, 12L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "R1" = ,
                "R" = list(cp = c(5L, 2L, 3L, 1L, 8L, 6L, 7L, 4L), 
                           ep = c(9L, 2L, 3L, 5L, 1L, 6L, 7L, 8L, 4L, 10L, 11L, 12L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "F1" = ,
                "F" = list(cp = c(2L, 6L, 3L, 4L, 1L, 5L, 7L, 8L), 
                           ep = c(6L, 10L, 3L, 4L, 5L, 2L, 7L, 8L, 9L, 1L, 11L, 12L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "D1" = ,
                "D" = list(cp = c(1L, 2L, 3L, 4L, 6L, 7L, 8L, 5L), 
                           ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 10L, 11L, 12L, 9L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "L1" = ,
                "L" = list(cp = c(1L, 3L, 7L, 4L, 5L, 2L, 6L, 8L), 
                           ep = c(1L, 7L, 11L, 4L, 5L, 6L, 3L, 8L, 9L, 10L, 2L, 12L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "B1" = ,
                "B" = list(cp = c(1L, 2L, 4L, 8L, 5L, 6L, 3L, 7L), 
                           ep = c(1L, 2L, 8L, 12L, 5L, 6L, 7L, 4L, 9L, 10L, 11L, 3L), 
                           spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "U'" = ,
                "U3" = list(cp = c(2L, 3L, 4L, 1L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 6L, 7L, 8L, 5L, 9L, 10L, 11L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "R'" = ,
                "R3" = list(cp = c(4L, 2L, 3L, 8L, 1L, 6L, 7L, 5L), 
                            ep = c(5L, 2L, 3L, 9L, 4L, 6L, 7L, 8L, 1L, 10L, 11L, 12L),
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "F'" = ,
                "F3" = list(cp = c(5L, 1L, 3L, 4L, 6L, 2L, 7L, 8L), 
                            ep = c(10L, 6L, 3L, 4L, 5L, 1L, 7L, 8L, 9L, 2L, 11L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "D'" = ,
                "D3" = list(cp = c(1L, 2L, 3L, 4L, 8L, 5L, 6L, 7L), 
                            ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 12L, 9L, 10L, 11L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "L'" = ,
                "L3" = list(cp = c(1L, 6L, 2L, 4L, 5L, 7L, 3L, 8L), 
                            ep = c(1L, 11L, 7L, 4L, 5L, 6L, 2L, 8L, 9L, 10L, 3L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "B'" = ,
                "B3" = list(cp = c(1L, 2L, 7L, 3L, 5L, 6L, 8L, 4L), 
                            ep = c(1L, 2L, 12L, 8L, 5L, 6L, 7L, 3L, 9L, 10L, 11L, 4L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "U2'" = ,
                "U2" = list(cp = c(3L, 4L, 1L, 2L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L, 9L, 10L, 11L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "R2'" = ,
                "R2" = list(cp = c(8L, 2L, 3L, 5L, 4L, 6L, 7L, 1L), 
                            ep = c(4L, 2L, 3L, 1L, 9L, 6L, 7L, 8L, 5L, 10L, 11L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "F2'" = ,
                "F2" = list(cp = c(6L, 5L, 3L, 4L, 2L, 1L, 7L, 8L), 
                            ep = c(2L, 1L, 3L, 4L, 5L, 10L, 7L, 8L, 9L, 6L, 11L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "D2'" = ,
                "D2" = list(cp = c(1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L), 
                            ep = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 11L, 12L, 9L, 10L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "L2'" = ,
                "L2" = list(cp = c(1L, 7L, 6L, 4L, 5L, 3L, 2L, 8L), 
                            ep = c(1L, 3L, 2L, 4L, 5L, 6L, 11L, 8L, 9L, 10L, 7L, 12L), 
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "B2'" = ,
                "B2" = list(cp = c(1L, 2L, 8L, 7L, 5L, 6L, 4L, 3L), 
                            ep = c(1L, 2L, 4L, 3L, 5L, 6L, 7L, 12L, 9L, 10L, 11L, 8L),
                            spor = c(1L, 2L, 3L, 4L, 5L, 6L)),
                "E1" = ,
                "E" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                           ep = c(2L, 3L, 4L, 1L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L), 
                           spor = c(1L, 3L, 5L, 4L, 6L, 2L)),
                "M1" = ,
                "M" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                           ep = c(1L, 2L, 3L, 4L, 5L, 8L, 7L, 12L, 9L, 6L, 11L, 10L), 
                           spor = c(6L, 2L, 1L, 3L, 5L, 4L)),
                "S1" = ,
                "S" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                           ep = c(1L, 2L, 3L, 4L, 9L, 6L, 5L, 8L, 11L, 10L, 7L, 12L), 
                           spor = c(2L, 4L, 3L, 5L, 1L, 6L)),
                "E'" = ,
                "E3" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(4L, 1L, 2L, 3L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L), 
                            spor = c(1L, 6L, 2L, 4L, 3L, 5L)),
                "M'" = ,
                "M3" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 5L, 10L, 7L, 6L, 9L, 12L, 11L, 8L), 
                            spor = c(3L, 2L, 4L, 6L, 5L, 1L)),
                "S'" = ,
                "S3" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 7L, 6L, 11L, 8L, 5L, 10L, 9L, 12L), 
                            spor = c(5L, 1L, 3L, 2L, 4L, 6L)),
                "E2'" = ,
                "E2" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(3L, 4L, 1L, 2L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L), 
                            spor = c(1L, 5L, 6L, 4L, 2L, 3L)),
                "M2'" = ,
                "M2" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 5L, 12L, 7L, 10L, 9L, 8L, 11L, 6L), 
                            spor = c(4L, 2L, 6L, 1L, 5L, 3L)),
                "S2'" = ,
                "S2" = list(cp = c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), 
                            ep = c(1L, 2L, 3L, 4L, 11L, 6L, 9L, 8L, 7L, 10L, 5L, 12L), 
                            spor = c(4L, 5L, 3L, 1L, 2L, 6L)),
                
                "y1" = ,
                "y" = list(cp = c(4L, 1L, 2L, 3L, 8L, 5L, 6L, 7L), 
                           ep = c(4L, 1L, 2L, 3L, 8L, 5L, 6L, 7L, 12L, 9L, 10L, 11L), 
                           spor = c(1L, 6L, 2L, 4L, 3L, 5L)),
                "x1" = ,
                "x" = list(cp = c(5L, 6L, 2L, 1L, 8L, 7L, 3L, 4L), 
                           ep = c(9L, 11L, 7L, 5L, 1L, 10L, 2L, 6L, 4L, 12L, 3L, 8L), 
                           spor = c(3L, 2L, 4L, 6L, 5L, 1L)),
                "z1" = ,
                "z" = list(cp = c(2L, 6L, 7L, 3L, 1L, 5L, 8L, 4 ), 
                           ep = c(6L, 10L, 12L, 8L, 7L, 2L, 11L, 3L, 5L, 1L, 9L, 4L), 
                           spor = c(5L, 1L, 3L, 2L, 4L, 6L)),
                "y'" = ,
                "y3" = list(cp = c(2L, 3L, 4L, 1L, 6L, 7L, 8L, 5L), 
                            ep = c(2L, 3L, 4L, 1L, 6L, 7L, 8L, 5L, 10L, 11L, 12L, 9L), 
                            spor = c(1L, 3L, 5L, 4L, 6L, 2L)),
                "x'" = ,
                "x3" = list(cp = c(4L, 3L, 7L, 8L, 1L, 2L, 6L, 5L), 
                            ep = c(5L, 7L, 11L, 9L, 4L, 8L, 3L, 12L, 1L, 6L, 2L, 10L), 
                            spor = c(6L, 2L, 1L, 3L, 5L, 4L)),
                "z'" = ,
                "z3" = list(cp = c(5L, 1L, 4L, 8L, 6L, 2L, 3L, 7L), 
                            ep = c(10L, 6L, 8L, 12L, 9L, 1L, 5L, 4L, 11L, 2L, 7L, 3L), 
                            spor = c(2L, 4L, 3L, 5L, 1L, 6L)),
                "y2'" = ,
                "y2" = list(cp = c(3L, 4L, 1L, 2L, 7L, 8L, 5L, 6L), 
                            ep = c(3L, 4L, 1L, 2L, 7L, 8L, 5L, 6L, 11L, 12L, 9L, 10L), 
                            spor = c(1L, 5L, 6L, 4L, 2L, 3L)),
                "x2'" = ,
                "x2" = list(cp = c(8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 
                            ep = c(4L, 3L, 2L, 1L, 9L, 12L, 11L, 10L, 5L, 8L, 7L, 6L), 
                            spor = c(4L, 2L, 6L, 1L, 5L, 3L)),
                "z2'" = ,
                "z2" = list(cp = c(6L, 5L, 8L, 7L, 2L, 1L, 4L, 3L), 
                            ep = c(2L, 1L, 4L, 3L, 11L, 10L, 9L, 12L, 7L, 6L, 5L, 8L), 
                            spor = c(4L, 5L, 3L, 1L, 2L, 6L)),
                stop("illegal move"))
  
  names(out$cp) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  names(out$spor) <- c("U", "R", "F", "D", "L", "B")
  class(out) <- c("cubieCubePO", "cube")
  out
}



