% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_median.R
\name{datelife_result_median}
\alias{datelife_result_median}
\title{Get a median summary chronogram from a datelifeResult object}
\usage{
datelife_result_median(datelife_result, ...)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{...}{
  Arguments passed on to \code{\link[=summary_matrix_to_phylo]{summary_matrix_to_phylo}}
  \describe{
    \item{\code{summ_matrix}}{Any summary patristic distance matrix, such as the ones obtained with \code{\link[=datelife_result_sdm_matrix]{datelife_result_sdm_matrix()}} or \code{\link[=datelife_result_median_matrix]{datelife_result_median_matrix()}}.}
    \item{\code{total_distance}}{Boolean. If \code{TRUE} it will divide the matrix in half, if
\code{FALSE} it will take it as is.}
    \item{\code{use}}{A character vector indicating what type of age to use for summary.
One of the following:
\describe{
\item{mean}{It will use the mean of the node age distributions.}
\item{min}{It will use the minimum age from the node age distributions.}
\item{max}{Choose this if you wanna be conservative; it will use the maximum
age from the node age distributions.}
}}
    \item{\code{target_tree}}{A \code{phylo} object. Use this in case you want a particular
backbone for the output tree.}
    \item{\code{datelife_query}}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}
  }}
}
\value{
A phylo object
}
\description{
Get a median summary chronogram from a datelifeResult object
}
