% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_match.R
\name{match_all_calibrations}
\alias{match_all_calibrations}
\title{Match calibrations to nodes of a tree}
\usage{
match_all_calibrations(phy, calibrations)
}
\arguments{
\item{phy}{A \code{phylo} object. Nodes can be named or not.}

\item{calibrations}{An object of class \code{datelifeCalibrations}, that is,
an output of \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}
}
\value{
A list with:
\describe{
\item{phy}{A phylo object with additional data of calibration distributions per node.}
\item{matched_calibrations}{A data frame of summarized calibrations.}
\item{present_calibrations}{A data frame of summarized calibrations.}
}
TODO: Explain the difference between present_calibrations and matched_calibrations
}
\description{
\code{match_all_calibrations} summarizes nodes in tree that match
to any pair of given taxon names in a data frame of secondary calibrations.
}
\details{
The function takes pairs of taxon names in a secondary calibrations data frame,
and looks for them in the vector of tip labels of the tree. If both are present,
then it gets the node that represents the Most Recent
Common Ancestor for that pair of taxa in the tree.
}
