% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_chronograms.R
\name{clean_ott_chronogram}
\alias{clean_ott_chronogram}
\title{Clean up some issues with Open Tree of Life chronograms
For now it 1) checks unmapped taxa and maps them with tnrs_match.phylo, 2) roots the chronogram if unrooted}
\usage{
clean_ott_chronogram(phy)
}
\arguments{
\item{phy}{A phylo object}
}
\value{
An object of class  data frame or phylo, with the added class match_names.

\code{NULL}

\code{NULL}
}
\description{
Clean up some issues with Open Tree of Life chronograms
For now it 1) checks unmapped taxa and maps them with tnrs_match.phylo, 2) roots the chronogram if unrooted
}
\details{
There is no limit to the number of names that can be queried and matched.

The output will preserve all elements from original input phylo object and will add
\describe{
\item{phy$mapped}{A character vector indicating the state of mapping of phy$tip.labels:}
\describe{
\item{original}{Tnrs matching was not attempted. Original labeling is preserved.}
\item{ott}{Matching was manually made by a curator in Open Tree of Life.}
\item{tnrs}{Tnrs matching was attempted and successful with no approximate matching. Original label is replaced by the matched name.}
\item{approximated}{Tnrs matching was attempted and successful but with approximate matching. Original labeling is preserved.}
\item{unmatched}{Tnrs matching was attempted and unsuccessful. Original labeling is preserved.}
}
\item{phy$original.tip.label}{A character vector preserving all original labels.}
\item{phy$ott_ids}{A numeric vector with ott id numbers of matched tips. Unmatched and original tips will be NaN.}
}
if tips are duplicated, tnrs will only be run once (avoiding increases in function running time) but the result will be applied to all duplicated tip labels
}
