% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_result.R
\name{get_datelife_result_datelifequery}
\alias{get_datelife_result_datelifequery}
\title{Get a list of patristic matrices from a given \code{datelifeQuery} object}
\usage{
get_datelife_result_datelifequery(
  datelife_query = NULL,
  partial = TRUE,
  cache = "opentree_chronograms",
  update_opentree_chronograms = FALSE,
  ...
)
}
\arguments{
\item{datelife_query}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}

\item{partial}{Whether to return or exclude partially matching source chronograms,
i.e, those that match some and not all of taxa given in \code{datelife_query}.
Options are \code{TRUE} or \code{FALSE}. Defaults to \code{TRUE}: return all matching source
chronograms.}

\item{cache}{A character vector of length one, with the name of the data object
to cache. Default to \code{"opentree_chronograms"}, a data object storing Open Tree of
Life's database chronograms and other associated information.}

\item{update_opentree_chronograms}{Whether to update the chronogram database or not.
Defaults to \code{FALSE}.}

\item{...}{
  Arguments passed on to \code{\link[=make_datelife_query]{make_datelife_query}}
  \describe{
    \item{\code{input}}{Taxon names as one of the following:
\describe{
\item{A character vector of taxon names}{With taxon names as a single comma separated starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or \code{multiPhylo}
object, OR as a newick character string.}
}}
    \item{\code{use_tnrs}}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}
    \item{\code{get_spp_from_taxon}}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}
  }}
}
\value{
A \code{datelifeResult} object -- a named list of patristic matrices.
}
\description{
Get a list of patristic matrices from a given \code{datelifeQuery} object
}
\details{
If there is just one taxon name in \code{input$cleaned_names}, the
function will run \code{\link[=make_datelife_query]{make_datelife_query()}} setting \code{get_spp_from_taxon = TRUE}.
The \code{datelifeQuery} used as input can be accessed with \code{attributes(datelifeResult)$query}.
}
