% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_use.R
\name{use_calibrations}
\alias{use_calibrations}
\title{Date a given tree topology using a combined set of given calibrations}
\usage{
use_calibrations(
  phy = NULL,
  calibrations = NULL,
  dating_method = "bladj",
  type = "median",
  ...
)
}
\arguments{
\item{phy}{A \code{phylo} object to use as tree topology.}

\item{calibrations}{A \code{calibrations} object, an output of \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}

\item{dating_method}{Tree dating algorithm to use. Options are "bladj" or "pathd8"
(Webb et al., 2008, \doi{10.1093/bioinformatics/btn358}; Britton et al., 2007,
\doi{10.1080/10635150701613783}).}

\item{type}{The type of age to use as calibration. Options are "median", "mean", "min", or "max".}

\item{...}{
  Arguments passed on to \code{\link[=use_calibrations_pathd8]{use_calibrations_pathd8}}
  \describe{
    \item{\code{expand}}{How much to expand by each step to get consistent calibrations. Should be between 0 and 1.}
    \item{\code{giveup}}{How many expansions to try before giving up}
  }}
}
\value{
A \code{phylo} object with branch lengths proportional to time.
}
\description{
\code{use_calibrations} combines all given calibrations and uses them as
constraints to perform a dating analysis on a given tree topology, using BLADJ
if it has no branch lengths, or PATHd8 if the given tree topology has initial
branch lengths.
}
\details{
If \code{phy} has no branch lengths, \code{dating_method} is ignores, and the function applies secondary
calibrations to date the tree with the BLADJ algorithm. See \code{\link[=make_bladj_tree]{make_bladj_tree()}} and \code{\link[=use_calibrations_bladj]{use_calibrations_bladj()}}.
If \code{phy} has branch lengths, the function can use the PATHd8 algorithm. See \code{\link[=use_calibrations_pathd8]{use_calibrations_pathd8()}}.
}
\section{More}{
 The output object stores the used \code{calibrations} and \code{dating_method} as
\code{attributes(output)$datelife_calibrations} and \code{attributes(output)$dating_method}.
}

