% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerDoFuture.R
\name{registerDoFuture}
\alias{registerDoFuture}
\title{Registers the future \%dopar\% backend}
\usage{
registerDoFuture()
}
\value{
Invisibly returns the previously registered foreach backend.
}
\description{
Register the \link{doFuture} parallel adapter to be used by
the \pkg{foreach} package.
}
\section{For package developers}{

Please refrain from modifying the foreach backend inside your packages /
functions, i.e. do not call \code{registerNnn()} in your code.  Instead, leave
the control on what backend to use to the end user.  This idea is part of
the core philosophy of the foreach framework.

However, if you think it necessary to register the \pkg{doFuture} backend
in a function, please make sure to undo your changes when exiting the
function.
This can be done using:

\preformatted{
  oldDoPar <- registerDoFuture()
  on.exit(with(oldDoPar, foreach::setDoPar(fun=fun, data=data, info=info)), add = TRUE)
  [...]
}

This is important because the end-user might have already registered a
foreach backend elsewhere for other purposes and will most likely not known
that calling your function will break their setup.
\emph{Remember, your package and its functions might be used in a greater
context where multiple packages and functions are involved and those might
also rely on the foreach framework, so it is important to avoid stepping on
others' toes.}
}

\examples{
registerDoFuture()

}
\keyword{utilities}
