% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle_force.R
\name{edge_bundle_force}
\alias{edge_bundle_force}
\title{force directed edge bundling}
\usage{
edge_bundle_force(
  object,
  xy,
  K = 1,
  C = 6,
  P = 1,
  S = 0.04,
  P_rate = 2,
  I = 50,
  I_rate = 2/3,
  compatibility_threshold = 0.6,
  eps = 1e-08
)
}
\arguments{
\item{object}{a graph object (igraph/network/tbl_graph)}

\item{xy}{coordinates of vertices}

\item{K}{spring constant}

\item{C}{number of iteration cycles}

\item{P}{number of initial edge divisions}

\item{S}{initial step size}

\item{P_rate}{rate of edge divisions}

\item{I}{number of initial iterations}

\item{I_rate}{rate of iteration decrease per cycle}

\item{compatibility_threshold}{threshold for when edges are considered compatible}

\item{eps}{accuracy}
}
\value{
data.frame containing the bundled edges
}
\description{
Implements the classic edge bundling by Holten.
}
\details{
This is a re-implementation of https://github.com/upphiminn/d3.ForceBundle. Force directed edge bundling is slow (O(E^2)).

see \href{https://github.com/schochastics/edgebundle}{online} for plotting tips
}
\examples{
library(igraph)
g  <- graph_from_edgelist(matrix(c(1,12,2,11,3,10,4,9,5,8,6,7),ncol = 2,byrow = TRUE),FALSE)
xy <- cbind(c(rep(0,6),rep(1,6)),c(1:6,1:6))
edge_bundle_force(g,xy)
}
\references{
Holten, Danny, and Jarke J. Van Wijk. "Force-Directed Edge Bundling for Graph Visualization." Computer Graphics Forum (Blackwell Publishing Ltd) 28, no. 3 (2009): 983-990.
}
\seealso{
\link{edge_bundle_hammer},\link{edge_bundle_stub},\link{edge_bundle_path}
}
\author{
David Schoch
}
