% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{exclude_duplicates}
\alias{exclude_duplicates}
\title{Exclude rows with duplicate IP addresses and/or locations}
\usage{
exclude_duplicates(
  x,
  id_col = "ResponseId",
  ip_col = "IPAddress",
  location_col = c("LocationLatitude", "LocationLongitude"),
  dupl_ip = TRUE,
  dupl_location = TRUE,
  include_na = FALSE,
  quiet = TRUE,
  print = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{ip_col}{Column name for IP addresses.}

\item{location_col}{Two element vector specifying columns for latitude and
longitude (in that order).}

\item{dupl_ip}{Logical indicating whether to check IP addresses.}

\item{dupl_location}{Logical indicating whether to check latitude and
longitude.}

\item{include_na}{Logical indicating whether to include rows with NAs for
IP address and location as potentially excluded rows.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}

\item{silent}{Logical indicating whether to print message to console. Note
this argument controls the exclude message not the check message.}
}
\value{
An object of the same type as \code{x} that excludes rows
with duplicate IP addresses and/or locations.
For a function that just checks for and returns duplicate rows,
use \code{\link[=check_duplicates]{check_duplicates()}}. For a function that marks these rows,
use \code{\link[=mark_duplicates]{mark_duplicates()}}.
}
\description{
The \code{exclude_duplicates()} function removes
rows of data that have the same IP address and/or same latitude and
longitude. The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
By default, IP address and location are both checked, but they can be
checked separately with the \code{dupl_ip} and \code{dupl_location} arguments.

The function outputs to console separate messages about the number of
rows with duplicate IP addresses and rows with duplicate locations.
These counts are computed independently, so rows may be counted for both
types of duplicates.
}
\examples{
# Exclude duplicate IP addresses and locations
data(qualtrics_text)
df <- exclude_duplicates(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_duplicates()

# Exclude only for duplicate locations
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_duplicates(dupl_location = FALSE)
}
\seealso{
Other duplicates functions: 
\code{\link{check_duplicates}()},
\code{\link{mark_duplicates}()}

Other exclude functions: 
\code{\link{exclude_duration}()},
\code{\link{exclude_ip}()},
\code{\link{exclude_location}()},
\code{\link{exclude_preview}()},
\code{\link{exclude_progress}()},
\code{\link{exclude_resolution}()}
}
\concept{duplicates functions}
\concept{exclude functions}
