
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General
# Public License along with this library; if not, write to the
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA  02111-1307  USA

# Copyrights (C)
# for this R-port:
#   2007-2008, Yohan Chalabi, GPL
#   Yohan Chalabi <ychalabi@phys.ethz.ch>
#   1999 - 2007, Diethelm Wuertz, GPL
#   Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
#   info@rmetrics.org
#   www.rmetrics.org
# for the code accessed (or partly included) from other R-ports:
#   see R's copyright and license files
# for the code accessed (or partly included) from contributed R-ports
# and other sources
#   see Rmetrics's copyright file


# fCalendar::2A-DaylightSavingTime.R
################################################################################
# FUNCTION:                 DESCRIPOTION:
#  Algiers                   Returns Algiers Daylight Saving Time Rules
#  ...
#  Honolulu                  Returns Honolulu Daylight Saving Time Rules
################################################################################


################################################################################
# The following DST Rules were extracted from tzdata (version tzdata2007k)
# and integrated into R functions.
################################################################################
# This file was auto-generated by .genDaylightSavingTime()
#


"Andorra" <- function () {
structure(list(Andorra = c("1901-12-14 20:45:52", "1946-09-30 00:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("0", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Andorra", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -107L), class = "data.frame")
}

"Dubai" <- function () {
structure(list(Dubai = "1901-12-14 20:45:52", offSet = "13272", 
    isdst = "0", TimeZone = "GST"), .Names = c("Dubai", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Kabul" <- function () {
structure(list(Kabul = "1901-12-14 20:45:52", offSet = "14400", 
    isdst = "0", TimeZone = "AFT"), .Names = c("Kabul", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Antigua" <- function () {
structure(list(Antigua = c("1901-12-14 20:45:52", "1912-03-02 04:07:12"
), offSet = c("-14832", "-18000"), isdst = c("0", "0"), TimeZone = c("AST", 
"AST")), .Names = c("Antigua", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Anguilla" <- function () {
structure(list(Anguilla = "1901-12-14 20:45:52", offSet = "-15136", 
    isdst = "0", TimeZone = "AST"), .Names = c("Anguilla", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Tirane" <- function () {
structure(list(Tirane = c("1901-12-14 20:45:52", "1913-12-31 22:40:40", 
"1940-06-15 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-04-10 01:00:00", "1974-05-03 23:00:00", "1974-10-01 22:00:00", 
"1975-04-30 23:00:00", "1975-10-01 22:00:00", "1976-05-01 23:00:00", 
"1976-10-02 22:00:00", "1977-05-07 23:00:00", "1977-10-01 22:00:00", 
"1978-05-05 23:00:00", "1978-09-30 22:00:00", "1979-05-04 23:00:00", 
"1979-09-29 22:00:00", "1980-05-02 23:00:00", "1980-10-03 22:00:00", 
"1981-04-25 23:00:00", "1981-09-26 22:00:00", "1982-05-01 23:00:00", 
"1982-10-02 22:00:00", "1983-04-17 23:00:00", "1983-09-30 22:00:00", 
"1984-03-31 23:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("4760", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Tirane", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -133L), class = "data.frame")
}

"Yerevan" <- function () {
structure(list(Yerevan = c("1901-12-14 20:45:52", "1924-05-01 21:02:00", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-03-30 22:00:00", 
"1991-09-28 23:00:00", "1992-03-28 20:00:00", "1992-09-26 19:00:00", 
"1993-03-27 23:00:00", "1993-09-25 23:00:00", "1994-03-26 23:00:00", 
"1994-09-24 23:00:00", "1995-09-23 23:00:00", "1997-03-29 22:00:00", 
"1997-10-25 22:00:00", "1998-03-28 22:00:00", "1998-10-24 22:00:00", 
"1999-03-27 22:00:00", "1999-10-30 22:00:00", "2000-03-25 22:00:00", 
"2000-10-28 22:00:00", "2001-03-24 22:00:00", "2001-10-27 22:00:00", 
"2002-03-30 22:00:00", "2002-10-26 22:00:00", "2003-03-29 22:00:00", 
"2003-10-25 22:00:00", "2004-03-27 22:00:00", "2004-10-30 22:00:00", 
"2005-03-26 22:00:00", "2005-10-29 22:00:00", "2006-03-25 22:00:00", 
"2006-10-28 22:00:00", "2007-03-24 22:00:00", "2007-10-27 22:00:00", 
"2008-03-29 22:00:00", "2008-10-25 22:00:00", "2009-03-28 22:00:00", 
"2009-10-24 22:00:00", "2010-03-27 22:00:00", "2010-10-30 22:00:00", 
"2011-03-26 22:00:00", "2011-10-29 22:00:00", "2012-03-24 22:00:00", 
"2012-10-27 22:00:00", "2013-03-30 22:00:00", "2013-10-26 22:00:00", 
"2014-03-29 22:00:00", "2014-10-25 22:00:00", "2015-03-28 22:00:00", 
"2015-10-24 22:00:00", "2016-03-26 22:00:00", "2016-10-29 22:00:00", 
"2017-03-25 22:00:00", "2017-10-28 22:00:00", "2018-03-24 22:00:00", 
"2018-10-27 22:00:00", "2019-03-30 22:00:00", "2019-10-26 22:00:00", 
"2020-03-28 22:00:00", "2020-10-24 22:00:00", "2021-03-27 22:00:00", 
"2021-10-30 22:00:00", "2022-03-26 22:00:00", "2022-10-29 22:00:00", 
"2023-03-25 22:00:00", "2023-10-28 22:00:00", "2024-03-30 22:00:00", 
"2024-10-26 22:00:00", "2025-03-29 22:00:00", "2025-10-25 22:00:00", 
"2026-03-28 22:00:00", "2026-10-24 22:00:00", "2027-03-27 22:00:00", 
"2027-10-30 22:00:00", "2028-03-25 22:00:00", "2028-10-28 22:00:00", 
"2029-03-24 22:00:00", "2029-10-27 22:00:00", "2030-03-30 22:00:00", 
"2030-10-26 22:00:00", "2031-03-29 22:00:00", "2031-10-25 22:00:00", 
"2032-03-27 22:00:00", "2032-10-30 22:00:00", "2033-03-26 22:00:00", 
"2033-10-29 22:00:00", "2034-03-25 22:00:00", "2034-10-28 22:00:00", 
"2035-03-24 22:00:00", "2035-10-27 22:00:00", "2036-03-29 22:00:00", 
"2036-10-25 22:00:00", "2037-03-28 22:00:00"), offSet = c("10680", 
"10800", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", "0", "1", 
"0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("AMT", "AMT", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST")), .Names = c("Yerevan", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -112L), class = "data.frame")
}

"Curacao" <- function () {
structure(list(Curacao = c("1901-12-14 20:45:52", "1912-02-12 04:35:44"
), offSet = c("-16544", "-16200"), isdst = c("0", "0"), TimeZone = c("AST", 
"AST")), .Names = c("Curacao", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Luanda" <- function () {
structure(list(Luanda = "1901-12-14 20:45:52", offSet = "3124", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Luanda", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"McMurdo" <- function () {
structure(list(McMurdo = c("1901-12-14 20:45:52", "1956-01-01 00:00:00", 
"1974-11-02 14:00:00", "1975-02-22 14:00:00", "1975-10-25 14:00:00", 
"1976-03-06 14:00:00", "1976-10-30 14:00:00", "1977-03-05 14:00:00", 
"1977-10-29 14:00:00", "1978-03-04 14:00:00", "1978-10-28 14:00:00", 
"1979-03-03 14:00:00", "1979-10-27 14:00:00", "1980-03-01 14:00:00", 
"1980-10-25 14:00:00", "1981-02-28 14:00:00", "1981-10-24 14:00:00", 
"1982-03-06 14:00:00", "1982-10-30 14:00:00", "1983-03-05 14:00:00", 
"1983-10-29 14:00:00", "1984-03-03 14:00:00", "1984-10-27 14:00:00", 
"1985-03-02 14:00:00", "1985-10-26 14:00:00", "1986-03-01 14:00:00", 
"1986-10-25 14:00:00", "1987-02-28 14:00:00", "1987-10-24 14:00:00", 
"1988-03-05 14:00:00", "1988-10-29 14:00:00", "1989-03-04 14:00:00", 
"1989-10-07 14:00:00", "1990-03-17 14:00:00", "1990-10-06 14:00:00", 
"1991-03-16 14:00:00", "1991-10-05 14:00:00", "1992-03-14 14:00:00", 
"1992-10-03 14:00:00", "1993-03-20 14:00:00", "1993-10-02 14:00:00", 
"1994-03-19 14:00:00", "1994-10-01 14:00:00", "1995-03-18 14:00:00", 
"1995-09-30 14:00:00", "1996-03-16 14:00:00", "1996-10-05 14:00:00", 
"1997-03-15 14:00:00", "1997-10-04 14:00:00", "1998-03-14 14:00:00", 
"1998-10-03 14:00:00", "1999-03-20 14:00:00", "1999-10-02 14:00:00", 
"2000-03-18 14:00:00", "2000-09-30 14:00:00", "2001-03-17 14:00:00", 
"2001-10-06 14:00:00", "2002-03-16 14:00:00", "2002-10-05 14:00:00", 
"2003-03-15 14:00:00", "2003-10-04 14:00:00", "2004-03-20 14:00:00", 
"2004-10-02 14:00:00", "2005-03-19 14:00:00", "2005-10-01 14:00:00", 
"2006-03-18 14:00:00", "2006-09-30 14:00:00", "2007-03-17 14:00:00", 
"2007-09-29 14:00:00", "2008-04-05 14:00:00", "2008-09-27 14:00:00", 
"2009-04-04 14:00:00", "2009-09-26 14:00:00", "2010-04-03 14:00:00", 
"2010-09-25 14:00:00", "2011-04-02 14:00:00", "2011-09-24 14:00:00", 
"2012-03-31 14:00:00", "2012-09-29 14:00:00", "2013-04-06 14:00:00", 
"2013-09-28 14:00:00", "2014-04-05 14:00:00", "2014-09-27 14:00:00", 
"2015-04-04 14:00:00", "2015-09-26 14:00:00", "2016-04-02 14:00:00", 
"2016-09-24 14:00:00", "2017-04-01 14:00:00", "2017-09-23 14:00:00", 
"2018-03-31 14:00:00", "2018-09-29 14:00:00", "2019-04-06 14:00:00", 
"2019-09-28 14:00:00", "2020-04-04 14:00:00", "2020-09-26 14:00:00", 
"2021-04-03 14:00:00", "2021-09-25 14:00:00", "2022-04-02 14:00:00", 
"2022-09-24 14:00:00", "2023-04-01 14:00:00", "2023-09-23 14:00:00", 
"2024-04-06 14:00:00", "2024-09-28 14:00:00", "2025-04-05 14:00:00", 
"2025-09-27 14:00:00", "2026-04-04 14:00:00", "2026-09-26 14:00:00", 
"2027-04-03 14:00:00", "2027-09-25 14:00:00", "2028-04-01 14:00:00", 
"2028-09-23 14:00:00", "2029-03-31 14:00:00", "2029-09-29 14:00:00", 
"2030-04-06 14:00:00", "2030-09-28 14:00:00", "2031-04-05 14:00:00", 
"2031-09-27 14:00:00", "2032-04-03 14:00:00", "2032-09-25 14:00:00", 
"2033-04-02 14:00:00", "2033-09-24 14:00:00", "2034-04-01 14:00:00", 
"2034-09-23 14:00:00", "2035-03-31 14:00:00", "2035-09-29 14:00:00", 
"2036-04-05 14:00:00", "2036-09-27 14:00:00", "2037-04-04 14:00:00"
), offSet = c("0", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("NZST", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST")), .Names = c("McMurdo", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -128L), class = "data.frame")
}

"South_Pole" <- function () {
structure(list(South_Pole = c("1901-12-14 20:45:52", "1956-01-01 00:00:00", 
"1974-11-02 14:00:00", "1975-02-22 14:00:00", "1975-10-25 14:00:00", 
"1976-03-06 14:00:00", "1976-10-30 14:00:00", "1977-03-05 14:00:00", 
"1977-10-29 14:00:00", "1978-03-04 14:00:00", "1978-10-28 14:00:00", 
"1979-03-03 14:00:00", "1979-10-27 14:00:00", "1980-03-01 14:00:00", 
"1980-10-25 14:00:00", "1981-02-28 14:00:00", "1981-10-24 14:00:00", 
"1982-03-06 14:00:00", "1982-10-30 14:00:00", "1983-03-05 14:00:00", 
"1983-10-29 14:00:00", "1984-03-03 14:00:00", "1984-10-27 14:00:00", 
"1985-03-02 14:00:00", "1985-10-26 14:00:00", "1986-03-01 14:00:00", 
"1986-10-25 14:00:00", "1987-02-28 14:00:00", "1987-10-24 14:00:00", 
"1988-03-05 14:00:00", "1988-10-29 14:00:00", "1989-03-04 14:00:00", 
"1989-10-07 14:00:00", "1990-03-17 14:00:00", "1990-10-06 14:00:00", 
"1991-03-16 14:00:00", "1991-10-05 14:00:00", "1992-03-14 14:00:00", 
"1992-10-03 14:00:00", "1993-03-20 14:00:00", "1993-10-02 14:00:00", 
"1994-03-19 14:00:00", "1994-10-01 14:00:00", "1995-03-18 14:00:00", 
"1995-09-30 14:00:00", "1996-03-16 14:00:00", "1996-10-05 14:00:00", 
"1997-03-15 14:00:00", "1997-10-04 14:00:00", "1998-03-14 14:00:00", 
"1998-10-03 14:00:00", "1999-03-20 14:00:00", "1999-10-02 14:00:00", 
"2000-03-18 14:00:00", "2000-09-30 14:00:00", "2001-03-17 14:00:00", 
"2001-10-06 14:00:00", "2002-03-16 14:00:00", "2002-10-05 14:00:00", 
"2003-03-15 14:00:00", "2003-10-04 14:00:00", "2004-03-20 14:00:00", 
"2004-10-02 14:00:00", "2005-03-19 14:00:00", "2005-10-01 14:00:00", 
"2006-03-18 14:00:00", "2006-09-30 14:00:00", "2007-03-17 14:00:00", 
"2007-09-29 14:00:00", "2008-04-05 14:00:00", "2008-09-27 14:00:00", 
"2009-04-04 14:00:00", "2009-09-26 14:00:00", "2010-04-03 14:00:00", 
"2010-09-25 14:00:00", "2011-04-02 14:00:00", "2011-09-24 14:00:00", 
"2012-03-31 14:00:00", "2012-09-29 14:00:00", "2013-04-06 14:00:00", 
"2013-09-28 14:00:00", "2014-04-05 14:00:00", "2014-09-27 14:00:00", 
"2015-04-04 14:00:00", "2015-09-26 14:00:00", "2016-04-02 14:00:00", 
"2016-09-24 14:00:00", "2017-04-01 14:00:00", "2017-09-23 14:00:00", 
"2018-03-31 14:00:00", "2018-09-29 14:00:00", "2019-04-06 14:00:00", 
"2019-09-28 14:00:00", "2020-04-04 14:00:00", "2020-09-26 14:00:00", 
"2021-04-03 14:00:00", "2021-09-25 14:00:00", "2022-04-02 14:00:00", 
"2022-09-24 14:00:00", "2023-04-01 14:00:00", "2023-09-23 14:00:00", 
"2024-04-06 14:00:00", "2024-09-28 14:00:00", "2025-04-05 14:00:00", 
"2025-09-27 14:00:00", "2026-04-04 14:00:00", "2026-09-26 14:00:00", 
"2027-04-03 14:00:00", "2027-09-25 14:00:00", "2028-04-01 14:00:00", 
"2028-09-23 14:00:00", "2029-03-31 14:00:00", "2029-09-29 14:00:00", 
"2030-04-06 14:00:00", "2030-09-28 14:00:00", "2031-04-05 14:00:00", 
"2031-09-27 14:00:00", "2032-04-03 14:00:00", "2032-09-25 14:00:00", 
"2033-04-02 14:00:00", "2033-09-24 14:00:00", "2034-04-01 14:00:00", 
"2034-09-23 14:00:00", "2035-03-31 14:00:00", "2035-09-29 14:00:00", 
"2036-04-05 14:00:00", "2036-09-27 14:00:00", "2037-04-04 14:00:00"
), offSet = c("0", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("NZST", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST")), .Names = c("South_Pole", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -128L), class = "data.frame")
}

"Rothera" <- function () {
structure(list(Rothera = "1901-12-14 20:45:52", offSet = "0", 
    isdst = "0", TimeZone = "ROTT"), .Names = c("Rothera", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Palmer" <- function () {
structure(list(Palmer = c("1901-12-14 20:45:52", "1965-01-01 00:00:00", 
"1965-03-01 03:00:00", "1965-10-15 04:00:00", "1966-03-01 03:00:00", 
"1966-10-15 04:00:00", "1967-04-02 03:00:00", "1967-10-01 04:00:00", 
"1968-04-07 03:00:00", "1968-10-06 04:00:00", "1969-04-06 03:00:00", 
"1969-10-05 04:00:00", "1974-01-23 03:00:00", "1974-05-01 02:00:00", 
"1982-05-01 03:00:00", "1982-10-10 04:00:00", "1983-03-13 03:00:00", 
"1983-10-09 04:00:00", "1984-03-11 03:00:00", "1984-10-14 04:00:00", 
"1985-03-10 03:00:00", "1985-10-13 04:00:00", "1986-03-09 03:00:00", 
"1986-10-12 04:00:00", "1987-04-12 03:00:00", "1987-10-11 04:00:00", 
"1988-03-13 03:00:00", "1988-10-02 04:00:00", "1989-03-12 03:00:00", 
"1989-10-15 04:00:00", "1990-03-18 03:00:00", "1990-09-16 04:00:00", 
"1991-03-10 03:00:00", "1991-10-13 04:00:00", "1992-03-15 03:00:00", 
"1992-10-11 04:00:00", "1993-03-14 03:00:00", "1993-10-10 04:00:00", 
"1994-03-13 03:00:00", "1994-10-09 04:00:00", "1995-03-12 03:00:00", 
"1995-10-15 04:00:00", "1996-03-10 03:00:00", "1996-10-13 04:00:00", 
"1997-03-30 03:00:00", "1997-10-12 04:00:00", "1998-03-15 03:00:00", 
"1998-09-27 04:00:00", "1999-04-04 03:00:00", "1999-10-10 04:00:00", 
"2000-03-12 03:00:00", "2000-10-15 04:00:00", "2001-03-11 03:00:00", 
"2001-10-14 04:00:00", "2002-03-10 03:00:00", "2002-10-13 04:00:00", 
"2003-03-09 03:00:00", "2003-10-12 04:00:00", "2004-03-14 03:00:00", 
"2004-10-10 04:00:00", "2005-03-13 03:00:00", "2005-10-09 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-14 04:00:00", "2008-03-09 03:00:00", "2008-10-12 04:00:00", 
"2009-03-15 03:00:00", "2009-10-11 04:00:00", "2010-03-14 03:00:00", 
"2010-10-10 04:00:00", "2011-03-13 03:00:00", "2011-10-09 04:00:00", 
"2012-03-11 03:00:00", "2012-10-14 04:00:00", "2013-03-10 03:00:00", 
"2013-10-13 04:00:00", "2014-03-09 03:00:00", "2014-10-12 04:00:00", 
"2015-03-15 03:00:00", "2015-10-11 04:00:00", "2016-03-13 03:00:00", 
"2016-10-09 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-14 04:00:00", "2019-03-10 03:00:00", 
"2019-10-13 04:00:00", "2020-03-15 03:00:00", "2020-10-11 04:00:00", 
"2021-03-14 03:00:00", "2021-10-10 04:00:00", "2022-03-13 03:00:00", 
"2022-10-09 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-13 04:00:00", "2025-03-09 03:00:00", 
"2025-10-12 04:00:00", "2026-03-15 03:00:00", "2026-10-11 04:00:00", 
"2027-03-14 03:00:00", "2027-10-10 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-14 04:00:00", 
"2030-03-10 03:00:00", "2030-10-13 04:00:00", "2031-03-09 03:00:00", 
"2031-10-12 04:00:00", "2032-03-14 03:00:00", "2032-10-10 04:00:00", 
"2033-03-13 03:00:00", "2033-10-09 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-14 04:00:00", 
"2036-03-09 03:00:00", "2036-10-12 04:00:00", "2037-03-15 03:00:00"
), offSet = c("0", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-7200", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLT", "CLST", "CLT", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT")), .Names = c("Palmer", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -125L), class = "data.frame")
}

"Mawson" <- function () {
structure(list(Mawson = "1901-12-14 20:45:52", offSet = "0", 
    isdst = "0", TimeZone = "MAWT"), .Names = c("Mawson", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Davis" <- function () {
structure(list(Davis = c("1901-12-14 20:45:52", "1957-01-13 00:00:00", 
"1964-10-31 17:00:00"), offSet = c("0", "25200", "0"), isdst = c("0", 
"0", "0"), TimeZone = c("DAVT", "DAVT", "DAVT")), .Names = c("Davis", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Casey" <- function () {
structure(list(Casey = "1901-12-14 20:45:52", offSet = "0", isdst = "0", 
    TimeZone = "WST"), .Names = c("Casey", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Vostok" <- function () {
structure(list(Vostok = "1901-12-14 20:45:52", offSet = "0", 
    isdst = "0", TimeZone = "VOST"), .Names = c("Vostok", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"DumontDUrville" <- function () {
structure(list(DumontDUrville = c("1901-12-14 20:45:52", "1947-01-01 00:00:00", 
"1952-01-13 14:00:00"), offSet = c("0", "36000", "0"), isdst = c("0", 
"0", "0"), TimeZone = c("DDUT", "DDUT", "DDUT")), .Names = c("DumontDUrville", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Syowa" <- function () {
structure(list(Syowa = "1901-12-14 20:45:52", offSet = "0", isdst = "0", 
    TimeZone = "SYOT"), .Names = c("Syowa", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Buenos_Aires" <- function () {
structure(list(Buenos_Aires = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-05 03:00:00", "2009-03-15 02:00:00", 
"2009-10-04 03:00:00", "2010-03-21 02:00:00", "2010-10-03 03:00:00", 
"2011-03-20 02:00:00", "2011-10-02 03:00:00", "2012-03-18 02:00:00", 
"2012-10-07 03:00:00", "2013-03-17 02:00:00", "2013-10-06 03:00:00", 
"2014-03-16 02:00:00", "2014-10-05 03:00:00", "2015-03-15 02:00:00", 
"2015-10-04 03:00:00", "2016-03-20 02:00:00", "2016-10-02 03:00:00", 
"2017-03-19 02:00:00", "2017-10-01 03:00:00", "2018-03-18 02:00:00", 
"2018-10-07 03:00:00", "2019-03-17 02:00:00", "2019-10-06 03:00:00", 
"2020-03-15 02:00:00", "2020-10-04 03:00:00", "2021-03-21 02:00:00", 
"2021-10-03 03:00:00", "2022-03-20 02:00:00", "2022-10-02 03:00:00", 
"2023-03-19 02:00:00", "2023-10-01 03:00:00", "2024-03-17 02:00:00", 
"2024-10-06 03:00:00", "2025-03-16 02:00:00", "2025-10-05 03:00:00", 
"2026-03-15 02:00:00", "2026-10-04 03:00:00", "2027-03-21 02:00:00", 
"2027-10-03 03:00:00", "2028-03-19 02:00:00", "2028-10-01 03:00:00", 
"2029-03-18 02:00:00", "2029-10-07 03:00:00", "2030-03-17 02:00:00", 
"2030-10-06 03:00:00", "2031-03-16 02:00:00", "2031-10-05 03:00:00", 
"2032-03-21 02:00:00", "2032-10-03 03:00:00", "2033-03-20 02:00:00", 
"2033-10-02 03:00:00", "2034-03-19 02:00:00", "2034-10-01 03:00:00", 
"2035-03-18 02:00:00", "2035-10-07 03:00:00", "2036-03-16 02:00:00", 
"2036-10-05 03:00:00", "2037-03-15 02:00:00"), offSet = c("-15408", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART")), .Names = c("Buenos_Aires", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -115L), class = "data.frame")
}

"Cordoba" <- function () {
structure(list(Cordoba = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-05 03:00:00", "2009-03-15 02:00:00", 
"2009-10-04 03:00:00", "2010-03-21 02:00:00", "2010-10-03 03:00:00", 
"2011-03-20 02:00:00", "2011-10-02 03:00:00", "2012-03-18 02:00:00", 
"2012-10-07 03:00:00", "2013-03-17 02:00:00", "2013-10-06 03:00:00", 
"2014-03-16 02:00:00", "2014-10-05 03:00:00", "2015-03-15 02:00:00", 
"2015-10-04 03:00:00", "2016-03-20 02:00:00", "2016-10-02 03:00:00", 
"2017-03-19 02:00:00", "2017-10-01 03:00:00", "2018-03-18 02:00:00", 
"2018-10-07 03:00:00", "2019-03-17 02:00:00", "2019-10-06 03:00:00", 
"2020-03-15 02:00:00", "2020-10-04 03:00:00", "2021-03-21 02:00:00", 
"2021-10-03 03:00:00", "2022-03-20 02:00:00", "2022-10-02 03:00:00", 
"2023-03-19 02:00:00", "2023-10-01 03:00:00", "2024-03-17 02:00:00", 
"2024-10-06 03:00:00", "2025-03-16 02:00:00", "2025-10-05 03:00:00", 
"2026-03-15 02:00:00", "2026-10-04 03:00:00", "2027-03-21 02:00:00", 
"2027-10-03 03:00:00", "2028-03-19 02:00:00", "2028-10-01 03:00:00", 
"2029-03-18 02:00:00", "2029-10-07 03:00:00", "2030-03-17 02:00:00", 
"2030-10-06 03:00:00", "2031-03-16 02:00:00", "2031-10-05 03:00:00", 
"2032-03-21 02:00:00", "2032-10-03 03:00:00", "2033-03-20 02:00:00", 
"2033-10-02 03:00:00", "2034-03-19 02:00:00", "2034-10-01 03:00:00", 
"2035-03-18 02:00:00", "2035-10-07 03:00:00", "2036-03-16 02:00:00", 
"2036-10-05 03:00:00", "2037-03-15 02:00:00"), offSet = c("-15408", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-14400", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART")), .Names = c("Cordoba", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -115L), class = "data.frame")
}

"Jujuy" <- function () {
structure(list(Jujuy = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-28 04:00:00", 
"1991-03-17 03:00:00", "1991-10-06 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-05 03:00:00", "2009-03-15 02:00:00", 
"2009-10-04 03:00:00", "2010-03-21 02:00:00", "2010-10-03 03:00:00", 
"2011-03-20 02:00:00", "2011-10-02 03:00:00", "2012-03-18 02:00:00", 
"2012-10-07 03:00:00", "2013-03-17 02:00:00", "2013-10-06 03:00:00", 
"2014-03-16 02:00:00", "2014-10-05 03:00:00", "2015-03-15 02:00:00", 
"2015-10-04 03:00:00", "2016-03-20 02:00:00", "2016-10-02 03:00:00", 
"2017-03-19 02:00:00", "2017-10-01 03:00:00", "2018-03-18 02:00:00", 
"2018-10-07 03:00:00", "2019-03-17 02:00:00", "2019-10-06 03:00:00", 
"2020-03-15 02:00:00", "2020-10-04 03:00:00", "2021-03-21 02:00:00", 
"2021-10-03 03:00:00", "2022-03-20 02:00:00", "2022-10-02 03:00:00", 
"2023-03-19 02:00:00", "2023-10-01 03:00:00", "2024-03-17 02:00:00", 
"2024-10-06 03:00:00", "2025-03-16 02:00:00", "2025-10-05 03:00:00", 
"2026-03-15 02:00:00", "2026-10-04 03:00:00", "2027-03-21 02:00:00", 
"2027-10-03 03:00:00", "2028-03-19 02:00:00", "2028-10-01 03:00:00", 
"2029-03-18 02:00:00", "2029-10-07 03:00:00", "2030-03-17 02:00:00", 
"2030-10-06 03:00:00", "2031-03-16 02:00:00", "2031-10-05 03:00:00", 
"2032-03-21 02:00:00", "2032-10-03 03:00:00", "2033-03-20 02:00:00", 
"2033-10-02 03:00:00", "2034-03-19 02:00:00", "2034-10-01 03:00:00", 
"2035-03-18 02:00:00", "2035-10-07 03:00:00", "2036-03-16 02:00:00", 
"2036-10-05 03:00:00", "2037-03-15 02:00:00"), offSet = c("-15408", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-14400", "-10800", 
"-14400", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART")), .Names = c("Jujuy", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -115L), class = "data.frame")
}

"Tucuman" <- function () {
structure(list(Tucuman = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-13 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-05 03:00:00", "2009-03-15 02:00:00", "2009-10-04 03:00:00", 
"2010-03-21 02:00:00", "2010-10-03 03:00:00", "2011-03-20 02:00:00", 
"2011-10-02 03:00:00", "2012-03-18 02:00:00", "2012-10-07 03:00:00", 
"2013-03-17 02:00:00", "2013-10-06 03:00:00", "2014-03-16 02:00:00", 
"2014-10-05 03:00:00", "2015-03-15 02:00:00", "2015-10-04 03:00:00", 
"2016-03-20 02:00:00", "2016-10-02 03:00:00", "2017-03-19 02:00:00", 
"2017-10-01 03:00:00", "2018-03-18 02:00:00", "2018-10-07 03:00:00", 
"2019-03-17 02:00:00", "2019-10-06 03:00:00", "2020-03-15 02:00:00", 
"2020-10-04 03:00:00", "2021-03-21 02:00:00", "2021-10-03 03:00:00", 
"2022-03-20 02:00:00", "2022-10-02 03:00:00", "2023-03-19 02:00:00", 
"2023-10-01 03:00:00", "2024-03-17 02:00:00", "2024-10-06 03:00:00", 
"2025-03-16 02:00:00", "2025-10-05 03:00:00", "2026-03-15 02:00:00", 
"2026-10-04 03:00:00", "2027-03-21 02:00:00", "2027-10-03 03:00:00", 
"2028-03-19 02:00:00", "2028-10-01 03:00:00", "2029-03-18 02:00:00", 
"2029-10-07 03:00:00", "2030-03-17 02:00:00", "2030-10-06 03:00:00", 
"2031-03-16 02:00:00", "2031-10-05 03:00:00", "2032-03-21 02:00:00", 
"2032-10-03 03:00:00", "2033-03-20 02:00:00", "2033-10-02 03:00:00", 
"2034-03-19 02:00:00", "2034-10-01 03:00:00", "2035-03-18 02:00:00", 
"2035-10-07 03:00:00", "2036-03-16 02:00:00", "2036-10-05 03:00:00", 
"2037-03-15 02:00:00"), offSet = c("-15408", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-14400", "-7200", 
"-10800", "-7200", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART")), .Names = c("Tucuman", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Catamarca" <- function () {
structure(list(Catamarca = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-05 03:00:00", "2009-03-15 02:00:00", "2009-10-04 03:00:00", 
"2010-03-21 02:00:00", "2010-10-03 03:00:00", "2011-03-20 02:00:00", 
"2011-10-02 03:00:00", "2012-03-18 02:00:00", "2012-10-07 03:00:00", 
"2013-03-17 02:00:00", "2013-10-06 03:00:00", "2014-03-16 02:00:00", 
"2014-10-05 03:00:00", "2015-03-15 02:00:00", "2015-10-04 03:00:00", 
"2016-03-20 02:00:00", "2016-10-02 03:00:00", "2017-03-19 02:00:00", 
"2017-10-01 03:00:00", "2018-03-18 02:00:00", "2018-10-07 03:00:00", 
"2019-03-17 02:00:00", "2019-10-06 03:00:00", "2020-03-15 02:00:00", 
"2020-10-04 03:00:00", "2021-03-21 02:00:00", "2021-10-03 03:00:00", 
"2022-03-20 02:00:00", "2022-10-02 03:00:00", "2023-03-19 02:00:00", 
"2023-10-01 03:00:00", "2024-03-17 02:00:00", "2024-10-06 03:00:00", 
"2025-03-16 02:00:00", "2025-10-05 03:00:00", "2026-03-15 02:00:00", 
"2026-10-04 03:00:00", "2027-03-21 02:00:00", "2027-10-03 03:00:00", 
"2028-03-19 02:00:00", "2028-10-01 03:00:00", "2029-03-18 02:00:00", 
"2029-10-07 03:00:00", "2030-03-17 02:00:00", "2030-10-06 03:00:00", 
"2031-03-16 02:00:00", "2031-10-05 03:00:00", "2032-03-21 02:00:00", 
"2032-10-03 03:00:00", "2033-03-20 02:00:00", "2033-10-02 03:00:00", 
"2034-03-19 02:00:00", "2034-10-01 03:00:00", "2035-03-18 02:00:00", 
"2035-10-07 03:00:00", "2036-03-16 02:00:00", "2036-10-05 03:00:00", 
"2037-03-15 02:00:00"), offSet = c("-15408", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-14400", "-7200", 
"-10800", "-7200", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART")), .Names = c("Catamarca", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"La_Rioja" <- function () {
structure(list(La_Rioja = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-01 02:00:00", "1991-05-07 04:00:00", "1991-10-20 03:00:00", 
"1992-03-01 02:00:00", "1992-10-18 03:00:00", "2000-03-03 03:00:00", 
"2004-06-01 03:00:00", "2004-06-20 04:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-05 03:00:00", "2009-03-15 02:00:00", 
"2009-10-04 03:00:00", "2010-03-21 02:00:00", "2010-10-03 03:00:00", 
"2011-03-20 02:00:00", "2011-10-02 03:00:00", "2012-03-18 02:00:00", 
"2012-10-07 03:00:00", "2013-03-17 02:00:00", "2013-10-06 03:00:00", 
"2014-03-16 02:00:00", "2014-10-05 03:00:00", "2015-03-15 02:00:00", 
"2015-10-04 03:00:00", "2016-03-20 02:00:00", "2016-10-02 03:00:00", 
"2017-03-19 02:00:00", "2017-10-01 03:00:00", "2018-03-18 02:00:00", 
"2018-10-07 03:00:00", "2019-03-17 02:00:00", "2019-10-06 03:00:00", 
"2020-03-15 02:00:00", "2020-10-04 03:00:00", "2021-03-21 02:00:00", 
"2021-10-03 03:00:00", "2022-03-20 02:00:00", "2022-10-02 03:00:00", 
"2023-03-19 02:00:00", "2023-10-01 03:00:00", "2024-03-17 02:00:00", 
"2024-10-06 03:00:00", "2025-03-16 02:00:00", "2025-10-05 03:00:00", 
"2026-03-15 02:00:00", "2026-10-04 03:00:00", "2027-03-21 02:00:00", 
"2027-10-03 03:00:00", "2028-03-19 02:00:00", "2028-10-01 03:00:00", 
"2029-03-18 02:00:00", "2029-10-07 03:00:00", "2030-03-17 02:00:00", 
"2030-10-06 03:00:00", "2031-03-16 02:00:00", "2031-10-05 03:00:00", 
"2032-03-21 02:00:00", "2032-10-03 03:00:00", "2033-03-20 02:00:00", 
"2033-10-02 03:00:00", "2034-03-19 02:00:00", "2034-10-01 03:00:00", 
"2035-03-18 02:00:00", "2035-10-07 03:00:00", "2036-03-16 02:00:00", 
"2036-10-05 03:00:00", "2037-03-15 02:00:00"), offSet = c("-15408", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-14400", "-10800", "-7200", "-10800", "-7200", "-10800", "-14400", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", 
"0", "1", "0", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0"
), TimeZone = c("ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ART", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART")), .Names = c("La_Rioja", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -118L), class = "data.frame")
}

"San_Juan" <- function () {
structure(list(San_Juan = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-01 02:00:00", "1991-05-07 04:00:00", "1991-10-20 03:00:00", 
"1992-03-01 02:00:00", "1992-10-18 03:00:00", "2000-03-03 03:00:00", 
"2004-05-31 03:00:00", "2004-07-25 04:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-05 03:00:00", "2009-03-15 02:00:00", 
"2009-10-04 03:00:00", "2010-03-21 02:00:00", "2010-10-03 03:00:00", 
"2011-03-20 02:00:00", "2011-10-02 03:00:00", "2012-03-18 02:00:00", 
"2012-10-07 03:00:00", "2013-03-17 02:00:00", "2013-10-06 03:00:00", 
"2014-03-16 02:00:00", "2014-10-05 03:00:00", "2015-03-15 02:00:00", 
"2015-10-04 03:00:00", "2016-03-20 02:00:00", "2016-10-02 03:00:00", 
"2017-03-19 02:00:00", "2017-10-01 03:00:00", "2018-03-18 02:00:00", 
"2018-10-07 03:00:00", "2019-03-17 02:00:00", "2019-10-06 03:00:00", 
"2020-03-15 02:00:00", "2020-10-04 03:00:00", "2021-03-21 02:00:00", 
"2021-10-03 03:00:00", "2022-03-20 02:00:00", "2022-10-02 03:00:00", 
"2023-03-19 02:00:00", "2023-10-01 03:00:00", "2024-03-17 02:00:00", 
"2024-10-06 03:00:00", "2025-03-16 02:00:00", "2025-10-05 03:00:00", 
"2026-03-15 02:00:00", "2026-10-04 03:00:00", "2027-03-21 02:00:00", 
"2027-10-03 03:00:00", "2028-03-19 02:00:00", "2028-10-01 03:00:00", 
"2029-03-18 02:00:00", "2029-10-07 03:00:00", "2030-03-17 02:00:00", 
"2030-10-06 03:00:00", "2031-03-16 02:00:00", "2031-10-05 03:00:00", 
"2032-03-21 02:00:00", "2032-10-03 03:00:00", "2033-03-20 02:00:00", 
"2033-10-02 03:00:00", "2034-03-19 02:00:00", "2034-10-01 03:00:00", 
"2035-03-18 02:00:00", "2035-10-07 03:00:00", "2036-03-16 02:00:00", 
"2036-10-05 03:00:00", "2037-03-15 02:00:00"), offSet = c("-15408", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-14400", "-10800", "-7200", "-10800", "-7200", "-10800", "-14400", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", 
"0", "1", "0", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0"
), TimeZone = c("ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ART", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART")), .Names = c("San_Juan", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -118L), class = "data.frame")
}

"Mendoza" <- function () {
structure(list(Mendoza = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-15 04:00:00", 
"1991-03-01 03:00:00", "1991-10-15 04:00:00", "1992-03-01 03:00:00", 
"1992-10-18 04:00:00", "2000-03-03 03:00:00", "2004-05-23 03:00:00", 
"2004-09-26 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-05 03:00:00", "2009-03-15 02:00:00", "2009-10-04 03:00:00", 
"2010-03-21 02:00:00", "2010-10-03 03:00:00", "2011-03-20 02:00:00", 
"2011-10-02 03:00:00", "2012-03-18 02:00:00", "2012-10-07 03:00:00", 
"2013-03-17 02:00:00", "2013-10-06 03:00:00", "2014-03-16 02:00:00", 
"2014-10-05 03:00:00", "2015-03-15 02:00:00", "2015-10-04 03:00:00", 
"2016-03-20 02:00:00", "2016-10-02 03:00:00", "2017-03-19 02:00:00", 
"2017-10-01 03:00:00", "2018-03-18 02:00:00", "2018-10-07 03:00:00", 
"2019-03-17 02:00:00", "2019-10-06 03:00:00", "2020-03-15 02:00:00", 
"2020-10-04 03:00:00", "2021-03-21 02:00:00", "2021-10-03 03:00:00", 
"2022-03-20 02:00:00", "2022-10-02 03:00:00", "2023-03-19 02:00:00", 
"2023-10-01 03:00:00", "2024-03-17 02:00:00", "2024-10-06 03:00:00", 
"2025-03-16 02:00:00", "2025-10-05 03:00:00", "2026-03-15 02:00:00", 
"2026-10-04 03:00:00", "2027-03-21 02:00:00", "2027-10-03 03:00:00", 
"2028-03-19 02:00:00", "2028-10-01 03:00:00", "2029-03-18 02:00:00", 
"2029-10-07 03:00:00", "2030-03-17 02:00:00", "2030-10-06 03:00:00", 
"2031-03-16 02:00:00", "2031-10-05 03:00:00", "2032-03-21 02:00:00", 
"2032-10-03 03:00:00", "2033-03-20 02:00:00", "2033-10-02 03:00:00", 
"2034-03-19 02:00:00", "2034-10-01 03:00:00", "2035-03-18 02:00:00", 
"2035-10-07 03:00:00", "2036-03-16 02:00:00", "2036-10-05 03:00:00", 
"2037-03-15 02:00:00"), offSet = c("-15408", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-7200", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART")), .Names = c("Mendoza", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Rio_Gallegos" <- function () {
structure(list(Rio_Gallegos = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-05 03:00:00", "2009-03-15 02:00:00", "2009-10-04 03:00:00", 
"2010-03-21 02:00:00", "2010-10-03 03:00:00", "2011-03-20 02:00:00", 
"2011-10-02 03:00:00", "2012-03-18 02:00:00", "2012-10-07 03:00:00", 
"2013-03-17 02:00:00", "2013-10-06 03:00:00", "2014-03-16 02:00:00", 
"2014-10-05 03:00:00", "2015-03-15 02:00:00", "2015-10-04 03:00:00", 
"2016-03-20 02:00:00", "2016-10-02 03:00:00", "2017-03-19 02:00:00", 
"2017-10-01 03:00:00", "2018-03-18 02:00:00", "2018-10-07 03:00:00", 
"2019-03-17 02:00:00", "2019-10-06 03:00:00", "2020-03-15 02:00:00", 
"2020-10-04 03:00:00", "2021-03-21 02:00:00", "2021-10-03 03:00:00", 
"2022-03-20 02:00:00", "2022-10-02 03:00:00", "2023-03-19 02:00:00", 
"2023-10-01 03:00:00", "2024-03-17 02:00:00", "2024-10-06 03:00:00", 
"2025-03-16 02:00:00", "2025-10-05 03:00:00", "2026-03-15 02:00:00", 
"2026-10-04 03:00:00", "2027-03-21 02:00:00", "2027-10-03 03:00:00", 
"2028-03-19 02:00:00", "2028-10-01 03:00:00", "2029-03-18 02:00:00", 
"2029-10-07 03:00:00", "2030-03-17 02:00:00", "2030-10-06 03:00:00", 
"2031-03-16 02:00:00", "2031-10-05 03:00:00", "2032-03-21 02:00:00", 
"2032-10-03 03:00:00", "2033-03-20 02:00:00", "2033-10-02 03:00:00", 
"2034-03-19 02:00:00", "2034-10-01 03:00:00", "2035-03-18 02:00:00", 
"2035-10-07 03:00:00", "2036-03-16 02:00:00", "2036-10-05 03:00:00", 
"2037-03-15 02:00:00"), offSet = c("-15408", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART")), .Names = c("Rio_Gallegos", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Ushuaia" <- function () {
structure(list(Ushuaia = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-05-30 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-05 03:00:00", "2009-03-15 02:00:00", "2009-10-04 03:00:00", 
"2010-03-21 02:00:00", "2010-10-03 03:00:00", "2011-03-20 02:00:00", 
"2011-10-02 03:00:00", "2012-03-18 02:00:00", "2012-10-07 03:00:00", 
"2013-03-17 02:00:00", "2013-10-06 03:00:00", "2014-03-16 02:00:00", 
"2014-10-05 03:00:00", "2015-03-15 02:00:00", "2015-10-04 03:00:00", 
"2016-03-20 02:00:00", "2016-10-02 03:00:00", "2017-03-19 02:00:00", 
"2017-10-01 03:00:00", "2018-03-18 02:00:00", "2018-10-07 03:00:00", 
"2019-03-17 02:00:00", "2019-10-06 03:00:00", "2020-03-15 02:00:00", 
"2020-10-04 03:00:00", "2021-03-21 02:00:00", "2021-10-03 03:00:00", 
"2022-03-20 02:00:00", "2022-10-02 03:00:00", "2023-03-19 02:00:00", 
"2023-10-01 03:00:00", "2024-03-17 02:00:00", "2024-10-06 03:00:00", 
"2025-03-16 02:00:00", "2025-10-05 03:00:00", "2026-03-15 02:00:00", 
"2026-10-04 03:00:00", "2027-03-21 02:00:00", "2027-10-03 03:00:00", 
"2028-03-19 02:00:00", "2028-10-01 03:00:00", "2029-03-18 02:00:00", 
"2029-10-07 03:00:00", "2030-03-17 02:00:00", "2030-10-06 03:00:00", 
"2031-03-16 02:00:00", "2031-10-05 03:00:00", "2032-03-21 02:00:00", 
"2032-10-03 03:00:00", "2033-03-20 02:00:00", "2033-10-02 03:00:00", 
"2034-03-19 02:00:00", "2034-10-01 03:00:00", "2035-03-18 02:00:00", 
"2035-10-07 03:00:00", "2036-03-16 02:00:00", "2036-10-05 03:00:00", 
"2037-03-15 02:00:00"), offSet = c("-15408", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("ART", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART")), .Names = c("Ushuaia", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Pago_Pago" <- function () {
structure(list(Pago_Pago = c("1901-12-14 20:45:52", "1911-01-01 11:22:48"
), offSet = c("-40968", "-41400"), isdst = c("0", "0"), TimeZone = c("SST", 
"SST")), .Names = c("Pago_Pago", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Vienna" <- function () {
structure(list(Vienna = c("1901-12-14 20:45:52", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1920-04-05 01:00:00", 
"1920-09-13 01:00:00", "1940-04-01 01:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-04-12 01:00:00", 
"1946-04-14 01:00:00", "1946-10-06 01:00:00", "1947-04-06 01:00:00", 
"1947-10-05 01:00:00", "1948-04-18 01:00:00", "1948-10-03 01:00:00", 
"1980-04-05 23:00:00", "1980-09-27 22:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST")), .Names = c("Vienna", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-138L), class = "data.frame")
}

"Lord_Howe" <- function () {
structure(list(Lord_Howe = c("1901-12-14 20:45:52", "1981-02-28 14:00:00", 
"1981-10-24 15:30:00", "1982-03-06 14:30:00", "1982-10-30 15:30:00", 
"1983-03-05 14:30:00", "1983-10-29 15:30:00", "1984-03-03 14:30:00", 
"1984-10-27 15:30:00", "1985-03-02 14:30:00", "1985-10-26 15:30:00", 
"1986-03-15 15:00:00", "1986-10-18 15:30:00", "1987-03-14 15:00:00", 
"1987-10-24 15:30:00", "1988-03-19 15:00:00", "1988-10-29 15:30:00", 
"1989-03-18 15:00:00", "1989-10-28 15:30:00", "1990-03-03 15:00:00", 
"1990-10-27 15:30:00", "1991-03-02 15:00:00", "1991-10-26 15:30:00", 
"1992-02-29 15:00:00", "1992-10-24 15:30:00", "1993-03-06 15:00:00", 
"1993-10-30 15:30:00", "1994-03-05 15:00:00", "1994-10-29 15:30:00", 
"1995-03-04 15:00:00", "1995-10-28 15:30:00", "1996-03-30 15:00:00", 
"1996-10-26 15:30:00", "1997-03-29 15:00:00", "1997-10-25 15:30:00", 
"1998-03-28 15:00:00", "1998-10-24 15:30:00", "1999-03-27 15:00:00", 
"1999-10-30 15:30:00", "2000-03-25 15:00:00", "2000-08-26 15:30:00", 
"2001-03-24 15:00:00", "2001-10-27 15:30:00", "2002-03-30 15:00:00", 
"2002-10-26 15:30:00", "2003-03-29 15:00:00", "2003-10-25 15:30:00", 
"2004-03-27 15:00:00", "2004-10-30 15:30:00", "2005-03-26 15:00:00", 
"2005-10-29 15:30:00", "2006-04-01 15:00:00", "2006-10-28 15:30:00", 
"2007-03-24 15:00:00", "2007-10-27 15:30:00", "2008-04-05 15:00:00", 
"2008-10-04 15:30:00", "2009-04-04 15:00:00", "2009-10-03 15:30:00", 
"2010-04-03 15:00:00", "2010-10-02 15:30:00", "2011-04-02 15:00:00", 
"2011-10-01 15:30:00", "2012-03-31 15:00:00", "2012-10-06 15:30:00", 
"2013-04-06 15:00:00", "2013-10-05 15:30:00", "2014-04-05 15:00:00", 
"2014-10-04 15:30:00", "2015-04-04 15:00:00", "2015-10-03 15:30:00", 
"2016-04-02 15:00:00", "2016-10-01 15:30:00", "2017-04-01 15:00:00", 
"2017-09-30 15:30:00", "2018-03-31 15:00:00", "2018-10-06 15:30:00", 
"2019-04-06 15:00:00", "2019-10-05 15:30:00", "2020-04-04 15:00:00", 
"2020-10-03 15:30:00", "2021-04-03 15:00:00", "2021-10-02 15:30:00", 
"2022-04-02 15:00:00", "2022-10-01 15:30:00", "2023-04-01 15:00:00", 
"2023-09-30 15:30:00", "2024-04-06 15:00:00", "2024-10-05 15:30:00", 
"2025-04-05 15:00:00", "2025-10-04 15:30:00", "2026-04-04 15:00:00", 
"2026-10-03 15:30:00", "2027-04-03 15:00:00", "2027-10-02 15:30:00", 
"2028-04-01 15:00:00", "2028-09-30 15:30:00", "2029-03-31 15:00:00", 
"2029-10-06 15:30:00", "2030-04-06 15:00:00", "2030-10-05 15:30:00", 
"2031-04-05 15:00:00", "2031-10-04 15:30:00", "2032-04-03 15:00:00", 
"2032-10-02 15:30:00", "2033-04-02 15:00:00", "2033-10-01 15:30:00", 
"2034-04-01 15:00:00", "2034-09-30 15:30:00", "2035-03-31 15:00:00", 
"2035-10-06 15:30:00", "2036-04-05 15:00:00", "2036-10-04 15:30:00", 
"2037-04-04 15:00:00"), offSet = c("36000", "37800", "41400", 
"37800", "41400", "37800", "41400", "37800", "41400", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800", "39600", 
"37800", "39600", "37800", "39600", "37800", "39600", "37800", 
"39600", "37800", "39600", "37800", "39600", "37800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", "LHST", 
"LHST")), .Names = c("Lord_Howe", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -114L), class = "data.frame")
}

"Hobart" <- function () {
structure(list(Hobart = c("1901-12-14 20:45:52", "1916-09-30 16:00:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1967-09-30 16:00:00", "1968-03-30 16:00:00", 
"1968-10-26 16:00:00", "1969-03-08 16:00:00", "1969-10-25 16:00:00", 
"1970-03-07 16:00:00", "1970-10-24 16:00:00", "1971-03-13 16:00:00", 
"1971-10-30 16:00:00", "1972-02-26 16:00:00", "1972-10-28 16:00:00", 
"1973-03-03 16:00:00", "1973-10-27 16:00:00", "1974-03-02 16:00:00", 
"1974-10-26 16:00:00", "1975-03-01 16:00:00", "1975-10-25 16:00:00", 
"1976-03-06 16:00:00", "1976-10-30 16:00:00", "1977-03-05 16:00:00", 
"1977-10-29 16:00:00", "1978-03-04 16:00:00", "1978-10-28 16:00:00", 
"1979-03-03 16:00:00", "1979-10-27 16:00:00", "1980-03-01 16:00:00", 
"1980-10-25 16:00:00", "1981-02-28 16:00:00", "1981-10-24 16:00:00", 
"1982-03-27 16:00:00", "1982-10-30 16:00:00", "1983-03-26 16:00:00", 
"1983-10-29 16:00:00", "1984-03-03 16:00:00", "1984-10-27 16:00:00", 
"1985-03-02 16:00:00", "1985-10-26 16:00:00", "1986-03-01 16:00:00", 
"1986-10-18 16:00:00", "1987-03-14 16:00:00", "1987-10-24 16:00:00", 
"1988-03-19 16:00:00", "1988-10-29 16:00:00", "1989-03-18 16:00:00", 
"1989-10-28 16:00:00", "1990-03-17 16:00:00", "1990-10-27 16:00:00", 
"1991-03-30 16:00:00", "1991-10-05 16:00:00", "1992-03-28 16:00:00", 
"1992-10-03 16:00:00", "1993-03-27 16:00:00", "1993-10-02 16:00:00", 
"1994-03-26 16:00:00", "1994-10-01 16:00:00", "1995-03-25 16:00:00", 
"1995-09-30 16:00:00", "1996-03-30 16:00:00", "1996-10-05 16:00:00", 
"1997-03-29 16:00:00", "1997-10-04 16:00:00", "1998-03-28 16:00:00", 
"1998-10-03 16:00:00", "1999-03-27 16:00:00", "1999-10-02 16:00:00", 
"2000-03-25 16:00:00", "2000-08-26 16:00:00", "2001-03-24 16:00:00", 
"2001-10-06 16:00:00", "2002-03-30 16:00:00", "2002-10-05 16:00:00", 
"2003-03-29 16:00:00", "2003-10-04 16:00:00", "2004-03-27 16:00:00", 
"2004-10-02 16:00:00", "2005-03-26 16:00:00", "2005-10-01 16:00:00", 
"2006-04-01 16:00:00", "2006-09-30 16:00:00", "2007-03-24 16:00:00", 
"2007-10-06 16:00:00", "2008-04-05 16:00:00", "2008-10-04 16:00:00", 
"2009-04-04 16:00:00", "2009-10-03 16:00:00", "2010-04-03 16:00:00", 
"2010-10-02 16:00:00", "2011-04-02 16:00:00", "2011-10-01 16:00:00", 
"2012-03-31 16:00:00", "2012-10-06 16:00:00", "2013-04-06 16:00:00", 
"2013-10-05 16:00:00", "2014-04-05 16:00:00", "2014-10-04 16:00:00", 
"2015-04-04 16:00:00", "2015-10-03 16:00:00", "2016-04-02 16:00:00", 
"2016-10-01 16:00:00", "2017-04-01 16:00:00", "2017-09-30 16:00:00", 
"2018-03-31 16:00:00", "2018-10-06 16:00:00", "2019-04-06 16:00:00", 
"2019-10-05 16:00:00", "2020-04-04 16:00:00", "2020-10-03 16:00:00", 
"2021-04-03 16:00:00", "2021-10-02 16:00:00", "2022-04-02 16:00:00", 
"2022-10-01 16:00:00", "2023-04-01 16:00:00", "2023-09-30 16:00:00", 
"2024-04-06 16:00:00", "2024-10-05 16:00:00", "2025-04-05 16:00:00", 
"2025-10-04 16:00:00", "2026-04-04 16:00:00", "2026-10-03 16:00:00", 
"2027-04-03 16:00:00", "2027-10-02 16:00:00", "2028-04-01 16:00:00", 
"2028-09-30 16:00:00", "2029-03-31 16:00:00", "2029-10-06 16:00:00", 
"2030-04-06 16:00:00", "2030-10-05 16:00:00", "2031-04-05 16:00:00", 
"2031-10-04 16:00:00", "2032-04-03 16:00:00", "2032-10-02 16:00:00", 
"2033-04-02 16:00:00", "2033-10-01 16:00:00", "2034-04-01 16:00:00", 
"2034-09-30 16:00:00", "2035-03-31 16:00:00", "2035-10-06 16:00:00", 
"2036-04-05 16:00:00", "2036-10-04 16:00:00", "2037-04-04 16:00:00"
), offSet = c("36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000"), isdst = c("0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0"), TimeZone = c("EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST")), .Names = c("Hobart", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -149L), class = "data.frame")
}

"Currie" <- function () {
structure(list(Currie = c("1901-12-14 20:45:52", "1916-09-30 16:00:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1972-10-28 16:00:00", "1973-03-03 16:00:00", "1973-10-27 16:00:00", 
"1974-03-02 16:00:00", "1974-10-26 16:00:00", "1975-03-01 16:00:00", 
"1975-10-25 16:00:00", "1976-03-06 16:00:00", "1976-10-30 16:00:00", 
"1977-03-05 16:00:00", "1977-10-29 16:00:00", "1978-03-04 16:00:00", 
"1978-10-28 16:00:00", "1979-03-03 16:00:00", "1979-10-27 16:00:00", 
"1980-03-01 16:00:00", "1980-10-25 16:00:00", "1981-02-28 16:00:00", 
"1981-10-24 16:00:00", "1982-03-27 16:00:00", "1982-10-30 16:00:00", 
"1983-03-26 16:00:00", "1983-10-29 16:00:00", "1984-03-03 16:00:00", 
"1984-10-27 16:00:00", "1985-03-02 16:00:00", "1985-10-26 16:00:00", 
"1986-03-01 16:00:00", "1986-10-18 16:00:00", "1987-03-14 16:00:00", 
"1987-10-24 16:00:00", "1988-03-19 16:00:00", "1988-10-29 16:00:00", 
"1989-03-18 16:00:00", "1989-10-28 16:00:00", "1990-03-17 16:00:00", 
"1990-10-27 16:00:00", "1991-03-30 16:00:00", "1991-10-05 16:00:00", 
"1992-03-28 16:00:00", "1992-10-03 16:00:00", "1993-03-27 16:00:00", 
"1993-10-02 16:00:00", "1994-03-26 16:00:00", "1994-10-01 16:00:00", 
"1995-03-25 16:00:00", "1995-09-30 16:00:00", "1996-03-30 16:00:00", 
"1996-10-05 16:00:00", "1997-03-29 16:00:00", "1997-10-04 16:00:00", 
"1998-03-28 16:00:00", "1998-10-03 16:00:00", "1999-03-27 16:00:00", 
"1999-10-02 16:00:00", "2000-03-25 16:00:00", "2000-08-26 16:00:00", 
"2001-03-24 16:00:00", "2001-10-06 16:00:00", "2002-03-30 16:00:00", 
"2002-10-05 16:00:00", "2003-03-29 16:00:00", "2003-10-04 16:00:00", 
"2004-03-27 16:00:00", "2004-10-02 16:00:00", "2005-03-26 16:00:00", 
"2005-10-01 16:00:00", "2006-04-01 16:00:00", "2006-09-30 16:00:00", 
"2007-03-24 16:00:00", "2007-10-06 16:00:00", "2008-04-05 16:00:00", 
"2008-10-04 16:00:00", "2009-04-04 16:00:00", "2009-10-03 16:00:00", 
"2010-04-03 16:00:00", "2010-10-02 16:00:00", "2011-04-02 16:00:00", 
"2011-10-01 16:00:00", "2012-03-31 16:00:00", "2012-10-06 16:00:00", 
"2013-04-06 16:00:00", "2013-10-05 16:00:00", "2014-04-05 16:00:00", 
"2014-10-04 16:00:00", "2015-04-04 16:00:00", "2015-10-03 16:00:00", 
"2016-04-02 16:00:00", "2016-10-01 16:00:00", "2017-04-01 16:00:00", 
"2017-09-30 16:00:00", "2018-03-31 16:00:00", "2018-10-06 16:00:00", 
"2019-04-06 16:00:00", "2019-10-05 16:00:00", "2020-04-04 16:00:00", 
"2020-10-03 16:00:00", "2021-04-03 16:00:00", "2021-10-02 16:00:00", 
"2022-04-02 16:00:00", "2022-10-01 16:00:00", "2023-04-01 16:00:00", 
"2023-09-30 16:00:00", "2024-04-06 16:00:00", "2024-10-05 16:00:00", 
"2025-04-05 16:00:00", "2025-10-04 16:00:00", "2026-04-04 16:00:00", 
"2026-10-03 16:00:00", "2027-04-03 16:00:00", "2027-10-02 16:00:00", 
"2028-04-01 16:00:00", "2028-09-30 16:00:00", "2029-03-31 16:00:00", 
"2029-10-06 16:00:00", "2030-04-06 16:00:00", "2030-10-05 16:00:00", 
"2031-04-05 16:00:00", "2031-10-04 16:00:00", "2032-04-03 16:00:00", 
"2032-10-02 16:00:00", "2033-04-02 16:00:00", "2033-10-01 16:00:00", 
"2034-04-01 16:00:00", "2034-09-30 16:00:00", "2035-03-31 16:00:00", 
"2035-10-06 16:00:00", "2036-04-05 16:00:00", "2036-10-04 16:00:00", 
"2037-04-04 16:00:00"), offSet = c("36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST")), .Names = c("Currie", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -141L), class = "data.frame")
}

"Melbourne" <- function () {
structure(list(Melbourne = c("1901-12-14 20:45:52", "1916-12-31 14:01:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1972-10-28 16:00:00", "1973-03-03 16:00:00", "1973-10-27 16:00:00", 
"1974-03-02 16:00:00", "1974-10-26 16:00:00", "1975-03-01 16:00:00", 
"1975-10-25 16:00:00", "1976-03-06 16:00:00", "1976-10-30 16:00:00", 
"1977-03-05 16:00:00", "1977-10-29 16:00:00", "1978-03-04 16:00:00", 
"1978-10-28 16:00:00", "1979-03-03 16:00:00", "1979-10-27 16:00:00", 
"1980-03-01 16:00:00", "1980-10-25 16:00:00", "1981-02-28 16:00:00", 
"1981-10-24 16:00:00", "1982-03-06 16:00:00", "1982-10-30 16:00:00", 
"1983-03-05 16:00:00", "1983-10-29 16:00:00", "1984-03-03 16:00:00", 
"1984-10-27 16:00:00", "1985-03-02 16:00:00", "1985-10-26 16:00:00", 
"1986-03-15 16:00:00", "1986-10-18 16:00:00", "1987-03-14 16:00:00", 
"1987-10-17 16:00:00", "1988-03-19 16:00:00", "1988-10-29 16:00:00", 
"1989-03-18 16:00:00", "1989-10-28 16:00:00", "1990-03-17 16:00:00", 
"1990-10-27 16:00:00", "1991-03-02 16:00:00", "1991-10-26 16:00:00", 
"1992-02-29 16:00:00", "1992-10-24 16:00:00", "1993-03-06 16:00:00", 
"1993-10-30 16:00:00", "1994-03-05 16:00:00", "1994-10-29 16:00:00", 
"1995-03-25 16:00:00", "1995-10-28 16:00:00", "1996-03-30 16:00:00", 
"1996-10-26 16:00:00", "1997-03-29 16:00:00", "1997-10-25 16:00:00", 
"1998-03-28 16:00:00", "1998-10-24 16:00:00", "1999-03-27 16:00:00", 
"1999-10-30 16:00:00", "2000-03-25 16:00:00", "2000-08-26 16:00:00", 
"2001-03-24 16:00:00", "2001-10-27 16:00:00", "2002-03-30 16:00:00", 
"2002-10-26 16:00:00", "2003-03-29 16:00:00", "2003-10-25 16:00:00", 
"2004-03-27 16:00:00", "2004-10-30 16:00:00", "2005-03-26 16:00:00", 
"2005-10-29 16:00:00", "2006-04-01 16:00:00", "2006-10-28 16:00:00", 
"2007-03-24 16:00:00", "2007-10-27 16:00:00", "2008-04-05 16:00:00", 
"2008-10-04 16:00:00", "2009-04-04 16:00:00", "2009-10-03 16:00:00", 
"2010-04-03 16:00:00", "2010-10-02 16:00:00", "2011-04-02 16:00:00", 
"2011-10-01 16:00:00", "2012-03-31 16:00:00", "2012-10-06 16:00:00", 
"2013-04-06 16:00:00", "2013-10-05 16:00:00", "2014-04-05 16:00:00", 
"2014-10-04 16:00:00", "2015-04-04 16:00:00", "2015-10-03 16:00:00", 
"2016-04-02 16:00:00", "2016-10-01 16:00:00", "2017-04-01 16:00:00", 
"2017-09-30 16:00:00", "2018-03-31 16:00:00", "2018-10-06 16:00:00", 
"2019-04-06 16:00:00", "2019-10-05 16:00:00", "2020-04-04 16:00:00", 
"2020-10-03 16:00:00", "2021-04-03 16:00:00", "2021-10-02 16:00:00", 
"2022-04-02 16:00:00", "2022-10-01 16:00:00", "2023-04-01 16:00:00", 
"2023-09-30 16:00:00", "2024-04-06 16:00:00", "2024-10-05 16:00:00", 
"2025-04-05 16:00:00", "2025-10-04 16:00:00", "2026-04-04 16:00:00", 
"2026-10-03 16:00:00", "2027-04-03 16:00:00", "2027-10-02 16:00:00", 
"2028-04-01 16:00:00", "2028-09-30 16:00:00", "2029-03-31 16:00:00", 
"2029-10-06 16:00:00", "2030-04-06 16:00:00", "2030-10-05 16:00:00", 
"2031-04-05 16:00:00", "2031-10-04 16:00:00", "2032-04-03 16:00:00", 
"2032-10-02 16:00:00", "2033-04-02 16:00:00", "2033-10-01 16:00:00", 
"2034-04-01 16:00:00", "2034-09-30 16:00:00", "2035-03-31 16:00:00", 
"2035-10-06 16:00:00", "2036-04-05 16:00:00", "2036-10-04 16:00:00", 
"2037-04-04 16:00:00"), offSet = c("36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST")), .Names = c("Melbourne", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -141L), class = "data.frame")
}

"Sydney" <- function () {
structure(list(Sydney = c("1901-12-14 20:45:52", "1916-12-31 14:01:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1972-10-28 16:00:00", "1973-03-03 16:00:00", "1973-10-27 16:00:00", 
"1974-03-02 16:00:00", "1974-10-26 16:00:00", "1975-03-01 16:00:00", 
"1975-10-25 16:00:00", "1976-03-06 16:00:00", "1976-10-30 16:00:00", 
"1977-03-05 16:00:00", "1977-10-29 16:00:00", "1978-03-04 16:00:00", 
"1978-10-28 16:00:00", "1979-03-03 16:00:00", "1979-10-27 16:00:00", 
"1980-03-01 16:00:00", "1980-10-25 16:00:00", "1981-02-28 16:00:00", 
"1981-10-24 16:00:00", "1982-04-03 16:00:00", "1982-10-30 16:00:00", 
"1983-03-05 16:00:00", "1983-10-29 16:00:00", "1984-03-03 16:00:00", 
"1984-10-27 16:00:00", "1985-03-02 16:00:00", "1985-10-26 16:00:00", 
"1986-03-15 16:00:00", "1986-10-18 16:00:00", "1987-03-14 16:00:00", 
"1987-10-24 16:00:00", "1988-03-19 16:00:00", "1988-10-29 16:00:00", 
"1989-03-18 16:00:00", "1989-10-28 16:00:00", "1990-03-03 16:00:00", 
"1990-10-27 16:00:00", "1991-03-02 16:00:00", "1991-10-26 16:00:00", 
"1992-02-29 16:00:00", "1992-10-24 16:00:00", "1993-03-06 16:00:00", 
"1993-10-30 16:00:00", "1994-03-05 16:00:00", "1994-10-29 16:00:00", 
"1995-03-04 16:00:00", "1995-10-28 16:00:00", "1996-03-30 16:00:00", 
"1996-10-26 16:00:00", "1997-03-29 16:00:00", "1997-10-25 16:00:00", 
"1998-03-28 16:00:00", "1998-10-24 16:00:00", "1999-03-27 16:00:00", 
"1999-10-30 16:00:00", "2000-03-25 16:00:00", "2000-08-26 16:00:00", 
"2001-03-24 16:00:00", "2001-10-27 16:00:00", "2002-03-30 16:00:00", 
"2002-10-26 16:00:00", "2003-03-29 16:00:00", "2003-10-25 16:00:00", 
"2004-03-27 16:00:00", "2004-10-30 16:00:00", "2005-03-26 16:00:00", 
"2005-10-29 16:00:00", "2006-04-01 16:00:00", "2006-10-28 16:00:00", 
"2007-03-24 16:00:00", "2007-10-27 16:00:00", "2008-04-05 16:00:00", 
"2008-10-04 16:00:00", "2009-04-04 16:00:00", "2009-10-03 16:00:00", 
"2010-04-03 16:00:00", "2010-10-02 16:00:00", "2011-04-02 16:00:00", 
"2011-10-01 16:00:00", "2012-03-31 16:00:00", "2012-10-06 16:00:00", 
"2013-04-06 16:00:00", "2013-10-05 16:00:00", "2014-04-05 16:00:00", 
"2014-10-04 16:00:00", "2015-04-04 16:00:00", "2015-10-03 16:00:00", 
"2016-04-02 16:00:00", "2016-10-01 16:00:00", "2017-04-01 16:00:00", 
"2017-09-30 16:00:00", "2018-03-31 16:00:00", "2018-10-06 16:00:00", 
"2019-04-06 16:00:00", "2019-10-05 16:00:00", "2020-04-04 16:00:00", 
"2020-10-03 16:00:00", "2021-04-03 16:00:00", "2021-10-02 16:00:00", 
"2022-04-02 16:00:00", "2022-10-01 16:00:00", "2023-04-01 16:00:00", 
"2023-09-30 16:00:00", "2024-04-06 16:00:00", "2024-10-05 16:00:00", 
"2025-04-05 16:00:00", "2025-10-04 16:00:00", "2026-04-04 16:00:00", 
"2026-10-03 16:00:00", "2027-04-03 16:00:00", "2027-10-02 16:00:00", 
"2028-04-01 16:00:00", "2028-09-30 16:00:00", "2029-03-31 16:00:00", 
"2029-10-06 16:00:00", "2030-04-06 16:00:00", "2030-10-05 16:00:00", 
"2031-04-05 16:00:00", "2031-10-04 16:00:00", "2032-04-03 16:00:00", 
"2032-10-02 16:00:00", "2033-04-02 16:00:00", "2033-10-01 16:00:00", 
"2034-04-01 16:00:00", "2034-09-30 16:00:00", "2035-03-31 16:00:00", 
"2035-10-06 16:00:00", "2036-04-05 16:00:00", "2036-10-04 16:00:00", 
"2037-04-04 16:00:00"), offSet = c("36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST")), .Names = c("Sydney", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -141L), class = "data.frame")
}

"Broken_Hill" <- function () {
structure(list(Broken_Hill = c("1901-12-14 20:45:52", "1916-12-31 14:31:00", 
"1917-03-24 15:30:00", "1941-12-31 16:30:00", "1942-03-28 15:30:00", 
"1942-09-26 16:30:00", "1943-03-27 15:30:00", "1943-10-02 16:30:00", 
"1944-03-25 15:30:00", "1971-10-30 16:30:00", "1972-02-26 16:30:00", 
"1972-10-28 16:30:00", "1973-03-03 16:30:00", "1973-10-27 16:30:00", 
"1974-03-02 16:30:00", "1974-10-26 16:30:00", "1975-03-01 16:30:00", 
"1975-10-25 16:30:00", "1976-03-06 16:30:00", "1976-10-30 16:30:00", 
"1977-03-05 16:30:00", "1977-10-29 16:30:00", "1978-03-04 16:30:00", 
"1978-10-28 16:30:00", "1979-03-03 16:30:00", "1979-10-27 16:30:00", 
"1980-03-01 16:30:00", "1980-10-25 16:30:00", "1981-02-28 16:30:00", 
"1981-10-24 16:30:00", "1982-04-03 16:30:00", "1982-10-30 16:30:00", 
"1983-03-05 16:30:00", "1983-10-29 16:30:00", "1984-03-03 16:30:00", 
"1984-10-27 16:30:00", "1985-03-02 16:30:00", "1985-10-26 16:30:00", 
"1986-03-15 16:30:00", "1986-10-18 16:30:00", "1987-03-14 16:30:00", 
"1987-10-24 16:30:00", "1988-03-19 16:30:00", "1988-10-29 16:30:00", 
"1989-03-18 16:30:00", "1989-10-28 16:30:00", "1990-03-03 16:30:00", 
"1990-10-27 16:30:00", "1991-03-02 16:30:00", "1991-10-26 16:30:00", 
"1992-02-29 16:30:00", "1992-10-24 16:30:00", "1993-03-06 16:30:00", 
"1993-10-30 16:30:00", "1994-03-05 16:30:00", "1994-10-29 16:30:00", 
"1995-03-04 16:30:00", "1995-10-28 16:30:00", "1996-03-30 16:30:00", 
"1996-10-26 16:30:00", "1997-03-29 16:30:00", "1997-10-25 16:30:00", 
"1998-03-28 16:30:00", "1998-10-24 16:30:00", "1999-03-27 16:30:00", 
"1999-10-30 16:30:00", "2000-03-25 16:30:00", "2000-10-28 16:30:00", 
"2001-03-24 16:30:00", "2001-10-27 16:30:00", "2002-03-30 16:30:00", 
"2002-10-26 16:30:00", "2003-03-29 16:30:00", "2003-10-25 16:30:00", 
"2004-03-27 16:30:00", "2004-10-30 16:30:00", "2005-03-26 16:30:00", 
"2005-10-29 16:30:00", "2006-04-01 16:30:00", "2006-10-28 16:30:00", 
"2007-03-24 16:30:00", "2007-10-27 16:30:00", "2008-04-05 16:30:00", 
"2008-10-04 16:30:00", "2009-04-04 16:30:00", "2009-10-03 16:30:00", 
"2010-04-03 16:30:00", "2010-10-02 16:30:00", "2011-04-02 16:30:00", 
"2011-10-01 16:30:00", "2012-03-31 16:30:00", "2012-10-06 16:30:00", 
"2013-04-06 16:30:00", "2013-10-05 16:30:00", "2014-04-05 16:30:00", 
"2014-10-04 16:30:00", "2015-04-04 16:30:00", "2015-10-03 16:30:00", 
"2016-04-02 16:30:00", "2016-10-01 16:30:00", "2017-04-01 16:30:00", 
"2017-09-30 16:30:00", "2018-03-31 16:30:00", "2018-10-06 16:30:00", 
"2019-04-06 16:30:00", "2019-10-05 16:30:00", "2020-04-04 16:30:00", 
"2020-10-03 16:30:00", "2021-04-03 16:30:00", "2021-10-02 16:30:00", 
"2022-04-02 16:30:00", "2022-10-01 16:30:00", "2023-04-01 16:30:00", 
"2023-09-30 16:30:00", "2024-04-06 16:30:00", "2024-10-05 16:30:00", 
"2025-04-05 16:30:00", "2025-10-04 16:30:00", "2026-04-04 16:30:00", 
"2026-10-03 16:30:00", "2027-04-03 16:30:00", "2027-10-02 16:30:00", 
"2028-04-01 16:30:00", "2028-09-30 16:30:00", "2029-03-31 16:30:00", 
"2029-10-06 16:30:00", "2030-04-06 16:30:00", "2030-10-05 16:30:00", 
"2031-04-05 16:30:00", "2031-10-04 16:30:00", "2032-04-03 16:30:00", 
"2032-10-02 16:30:00", "2033-04-02 16:30:00", "2033-10-01 16:30:00", 
"2034-04-01 16:30:00", "2034-09-30 16:30:00", "2035-03-31 16:30:00", 
"2035-10-06 16:30:00", "2036-04-05 16:30:00", "2036-10-04 16:30:00", 
"2037-04-04 16:30:00"), offSet = c("34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST")), .Names = c("Broken_Hill", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -141L), class = "data.frame")
}

"Brisbane" <- function () {
structure(list(Brisbane = c("1901-12-14 20:45:52", "1916-12-31 14:01:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1989-10-28 16:00:00", "1990-03-03 16:00:00", "1990-10-27 16:00:00", 
"1991-03-02 16:00:00", "1991-10-26 16:00:00"), offSet = c("36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST")), .Names = c("Brisbane", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -16L), class = "data.frame")
}

"Lindeman" <- function () {
structure(list(Lindeman = c("1901-12-14 20:45:52", "1916-12-31 14:01:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1989-10-28 16:00:00", "1990-03-03 16:00:00", "1990-10-27 16:00:00", 
"1991-03-02 16:00:00", "1991-10-26 16:00:00", "1992-02-29 16:00:00", 
"1992-10-24 16:00:00", "1993-03-06 16:00:00", "1993-10-30 16:00:00"
), offSet = c("36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", "EST", 
"EST")), .Names = c("Lindeman", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -20L), class = "data.frame")
}

"Adelaide" <- function () {
structure(list(Adelaide = c("1901-12-14 20:45:52", "1916-12-31 14:31:00", 
"1917-03-24 15:30:00", "1941-12-31 16:30:00", "1942-03-28 15:30:00", 
"1942-09-26 16:30:00", "1943-03-27 15:30:00", "1943-10-02 16:30:00", 
"1944-03-25 15:30:00", "1971-10-30 16:30:00", "1972-02-26 16:30:00", 
"1972-10-28 16:30:00", "1973-03-03 16:30:00", "1973-10-27 16:30:00", 
"1974-03-02 16:30:00", "1974-10-26 16:30:00", "1975-03-01 16:30:00", 
"1975-10-25 16:30:00", "1976-03-06 16:30:00", "1976-10-30 16:30:00", 
"1977-03-05 16:30:00", "1977-10-29 16:30:00", "1978-03-04 16:30:00", 
"1978-10-28 16:30:00", "1979-03-03 16:30:00", "1979-10-27 16:30:00", 
"1980-03-01 16:30:00", "1980-10-25 16:30:00", "1981-02-28 16:30:00", 
"1981-10-24 16:30:00", "1982-03-06 16:30:00", "1982-10-30 16:30:00", 
"1983-03-05 16:30:00", "1983-10-29 16:30:00", "1984-03-03 16:30:00", 
"1984-10-27 16:30:00", "1985-03-02 16:30:00", "1985-10-26 16:30:00", 
"1986-03-15 16:30:00", "1986-10-18 16:30:00", "1987-03-14 16:30:00", 
"1987-10-24 16:30:00", "1988-03-19 16:30:00", "1988-10-29 16:30:00", 
"1989-03-18 16:30:00", "1989-10-28 16:30:00", "1990-03-17 16:30:00", 
"1990-10-27 16:30:00", "1991-03-02 16:30:00", "1991-10-26 16:30:00", 
"1992-03-21 16:30:00", "1992-10-24 16:30:00", "1993-03-06 16:30:00", 
"1993-10-30 16:30:00", "1994-03-19 16:30:00", "1994-10-29 16:30:00", 
"1995-03-25 16:30:00", "1995-10-28 16:30:00", "1996-03-30 16:30:00", 
"1996-10-26 16:30:00", "1997-03-29 16:30:00", "1997-10-25 16:30:00", 
"1998-03-28 16:30:00", "1998-10-24 16:30:00", "1999-03-27 16:30:00", 
"1999-10-30 16:30:00", "2000-03-25 16:30:00", "2000-10-28 16:30:00", 
"2001-03-24 16:30:00", "2001-10-27 16:30:00", "2002-03-30 16:30:00", 
"2002-10-26 16:30:00", "2003-03-29 16:30:00", "2003-10-25 16:30:00", 
"2004-03-27 16:30:00", "2004-10-30 16:30:00", "2005-03-26 16:30:00", 
"2005-10-29 16:30:00", "2006-04-01 16:30:00", "2006-10-28 16:30:00", 
"2007-03-24 16:30:00", "2007-10-27 16:30:00", "2008-04-05 16:30:00", 
"2008-10-04 16:30:00", "2009-04-04 16:30:00", "2009-10-03 16:30:00", 
"2010-04-03 16:30:00", "2010-10-02 16:30:00", "2011-04-02 16:30:00", 
"2011-10-01 16:30:00", "2012-03-31 16:30:00", "2012-10-06 16:30:00", 
"2013-04-06 16:30:00", "2013-10-05 16:30:00", "2014-04-05 16:30:00", 
"2014-10-04 16:30:00", "2015-04-04 16:30:00", "2015-10-03 16:30:00", 
"2016-04-02 16:30:00", "2016-10-01 16:30:00", "2017-04-01 16:30:00", 
"2017-09-30 16:30:00", "2018-03-31 16:30:00", "2018-10-06 16:30:00", 
"2019-04-06 16:30:00", "2019-10-05 16:30:00", "2020-04-04 16:30:00", 
"2020-10-03 16:30:00", "2021-04-03 16:30:00", "2021-10-02 16:30:00", 
"2022-04-02 16:30:00", "2022-10-01 16:30:00", "2023-04-01 16:30:00", 
"2023-09-30 16:30:00", "2024-04-06 16:30:00", "2024-10-05 16:30:00", 
"2025-04-05 16:30:00", "2025-10-04 16:30:00", "2026-04-04 16:30:00", 
"2026-10-03 16:30:00", "2027-04-03 16:30:00", "2027-10-02 16:30:00", 
"2028-04-01 16:30:00", "2028-09-30 16:30:00", "2029-03-31 16:30:00", 
"2029-10-06 16:30:00", "2030-04-06 16:30:00", "2030-10-05 16:30:00", 
"2031-04-05 16:30:00", "2031-10-04 16:30:00", "2032-04-03 16:30:00", 
"2032-10-02 16:30:00", "2033-04-02 16:30:00", "2033-10-01 16:30:00", 
"2034-04-01 16:30:00", "2034-09-30 16:30:00", "2035-03-31 16:30:00", 
"2035-10-06 16:30:00", "2036-04-05 16:30:00", "2036-10-04 16:30:00", 
"2037-04-04 16:30:00"), offSet = c("34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200", "37800", "34200", 
"37800", "34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800", "34200", "37800", "34200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST", "CST", "CST", "CST")), .Names = c("Adelaide", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -141L), class = "data.frame")
}

"Darwin" <- function () {
structure(list(Darwin = c("1901-12-14 20:45:52", "1916-12-31 14:31:00", 
"1917-03-24 15:30:00", "1941-12-31 16:30:00", "1942-03-28 15:30:00", 
"1942-09-26 16:30:00", "1943-03-27 15:30:00", "1943-10-02 16:30:00"
), offSet = c("34200", "37800", "34200", "37800", "34200", "37800", 
"34200", "37800"), isdst = c("0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CST")), .Names = c("Darwin", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -8L), class = "data.frame")
}

"Perth" <- function () {
structure(list(Perth = c("1901-12-14 20:45:52", "1916-12-31 16:01:00", 
"1917-03-24 17:00:00", "1941-12-31 18:00:00", "1942-03-28 17:00:00", 
"1942-09-26 18:00:00", "1943-03-27 17:00:00", "1974-10-26 18:00:00", 
"1975-03-01 18:00:00", "1983-10-29 18:00:00", "1984-03-03 18:00:00", 
"1991-11-16 18:00:00", "1992-02-29 18:00:00", "2006-12-02 18:00:00", 
"2007-03-24 18:00:00", "2007-10-27 18:00:00", "2008-03-29 18:00:00", 
"2008-10-25 18:00:00"), offSet = c("28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("WST", 
"WST", "WST", "WST", "WST", "WST", "WST", "WST", "WST", "WST", 
"WST", "WST", "WST", "WST", "WST", "WST", "WST", "WST")), .Names = c("Perth", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -18L), class = "data.frame")
}

"Eucla" <- function () {
structure(list(Eucla = c("1901-12-14 20:45:52", "1916-12-31 15:16:00", 
"1917-03-24 16:15:00", "1941-12-31 17:15:00", "1942-03-28 16:15:00", 
"1942-09-26 17:15:00", "1943-03-27 16:15:00", "1974-10-26 17:15:00", 
"1975-03-01 17:15:00", "1983-10-29 17:15:00", "1984-03-03 17:15:00", 
"1991-11-16 17:15:00", "1992-02-29 17:15:00", "2006-12-02 17:15:00", 
"2007-03-24 17:15:00", "2007-10-27 17:15:00", "2008-03-29 17:15:00", 
"2008-10-25 17:15:00"), offSet = c("31500", "35100", "31500", 
"35100", "31500", "35100", "31500", "35100", "31500", "35100", 
"31500", "35100", "31500", "35100", "31500", "35100", "31500", 
"35100"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CWST", 
"CWST", "CWST", "CWST", "CWST", "CWST", "CWST", "CWST", "CWST", 
"CWST", "CWST", "CWST", "CWST", "CWST", "CWST", "CWST", "CWST", 
"CWST")), .Names = c("Eucla", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-18L), class = "data.frame")
}

"Aruba" <- function () {
structure(list(Aruba = c("1901-12-14 20:45:52", "1912-02-12 04:40:24"
), offSet = c("-16824", "-16200"), isdst = c("0", "0"), TimeZone = c("AST", 
"AST")), .Names = c("Aruba", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Mariehamn" <- function () {
structure(list(Mariehamn = c("1901-12-14 20:45:52", "1921-04-30 22:20:08", 
"1942-04-02 22:00:00", "1942-10-02 21:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("5992", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("EET", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Mariehamn", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Baku" <- function () {
structure(list(Baku = c("1901-12-14 20:45:52", "1924-05-01 20:40:36", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-03-30 22:00:00", 
"1991-09-28 23:00:00", "1992-09-26 19:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 00:00:00", "1997-10-26 00:00:00", 
"1998-03-29 00:00:00", "1998-10-25 00:00:00", "1999-03-28 00:00:00", 
"1999-10-31 00:00:00", "2000-03-26 00:00:00", "2000-10-29 00:00:00", 
"2001-03-25 00:00:00", "2001-10-28 00:00:00", "2002-03-31 00:00:00", 
"2002-10-27 00:00:00", "2003-03-30 00:00:00", "2003-10-26 00:00:00", 
"2004-03-28 00:00:00", "2004-10-31 00:00:00", "2005-03-27 00:00:00", 
"2005-10-30 00:00:00", "2006-03-26 00:00:00", "2006-10-29 00:00:00", 
"2007-03-25 00:00:00", "2007-10-28 00:00:00", "2008-03-30 00:00:00", 
"2008-10-26 00:00:00", "2009-03-29 00:00:00", "2009-10-25 00:00:00", 
"2010-03-28 00:00:00", "2010-10-31 00:00:00", "2011-03-27 00:00:00", 
"2011-10-30 00:00:00", "2012-03-25 00:00:00", "2012-10-28 00:00:00", 
"2013-03-31 00:00:00", "2013-10-27 00:00:00", "2014-03-30 00:00:00", 
"2014-10-26 00:00:00", "2015-03-29 00:00:00", "2015-10-25 00:00:00", 
"2016-03-27 00:00:00", "2016-10-30 00:00:00", "2017-03-26 00:00:00", 
"2017-10-29 00:00:00", "2018-03-25 00:00:00", "2018-10-28 00:00:00", 
"2019-03-31 00:00:00", "2019-10-27 00:00:00", "2020-03-29 00:00:00", 
"2020-10-25 00:00:00", "2021-03-28 00:00:00", "2021-10-31 00:00:00", 
"2022-03-27 00:00:00", "2022-10-30 00:00:00", "2023-03-26 00:00:00", 
"2023-10-29 00:00:00", "2024-03-31 00:00:00", "2024-10-27 00:00:00", 
"2025-03-30 00:00:00", "2025-10-26 00:00:00", "2026-03-29 00:00:00", 
"2026-10-25 00:00:00", "2027-03-28 00:00:00", "2027-10-31 00:00:00", 
"2028-03-26 00:00:00", "2028-10-29 00:00:00", "2029-03-25 00:00:00", 
"2029-10-28 00:00:00", "2030-03-31 00:00:00", "2030-10-27 00:00:00", 
"2031-03-30 00:00:00", "2031-10-26 00:00:00", "2032-03-28 00:00:00", 
"2032-10-31 00:00:00", "2033-03-27 00:00:00", "2033-10-30 00:00:00", 
"2034-03-26 00:00:00", "2034-10-29 00:00:00", "2035-03-25 00:00:00", 
"2035-10-28 00:00:00", "2036-03-30 00:00:00", "2036-10-26 00:00:00", 
"2037-03-29 00:00:00"), offSet = c("11964", "10800", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "10800", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000"
), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("AZT", "AZT", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZST", "AZT", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST")), .Names = c("Baku", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -108L), class = "data.frame")
}

"Sarajevo" <- function () {
structure(list(Sarajevo = c("1901-12-14 20:45:52", "1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Sarajevo", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Barbados" <- function () {
structure(list(Barbados = c("1901-12-14 20:45:52", "1932-01-01 03:58:28", 
"1977-06-12 06:00:00", "1977-10-02 05:00:00", "1978-04-16 06:00:00", 
"1978-10-01 05:00:00", "1979-04-15 06:00:00", "1979-09-30 05:00:00", 
"1980-04-20 06:00:00"), offSet = c("-14308", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("AST", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT")), .Names = c("Barbados", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -9L), class = "data.frame")
}

"Dhaka" <- function () {
structure(list(Dhaka = c("1901-12-14 20:45:52", "1941-09-30 18:06:40", 
"1942-05-14 17:30:00", "1942-08-31 18:30:00"), offSet = c("21200", 
"23400", "19800", "23400"), isdst = c("0", "0", "0", "0"), TimeZone = c("BDT", 
"BDT", "BDT", "BDT")), .Names = c("Dhaka", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Brussels" <- function () {
structure(list(Brussels = c("1901-12-14 20:45:52", "1914-11-08 00:00:00", 
"1916-04-30 23:00:00", "1916-09-30 23:00:00", "1917-04-16 01:00:00", 
"1917-09-17 01:00:00", "1918-04-15 01:00:00", "1918-09-16 01:00:00", 
"1918-11-11 11:00:00", "1919-03-01 23:00:00", "1919-10-04 23:00:00", 
"1920-02-14 23:00:00", "1920-10-23 23:00:00", "1921-03-14 23:00:00", 
"1921-10-25 23:00:00", "1922-03-25 23:00:00", "1922-10-07 23:00:00", 
"1923-04-21 23:00:00", "1923-10-06 23:00:00", "1924-03-29 23:00:00", 
"1924-10-04 23:00:00", "1925-04-04 23:00:00", "1925-10-03 23:00:00", 
"1926-04-17 23:00:00", "1926-10-02 23:00:00", "1927-04-09 23:00:00", 
"1927-10-01 23:00:00", "1928-04-14 23:00:00", "1928-10-07 02:00:00", 
"1929-04-21 02:00:00", "1929-10-06 02:00:00", "1930-04-13 02:00:00", 
"1930-10-05 02:00:00", "1931-04-19 02:00:00", "1931-10-04 02:00:00", 
"1932-04-03 02:00:00", "1932-10-02 02:00:00", "1933-03-26 02:00:00", 
"1933-10-08 02:00:00", "1934-04-08 02:00:00", "1934-10-07 02:00:00", 
"1935-03-31 02:00:00", "1935-10-06 02:00:00", "1936-04-19 02:00:00", 
"1936-10-04 02:00:00", "1937-04-04 02:00:00", "1937-10-03 02:00:00", 
"1938-03-27 02:00:00", "1938-10-02 02:00:00", "1939-04-16 02:00:00", 
"1939-11-19 02:00:00", "1940-02-25 02:00:00", "1940-05-20 02:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-09-16 01:00:00", "1946-05-19 01:00:00", "1946-10-07 01:00:00", 
"1977-04-03 01:00:00", "1977-09-25 01:00:00", "1978-04-02 01:00:00", 
"1978-10-01 01:00:00", "1979-04-01 01:00:00", "1979-09-30 01:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("0", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST")), .Names = c("Brussels", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -183L), class = "data.frame")
}

"Ouagadougou" <- function () {
structure(list(Ouagadougou = "1901-12-14 20:45:52", offSet = "-364", 
    isdst = "0", TimeZone = "GMT"), .Names = c("Ouagadougou", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Sofia" <- function () {
structure(list(Sofia = c("1901-12-14 20:45:52", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 02:00:00", "1979-03-31 21:00:00", 
"1979-09-30 22:00:00", "1980-04-05 21:00:00", "1980-09-28 22:00:00", 
"1981-04-04 21:00:00", "1981-09-26 23:00:00", "1982-04-03 21:00:00", 
"1982-09-26 00:00:00", "1983-03-27 00:00:00", "1983-09-25 00:00:00", 
"1984-03-25 00:00:00", "1984-09-30 00:00:00", "1985-03-31 00:00:00", 
"1985-09-29 00:00:00", "1986-03-30 00:00:00", "1986-09-28 00:00:00", 
"1987-03-29 00:00:00", "1987-09-27 00:00:00", "1988-03-27 00:00:00", 
"1988-09-25 00:00:00", "1989-03-26 00:00:00", "1989-09-24 00:00:00", 
"1990-03-25 00:00:00", "1990-09-30 00:00:00", "1991-03-30 22:00:00", 
"1991-09-28 21:00:00", "1992-03-28 22:00:00", "1992-09-26 21:00:00", 
"1993-03-27 22:00:00", "1993-09-25 21:00:00", "1994-03-26 22:00:00", 
"1994-09-24 21:00:00", "1995-03-25 22:00:00", "1995-09-23 21:00:00", 
"1996-03-30 22:00:00", "1996-10-26 21:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800"), isdst = c("0", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("EET", "EET", "EEST", "EET", "EEST", 
"EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST")), .Names = c("Sofia", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -124L), class = "data.frame")
}

"Bahrain" <- function () {
structure(list(Bahrain = c("1901-12-14 20:45:52", "1919-12-31 20:37:40"
), offSet = c("12140", "14400"), isdst = c("0", "0"), TimeZone = c("AST", 
"AST")), .Names = c("Bahrain", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Bujumbura" <- function () {
structure(list(Bujumbura = "1901-12-14 20:45:52", offSet = "7200", 
    isdst = "0", TimeZone = "CAT"), .Names = c("Bujumbura", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Porto-Novo" <- function () {
structure(list("Porto-Novo" = c("1901-12-14 20:45:52", "1911-12-31 23:49:32"
), offSet = c("628", "0"), isdst = c("0", "0"), TimeZone = c("WAT", 
"WAT")), .Names = c("Porto-Novo", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"St_Barthelemy" <- function () {
structure(list(St_Barthelemy = "1901-12-14 20:45:52", offSet = "-14768", 
    isdst = "0", TimeZone = "AST"), .Names = c("St_Barthelemy", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Bermuda" <- function () {
structure(list(Bermuda = c("1901-12-14 20:45:52", "1930-01-01 06:19:04", 
"1974-04-28 06:00:00", "1974-10-27 05:00:00", "1975-04-27 06:00:00", 
"1975-10-26 05:00:00", "1976-04-25 06:00:00", "1976-10-31 05:00:00", 
"1977-04-24 06:00:00", "1977-10-30 05:00:00", "1978-04-30 06:00:00", 
"1978-10-29 05:00:00", "1979-04-29 06:00:00", "1979-10-28 05:00:00", 
"1980-04-27 06:00:00", "1980-10-26 05:00:00", "1981-04-26 06:00:00", 
"1981-10-25 05:00:00", "1982-04-25 06:00:00", "1982-10-31 05:00:00", 
"1983-04-24 06:00:00", "1983-10-30 05:00:00", "1984-04-29 06:00:00", 
"1984-10-28 05:00:00", "1985-04-28 06:00:00", "1985-10-27 05:00:00", 
"1986-04-27 06:00:00", "1986-10-26 05:00:00", "1987-04-05 06:00:00", 
"1987-10-25 05:00:00", "1988-04-03 06:00:00", "1988-10-30 05:00:00", 
"1989-04-02 06:00:00", "1989-10-29 05:00:00", "1990-04-01 06:00:00", 
"1990-10-28 05:00:00", "1991-04-07 06:00:00", "1991-10-27 05:00:00", 
"1992-04-05 06:00:00", "1992-10-25 05:00:00", "1993-04-04 06:00:00", 
"1993-10-31 05:00:00", "1994-04-03 06:00:00", "1994-10-30 05:00:00", 
"1995-04-02 06:00:00", "1995-10-29 05:00:00", "1996-04-07 06:00:00", 
"1996-10-27 05:00:00", "1997-04-06 06:00:00", "1997-10-26 05:00:00", 
"1998-04-05 06:00:00", "1998-10-25 05:00:00", "1999-04-04 06:00:00", 
"1999-10-31 05:00:00", "2000-04-02 06:00:00", "2000-10-29 05:00:00", 
"2001-04-01 06:00:00", "2001-10-28 05:00:00", "2002-04-07 06:00:00", 
"2002-10-27 05:00:00", "2003-04-06 06:00:00", "2003-10-26 05:00:00", 
"2004-04-04 06:00:00", "2004-10-31 05:00:00", "2005-04-03 06:00:00", 
"2005-10-30 05:00:00", "2006-04-02 06:00:00", "2006-10-29 05:00:00", 
"2007-03-11 06:00:00", "2007-11-04 05:00:00", "2008-03-09 06:00:00", 
"2008-11-02 05:00:00", "2009-03-08 06:00:00", "2009-11-01 05:00:00", 
"2010-03-14 06:00:00", "2010-11-07 05:00:00", "2011-03-13 06:00:00", 
"2011-11-06 05:00:00", "2012-03-11 06:00:00", "2012-11-04 05:00:00", 
"2013-03-10 06:00:00", "2013-11-03 05:00:00", "2014-03-09 06:00:00", 
"2014-11-02 05:00:00", "2015-03-08 06:00:00", "2015-11-01 05:00:00", 
"2016-03-13 06:00:00", "2016-11-06 05:00:00", "2017-03-12 06:00:00", 
"2017-11-05 05:00:00", "2018-03-11 06:00:00", "2018-11-04 05:00:00", 
"2019-03-10 06:00:00", "2019-11-03 05:00:00", "2020-03-08 06:00:00", 
"2020-11-01 05:00:00", "2021-03-14 06:00:00", "2021-11-07 05:00:00", 
"2022-03-13 06:00:00", "2022-11-06 05:00:00", "2023-03-12 06:00:00", 
"2023-11-05 05:00:00", "2024-03-10 06:00:00", "2024-11-03 05:00:00", 
"2025-03-09 06:00:00", "2025-11-02 05:00:00", "2026-03-08 06:00:00", 
"2026-11-01 05:00:00", "2027-03-14 06:00:00", "2027-11-07 05:00:00", 
"2028-03-12 06:00:00", "2028-11-05 05:00:00", "2029-03-11 06:00:00", 
"2029-11-04 05:00:00", "2030-03-10 06:00:00", "2030-11-03 05:00:00", 
"2031-03-09 06:00:00", "2031-11-02 05:00:00", "2032-03-14 06:00:00", 
"2032-11-07 05:00:00", "2033-03-13 06:00:00", "2033-11-06 05:00:00", 
"2034-03-12 06:00:00", "2034-11-05 05:00:00", "2035-03-11 06:00:00", 
"2035-11-04 05:00:00", "2036-03-09 06:00:00", "2036-11-02 05:00:00", 
"2037-03-08 06:00:00"), offSet = c("-15544", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("AST", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT")), .Names = c("Bermuda", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -129L), class = "data.frame")
}

"Brunei" <- function () {
structure(list(Brunei = c("1901-12-14 20:45:52", "1926-02-28 16:20:20"
), offSet = c("27580", "27000"), isdst = c("0", "0"), TimeZone = c("BNT", 
"BNT")), .Names = c("Brunei", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"La_Paz" <- function () {
structure(list(La_Paz = c("1901-12-14 20:45:52", "1931-10-15 04:32:36"
), offSet = c("-16356", "-12756"), isdst = c("0", "1"), TimeZone = c("BOT", 
"BOST")), .Names = c("La_Paz", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Noronha" <- function () {
structure(list(Noronha = c("1901-12-14 20:45:52", "1914-01-01 02:09:40", 
"1931-10-03 13:00:00", "1932-04-01 01:00:00", "1932-10-03 02:00:00", 
"1933-04-01 01:00:00", "1949-12-01 02:00:00", "1950-04-16 02:00:00", 
"1950-12-01 02:00:00", "1951-04-01 01:00:00", "1951-12-01 02:00:00", 
"1952-04-01 01:00:00", "1952-12-01 02:00:00", "1953-03-01 01:00:00", 
"1963-12-09 02:00:00", "1964-03-01 01:00:00", "1965-01-31 02:00:00", 
"1965-03-31 01:00:00", "1965-12-01 02:00:00", "1966-03-01 01:00:00", 
"1966-11-01 02:00:00", "1967-03-01 01:00:00", "1967-11-01 02:00:00", 
"1968-03-01 01:00:00", "1985-11-02 02:00:00", "1986-03-15 01:00:00", 
"1986-10-25 02:00:00", "1987-02-14 01:00:00", "1987-10-25 02:00:00", 
"1988-02-07 01:00:00", "1988-10-16 02:00:00", "1989-01-29 01:00:00", 
"1989-10-15 02:00:00", "1990-02-11 01:00:00", "1999-10-03 02:00:00", 
"2000-02-27 01:00:00", "2000-10-08 02:00:00", "2000-10-15 01:00:00", 
"2001-10-14 02:00:00"), offSet = c("-7780", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("FNT", "FNT", "FNST", "FNT", 
"FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", 
"FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", 
"FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", 
"FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST")), .Names = c("Noronha", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -39L), class = "data.frame")
}

"Belem" <- function () {
structure(list(Belem = c("1901-12-14 20:45:52", "1914-01-01 03:13:56", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00"
), offSet = c("-11636", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("BRT", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST")), .Names = c("Belem", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-29L), class = "data.frame")
}

"Fortaleza" <- function () {
structure(list(Fortaleza = c("1901-12-14 20:45:52", "1914-01-01 02:34:00", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2000-10-22 02:00:00", 
"2001-10-14 03:00:00"), offSet = c("-9240", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("BRT", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST")), .Names = c("Fortaleza", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -39L), class = "data.frame")
}

"Recife" <- function () {
structure(list(Recife = c("1901-12-14 20:45:52", "1914-01-01 02:19:36", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2000-10-15 02:00:00", 
"2001-10-14 03:00:00"), offSet = c("-8376", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("BRT", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST")), .Names = c("Recife", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -39L), class = "data.frame")
}

"Araguaina" <- function () {
structure(list(Araguaina = c("1901-12-14 20:45:52", "1914-01-01 03:12:48", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1995-10-15 03:00:00", 
"1996-02-11 02:00:00", "1996-10-06 03:00:00", "1997-02-16 02:00:00", 
"1997-10-06 03:00:00", "1998-03-01 02:00:00", "1998-10-11 03:00:00", 
"1999-02-21 02:00:00", "1999-10-03 03:00:00", "2000-02-27 02:00:00", 
"2000-10-08 03:00:00", "2001-02-18 02:00:00", "2001-10-14 03:00:00", 
"2002-02-17 02:00:00", "2002-11-03 03:00:00"), offSet = c("-11568", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("BRT", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST")), .Names = c("Araguaina", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -49L), class = "data.frame")
}

"Maceio" <- function () {
structure(list(Maceio = c("1901-12-14 20:45:52", "1914-01-01 02:22:52", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1995-10-15 03:00:00", 
"1996-02-11 02:00:00", "1999-10-03 03:00:00", "2000-02-27 02:00:00", 
"2000-10-08 03:00:00", "2000-10-22 02:00:00", "2001-10-14 03:00:00"
), offSet = c("-8572", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("BRT", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST")), .Names = c("Maceio", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -41L), class = "data.frame")
}

"Bahia" <- function () {
structure(list(Bahia = c("1901-12-14 20:45:52", "1914-01-01 02:34:04", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1990-10-21 03:00:00", 
"1991-02-17 02:00:00", "1991-10-20 03:00:00", "1992-02-09 02:00:00", 
"1992-10-25 03:00:00", "1993-01-31 02:00:00", "1993-10-17 03:00:00", 
"1994-02-20 02:00:00", "1994-10-16 03:00:00", "1995-02-19 02:00:00", 
"1995-10-15 03:00:00", "1996-02-11 02:00:00", "1996-10-06 03:00:00", 
"1997-02-16 02:00:00", "1997-10-06 03:00:00", "1998-03-01 02:00:00", 
"1998-10-11 03:00:00", "1999-02-21 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2001-02-18 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00", "2002-11-03 03:00:00"
), offSet = c("-9244", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("BRT", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST")), .Names = c("Bahia", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -59L), class = "data.frame")
}

"Sao_Paulo" <- function () {
structure(list(Sao_Paulo = c("1901-12-14 20:45:52", "1914-01-01 03:06:28", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-10-23 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1990-10-21 03:00:00", 
"1991-02-17 02:00:00", "1991-10-20 03:00:00", "1992-02-09 02:00:00", 
"1992-10-25 03:00:00", "1993-01-31 02:00:00", "1993-10-17 03:00:00", 
"1994-02-20 02:00:00", "1994-10-16 03:00:00", "1995-02-19 02:00:00", 
"1995-10-15 03:00:00", "1996-02-11 02:00:00", "1996-10-06 03:00:00", 
"1997-02-16 02:00:00", "1997-10-06 03:00:00", "1998-03-01 02:00:00", 
"1998-10-11 03:00:00", "1999-02-21 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2001-02-18 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00", "2002-11-03 03:00:00", 
"2003-02-16 02:00:00", "2003-10-19 03:00:00", "2004-02-15 02:00:00", 
"2004-11-02 03:00:00", "2005-02-20 02:00:00", "2005-10-16 03:00:00", 
"2006-02-19 02:00:00", "2006-11-05 03:00:00", "2007-02-25 02:00:00", 
"2007-10-14 03:00:00", "2008-02-17 02:00:00", "2008-10-12 03:00:00", 
"2009-02-15 02:00:00", "2009-10-11 03:00:00", "2010-02-21 02:00:00", 
"2010-10-10 03:00:00", "2011-02-20 02:00:00", "2011-10-09 03:00:00", 
"2012-02-19 02:00:00", "2012-10-14 03:00:00", "2013-02-17 02:00:00", 
"2013-10-13 03:00:00", "2014-02-16 02:00:00", "2014-10-12 03:00:00", 
"2015-02-15 02:00:00", "2015-10-11 03:00:00", "2016-02-21 02:00:00", 
"2016-10-09 03:00:00", "2017-02-19 02:00:00", "2017-10-08 03:00:00", 
"2018-02-18 02:00:00", "2018-10-14 03:00:00", "2019-02-17 02:00:00", 
"2019-10-13 03:00:00", "2020-02-16 02:00:00", "2020-10-11 03:00:00", 
"2021-02-21 02:00:00", "2021-10-10 03:00:00", "2022-02-20 02:00:00", 
"2022-10-09 03:00:00", "2023-02-19 02:00:00", "2023-10-08 03:00:00", 
"2024-02-18 02:00:00", "2024-10-13 03:00:00", "2025-02-16 02:00:00", 
"2025-10-12 03:00:00", "2026-02-15 02:00:00", "2026-10-11 03:00:00", 
"2027-02-21 02:00:00", "2027-10-10 03:00:00", "2028-02-20 02:00:00", 
"2028-10-08 03:00:00", "2029-02-18 02:00:00", "2029-10-14 03:00:00", 
"2030-02-17 02:00:00", "2030-10-13 03:00:00", "2031-02-16 02:00:00", 
"2031-10-12 03:00:00", "2032-02-15 02:00:00", "2032-10-10 03:00:00", 
"2033-02-20 02:00:00", "2033-10-09 03:00:00", "2034-02-19 02:00:00", 
"2034-10-08 03:00:00", "2035-02-18 02:00:00", "2035-10-14 03:00:00", 
"2036-02-17 02:00:00", "2036-10-12 03:00:00", "2037-02-15 02:00:00"
), offSet = c("-11188", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800"), isdst = c("0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("BRT", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT")), .Names = c("Sao_Paulo", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -128L), class = "data.frame")
}

"Campo_Grande" <- function () {
structure(list(Campo_Grande = c("1901-12-14 20:45:52", "1914-01-01 03:38:28", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1988-10-16 04:00:00", "1989-01-29 03:00:00", 
"1989-10-15 04:00:00", "1990-02-11 03:00:00", "1990-10-21 04:00:00", 
"1991-02-17 03:00:00", "1991-10-20 04:00:00", "1992-02-09 03:00:00", 
"1992-10-25 04:00:00", "1993-01-31 03:00:00", "1993-10-17 04:00:00", 
"1994-02-20 03:00:00", "1994-10-16 04:00:00", "1995-02-19 03:00:00", 
"1995-10-15 04:00:00", "1996-02-11 03:00:00", "1996-10-06 04:00:00", 
"1997-02-16 03:00:00", "1997-10-06 04:00:00", "1998-03-01 03:00:00", 
"1998-10-11 04:00:00", "1999-02-21 03:00:00", "1999-10-03 04:00:00", 
"2000-02-27 03:00:00", "2000-10-08 04:00:00", "2001-02-18 03:00:00", 
"2001-10-14 04:00:00", "2002-02-17 03:00:00", "2002-11-03 04:00:00", 
"2003-02-16 03:00:00", "2003-10-19 04:00:00", "2004-02-15 03:00:00", 
"2004-11-02 04:00:00", "2005-02-20 03:00:00", "2005-10-16 04:00:00", 
"2006-02-19 03:00:00", "2006-11-05 04:00:00", "2007-02-25 03:00:00", 
"2007-10-14 04:00:00", "2008-02-17 03:00:00", "2008-10-12 04:00:00", 
"2009-02-15 03:00:00", "2009-10-11 04:00:00", "2010-02-21 03:00:00", 
"2010-10-10 04:00:00", "2011-02-20 03:00:00", "2011-10-09 04:00:00", 
"2012-02-19 03:00:00", "2012-10-14 04:00:00", "2013-02-17 03:00:00", 
"2013-10-13 04:00:00", "2014-02-16 03:00:00", "2014-10-12 04:00:00", 
"2015-02-15 03:00:00", "2015-10-11 04:00:00", "2016-02-21 03:00:00", 
"2016-10-09 04:00:00", "2017-02-19 03:00:00", "2017-10-08 04:00:00", 
"2018-02-18 03:00:00", "2018-10-14 04:00:00", "2019-02-17 03:00:00", 
"2019-10-13 04:00:00", "2020-02-16 03:00:00", "2020-10-11 04:00:00", 
"2021-02-21 03:00:00", "2021-10-10 04:00:00", "2022-02-20 03:00:00", 
"2022-10-09 04:00:00", "2023-02-19 03:00:00", "2023-10-08 04:00:00", 
"2024-02-18 03:00:00", "2024-10-13 04:00:00", "2025-02-16 03:00:00", 
"2025-10-12 04:00:00", "2026-02-15 03:00:00", "2026-10-11 04:00:00", 
"2027-02-21 03:00:00", "2027-10-10 04:00:00", "2028-02-20 03:00:00", 
"2028-10-08 04:00:00", "2029-02-18 03:00:00", "2029-10-14 04:00:00", 
"2030-02-17 03:00:00", "2030-10-13 04:00:00", "2031-02-16 03:00:00", 
"2031-10-12 04:00:00", "2032-02-15 03:00:00", "2032-10-10 04:00:00", 
"2033-02-20 03:00:00", "2033-10-09 04:00:00", "2034-02-19 03:00:00", 
"2034-10-08 04:00:00", "2035-02-18 03:00:00", "2035-10-14 04:00:00", 
"2036-02-17 03:00:00", "2036-10-12 04:00:00", "2037-02-15 03:00:00"
), offSet = c("-13108", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("AMT", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT")), .Names = c("Campo_Grande", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -128L), class = "data.frame")
}

"Cuiaba" <- function () {
structure(list(Cuiaba = c("1901-12-14 20:45:52", "1914-01-01 03:44:20", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1988-10-16 04:00:00", "1989-01-29 03:00:00", 
"1989-10-15 04:00:00", "1990-02-11 03:00:00", "1990-10-21 04:00:00", 
"1991-02-17 03:00:00", "1991-10-20 04:00:00", "1992-02-09 03:00:00", 
"1992-10-25 04:00:00", "1993-01-31 03:00:00", "1993-10-17 04:00:00", 
"1994-02-20 03:00:00", "1994-10-16 04:00:00", "1995-02-19 03:00:00", 
"1995-10-15 04:00:00", "1996-02-11 03:00:00", "1996-10-06 04:00:00", 
"1997-02-16 03:00:00", "1997-10-06 04:00:00", "1998-03-01 03:00:00", 
"1998-10-11 04:00:00", "1999-02-21 03:00:00", "1999-10-03 04:00:00", 
"2000-02-27 03:00:00", "2000-10-08 04:00:00", "2001-02-18 03:00:00", 
"2001-10-14 04:00:00", "2002-02-17 03:00:00", "2002-11-03 04:00:00", 
"2003-02-16 03:00:00", "2004-11-02 04:00:00", "2005-02-20 03:00:00", 
"2005-10-16 04:00:00", "2006-02-19 03:00:00", "2006-11-05 04:00:00", 
"2007-02-25 03:00:00", "2007-10-14 04:00:00", "2008-02-17 03:00:00", 
"2008-10-12 04:00:00", "2009-02-15 03:00:00", "2009-10-11 04:00:00", 
"2010-02-21 03:00:00", "2010-10-10 04:00:00", "2011-02-20 03:00:00", 
"2011-10-09 04:00:00", "2012-02-19 03:00:00", "2012-10-14 04:00:00", 
"2013-02-17 03:00:00", "2013-10-13 04:00:00", "2014-02-16 03:00:00", 
"2014-10-12 04:00:00", "2015-02-15 03:00:00", "2015-10-11 04:00:00", 
"2016-02-21 03:00:00", "2016-10-09 04:00:00", "2017-02-19 03:00:00", 
"2017-10-08 04:00:00", "2018-02-18 03:00:00", "2018-10-14 04:00:00", 
"2019-02-17 03:00:00", "2019-10-13 04:00:00", "2020-02-16 03:00:00", 
"2020-10-11 04:00:00", "2021-02-21 03:00:00", "2021-10-10 04:00:00", 
"2022-02-20 03:00:00", "2022-10-09 04:00:00", "2023-02-19 03:00:00", 
"2023-10-08 04:00:00", "2024-02-18 03:00:00", "2024-10-13 04:00:00", 
"2025-02-16 03:00:00", "2025-10-12 04:00:00", "2026-02-15 03:00:00", 
"2026-10-11 04:00:00", "2027-02-21 03:00:00", "2027-10-10 04:00:00", 
"2028-02-20 03:00:00", "2028-10-08 04:00:00", "2029-02-18 03:00:00", 
"2029-10-14 04:00:00", "2030-02-17 03:00:00", "2030-10-13 04:00:00", 
"2031-02-16 03:00:00", "2031-10-12 04:00:00", "2032-02-15 03:00:00", 
"2032-10-10 04:00:00", "2033-02-20 03:00:00", "2033-10-09 04:00:00", 
"2034-02-19 03:00:00", "2034-10-08 04:00:00", "2035-02-18 03:00:00", 
"2035-10-14 04:00:00", "2036-02-17 03:00:00", "2036-10-12 04:00:00", 
"2037-02-15 03:00:00"), offSet = c("-13460", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0"), TimeZone = c("AMT", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT")), .Names = c("Cuiaba", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -126L), class = "data.frame")
}

"Porto_Velho" <- function () {
structure(list(Porto_Velho = c("1901-12-14 20:45:52", "1914-01-01 04:15:36", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00"
), offSet = c("-15336", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("AMT", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST")), .Names = c("Porto_Velho", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -29L), class = "data.frame")
}

"Boa_Vista" <- function () {
structure(list(Boa_Vista = c("1901-12-14 20:45:52", "1914-01-01 04:02:40", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1999-10-03 04:00:00", "2000-02-27 03:00:00", 
"2000-10-08 04:00:00"), offSet = c("-14560", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("AMT", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST"
)), .Names = c("Boa_Vista", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-33L), class = "data.frame")
}

"Manaus" <- function () {
structure(list(Manaus = c("1901-12-14 20:45:52", "1914-01-01 04:00:04", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1993-10-17 04:00:00"), offSet = c("-14404", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("AMT", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
    "AMST")), .Names = c("Manaus", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -31L), class = "data.frame")
}

"Eirunepe" <- function () {
structure(list(Eirunepe = c("1901-12-14 20:45:52", "1914-01-01 04:39:28", 
"1931-10-03 16:00:00", "1932-04-01 04:00:00", "1932-10-03 05:00:00", 
"1933-04-01 04:00:00", "1949-12-01 05:00:00", "1950-04-16 05:00:00", 
"1950-12-01 05:00:00", "1951-04-01 04:00:00", "1951-12-01 05:00:00", 
"1952-04-01 04:00:00", "1952-12-01 05:00:00", "1953-03-01 04:00:00", 
"1963-12-09 05:00:00", "1964-03-01 04:00:00", "1965-01-31 05:00:00", 
"1965-03-31 04:00:00", "1965-12-01 05:00:00", "1966-03-01 04:00:00", 
"1966-11-01 05:00:00", "1967-03-01 04:00:00", "1967-11-01 05:00:00", 
"1968-03-01 04:00:00", "1985-11-02 05:00:00", "1986-03-15 04:00:00", 
"1986-10-25 05:00:00", "1987-02-14 04:00:00", "1987-10-25 05:00:00", 
"1988-02-07 04:00:00", "1993-10-17 05:00:00"), offSet = c("-16768", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("ACT", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST")), .Names = c("Eirunepe", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -31L), class = "data.frame")
}

"Rio_Branco" <- function () {
structure(list(Rio_Branco = c("1901-12-14 20:45:52", "1914-01-01 04:31:12", 
"1931-10-03 16:00:00", "1932-04-01 04:00:00", "1932-10-03 05:00:00", 
"1933-04-01 04:00:00", "1949-12-01 05:00:00", "1950-04-16 05:00:00", 
"1950-12-01 05:00:00", "1951-04-01 04:00:00", "1951-12-01 05:00:00", 
"1952-04-01 04:00:00", "1952-12-01 05:00:00", "1953-03-01 04:00:00", 
"1963-12-09 05:00:00", "1964-03-01 04:00:00", "1965-01-31 05:00:00", 
"1965-03-31 04:00:00", "1965-12-01 05:00:00", "1966-03-01 04:00:00", 
"1966-11-01 05:00:00", "1967-03-01 04:00:00", "1967-11-01 05:00:00", 
"1968-03-01 04:00:00", "1985-11-02 05:00:00", "1986-03-15 04:00:00", 
"1986-10-25 05:00:00", "1987-02-14 04:00:00", "1987-10-25 05:00:00"
), offSet = c("-16272", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("ACT", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
    "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST")), .Names = c("Rio_Branco", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -29L), class = "data.frame")
}

"Nassau" <- function () {
structure(list(Nassau = c("1901-12-14 20:45:52", "1912-03-02 05:09:24", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("-18564", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("EST", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT")), .Names = c("Nassau", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-149L), class = "data.frame")
}

"Thimphu" <- function () {
structure(list(Thimphu = c("1901-12-14 20:45:52", "1947-08-14 18:01:24"
), offSet = c("21516", "19800"), isdst = c("0", "0"), TimeZone = c("BTT", 
"BTT")), .Names = c("Thimphu", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Gaborone" <- function () {
structure(list(Gaborone = c("1901-12-14 20:45:52", "1943-09-19 00:00:00"
), offSet = c("7200", "10800"), isdst = c("0", "1"), TimeZone = c("CAT", 
"CAST")), .Names = c("Gaborone", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Minsk" <- function () {
structure(list(Minsk = c("1901-12-14 20:45:52", "1924-05-01 22:10:00", 
"1930-06-20 22:00:00", "1941-06-27 21:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-07-02 22:00:00", "1981-03-31 21:00:00", "1981-09-30 20:00:00", 
"1982-03-31 21:00:00", "1982-09-30 20:00:00", "1983-03-31 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-29 23:00:00", 
"1985-03-30 23:00:00", "1985-09-28 23:00:00", "1986-03-29 23:00:00", 
"1986-09-27 23:00:00", "1987-03-28 23:00:00", "1987-09-26 23:00:00", 
"1988-03-26 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1991-03-30 23:00:00", "1991-09-29 00:00:00", "1992-03-28 22:00:00", 
"1992-09-26 22:00:00", "1993-03-28 00:00:00", "1993-09-26 00:00:00", 
"1994-03-27 00:00:00", "1994-09-25 00:00:00", "1995-03-26 00:00:00", 
"1995-09-24 00:00:00", "1996-03-31 00:00:00", "1996-10-27 00:00:00", 
"1997-03-30 00:00:00", "1997-10-26 00:00:00", "1998-03-29 00:00:00", 
"1998-10-25 00:00:00", "1999-03-28 00:00:00", "1999-10-31 00:00:00", 
"2000-03-26 00:00:00", "2000-10-29 00:00:00", "2001-03-25 00:00:00", 
"2001-10-28 00:00:00", "2002-03-31 00:00:00", "2002-10-27 00:00:00", 
"2003-03-30 00:00:00", "2003-10-26 00:00:00", "2004-03-28 00:00:00", 
"2004-10-31 00:00:00", "2005-03-27 00:00:00", "2005-10-30 00:00:00", 
"2006-03-26 00:00:00", "2006-10-29 00:00:00", "2007-03-25 00:00:00", 
"2007-10-28 00:00:00", "2008-03-30 00:00:00", "2008-10-26 00:00:00", 
"2009-03-29 00:00:00", "2009-10-25 00:00:00", "2010-03-28 00:00:00", 
"2010-10-31 00:00:00", "2011-03-27 00:00:00", "2011-10-30 00:00:00", 
"2012-03-25 00:00:00", "2012-10-28 00:00:00", "2013-03-31 00:00:00", 
"2013-10-27 00:00:00", "2014-03-30 00:00:00", "2014-10-26 00:00:00", 
"2015-03-29 00:00:00", "2015-10-25 00:00:00", "2016-03-27 00:00:00", 
"2016-10-30 00:00:00", "2017-03-26 00:00:00", "2017-10-29 00:00:00", 
"2018-03-25 00:00:00", "2018-10-28 00:00:00", "2019-03-31 00:00:00", 
"2019-10-27 00:00:00", "2020-03-29 00:00:00", "2020-10-25 00:00:00", 
"2021-03-28 00:00:00", "2021-10-31 00:00:00", "2022-03-27 00:00:00", 
"2022-10-30 00:00:00", "2023-03-26 00:00:00", "2023-10-29 00:00:00", 
"2024-03-31 00:00:00", "2024-10-27 00:00:00", "2025-03-30 00:00:00", 
"2025-10-26 00:00:00", "2026-03-29 00:00:00", "2026-10-25 00:00:00", 
"2027-03-28 00:00:00", "2027-10-31 00:00:00", "2028-03-26 00:00:00", 
"2028-10-29 00:00:00", "2029-03-25 00:00:00", "2029-10-28 00:00:00", 
"2030-03-31 00:00:00", "2030-10-27 00:00:00", "2031-03-30 00:00:00", 
"2031-10-26 00:00:00", "2032-03-28 00:00:00", "2032-10-31 00:00:00", 
"2033-03-27 00:00:00", "2033-10-30 00:00:00", "2034-03-26 00:00:00", 
"2034-10-29 00:00:00", "2035-03-25 00:00:00", "2035-10-28 00:00:00", 
"2036-03-30 00:00:00", "2036-10-26 00:00:00", "2037-03-29 00:00:00"
), offSet = c("6600", "7200", "10800", "7200", "3600", "7200", 
"3600", "7200", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800"), isdst = c("0", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST")), .Names = c("Minsk", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -119L), class = "data.frame")
}

"Belize" <- function () {
structure(list(Belize = c("1901-12-14 20:45:52", "1912-04-01 05:52:48", 
"1918-10-06 06:00:00", "1919-02-09 05:30:00", "1919-10-05 06:00:00", 
"1920-02-15 05:30:00", "1920-10-03 06:00:00", "1921-02-13 05:30:00", 
"1921-10-02 06:00:00", "1922-02-12 05:30:00", "1922-10-08 06:00:00", 
"1923-02-11 05:30:00", "1923-10-07 06:00:00", "1924-02-10 05:30:00", 
"1924-10-05 06:00:00", "1925-02-15 05:30:00", "1925-10-04 06:00:00", 
"1926-02-14 05:30:00", "1926-10-03 06:00:00", "1927-02-13 05:30:00", 
"1927-10-02 06:00:00", "1928-02-12 05:30:00", "1928-10-07 06:00:00", 
"1929-02-10 05:30:00", "1929-10-06 06:00:00", "1930-02-09 05:30:00", 
"1930-10-05 06:00:00", "1931-02-15 05:30:00", "1931-10-04 06:00:00", 
"1932-02-14 05:30:00", "1932-10-02 06:00:00", "1933-02-12 05:30:00", 
"1933-10-08 06:00:00", "1934-02-11 05:30:00", "1934-10-07 06:00:00", 
"1935-02-10 05:30:00", "1935-10-06 06:00:00", "1936-02-09 05:30:00", 
"1936-10-04 06:00:00", "1937-02-14 05:30:00", "1937-10-03 06:00:00", 
"1938-02-13 05:30:00", "1938-10-02 06:00:00", "1939-02-12 05:30:00", 
"1939-10-08 06:00:00", "1940-02-11 05:30:00", "1940-10-06 06:00:00", 
"1941-02-09 05:30:00", "1941-10-05 06:00:00", "1942-02-15 05:30:00", 
"1942-10-04 06:00:00", "1943-02-14 05:30:00", "1973-12-05 06:00:00", 
"1974-02-09 05:00:00", "1982-12-18 06:00:00"), offSet = c("-21168", 
"-21600", "-19800", "-21600", "-19800", "-21600", "-19800", "-21600", 
"-19800", "-21600", "-19800", "-21600", "-19800", "-21600", "-19800", 
"-21600", "-19800", "-21600", "-19800", "-21600", "-19800", "-21600", 
"-19800", "-21600", "-19800", "-21600", "-19800", "-21600", "-19800", 
"-21600", "-19800", "-21600", "-19800", "-21600", "-19800", "-21600", 
"-19800", "-21600", "-19800", "-21600", "-19800", "-21600", "-19800", 
"-21600", "-19800", "-21600", "-19800", "-21600", "-19800", "-21600", 
"-19800", "-21600", "-18000", "-21600", "-18000"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("CST", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT")), .Names = c("Belize", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -55L), class = "data.frame")
}

"St_Johns" <- function () {
structure(list(St_Johns = c("1901-12-14 20:45:52", "1917-04-08 05:30:52", 
"1917-09-17 04:30:52", "1918-04-14 05:30:52", "1918-10-31 04:30:52", 
"1919-05-06 02:30:52", "1919-08-13 01:30:52", "1920-05-03 02:30:52", 
"1920-11-01 01:30:52", "1921-05-02 02:30:52", "1921-10-31 01:30:52", 
"1922-05-08 02:30:52", "1922-10-30 01:30:52", "1923-05-07 02:30:52", 
"1923-10-29 01:30:52", "1924-05-05 02:30:52", "1924-10-27 01:30:52", 
"1925-05-04 02:30:52", "1925-10-26 01:30:52", "1926-05-03 02:30:52", 
"1926-11-01 01:30:52", "1927-05-02 02:30:52", "1927-10-31 01:30:52", 
"1928-05-07 02:30:52", "1928-10-29 01:30:52", "1929-05-06 02:30:52", 
"1929-10-28 01:30:52", "1930-05-05 02:30:52", "1930-10-27 01:30:52", 
"1931-05-04 02:30:52", "1931-10-26 01:30:52", "1932-05-02 02:30:52", 
"1932-10-31 01:30:52", "1933-05-08 02:30:52", "1933-10-30 01:30:52", 
"1934-05-07 02:30:52", "1934-10-29 01:30:52", "1935-03-30 03:30:52", 
"1935-05-06 02:30:00", "1935-10-28 01:30:00", "1936-05-11 03:30:00", 
"1936-10-05 02:30:00", "1937-05-10 03:30:00", "1937-10-04 02:30:00", 
"1938-05-09 03:30:00", "1938-10-03 02:30:00", "1939-05-15 03:30:00", 
"1939-10-02 02:30:00", "1940-05-13 03:30:00", "1940-10-07 02:30:00", 
"1941-05-12 03:30:00", "1941-10-06 02:30:00", "1942-05-11 03:30:00", 
"1945-09-30 04:30:00", "1946-05-12 05:30:00", "1946-10-06 04:30:00", 
"1947-05-11 05:30:00", "1947-10-05 04:30:00", "1948-05-09 05:30:00", 
"1948-10-03 04:30:00", "1949-05-08 05:30:00", "1949-10-02 04:30:00", 
"1950-05-14 05:30:00", "1950-10-08 04:30:00", "1951-04-29 05:30:00", 
"1951-09-30 04:30:00", "1952-04-27 05:30:00", "1952-09-28 04:30:00", 
"1953-04-26 05:30:00", "1953-09-27 04:30:00", "1954-04-25 05:30:00", 
"1954-09-26 04:30:00", "1955-04-24 05:30:00", "1955-09-25 04:30:00", 
"1956-04-29 05:30:00", "1956-09-30 04:30:00", "1957-04-28 05:30:00", 
"1957-09-29 04:30:00", "1958-04-27 05:30:00", "1958-09-28 04:30:00", 
"1959-04-26 05:30:00", "1959-09-27 04:30:00", "1960-04-24 05:30:00", 
"1960-10-30 04:30:00", "1961-04-30 05:30:00", "1961-10-29 04:30:00", 
"1962-04-29 05:30:00", "1962-10-28 04:30:00", "1963-04-28 05:30:00", 
"1963-10-27 04:30:00", "1964-04-26 05:30:00", "1964-10-25 04:30:00", 
"1965-04-25 05:30:00", "1965-10-31 04:30:00", "1966-04-24 05:30:00", 
"1966-10-30 04:30:00", "1967-04-30 05:30:00", "1967-10-29 04:30:00", 
"1968-04-28 05:30:00", "1968-10-27 04:30:00", "1969-04-27 05:30:00", 
"1969-10-26 04:30:00", "1970-04-26 05:30:00", "1970-10-25 04:30:00", 
"1971-04-25 05:30:00", "1971-10-31 04:30:00", "1972-04-30 05:30:00", 
"1972-10-29 04:30:00", "1973-04-29 05:30:00", "1973-10-28 04:30:00", 
"1974-04-28 05:30:00", "1974-10-27 04:30:00", "1975-04-27 05:30:00", 
"1975-10-26 04:30:00", "1976-04-25 05:30:00", "1976-10-31 04:30:00", 
"1977-04-24 05:30:00", "1977-10-30 04:30:00", "1978-04-30 05:30:00", 
"1978-10-29 04:30:00", "1979-04-29 05:30:00", "1979-10-28 04:30:00", 
"1980-04-27 05:30:00", "1980-10-26 04:30:00", "1981-04-26 05:30:00", 
"1981-10-25 04:30:00", "1982-04-25 05:30:00", "1982-10-31 04:30:00", 
"1983-04-24 05:30:00", "1983-10-30 04:30:00", "1984-04-29 05:30:00", 
"1984-10-28 04:30:00", "1985-04-28 05:30:00", "1985-10-27 04:30:00", 
"1986-04-27 05:30:00", "1986-10-26 04:30:00", "1987-04-05 03:31:00", 
"1987-10-25 02:31:00", "1988-04-03 03:31:00", "1988-10-30 01:31:00", 
"1989-04-02 03:31:00", "1989-10-29 02:31:00", "1990-04-01 03:31:00", 
"1990-10-28 02:31:00", "1991-04-07 03:31:00", "1991-10-27 02:31:00", 
"1992-04-05 03:31:00", "1992-10-25 02:31:00", "1993-04-04 03:31:00", 
"1993-10-31 02:31:00", "1994-04-03 03:31:00", "1994-10-30 02:31:00", 
"1995-04-02 03:31:00", "1995-10-29 02:31:00", "1996-04-07 03:31:00", 
"1996-10-27 02:31:00", "1997-04-06 03:31:00", "1997-10-26 02:31:00", 
"1998-04-05 03:31:00", "1998-10-25 02:31:00", "1999-04-04 03:31:00", 
"1999-10-31 02:31:00", "2000-04-02 03:31:00", "2000-10-29 02:31:00", 
"2001-04-01 03:31:00", "2001-10-28 02:31:00", "2002-04-07 03:31:00", 
"2002-10-27 02:31:00", "2003-04-06 03:31:00", "2003-10-26 02:31:00", 
"2004-04-04 03:31:00", "2004-10-31 02:31:00", "2005-04-03 03:31:00", 
"2005-10-30 02:31:00", "2006-04-02 03:31:00", "2006-10-29 02:31:00", 
"2007-03-11 03:31:00", "2007-11-04 02:31:00", "2008-03-09 03:31:00", 
"2008-11-02 02:31:00", "2009-03-08 03:31:00", "2009-11-01 02:31:00", 
"2010-03-14 03:31:00", "2010-11-07 02:31:00", "2011-03-13 03:31:00", 
"2011-11-06 02:31:00", "2012-03-11 03:31:00", "2012-11-04 02:31:00", 
"2013-03-10 03:31:00", "2013-11-03 02:31:00", "2014-03-09 03:31:00", 
"2014-11-02 02:31:00", "2015-03-08 03:31:00", "2015-11-01 02:31:00", 
"2016-03-13 03:31:00", "2016-11-06 02:31:00", "2017-03-12 03:31:00", 
"2017-11-05 02:31:00", "2018-03-11 03:31:00", "2018-11-04 02:31:00", 
"2019-03-10 03:31:00", "2019-11-03 02:31:00", "2020-03-08 03:31:00", 
"2020-11-01 02:31:00", "2021-03-14 03:31:00", "2021-11-07 02:31:00", 
"2022-03-13 03:31:00", "2022-11-06 02:31:00", "2023-03-12 03:31:00", 
"2023-11-05 02:31:00", "2024-03-10 03:31:00", "2024-11-03 02:31:00", 
"2025-03-09 03:31:00", "2025-11-02 02:31:00", "2026-03-08 03:31:00", 
"2026-11-01 02:31:00", "2027-03-14 03:31:00", "2027-11-07 02:31:00", 
"2028-03-12 03:31:00", "2028-11-05 02:31:00", "2029-03-11 03:31:00", 
"2029-11-04 02:31:00", "2030-03-10 03:31:00", "2030-11-03 02:31:00", 
"2031-03-09 03:31:00", "2031-11-02 02:31:00", "2032-03-14 03:31:00", 
"2032-11-07 02:31:00", "2033-03-13 03:31:00", "2033-11-06 02:31:00", 
"2034-03-12 03:31:00", "2034-11-05 02:31:00", "2035-03-11 03:31:00", 
"2035-11-04 02:31:00", "2036-03-09 03:31:00", "2036-11-02 02:31:00", 
"2037-03-08 03:31:00"), offSet = c("-12652", "-9052", "-12652", 
"-9052", "-12652", "-9052", "-12652", "-9052", "-12652", "-9052", 
"-12652", "-9052", "-12652", "-9052", "-12652", "-9052", "-12652", 
"-9052", "-12652", "-9052", "-12652", "-9052", "-12652", "-9052", 
"-12652", "-9052", "-12652", "-9052", "-12652", "-9052", "-12652", 
"-9052", "-12652", "-9052", "-12652", "-9052", "-12652", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-5400", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000"), isdst = c("0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT")), .Names = c("St_Johns", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -237L), class = "data.frame")
}

"Halifax" <- function () {
structure(list(Halifax = c("1901-12-14 20:45:52", "1902-06-15 04:14:24", 
"1916-04-01 04:00:00", "1916-10-01 03:00:00", "1918-04-14 06:00:00", 
"1918-10-31 05:00:00", "1920-05-09 04:00:00", "1920-08-29 03:00:00", 
"1921-05-06 04:00:00", "1921-09-05 03:00:00", "1922-04-30 04:00:00", 
"1922-09-05 03:00:00", "1923-05-06 04:00:00", "1923-09-04 03:00:00", 
"1924-05-04 04:00:00", "1924-09-15 03:00:00", "1925-05-03 04:00:00", 
"1925-09-28 03:00:00", "1926-05-16 04:00:00", "1926-09-13 03:00:00", 
"1927-05-01 04:00:00", "1927-09-26 03:00:00", "1928-05-13 04:00:00", 
"1928-09-09 03:00:00", "1929-05-12 04:00:00", "1929-09-03 03:00:00", 
"1930-05-11 04:00:00", "1930-09-15 03:00:00", "1931-05-10 04:00:00", 
"1931-09-28 03:00:00", "1932-05-01 04:00:00", "1932-09-26 03:00:00", 
"1933-04-30 04:00:00", "1933-10-02 03:00:00", "1934-05-20 04:00:00", 
"1934-09-16 03:00:00", "1935-06-02 04:00:00", "1935-09-30 03:00:00", 
"1936-06-01 04:00:00", "1936-09-14 03:00:00", "1937-05-02 04:00:00", 
"1937-09-27 03:00:00", "1938-05-01 04:00:00", "1938-09-26 03:00:00", 
"1939-05-28 04:00:00", "1939-09-25 03:00:00", "1940-05-05 04:00:00", 
"1940-09-30 03:00:00", "1941-05-04 04:00:00", "1941-09-29 03:00:00", 
"1942-02-09 06:00:00", "1945-09-30 05:00:00", "1946-04-28 06:00:00", 
"1946-09-29 05:00:00", "1947-04-27 06:00:00", "1947-09-28 05:00:00", 
"1948-04-25 06:00:00", "1948-09-26 05:00:00", "1949-04-24 06:00:00", 
"1949-09-25 05:00:00", "1951-04-29 06:00:00", "1951-09-30 05:00:00", 
"1952-04-27 06:00:00", "1952-09-28 05:00:00", "1953-04-26 06:00:00", 
"1953-09-27 05:00:00", "1954-04-25 06:00:00", "1954-09-26 05:00:00", 
"1956-04-29 06:00:00", "1956-09-30 05:00:00", "1957-04-28 06:00:00", 
"1957-09-29 05:00:00", "1958-04-27 06:00:00", "1958-09-28 05:00:00", 
"1959-04-26 06:00:00", "1959-09-27 05:00:00", "1962-04-29 06:00:00", 
"1962-10-28 05:00:00", "1963-04-28 06:00:00", "1963-10-27 05:00:00", 
"1964-04-26 06:00:00", "1964-10-25 05:00:00", "1965-04-25 06:00:00", 
"1965-10-31 05:00:00", "1966-04-24 06:00:00", "1966-10-30 05:00:00", 
"1967-04-30 06:00:00", "1967-10-29 05:00:00", "1968-04-28 06:00:00", 
"1968-10-27 05:00:00", "1969-04-27 06:00:00", "1969-10-26 05:00:00", 
"1970-04-26 06:00:00", "1970-10-25 05:00:00", "1971-04-25 06:00:00", 
"1971-10-31 05:00:00", "1972-04-30 06:00:00", "1972-10-29 05:00:00", 
"1973-04-29 06:00:00", "1973-10-28 05:00:00", "1974-04-28 06:00:00", 
"1974-10-27 05:00:00", "1975-04-27 06:00:00", "1975-10-26 05:00:00", 
"1976-04-25 06:00:00", "1976-10-31 05:00:00", "1977-04-24 06:00:00", 
"1977-10-30 05:00:00", "1978-04-30 06:00:00", "1978-10-29 05:00:00", 
"1979-04-29 06:00:00", "1979-10-28 05:00:00", "1980-04-27 06:00:00", 
"1980-10-26 05:00:00", "1981-04-26 06:00:00", "1981-10-25 05:00:00", 
"1982-04-25 06:00:00", "1982-10-31 05:00:00", "1983-04-24 06:00:00", 
"1983-10-30 05:00:00", "1984-04-29 06:00:00", "1984-10-28 05:00:00", 
"1985-04-28 06:00:00", "1985-10-27 05:00:00", "1986-04-27 06:00:00", 
"1986-10-26 05:00:00", "1987-04-05 06:00:00", "1987-10-25 05:00:00", 
"1988-04-03 06:00:00", "1988-10-30 05:00:00", "1989-04-02 06:00:00", 
"1989-10-29 05:00:00", "1990-04-01 06:00:00", "1990-10-28 05:00:00", 
"1991-04-07 06:00:00", "1991-10-27 05:00:00", "1992-04-05 06:00:00", 
"1992-10-25 05:00:00", "1993-04-04 06:00:00", "1993-10-31 05:00:00", 
"1994-04-03 06:00:00", "1994-10-30 05:00:00", "1995-04-02 06:00:00", 
"1995-10-29 05:00:00", "1996-04-07 06:00:00", "1996-10-27 05:00:00", 
"1997-04-06 06:00:00", "1997-10-26 05:00:00", "1998-04-05 06:00:00", 
"1998-10-25 05:00:00", "1999-04-04 06:00:00", "1999-10-31 05:00:00", 
"2000-04-02 06:00:00", "2000-10-29 05:00:00", "2001-04-01 06:00:00", 
"2001-10-28 05:00:00", "2002-04-07 06:00:00", "2002-10-27 05:00:00", 
"2003-04-06 06:00:00", "2003-10-26 05:00:00", "2004-04-04 06:00:00", 
"2004-10-31 05:00:00", "2005-04-03 06:00:00", "2005-10-30 05:00:00", 
"2006-04-02 06:00:00", "2006-10-29 05:00:00", "2007-03-11 06:00:00", 
"2007-11-04 05:00:00", "2008-03-09 06:00:00", "2008-11-02 05:00:00", 
"2009-03-08 06:00:00", "2009-11-01 05:00:00", "2010-03-14 06:00:00", 
"2010-11-07 05:00:00", "2011-03-13 06:00:00", "2011-11-06 05:00:00", 
"2012-03-11 06:00:00", "2012-11-04 05:00:00", "2013-03-10 06:00:00", 
"2013-11-03 05:00:00", "2014-03-09 06:00:00", "2014-11-02 05:00:00", 
"2015-03-08 06:00:00", "2015-11-01 05:00:00", "2016-03-13 06:00:00", 
"2016-11-06 05:00:00", "2017-03-12 06:00:00", "2017-11-05 05:00:00", 
"2018-03-11 06:00:00", "2018-11-04 05:00:00", "2019-03-10 06:00:00", 
"2019-11-03 05:00:00", "2020-03-08 06:00:00", "2020-11-01 05:00:00", 
"2021-03-14 06:00:00", "2021-11-07 05:00:00", "2022-03-13 06:00:00", 
"2022-11-06 05:00:00", "2023-03-12 06:00:00", "2023-11-05 05:00:00", 
"2024-03-10 06:00:00", "2024-11-03 05:00:00", "2025-03-09 06:00:00", 
"2025-11-02 05:00:00", "2026-03-08 06:00:00", "2026-11-01 05:00:00", 
"2027-03-14 06:00:00", "2027-11-07 05:00:00", "2028-03-12 06:00:00", 
"2028-11-05 05:00:00", "2029-03-11 06:00:00", "2029-11-04 05:00:00", 
"2030-03-10 06:00:00", "2030-11-03 05:00:00", "2031-03-09 06:00:00", 
"2031-11-02 05:00:00", "2032-03-14 06:00:00", "2032-11-07 05:00:00", 
"2033-03-13 06:00:00", "2033-11-06 05:00:00", "2034-03-12 06:00:00", 
"2034-11-05 05:00:00", "2035-03-11 06:00:00", "2035-11-04 05:00:00", 
"2036-03-09 06:00:00", "2036-11-02 05:00:00", "2037-03-08 06:00:00"
), offSet = c("-15264", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("AST", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT")), .Names = c("Halifax", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -227L), class = "data.frame")
}

"Glace_Bay" <- function () {
structure(list(Glace_Bay = c("1901-12-14 20:45:52", "1902-06-15 03:59:48", 
"1918-04-14 06:00:00", "1918-10-31 05:00:00", "1942-02-09 06:00:00", 
"1945-09-30 05:00:00", "1953-04-26 06:00:00", "1953-09-27 05:00:00", 
"1972-04-30 06:00:00", "1972-10-29 05:00:00", "1973-04-29 06:00:00", 
"1973-10-28 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 06:00:00", "1993-10-31 05:00:00", "1994-04-03 06:00:00", 
"1994-10-30 05:00:00", "1995-04-02 06:00:00", "1995-10-29 05:00:00", 
"1996-04-07 06:00:00", "1996-10-27 05:00:00", "1997-04-06 06:00:00", 
"1997-10-26 05:00:00", "1998-04-05 06:00:00", "1998-10-25 05:00:00", 
"1999-04-04 06:00:00", "1999-10-31 05:00:00", "2000-04-02 06:00:00", 
"2000-10-29 05:00:00", "2001-04-01 06:00:00", "2001-10-28 05:00:00", 
"2002-04-07 06:00:00", "2002-10-27 05:00:00", "2003-04-06 06:00:00", 
"2003-10-26 05:00:00", "2004-04-04 06:00:00", "2004-10-31 05:00:00", 
"2005-04-03 06:00:00", "2005-10-30 05:00:00", "2006-04-02 06:00:00", 
"2006-10-29 05:00:00", "2007-03-11 06:00:00", "2007-11-04 05:00:00", 
"2008-03-09 06:00:00", "2008-11-02 05:00:00", "2009-03-08 06:00:00", 
"2009-11-01 05:00:00", "2010-03-14 06:00:00", "2010-11-07 05:00:00", 
"2011-03-13 06:00:00", "2011-11-06 05:00:00", "2012-03-11 06:00:00", 
"2012-11-04 05:00:00", "2013-03-10 06:00:00", "2013-11-03 05:00:00", 
"2014-03-09 06:00:00", "2014-11-02 05:00:00", "2015-03-08 06:00:00", 
"2015-11-01 05:00:00", "2016-03-13 06:00:00", "2016-11-06 05:00:00", 
"2017-03-12 06:00:00", "2017-11-05 05:00:00", "2018-03-11 06:00:00", 
"2018-11-04 05:00:00", "2019-03-10 06:00:00", "2019-11-03 05:00:00", 
"2020-03-08 06:00:00", "2020-11-01 05:00:00", "2021-03-14 06:00:00", 
"2021-11-07 05:00:00", "2022-03-13 06:00:00", "2022-11-06 05:00:00", 
"2023-03-12 06:00:00", "2023-11-05 05:00:00", "2024-03-10 06:00:00", 
"2024-11-03 05:00:00", "2025-03-09 06:00:00", "2025-11-02 05:00:00", 
"2026-03-08 06:00:00", "2026-11-01 05:00:00", "2027-03-14 06:00:00", 
"2027-11-07 05:00:00", "2028-03-12 06:00:00", "2028-11-05 05:00:00", 
"2029-03-11 06:00:00", "2029-11-04 05:00:00", "2030-03-10 06:00:00", 
"2030-11-03 05:00:00", "2031-03-09 06:00:00", "2031-11-02 05:00:00", 
"2032-03-14 06:00:00", "2032-11-07 05:00:00", "2033-03-13 06:00:00", 
"2033-11-06 05:00:00", "2034-03-12 06:00:00", "2034-11-05 05:00:00", 
"2035-03-11 06:00:00", "2035-11-04 05:00:00", "2036-03-09 06:00:00", 
"2036-11-02 05:00:00", "2037-03-08 06:00:00"), offSet = c("-14388", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("AST", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT")), .Names = c("Glace_Bay", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -139L), class = "data.frame")
}

"Moncton" <- function () {
structure(list(Moncton = c("1901-12-14 20:45:52", "1902-06-15 05:00:00", 
"1918-04-14 06:00:00", "1918-10-31 05:00:00", "1933-06-11 05:00:00", 
"1933-09-10 04:00:00", "1934-06-10 05:00:00", "1934-09-09 04:00:00", 
"1935-06-09 05:00:00", "1935-09-08 04:00:00", "1936-06-07 05:00:00", 
"1936-09-06 04:00:00", "1937-06-06 05:00:00", "1937-09-05 04:00:00", 
"1938-06-05 05:00:00", "1938-09-04 04:00:00", "1939-05-27 05:00:00", 
"1939-09-23 04:00:00", "1940-05-19 05:00:00", "1940-09-21 04:00:00", 
"1941-05-04 05:00:00", "1941-09-27 04:00:00", "1942-02-09 06:00:00", 
"1945-09-30 05:00:00", "1946-04-28 06:00:00", "1946-09-29 05:00:00", 
"1947-04-27 06:00:00", "1947-09-28 05:00:00", "1948-04-25 06:00:00", 
"1948-09-26 05:00:00", "1949-04-24 06:00:00", "1949-09-25 05:00:00", 
"1950-04-30 06:00:00", "1950-09-24 05:00:00", "1951-04-29 06:00:00", 
"1951-09-30 05:00:00", "1952-04-27 06:00:00", "1952-09-28 05:00:00", 
"1953-04-26 06:00:00", "1953-09-27 05:00:00", "1954-04-25 06:00:00", 
"1954-09-26 05:00:00", "1955-04-24 06:00:00", "1955-09-25 05:00:00", 
"1956-04-29 06:00:00", "1956-09-30 05:00:00", "1957-04-28 06:00:00", 
"1957-10-27 05:00:00", "1958-04-27 06:00:00", "1958-10-26 05:00:00", 
"1959-04-26 06:00:00", "1959-10-25 05:00:00", "1960-04-24 06:00:00", 
"1960-10-30 05:00:00", "1961-04-30 06:00:00", "1961-10-29 05:00:00", 
"1962-04-29 06:00:00", "1962-10-28 05:00:00", "1963-04-28 06:00:00", 
"1963-10-27 05:00:00", "1964-04-26 06:00:00", "1964-10-25 05:00:00", 
"1965-04-25 06:00:00", "1965-10-31 05:00:00", "1966-04-24 06:00:00", 
"1966-10-30 05:00:00", "1967-04-30 06:00:00", "1967-10-29 05:00:00", 
"1968-04-28 06:00:00", "1968-10-27 05:00:00", "1969-04-27 06:00:00", 
"1969-10-26 05:00:00", "1970-04-26 06:00:00", "1970-10-25 05:00:00", 
"1971-04-25 06:00:00", "1971-10-31 05:00:00", "1972-04-30 06:00:00", 
"1972-10-29 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 04:01:00", "1993-10-31 03:01:00", "1994-04-03 04:01:00", 
"1994-10-30 03:01:00", "1995-04-02 04:01:00", "1995-10-29 03:01:00", 
"1996-04-07 04:01:00", "1996-10-27 03:01:00", "1997-04-06 04:01:00", 
"1997-10-26 03:01:00", "1998-04-05 04:01:00", "1998-10-25 03:01:00", 
"1999-04-04 04:01:00", "1999-10-31 03:01:00", "2000-04-02 04:01:00", 
"2000-10-29 03:01:00", "2001-04-01 04:01:00", "2001-10-28 03:01:00", 
"2002-04-07 04:01:00", "2002-10-27 03:01:00", "2003-04-06 04:01:00", 
"2003-10-26 03:01:00", "2004-04-04 04:01:00", "2004-10-31 03:01:00", 
"2005-04-03 04:01:00", "2005-10-30 03:01:00", "2006-04-02 04:01:00", 
"2006-10-29 03:01:00", "2007-03-11 06:00:00", "2007-11-04 05:00:00", 
"2008-03-09 06:00:00", "2008-11-02 05:00:00", "2009-03-08 06:00:00", 
"2009-11-01 05:00:00", "2010-03-14 06:00:00", "2010-11-07 05:00:00", 
"2011-03-13 06:00:00", "2011-11-06 05:00:00", "2012-03-11 06:00:00", 
"2012-11-04 05:00:00", "2013-03-10 06:00:00", "2013-11-03 05:00:00", 
"2014-03-09 06:00:00", "2014-11-02 05:00:00", "2015-03-08 06:00:00", 
"2015-11-01 05:00:00", "2016-03-13 06:00:00", "2016-11-06 05:00:00", 
"2017-03-12 06:00:00", "2017-11-05 05:00:00", "2018-03-11 06:00:00", 
"2018-11-04 05:00:00", "2019-03-10 06:00:00", "2019-11-03 05:00:00", 
"2020-03-08 06:00:00", "2020-11-01 05:00:00", "2021-03-14 06:00:00", 
"2021-11-07 05:00:00", "2022-03-13 06:00:00", "2022-11-06 05:00:00", 
"2023-03-12 06:00:00", "2023-11-05 05:00:00", "2024-03-10 06:00:00", 
"2024-11-03 05:00:00", "2025-03-09 06:00:00", "2025-11-02 05:00:00", 
"2026-03-08 06:00:00", "2026-11-01 05:00:00", "2027-03-14 06:00:00", 
"2027-11-07 05:00:00", "2028-03-12 06:00:00", "2028-11-05 05:00:00", 
"2029-03-11 06:00:00", "2029-11-04 05:00:00", "2030-03-10 06:00:00", 
"2030-11-03 05:00:00", "2031-03-09 06:00:00", "2031-11-02 05:00:00", 
"2032-03-14 06:00:00", "2032-11-07 05:00:00", "2033-03-13 06:00:00", 
"2033-11-06 05:00:00", "2034-03-12 06:00:00", "2034-11-05 05:00:00", 
"2035-03-11 06:00:00", "2035-11-04 05:00:00", "2036-03-09 06:00:00", 
"2036-11-02 05:00:00", "2037-03-08 06:00:00"), offSet = c("-18000", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("AST", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT")), .Names = c("Moncton", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-205L), class = "data.frame")
}

"Goose_Bay" <- function () {
structure(list(Goose_Bay = c("1901-12-14 20:45:52", "1918-04-14 05:30:52", 
"1918-10-31 04:30:52", "1935-03-30 03:30:52", "1936-05-11 03:30:00", 
"1936-10-05 02:30:00", "1937-05-10 03:30:00", "1937-10-04 02:30:00", 
"1938-05-09 03:30:00", "1938-10-03 02:30:00", "1939-05-15 03:30:00", 
"1939-10-02 02:30:00", "1940-05-13 03:30:00", "1940-10-07 02:30:00", 
"1941-05-12 03:30:00", "1941-10-06 02:30:00", "1942-05-11 03:30:00", 
"1945-09-30 04:30:00", "1946-05-12 05:30:00", "1946-10-06 04:30:00", 
"1947-05-11 05:30:00", "1947-10-05 04:30:00", "1948-05-09 05:30:00", 
"1948-10-03 04:30:00", "1949-05-08 05:30:00", "1949-10-02 04:30:00", 
"1950-05-14 05:30:00", "1950-10-08 04:30:00", "1951-04-29 05:30:00", 
"1951-09-30 04:30:00", "1952-04-27 05:30:00", "1952-09-28 04:30:00", 
"1953-04-26 05:30:00", "1953-09-27 04:30:00", "1954-04-25 05:30:00", 
"1954-09-26 04:30:00", "1955-04-24 05:30:00", "1955-09-25 04:30:00", 
"1956-04-29 05:30:00", "1956-09-30 04:30:00", "1957-04-28 05:30:00", 
"1957-09-29 04:30:00", "1958-04-27 05:30:00", "1958-09-28 04:30:00", 
"1959-04-26 05:30:00", "1959-09-27 04:30:00", "1960-04-24 05:30:00", 
"1960-10-30 04:30:00", "1961-04-30 05:30:00", "1961-10-29 04:30:00", 
"1962-04-29 05:30:00", "1962-10-28 04:30:00", "1963-04-28 05:30:00", 
"1963-10-27 04:30:00", "1964-04-26 05:30:00", "1964-10-25 04:30:00", 
"1965-04-25 05:30:00", "1965-10-31 04:30:00", "1966-03-15 05:30:00", 
"1966-04-24 06:00:00", "1966-10-30 05:00:00", "1967-04-30 06:00:00", 
"1967-10-29 05:00:00", "1968-04-28 06:00:00", "1968-10-27 05:00:00", 
"1969-04-27 06:00:00", "1969-10-26 05:00:00", "1970-04-26 06:00:00", 
"1970-10-25 05:00:00", "1971-04-25 06:00:00", "1971-10-31 05:00:00", 
"1972-04-30 06:00:00", "1972-10-29 05:00:00", "1973-04-29 06:00:00", 
"1973-10-28 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 04:01:00", "1987-10-25 03:01:00", "1988-04-03 04:01:00", 
"1988-10-30 02:01:00", "1989-04-02 04:01:00", "1989-10-29 03:01:00", 
"1990-04-01 04:01:00", "1990-10-28 03:01:00", "1991-04-07 04:01:00", 
"1991-10-27 03:01:00", "1992-04-05 04:01:00", "1992-10-25 03:01:00", 
"1993-04-04 04:01:00", "1993-10-31 03:01:00", "1994-04-03 04:01:00", 
"1994-10-30 03:01:00", "1995-04-02 04:01:00", "1995-10-29 03:01:00", 
"1996-04-07 04:01:00", "1996-10-27 03:01:00", "1997-04-06 04:01:00", 
"1997-10-26 03:01:00", "1998-04-05 04:01:00", "1998-10-25 03:01:00", 
"1999-04-04 04:01:00", "1999-10-31 03:01:00", "2000-04-02 04:01:00", 
"2000-10-29 03:01:00", "2001-04-01 04:01:00", "2001-10-28 03:01:00", 
"2002-04-07 04:01:00", "2002-10-27 03:01:00", "2003-04-06 04:01:00", 
"2003-10-26 03:01:00", "2004-04-04 04:01:00", "2004-10-31 03:01:00", 
"2005-04-03 04:01:00", "2005-10-30 03:01:00", "2006-04-02 04:01:00", 
"2006-10-29 03:01:00", "2007-03-11 04:01:00", "2007-11-04 03:01:00", 
"2008-03-09 04:01:00", "2008-11-02 03:01:00", "2009-03-08 04:01:00", 
"2009-11-01 03:01:00", "2010-03-14 04:01:00", "2010-11-07 03:01:00", 
"2011-03-13 04:01:00", "2011-11-06 03:01:00", "2012-03-11 04:01:00", 
"2012-11-04 03:01:00", "2013-03-10 04:01:00", "2013-11-03 03:01:00", 
"2014-03-09 04:01:00", "2014-11-02 03:01:00", "2015-03-08 04:01:00", 
"2015-11-01 03:01:00", "2016-03-13 04:01:00", "2016-11-06 03:01:00", 
"2017-03-12 04:01:00", "2017-11-05 03:01:00", "2018-03-11 04:01:00", 
"2018-11-04 03:01:00", "2019-03-10 04:01:00", "2019-11-03 03:01:00", 
"2020-03-08 04:01:00", "2020-11-01 03:01:00", "2021-03-14 04:01:00", 
"2021-11-07 03:01:00", "2022-03-13 04:01:00", "2022-11-06 03:01:00", 
"2023-03-12 04:01:00", "2023-11-05 03:01:00", "2024-03-10 04:01:00", 
"2024-11-03 03:01:00", "2025-03-09 04:01:00", "2025-11-02 03:01:00", 
"2026-03-08 04:01:00", "2026-11-01 03:01:00", "2027-03-14 04:01:00", 
"2027-11-07 03:01:00", "2028-03-12 04:01:00", "2028-11-05 03:01:00", 
"2029-03-11 04:01:00", "2029-11-04 03:01:00", "2030-03-10 04:01:00", 
"2030-11-03 03:01:00", "2031-03-09 04:01:00", "2031-11-02 03:01:00", 
"2032-03-14 04:01:00", "2032-11-07 03:01:00", "2033-03-13 04:01:00", 
"2033-11-06 03:01:00", "2034-03-12 04:01:00", "2034-11-05 03:01:00", 
"2035-03-11 04:01:00", "2035-11-04 03:01:00", "2036-03-09 04:01:00", 
"2036-11-02 03:01:00", "2037-03-08 04:01:00"), offSet = c("-12652", 
"-9052", "-12652", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-9000", "-12600", "-9000", "-12600", "-9000", "-12600", 
"-9000", "-12600", "-9000", "-12600", "-9000", "-12600", "-9000", 
"-12600", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-7200", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800"), isdst = c("0", 
"1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("AST", "ADT", "AST", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT")), .Names = c("Goose_Bay", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -202L), class = "data.frame")
}

"Blanc-Sablon" <- function () {
structure(list("Blanc-Sablon" = c("1901-12-14 20:45:52", "1918-04-14 06:00:00", 
"1918-10-31 05:00:00", "1942-02-09 06:00:00"), offSet = c("-14400", 
"-10800", "-14400", "-10800"), isdst = c("0", "1", "0", "1"), 
    TimeZone = c("AST", "APT", "AST", "APT")), .Names = c("Blanc-Sablon", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Montreal" <- function () {
structure(list(Montreal = c("1901-12-14 20:45:52", "1917-03-25 07:00:00", 
"1917-04-24 04:00:00", "1918-04-14 07:00:00", "1918-10-31 06:00:00", 
"1919-03-31 07:30:00", "1919-10-25 06:30:00", "1920-05-02 07:30:00", 
"1920-10-03 06:30:00", "1921-05-01 07:00:00", "1921-10-02 06:30:00", 
"1922-04-30 07:00:00", "1922-10-01 06:30:00", "1924-05-17 07:00:00", 
"1924-09-28 06:30:00", "1925-05-03 07:00:00", "1925-09-27 06:30:00", 
"1926-05-02 07:00:00", "1926-09-26 06:30:00", "1927-05-01 05:00:00", 
"1927-09-25 04:00:00", "1928-04-29 05:00:00", "1928-09-30 04:00:00", 
"1929-04-28 05:00:00", "1929-09-29 04:00:00", "1930-04-27 05:00:00", 
"1930-09-28 04:00:00", "1931-04-26 05:00:00", "1931-09-27 04:00:00", 
"1932-05-01 05:00:00", "1932-09-25 04:00:00", "1933-04-30 05:00:00", 
"1933-10-01 04:00:00", "1934-04-29 05:00:00", "1934-09-30 04:00:00", 
"1935-04-28 05:00:00", "1935-09-29 04:00:00", "1936-04-26 05:00:00", 
"1936-09-27 04:00:00", "1937-04-25 05:00:00", "1937-09-26 04:00:00", 
"1938-04-24 05:00:00", "1938-09-25 04:00:00", "1939-04-30 05:00:00", 
"1939-09-24 04:00:00", "1940-04-28 05:00:00", "1945-09-30 06:00:00", 
"1946-04-28 07:00:00", "1946-09-29 06:00:00", "1947-04-27 07:00:00", 
"1947-09-28 06:00:00", "1948-04-25 07:00:00", "1948-09-26 06:00:00", 
"1949-04-24 07:00:00", "1949-10-30 06:00:00", "1950-04-30 07:00:00", 
"1950-10-29 06:00:00", "1951-04-29 07:00:00", "1951-09-30 06:00:00", 
"1952-04-27 07:00:00", "1952-09-28 06:00:00", "1953-04-26 07:00:00", 
"1953-09-27 06:00:00", "1954-04-25 07:00:00", "1954-09-26 06:00:00", 
"1955-04-24 07:00:00", "1955-09-25 06:00:00", "1956-04-29 07:00:00", 
"1956-09-30 06:00:00", "1957-04-28 07:00:00", "1957-10-27 06:00:00", 
"1958-04-27 07:00:00", "1958-10-26 06:00:00", "1959-04-26 07:00:00", 
"1959-10-25 06:00:00", "1960-04-24 07:00:00", "1960-10-30 06:00:00", 
"1961-04-30 07:00:00", "1961-10-29 06:00:00", "1962-04-29 07:00:00", 
"1962-10-28 06:00:00", "1963-04-28 07:00:00", "1963-10-27 06:00:00", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT")), .Names = c("Montreal", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -230L), class = "data.frame")
}

"Toronto" <- function () {
structure(list(Toronto = c("1901-12-14 20:45:52", "1918-04-14 07:00:00", 
"1918-10-31 06:00:00", "1919-03-31 04:30:00", "1919-10-26 04:00:00", 
"1920-05-02 07:00:00", "1920-09-26 04:00:00", "1921-05-15 07:00:00", 
"1921-09-15 06:00:00", "1922-05-14 07:00:00", "1922-09-17 06:00:00", 
"1923-05-13 07:00:00", "1923-09-16 06:00:00", "1924-05-04 07:00:00", 
"1924-09-21 06:00:00", "1925-05-03 07:00:00", "1925-09-20 06:00:00", 
"1926-05-02 07:00:00", "1926-09-19 06:00:00", "1927-05-01 07:00:00", 
"1927-09-25 06:00:00", "1928-04-29 07:00:00", "1928-09-30 06:00:00", 
"1929-04-28 07:00:00", "1929-09-29 06:00:00", "1930-04-27 07:00:00", 
"1930-09-28 06:00:00", "1931-04-26 07:00:00", "1931-09-27 06:00:00", 
"1932-05-01 07:00:00", "1932-09-25 06:00:00", "1933-04-30 07:00:00", 
"1933-10-01 06:00:00", "1934-04-29 07:00:00", "1934-09-30 06:00:00", 
"1935-04-28 07:00:00", "1935-09-29 06:00:00", "1936-04-26 07:00:00", 
"1936-09-27 06:00:00", "1937-04-25 07:00:00", "1937-09-26 06:00:00", 
"1938-04-24 07:00:00", "1938-09-25 06:00:00", "1939-04-30 07:00:00", 
"1939-09-24 06:00:00", "1940-04-28 07:00:00", "1945-09-30 06:00:00", 
"1946-04-28 07:00:00", "1946-09-29 06:00:00", "1947-04-27 05:00:00", 
"1947-09-28 04:00:00", "1948-04-25 05:00:00", "1948-09-26 04:00:00", 
"1949-04-24 05:00:00", "1949-11-27 04:00:00", "1950-04-30 07:00:00", 
"1950-11-26 06:00:00", "1951-04-29 07:00:00", "1951-09-30 06:00:00", 
"1952-04-27 07:00:00", "1952-09-28 06:00:00", "1953-04-26 07:00:00", 
"1953-09-27 06:00:00", "1954-04-25 07:00:00", "1954-09-26 06:00:00", 
"1955-04-24 07:00:00", "1955-09-25 06:00:00", "1956-04-29 07:00:00", 
"1956-09-30 06:00:00", "1957-04-28 07:00:00", "1957-10-27 06:00:00", 
"1958-04-27 07:00:00", "1958-10-26 06:00:00", "1959-04-26 07:00:00", 
"1959-10-25 06:00:00", "1960-04-24 07:00:00", "1960-10-30 06:00:00", 
"1961-04-30 07:00:00", "1961-10-29 06:00:00", "1962-04-29 07:00:00", 
"1962-10-28 06:00:00", "1963-04-28 07:00:00", "1963-10-27 06:00:00", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT")), .Names = c("Toronto", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -230L), class = "data.frame")
}

"Nipigon" <- function () {
structure(list(Nipigon = c("1901-12-14 20:45:52", "1918-04-14 07:00:00", 
"1918-10-31 06:00:00", "1940-09-29 05:00:00", "1945-09-30 06:00:00", 
"1974-04-28 07:00:00", "1974-10-27 06:00:00", "1975-04-27 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-04-02 07:00:00", "2000-10-29 06:00:00", 
"2001-04-01 07:00:00", "2001-10-28 06:00:00", "2002-04-07 07:00:00", 
"2002-10-27 06:00:00", "2003-04-06 07:00:00", "2003-10-26 06:00:00", 
"2004-04-04 07:00:00", "2004-10-31 06:00:00", "2005-04-03 07:00:00", 
"2005-10-30 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-03-11 07:00:00", "2007-11-04 06:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00"), offSet = c("-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT")), .Names = c("Nipigon", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -132L), class = "data.frame")
}

"Thunder_Bay" <- function () {
structure(list(Thunder_Bay = c("1901-12-14 20:45:52", "1910-01-01 06:00:00", 
"1942-02-09 07:00:00", "1945-09-30 06:00:00", "1970-04-26 07:00:00", 
"1970-10-25 06:00:00", "1971-04-25 07:00:00", "1971-10-31 06:00:00", 
"1972-04-30 07:00:00", "1972-10-29 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("-21600", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT"
    )), .Names = c("Thunder_Bay", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -137L), class = "data.frame")
}

"Iqaluit" <- function () {
structure(list(Iqaluit = c("1901-12-14 20:45:52", "1942-08-01 00:00:00", 
"1945-09-30 06:00:00", "1965-04-25 05:00:00", "1965-10-31 05:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-10-29 07:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("0", "-14400", "-18000", "-10800", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-21600", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT"
)), .Names = c("Iqaluit", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-119L), class = "data.frame")
}

"Pangnirtung" <- function () {
structure(list(Pangnirtung = c("1901-12-14 20:45:52", "1921-01-01 00:00:00", 
"1942-02-09 06:00:00", "1945-09-30 05:00:00", "1965-04-25 04:00:00", 
"1965-10-31 04:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 06:00:00", "1993-10-31 05:00:00", "1994-04-03 06:00:00", 
"1995-04-02 06:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-10-29 07:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00"
), offSet = c("0", "-14400", "-10800", "-14400", "-7200", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-21600", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EST", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT"
)), .Names = c("Pangnirtung", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-119L), class = "data.frame")
}

"Resolute" <- function () {
structure(list(Resolute = c("1901-12-14 20:45:52", "1947-08-31 00:00:00", 
"1965-04-25 06:00:00", "1965-10-31 06:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00"), offSet = c("0", "-21600", "-14400", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0"), TimeZone = c("EST", "EST", 
"CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", 
"EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", 
"CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", 
"EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", 
"CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", "EST", "CDT", 
"EST", "CDT", "EST", "CDT", "EST", "CDT", "EST")), .Names = c("Resolute", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -54L), class = "data.frame")
}

"Atikokan" <- function () {
structure(list(Atikokan = c("1901-12-14 20:45:52", "1918-04-14 08:00:00", 
"1918-10-31 07:00:00"), offSet = c("-21600", "-18000", "-21600"
), isdst = c("0", "1", "0"), TimeZone = c("EST", "CPT", "EST"
)), .Names = c("Atikokan", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Rankin_Inlet" <- function () {
structure(list(Rankin_Inlet = c("1901-12-14 20:45:52", "1957-01-01 00:00:00", 
"1965-04-25 06:00:00", "1965-10-31 06:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00"), offSet = c("0", "-21600", "-14400", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CST", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Rankin_Inlet", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Winnipeg" <- function () {
structure(list(Winnipeg = c("1901-12-14 20:45:52", "1916-04-23 06:00:00", 
"1916-09-17 05:00:00", "1918-04-14 08:00:00", "1918-10-31 07:00:00", 
"1937-05-16 08:00:00", "1937-09-26 07:00:00", "1942-02-09 08:00:00", 
"1945-09-30 07:00:00", "1946-05-12 08:00:00", "1946-10-13 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-05-01 08:00:00", "1950-09-30 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1955-09-25 07:00:00", 
"1956-04-29 08:00:00", "1956-09-30 07:00:00", "1957-04-28 08:00:00", 
"1957-09-29 07:00:00", "1958-04-27 08:00:00", "1958-09-28 07:00:00", 
"1959-04-26 08:00:00", "1959-10-25 07:00:00", "1960-04-24 08:00:00", 
"1960-09-25 07:00:00", "1963-04-28 08:00:00", "1963-09-22 07:00:00", 
"1966-04-24 08:00:00", "1966-10-30 08:00:00", "1967-04-30 08:00:00", 
"1967-10-29 08:00:00", "1968-04-28 08:00:00", "1968-10-27 08:00:00", 
"1969-04-27 08:00:00", "1969-10-26 08:00:00", "1970-04-26 08:00:00", 
"1970-10-25 08:00:00", "1971-04-25 08:00:00", "1971-10-31 08:00:00", 
"1972-04-30 08:00:00", "1972-10-29 08:00:00", "1973-04-29 08:00:00", 
"1973-10-28 08:00:00", "1974-04-28 08:00:00", "1974-10-27 08:00:00", 
"1975-04-27 08:00:00", "1975-10-26 08:00:00", "1976-04-25 08:00:00", 
"1976-10-31 08:00:00", "1977-04-24 08:00:00", "1977-10-30 08:00:00", 
"1978-04-30 08:00:00", "1978-10-29 08:00:00", "1979-04-29 08:00:00", 
"1979-10-28 08:00:00", "1980-04-27 08:00:00", "1980-10-26 08:00:00", 
"1981-04-26 08:00:00", "1981-10-25 08:00:00", "1982-04-25 08:00:00", 
"1982-10-31 08:00:00", "1983-04-24 08:00:00", "1983-10-30 08:00:00", 
"1984-04-29 08:00:00", "1984-10-28 08:00:00", "1985-04-28 08:00:00", 
"1985-10-27 08:00:00", "1986-04-27 08:00:00", "1986-10-26 08:00:00", 
"1987-04-05 08:00:00", "1987-10-25 08:00:00", "1988-04-03 08:00:00", 
"1988-10-30 08:00:00", "1989-04-02 08:00:00", "1989-10-29 08:00:00", 
"1990-04-01 08:00:00", "1990-10-28 08:00:00", "1991-04-07 08:00:00", 
"1991-10-27 08:00:00", "1992-04-05 08:00:00", "1992-10-25 08:00:00", 
"1993-04-04 08:00:00", "1993-10-31 08:00:00", "1994-04-03 08:00:00", 
"1994-10-30 08:00:00", "1995-04-02 08:00:00", "1995-10-29 08:00:00", 
"1996-04-07 08:00:00", "1996-10-27 08:00:00", "1997-04-06 08:00:00", 
"1997-10-26 08:00:00", "1998-04-05 08:00:00", "1998-10-25 08:00:00", 
"1999-04-04 08:00:00", "1999-10-31 08:00:00", "2000-04-02 08:00:00", 
"2000-10-29 08:00:00", "2001-04-01 08:00:00", "2001-10-28 08:00:00", 
"2002-04-07 08:00:00", "2002-10-27 08:00:00", "2003-04-06 08:00:00", 
"2003-10-26 08:00:00", "2004-04-04 08:00:00", "2004-10-31 08:00:00", 
"2005-04-03 08:00:00", "2005-10-30 08:00:00", "2006-04-02 08:00:00", 
"2006-10-29 07:00:00", "2007-03-11 08:00:00", "2007-11-04 07:00:00", 
"2008-03-09 08:00:00", "2008-11-02 07:00:00", "2009-03-08 08:00:00", 
"2009-11-01 07:00:00", "2010-03-14 08:00:00", "2010-11-07 07:00:00", 
"2011-03-13 08:00:00", "2011-11-06 07:00:00", "2012-03-11 08:00:00", 
"2012-11-04 07:00:00", "2013-03-10 08:00:00", "2013-11-03 07:00:00", 
"2014-03-09 08:00:00", "2014-11-02 07:00:00", "2015-03-08 08:00:00", 
"2015-11-01 07:00:00", "2016-03-13 08:00:00", "2016-11-06 07:00:00", 
"2017-03-12 08:00:00", "2017-11-05 07:00:00", "2018-03-11 08:00:00", 
"2018-11-04 07:00:00", "2019-03-10 08:00:00", "2019-11-03 07:00:00", 
"2020-03-08 08:00:00", "2020-11-01 07:00:00", "2021-03-14 08:00:00", 
"2021-11-07 07:00:00", "2022-03-13 08:00:00", "2022-11-06 07:00:00", 
"2023-03-12 08:00:00", "2023-11-05 07:00:00", "2024-03-10 08:00:00", 
"2024-11-03 07:00:00", "2025-03-09 08:00:00", "2025-11-02 07:00:00", 
"2026-03-08 08:00:00", "2026-11-01 07:00:00", "2027-03-14 08:00:00", 
"2027-11-07 07:00:00", "2028-03-12 08:00:00", "2028-11-05 07:00:00", 
"2029-03-11 08:00:00", "2029-11-04 07:00:00", "2030-03-10 08:00:00", 
"2030-11-03 07:00:00", "2031-03-09 08:00:00", "2031-11-02 07:00:00", 
"2032-03-14 08:00:00", "2032-11-07 07:00:00", "2033-03-13 08:00:00", 
"2033-11-06 07:00:00", "2034-03-12 08:00:00", "2034-11-05 07:00:00", 
"2035-03-11 08:00:00", "2035-11-04 07:00:00", "2036-03-09 08:00:00", 
"2036-11-02 07:00:00", "2037-03-08 08:00:00"), offSet = c("-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT")), .Names = c("Winnipeg", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -184L), class = "data.frame")
}

"Rainy_River" <- function () {
structure(list(Rainy_River = c("1901-12-14 20:45:52", "1918-04-14 08:00:00", 
"1918-10-31 07:00:00", "1940-09-29 06:00:00", "1945-09-30 07:00:00", 
"1974-04-28 08:00:00", "1974-10-27 07:00:00", "1975-04-27 08:00:00", 
"1975-10-26 07:00:00", "1976-04-25 08:00:00", "1976-10-31 07:00:00", 
"1977-04-24 08:00:00", "1977-10-30 07:00:00", "1978-04-30 08:00:00", 
"1978-10-29 07:00:00", "1979-04-29 08:00:00", "1979-10-28 07:00:00", 
"1980-04-27 08:00:00", "1980-10-26 07:00:00", "1981-04-26 08:00:00", 
"1981-10-25 07:00:00", "1982-04-25 08:00:00", "1982-10-31 07:00:00", 
"1983-04-24 08:00:00", "1983-10-30 07:00:00", "1984-04-29 08:00:00", 
"1984-10-28 07:00:00", "1985-04-28 08:00:00", "1985-10-27 07:00:00", 
"1986-04-27 08:00:00", "1986-10-26 07:00:00", "1987-04-05 08:00:00", 
"1987-10-25 07:00:00", "1988-04-03 08:00:00", "1988-10-30 07:00:00", 
"1989-04-02 08:00:00", "1989-10-29 07:00:00", "1990-04-01 08:00:00", 
"1990-10-28 07:00:00", "1991-04-07 08:00:00", "1991-10-27 07:00:00", 
"1992-04-05 08:00:00", "1992-10-25 07:00:00", "1993-04-04 08:00:00", 
"1993-10-31 07:00:00", "1994-04-03 08:00:00", "1994-10-30 07:00:00", 
"1995-04-02 08:00:00", "1995-10-29 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00"), offSet = c("-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Rainy_River", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -132L), class = "data.frame")
}

"Regina" <- function () {
structure(list(Regina = c("1901-12-14 20:45:52", "1905-09-01 06:58:36", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1930-05-04 07:00:00", 
"1930-10-05 06:00:00", "1931-05-03 07:00:00", "1931-10-04 06:00:00", 
"1932-05-01 07:00:00", "1932-10-02 06:00:00", "1933-05-07 07:00:00", 
"1933-10-01 06:00:00", "1934-05-06 07:00:00", "1934-10-07 06:00:00", 
"1937-04-11 07:00:00", "1937-10-10 06:00:00", "1938-04-10 07:00:00", 
"1938-10-02 06:00:00", "1939-04-09 07:00:00", "1939-10-08 06:00:00", 
"1940-04-14 07:00:00", "1940-10-13 06:00:00", "1941-04-13 07:00:00", 
"1941-10-12 06:00:00", "1942-02-09 09:00:00", "1945-09-30 08:00:00", 
"1946-04-14 09:00:00", "1946-10-13 08:00:00", "1947-04-27 09:00:00", 
"1947-09-28 08:00:00", "1948-04-25 09:00:00", "1948-09-26 08:00:00", 
"1949-04-24 09:00:00", "1949-09-25 08:00:00", "1950-04-30 09:00:00", 
"1950-09-24 08:00:00", "1951-04-29 09:00:00", "1951-09-30 08:00:00", 
"1952-04-27 09:00:00", "1952-09-28 08:00:00", "1953-04-26 09:00:00", 
"1953-09-27 08:00:00", "1954-04-25 09:00:00", "1954-09-26 08:00:00", 
"1955-04-24 09:00:00", "1955-09-25 08:00:00", "1956-04-29 09:00:00", 
"1956-09-30 08:00:00", "1957-04-28 09:00:00", "1957-09-29 08:00:00", 
"1959-04-26 09:00:00", "1959-10-25 08:00:00"), offSet = c("-25116", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0"), TimeZone = c("CST", "CST", 
"MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", 
"CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", 
"MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", 
"CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", 
"MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", 
"CST", "MDT", "CST", "MDT", "CST")), .Names = c("Regina", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -52L), class = "data.frame")
}

"Swift_Current" <- function () {
structure(list(Swift_Current = c("1901-12-14 20:45:52", "1905-09-01 07:11:20", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1942-02-09 09:00:00", 
"1945-09-30 08:00:00", "1946-04-28 09:00:00", "1946-10-13 08:00:00", 
"1947-04-27 09:00:00", "1947-09-28 08:00:00", "1948-04-25 09:00:00", 
"1948-09-26 08:00:00", "1949-04-24 09:00:00", "1949-09-25 08:00:00", 
"1957-04-28 09:00:00", "1957-10-27 08:00:00", "1959-04-26 09:00:00", 
"1959-10-25 08:00:00", "1960-04-24 09:00:00", "1960-09-25 08:00:00", 
"1961-04-30 09:00:00", "1961-09-24 08:00:00"), offSet = c("-25880", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), 
    TimeZone = c("CST", "CST", "MDT", "CST", "MDT", "CST", "MDT", 
    "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", "MDT", "CST", 
    "MDT", "CST", "MDT", "CST", "MDT", "CST")), .Names = c("Swift_Current", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -22L), class = "data.frame")
}

"Edmonton" <- function () {
structure(list(Edmonton = c("1901-12-14 20:45:52", "1906-09-01 07:33:52", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1919-04-13 09:00:00", 
"1919-05-27 08:00:00", "1920-04-25 09:00:00", "1920-10-31 08:00:00", 
"1921-04-24 09:00:00", "1921-09-25 08:00:00", "1922-04-30 09:00:00", 
"1922-09-24 08:00:00", "1923-04-29 09:00:00", "1923-09-30 08:00:00", 
"1942-02-09 09:00:00", "1945-09-30 08:00:00", "1947-04-27 09:00:00", 
"1947-09-28 08:00:00", "1967-04-30 09:00:00", "1967-10-29 08:00:00", 
"1969-04-27 09:00:00", "1969-10-26 08:00:00", "1972-04-30 09:00:00", 
"1972-10-29 08:00:00", "1973-04-29 09:00:00", "1973-10-28 08:00:00", 
"1974-04-28 09:00:00", "1974-10-27 08:00:00", "1975-04-27 09:00:00", 
"1975-10-26 08:00:00", "1976-04-25 09:00:00", "1976-10-31 08:00:00", 
"1977-04-24 09:00:00", "1977-10-30 08:00:00", "1978-04-30 09:00:00", 
"1978-10-29 08:00:00", "1979-04-29 09:00:00", "1979-10-28 08:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00"), offSet = c("-27232", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("MST", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT")), .Names = c("Edmonton", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -153L), class = "data.frame")
}

"Cambridge_Bay" <- function () {
structure(list(Cambridge_Bay = c("1901-12-14 20:45:52", "1920-01-01 00:00:00", 
"1942-02-09 09:00:00", "1945-09-30 08:00:00", "1965-04-25 07:00:00", 
"1965-10-31 07:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-04-05 09:00:00", "1992-10-25 08:00:00", 
"1993-04-04 09:00:00", "1993-10-31 08:00:00", "1994-04-03 09:00:00", 
"1994-10-30 08:00:00", "1995-04-02 09:00:00", "1995-10-29 08:00:00", 
"1996-04-07 09:00:00", "1996-10-27 08:00:00", "1997-04-06 09:00:00", 
"1997-10-26 08:00:00", "1998-04-05 09:00:00", "1998-10-25 08:00:00", 
"1999-10-31 08:00:00", "2000-10-29 07:00:00", "2001-04-01 09:00:00", 
"2001-10-28 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-03-11 09:00:00", 
"2007-11-04 08:00:00", "2008-03-09 09:00:00", "2008-11-02 08:00:00", 
"2009-03-08 09:00:00", "2009-11-01 08:00:00", "2010-03-14 09:00:00", 
"2010-11-07 08:00:00", "2011-03-13 09:00:00", "2011-11-06 08:00:00", 
"2012-03-11 09:00:00", "2012-11-04 08:00:00", "2013-03-10 09:00:00", 
"2013-11-03 08:00:00", "2014-03-09 09:00:00", "2014-11-02 08:00:00", 
"2015-03-08 09:00:00", "2015-11-01 08:00:00", "2016-03-13 09:00:00", 
"2016-11-06 08:00:00", "2017-03-12 09:00:00", "2017-11-05 08:00:00", 
"2018-03-11 09:00:00", "2018-11-04 08:00:00", "2019-03-10 09:00:00", 
"2019-11-03 08:00:00", "2020-03-08 09:00:00", "2020-11-01 08:00:00", 
"2021-03-14 09:00:00", "2021-11-07 08:00:00", "2022-03-13 09:00:00", 
"2022-11-06 08:00:00", "2023-03-12 09:00:00", "2023-11-05 08:00:00", 
"2024-03-10 09:00:00", "2024-11-03 08:00:00", "2025-03-09 09:00:00", 
"2025-11-02 08:00:00", "2026-03-08 09:00:00", "2026-11-01 08:00:00", 
"2027-03-14 09:00:00", "2027-11-07 08:00:00", "2028-03-12 09:00:00", 
"2028-11-05 08:00:00", "2029-03-11 09:00:00", "2029-11-04 08:00:00", 
"2030-03-10 09:00:00", "2030-11-03 08:00:00", "2031-03-09 09:00:00", 
"2031-11-02 08:00:00", "2032-03-14 09:00:00", "2032-11-07 08:00:00", 
"2033-03-13 09:00:00", "2033-11-06 08:00:00", "2034-03-12 09:00:00", 
"2034-11-05 08:00:00", "2035-03-11 09:00:00", "2035-11-04 08:00:00", 
"2036-03-09 09:00:00", "2036-11-02 08:00:00", "2037-03-08 09:00:00"
), offSet = c("0", "-25200", "-21600", "-25200", "-18000", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-18000", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("MST", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MST", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT"
)), .Names = c("Cambridge_Bay", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -119L), class = "data.frame")
}

"Yellowknife" <- function () {
structure(list(Yellowknife = c("1901-12-14 20:45:52", "1935-01-01 00:00:00", 
"1942-02-09 09:00:00", "1945-09-30 08:00:00", "1965-04-25 07:00:00", 
"1965-10-31 07:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-04-05 09:00:00", "1992-10-25 08:00:00", 
"1993-04-04 09:00:00", "1993-10-31 08:00:00", "1994-04-03 09:00:00", 
"1994-10-30 08:00:00", "1995-04-02 09:00:00", "1995-10-29 08:00:00", 
"1996-04-07 09:00:00", "1996-10-27 08:00:00", "1997-04-06 09:00:00", 
"1997-10-26 08:00:00", "1998-04-05 09:00:00", "1998-10-25 08:00:00", 
"1999-04-04 09:00:00", "1999-10-31 08:00:00", "2000-04-02 09:00:00", 
"2000-10-29 08:00:00", "2001-04-01 09:00:00", "2001-10-28 08:00:00", 
"2002-04-07 09:00:00", "2002-10-27 08:00:00", "2003-04-06 09:00:00", 
"2003-10-26 08:00:00", "2004-04-04 09:00:00", "2004-10-31 08:00:00", 
"2005-04-03 09:00:00", "2005-10-30 08:00:00", "2006-04-02 09:00:00", 
"2006-10-29 08:00:00", "2007-03-11 09:00:00", "2007-11-04 08:00:00", 
"2008-03-09 09:00:00", "2008-11-02 08:00:00", "2009-03-08 09:00:00", 
"2009-11-01 08:00:00", "2010-03-14 09:00:00", "2010-11-07 08:00:00", 
"2011-03-13 09:00:00", "2011-11-06 08:00:00", "2012-03-11 09:00:00", 
"2012-11-04 08:00:00", "2013-03-10 09:00:00", "2013-11-03 08:00:00", 
"2014-03-09 09:00:00", "2014-11-02 08:00:00", "2015-03-08 09:00:00", 
"2015-11-01 08:00:00", "2016-03-13 09:00:00", "2016-11-06 08:00:00", 
"2017-03-12 09:00:00", "2017-11-05 08:00:00", "2018-03-11 09:00:00", 
"2018-11-04 08:00:00", "2019-03-10 09:00:00", "2019-11-03 08:00:00", 
"2020-03-08 09:00:00", "2020-11-01 08:00:00", "2021-03-14 09:00:00", 
"2021-11-07 08:00:00", "2022-03-13 09:00:00", "2022-11-06 08:00:00", 
"2023-03-12 09:00:00", "2023-11-05 08:00:00", "2024-03-10 09:00:00", 
"2024-11-03 08:00:00", "2025-03-09 09:00:00", "2025-11-02 08:00:00", 
"2026-03-08 09:00:00", "2026-11-01 08:00:00", "2027-03-14 09:00:00", 
"2027-11-07 08:00:00", "2028-03-12 09:00:00", "2028-11-05 08:00:00", 
"2029-03-11 09:00:00", "2029-11-04 08:00:00", "2030-03-10 09:00:00", 
"2030-11-03 08:00:00", "2031-03-09 09:00:00", "2031-11-02 08:00:00", 
"2032-03-14 09:00:00", "2032-11-07 08:00:00", "2033-03-13 09:00:00", 
"2033-11-06 08:00:00", "2034-03-12 09:00:00", "2034-11-05 08:00:00", 
"2035-03-11 09:00:00", "2035-11-04 08:00:00", "2036-03-09 09:00:00", 
"2036-11-02 08:00:00", "2037-03-08 09:00:00"), offSet = c("0", 
"-25200", "-21600", "-25200", "-18000", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("MST", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT")), .Names = c("Yellowknife", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -121L), class = "data.frame")
}

"Inuvik" <- function () {
structure(list(Inuvik = c("1901-12-14 20:45:52", "1953-01-01 00:00:00", 
"1965-04-25 08:00:00", "1965-10-31 08:00:00", "1979-04-29 10:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00"), offSet = c("0", "-28800", "-21600", "-28800", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600"), isdst = c("0", "0", 
"1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("MST", "MST", "MDT", "MST", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT")), .Names = c("Inuvik", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -120L), class = "data.frame")
}

"Dawson_Creek" <- function () {
structure(list(Dawson_Creek = c("1901-12-14 20:45:52", "1918-04-14 10:00:00", 
"1918-10-31 09:00:00", "1942-02-09 10:00:00", "1945-09-30 09:00:00", 
"1947-04-27 10:00:00", "1947-09-28 09:00:00", "1948-04-25 10:00:00", 
"1948-09-26 09:00:00", "1949-04-24 10:00:00", "1949-09-25 09:00:00", 
"1950-04-30 10:00:00", "1950-09-24 09:00:00", "1951-04-29 10:00:00", 
"1951-09-30 09:00:00", "1952-04-27 10:00:00", "1952-09-28 09:00:00", 
"1953-04-26 10:00:00", "1953-09-27 09:00:00", "1954-04-25 10:00:00", 
"1954-09-26 09:00:00", "1955-04-24 10:00:00", "1955-09-25 09:00:00", 
"1956-04-29 10:00:00", "1956-09-30 09:00:00", "1957-04-28 10:00:00", 
"1957-09-29 09:00:00", "1958-04-27 10:00:00", "1958-09-28 09:00:00", 
"1959-04-26 10:00:00", "1959-09-27 09:00:00", "1960-04-24 10:00:00", 
"1960-09-25 09:00:00", "1961-04-30 10:00:00", "1961-09-24 09:00:00", 
"1962-04-29 10:00:00", "1962-10-28 09:00:00", "1963-04-28 10:00:00", 
"1963-10-27 09:00:00", "1964-04-26 10:00:00", "1964-10-25 09:00:00", 
"1965-04-25 10:00:00", "1965-10-31 09:00:00", "1966-04-24 10:00:00", 
"1966-10-30 09:00:00", "1967-04-30 10:00:00", "1967-10-29 09:00:00", 
"1968-04-28 10:00:00", "1968-10-27 09:00:00", "1969-04-27 10:00:00", 
"1969-10-26 09:00:00", "1970-04-26 10:00:00", "1970-10-25 09:00:00", 
"1971-04-25 10:00:00", "1971-10-31 09:00:00"), offSet = c("-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0"), TimeZone = c("MST", "PDT", "MST", "PDT", "MST", "PDT", 
"MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", 
"PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", 
"MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", 
"PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", 
"MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", "PDT", "MST", 
"PDT", "MST", "PDT", "MST")), .Names = c("Dawson_Creek", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -55L), class = "data.frame")
}

"Vancouver" <- function () {
structure(list(Vancouver = c("1901-12-14 20:45:52", "1918-04-14 10:00:00", 
"1918-10-31 09:00:00", "1942-02-09 10:00:00", "1945-09-30 09:00:00", 
"1946-04-28 10:00:00", "1946-10-13 09:00:00", "1947-04-27 10:00:00", 
"1947-09-28 09:00:00", "1948-04-25 10:00:00", "1948-09-26 09:00:00", 
"1949-04-24 10:00:00", "1949-09-25 09:00:00", "1950-04-30 10:00:00", 
"1950-09-24 09:00:00", "1951-04-29 10:00:00", "1951-09-30 09:00:00", 
"1952-04-27 10:00:00", "1952-09-28 09:00:00", "1953-04-26 10:00:00", 
"1953-09-27 09:00:00", "1954-04-25 10:00:00", "1954-09-26 09:00:00", 
"1955-04-24 10:00:00", "1955-09-25 09:00:00", "1956-04-29 10:00:00", 
"1956-09-30 09:00:00", "1957-04-28 10:00:00", "1957-09-29 09:00:00", 
"1958-04-27 10:00:00", "1958-09-28 09:00:00", "1959-04-26 10:00:00", 
"1959-09-27 09:00:00", "1960-04-24 10:00:00", "1960-09-25 09:00:00", 
"1961-04-30 10:00:00", "1961-09-24 09:00:00", "1962-04-29 10:00:00", 
"1962-10-28 09:00:00", "1963-04-28 10:00:00", "1963-10-27 09:00:00", 
"1964-04-26 10:00:00", "1964-10-25 09:00:00", "1965-04-25 10:00:00", 
"1965-10-31 09:00:00", "1966-04-24 10:00:00", "1966-10-30 09:00:00", 
"1967-04-30 10:00:00", "1967-10-29 09:00:00", "1968-04-28 10:00:00", 
"1968-10-27 09:00:00", "1969-04-27 10:00:00", "1969-10-26 09:00:00", 
"1970-04-26 10:00:00", "1970-10-25 09:00:00", "1971-04-25 10:00:00", 
"1971-10-31 09:00:00", "1972-04-30 10:00:00", "1972-10-29 09:00:00", 
"1973-04-29 10:00:00", "1973-10-28 09:00:00", "1974-04-28 10:00:00", 
"1974-10-27 09:00:00", "1975-04-27 10:00:00", "1975-10-26 09:00:00", 
"1976-04-25 10:00:00", "1976-10-31 09:00:00", "1977-04-24 10:00:00", 
"1977-10-30 09:00:00", "1978-04-30 10:00:00", "1978-10-29 09:00:00", 
"1979-04-29 10:00:00", "1979-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00"
), offSet = c("-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT")), .Names = c("Vancouver", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -188L), class = "data.frame")
}

"Whitehorse" <- function () {
structure(list(Whitehorse = c("1901-12-14 20:45:52", "1918-04-14 11:00:00", 
"1918-10-27 10:00:00", "1919-05-25 11:00:00", "1919-11-01 08:00:00", 
"1942-02-09 11:00:00", "1945-09-30 10:00:00", "1965-04-25 09:00:00", 
"1965-10-31 09:00:00", "1966-07-01 11:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00"
), offSet = c("-32400", "-28800", "-32400", "-28800", "-32400", 
"-28800", "-32400", "-25200", "-32400", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT")), .Names = c("Whitehorse", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -125L), class = "data.frame")
}

"Dawson" <- function () {
structure(list(Dawson = c("1901-12-14 20:45:52", "1918-04-14 11:00:00", 
"1918-10-27 10:00:00", "1919-05-25 11:00:00", "1919-11-01 08:00:00", 
"1942-02-09 11:00:00", "1945-09-30 10:00:00", "1965-04-25 09:00:00", 
"1965-10-31 09:00:00", "1973-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00"
), offSet = c("-32400", "-28800", "-32400", "-28800", "-32400", 
"-28800", "-32400", "-25200", "-32400", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT")), .Names = c("Dawson", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-125L), class = "data.frame")
}

"Cocos" <- function () {
structure(list(Cocos = "1901-12-14 20:45:52", offSet = "23400", 
    isdst = "0", TimeZone = "CCT"), .Names = c("Cocos", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Kinshasa" <- function () {
structure(list(Kinshasa = "1901-12-14 20:45:52", offSet = "3600", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Kinshasa", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Lubumbashi" <- function () {
structure(list(Lubumbashi = "1901-12-14 20:45:52", offSet = "7200", 
    isdst = "0", TimeZone = "CAT"), .Names = c("Lubumbashi", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Bangui" <- function () {
structure(list(Bangui = "1901-12-14 20:45:52", offSet = "4460", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Bangui", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Brazzaville" <- function () {
structure(list(Brazzaville = "1901-12-14 20:45:52", offSet = "3668", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Brazzaville", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Zurich" <- function () {
structure(list(Zurich = c("1901-12-14 20:45:52", "1940-11-01 23:00:00", 
"1940-12-30 22:00:00", "1941-05-04 01:00:00", "1941-10-04 22:00:00", 
"1942-05-03 01:00:00", "1942-10-03 22:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST")), .Names = c("Zurich", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -120L), class = "data.frame")
}

"Abidjan" <- function () {
structure(list(Abidjan = "1901-12-14 20:45:52", offSet = "-968", 
    isdst = "0", TimeZone = "GMT"), .Names = c("Abidjan", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Rarotonga" <- function () {
structure(list(Rarotonga = c("1901-12-14 20:45:52", "1978-11-12 10:30:00", 
"1979-03-04 09:30:00", "1979-10-28 10:00:00", "1980-03-02 09:30:00", 
"1980-10-26 10:00:00", "1981-03-01 09:30:00", "1981-10-25 10:00:00", 
"1982-03-07 09:30:00", "1982-10-31 10:00:00", "1983-03-06 09:30:00", 
"1983-10-30 10:00:00", "1984-03-04 09:30:00", "1984-10-28 10:00:00", 
"1985-03-03 09:30:00", "1985-10-27 10:00:00", "1986-03-02 09:30:00", 
"1986-10-26 10:00:00", "1987-03-01 09:30:00", "1987-10-25 10:00:00", 
"1988-03-06 09:30:00", "1988-10-30 10:00:00", "1989-03-05 09:30:00", 
"1989-10-29 10:00:00", "1990-03-04 09:30:00", "1990-10-28 10:00:00"
), offSet = c("-37800", "-34200", "-36000", "-34200", "-36000", 
"-34200", "-36000", "-34200", "-36000", "-34200", "-36000", "-34200", 
"-36000", "-34200", "-36000", "-34200", "-36000", "-34200", "-36000", 
"-34200", "-36000", "-34200", "-36000", "-34200", "-36000", "-34200"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1"), TimeZone = c("CKT", "CKHST", "CKT", "CKHST", 
"CKT", "CKHST", "CKT", "CKHST", "CKT", "CKHST", "CKT", "CKHST", 
"CKT", "CKHST", "CKT", "CKHST", "CKT", "CKHST", "CKT", "CKHST", 
"CKT", "CKHST", "CKT", "CKHST", "CKT", "CKHST")), .Names = c("Rarotonga", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -26L), class = "data.frame")
}

"Santiago" <- function () {
structure(list(Santiago = c("1901-12-14 20:45:52", "1910-01-01 04:42:46", 
"1916-07-01 05:00:00", "1918-09-01 04:42:46", "1919-07-01 04:00:00", 
"1927-09-01 04:42:46", "1928-04-01 04:00:00", "1928-09-01 05:00:00", 
"1929-04-01 04:00:00", "1929-09-01 05:00:00", "1930-04-01 04:00:00", 
"1930-09-01 05:00:00", "1931-04-01 04:00:00", "1931-09-01 05:00:00", 
"1932-04-01 04:00:00", "1932-09-01 05:00:00", "1942-06-01 04:00:00", 
"1942-08-01 05:00:00", "1946-09-01 03:00:00", "1947-05-22 05:00:00", 
"1968-11-03 04:00:00", "1969-03-30 03:00:00", "1969-11-23 04:00:00", 
"1970-03-29 03:00:00", "1970-10-11 04:00:00", "1971-03-14 03:00:00", 
"1971-10-10 04:00:00", "1972-03-12 03:00:00", "1972-10-15 04:00:00", 
"1973-03-11 03:00:00", "1973-09-30 04:00:00", "1974-03-10 03:00:00", 
"1974-10-13 04:00:00", "1975-03-09 03:00:00", "1975-10-12 04:00:00", 
"1976-03-14 03:00:00", "1976-10-10 04:00:00", "1977-03-13 03:00:00", 
"1977-10-09 04:00:00", "1978-03-12 03:00:00", "1978-10-15 04:00:00", 
"1979-03-11 03:00:00", "1979-10-14 04:00:00", "1980-03-09 03:00:00", 
"1980-10-12 04:00:00", "1981-03-15 03:00:00", "1981-10-11 04:00:00", 
"1982-03-14 03:00:00", "1982-10-10 04:00:00", "1983-03-13 03:00:00", 
"1983-10-09 04:00:00", "1984-03-11 03:00:00", "1984-10-14 04:00:00", 
"1985-03-10 03:00:00", "1985-10-13 04:00:00", "1986-03-09 03:00:00", 
"1986-10-12 04:00:00", "1987-04-12 03:00:00", "1987-10-11 04:00:00", 
"1988-03-13 03:00:00", "1988-10-02 04:00:00", "1989-03-12 03:00:00", 
"1989-10-15 04:00:00", "1990-03-18 03:00:00", "1990-09-16 04:00:00", 
"1991-03-10 03:00:00", "1991-10-13 04:00:00", "1992-03-15 03:00:00", 
"1992-10-11 04:00:00", "1993-03-14 03:00:00", "1993-10-10 04:00:00", 
"1994-03-13 03:00:00", "1994-10-09 04:00:00", "1995-03-12 03:00:00", 
"1995-10-15 04:00:00", "1996-03-10 03:00:00", "1996-10-13 04:00:00", 
"1997-03-30 03:00:00", "1997-10-12 04:00:00", "1998-03-15 03:00:00", 
"1998-09-27 04:00:00", "1999-04-04 03:00:00", "1999-10-10 04:00:00", 
"2000-03-12 03:00:00", "2000-10-15 04:00:00", "2001-03-11 03:00:00", 
"2001-10-14 04:00:00", "2002-03-10 03:00:00", "2002-10-13 04:00:00", 
"2003-03-09 03:00:00", "2003-10-12 04:00:00", "2004-03-14 03:00:00", 
"2004-10-10 04:00:00", "2005-03-13 03:00:00", "2005-10-09 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-14 04:00:00", "2008-03-30 03:00:00", "2008-10-12 04:00:00", 
"2009-03-15 03:00:00", "2009-10-11 04:00:00", "2010-03-14 03:00:00", 
"2010-10-10 04:00:00", "2011-03-13 03:00:00", "2011-10-09 04:00:00", 
"2012-03-11 03:00:00", "2012-10-14 04:00:00", "2013-03-10 03:00:00", 
"2013-10-13 04:00:00", "2014-03-09 03:00:00", "2014-10-12 04:00:00", 
"2015-03-15 03:00:00", "2015-10-11 04:00:00", "2016-03-13 03:00:00", 
"2016-10-09 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-14 04:00:00", "2019-03-10 03:00:00", 
"2019-10-13 04:00:00", "2020-03-15 03:00:00", "2020-10-11 04:00:00", 
"2021-03-14 03:00:00", "2021-10-10 04:00:00", "2022-03-13 03:00:00", 
"2022-10-09 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-13 04:00:00", "2025-03-09 03:00:00", 
"2025-10-12 04:00:00", "2026-03-15 03:00:00", "2026-10-11 04:00:00", 
"2027-03-14 03:00:00", "2027-10-10 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-14 04:00:00", 
"2030-03-10 03:00:00", "2030-10-13 04:00:00", "2031-03-09 03:00:00", 
"2031-10-12 04:00:00", "2032-03-14 03:00:00", "2032-10-10 04:00:00", 
"2033-03-13 03:00:00", "2033-10-09 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-14 04:00:00", 
"2036-03-09 03:00:00", "2036-10-12 04:00:00", "2037-03-15 03:00:00"
), offSet = c("-16966", "-18000", "-16966", "-14400", "-16966", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400"), 
    isdst = c("0", "0", "0", "0", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0"), TimeZone = c("CLT", "CLT", "CLT", "CLT", 
    "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
    "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
    "CLST", "CLT")), .Names = c("Santiago", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -158L), class = "data.frame")
}

"Easter" <- function () {
structure(list(Easter = c("1901-12-14 20:45:52", "1932-09-01 07:17:28", 
"1942-06-01 04:00:00", "1942-08-01 05:00:00", "1946-09-01 03:00:00", 
"1968-11-03 04:00:00", "1969-03-30 03:00:00", "1969-11-23 04:00:00", 
"1970-03-29 03:00:00", "1970-10-11 04:00:00", "1971-03-14 03:00:00", 
"1971-10-10 04:00:00", "1972-03-12 03:00:00", "1972-10-15 04:00:00", 
"1973-03-11 03:00:00", "1973-09-30 04:00:00", "1974-03-10 03:00:00", 
"1974-10-13 04:00:00", "1975-03-09 03:00:00", "1975-10-12 04:00:00", 
"1976-03-14 03:00:00", "1976-10-10 04:00:00", "1977-03-13 03:00:00", 
"1977-10-09 04:00:00", "1978-03-12 03:00:00", "1978-10-15 04:00:00", 
"1979-03-11 03:00:00", "1979-10-14 04:00:00", "1980-03-09 03:00:00", 
"1980-10-12 04:00:00", "1981-03-15 03:00:00", "1982-03-14 03:00:00", 
"1982-10-10 04:00:00", "1983-03-13 03:00:00", "1983-10-09 04:00:00", 
"1984-03-11 03:00:00", "1984-10-14 04:00:00", "1985-03-10 03:00:00", 
"1985-10-13 04:00:00", "1986-03-09 03:00:00", "1986-10-12 04:00:00", 
"1987-04-12 03:00:00", "1987-10-11 04:00:00", "1988-03-13 03:00:00", 
"1988-10-02 04:00:00", "1989-03-12 03:00:00", "1989-10-15 04:00:00", 
"1990-03-18 03:00:00", "1990-09-16 04:00:00", "1991-03-10 03:00:00", 
"1991-10-13 04:00:00", "1992-03-15 03:00:00", "1992-10-11 04:00:00", 
"1993-03-14 03:00:00", "1993-10-10 04:00:00", "1994-03-13 03:00:00", 
"1994-10-09 04:00:00", "1995-03-12 03:00:00", "1995-10-15 04:00:00", 
"1996-03-10 03:00:00", "1996-10-13 04:00:00", "1997-03-30 03:00:00", 
"1997-10-12 04:00:00", "1998-03-15 03:00:00", "1998-09-27 04:00:00", 
"1999-04-04 03:00:00", "1999-10-10 04:00:00", "2000-03-12 03:00:00", 
"2000-10-15 04:00:00", "2001-03-11 03:00:00", "2001-10-14 04:00:00", 
"2002-03-10 03:00:00", "2002-10-13 04:00:00", "2003-03-09 03:00:00", 
"2003-10-12 04:00:00", "2004-03-14 03:00:00", "2004-10-10 04:00:00", 
"2005-03-13 03:00:00", "2005-10-09 04:00:00", "2006-03-12 03:00:00", 
"2006-10-15 04:00:00", "2007-03-11 03:00:00", "2007-10-14 04:00:00", 
"2008-03-30 03:00:00", "2008-10-12 04:00:00", "2009-03-15 03:00:00", 
"2009-10-11 04:00:00", "2010-03-14 03:00:00", "2010-10-10 04:00:00", 
"2011-03-13 03:00:00", "2011-10-09 04:00:00", "2012-03-11 03:00:00", 
"2012-10-14 04:00:00", "2013-03-10 03:00:00", "2013-10-13 04:00:00", 
"2014-03-09 03:00:00", "2014-10-12 04:00:00", "2015-03-15 03:00:00", 
"2015-10-11 04:00:00", "2016-03-13 03:00:00", "2016-10-09 04:00:00", 
"2017-03-12 03:00:00", "2017-10-15 04:00:00", "2018-03-11 03:00:00", 
"2018-10-14 04:00:00", "2019-03-10 03:00:00", "2019-10-13 04:00:00", 
"2020-03-15 03:00:00", "2020-10-11 04:00:00", "2021-03-14 03:00:00", 
"2021-10-10 04:00:00", "2022-03-13 03:00:00", "2022-10-09 04:00:00", 
"2023-03-12 03:00:00", "2023-10-15 04:00:00", "2024-03-10 03:00:00", 
"2024-10-13 04:00:00", "2025-03-09 03:00:00", "2025-10-12 04:00:00", 
"2026-03-15 03:00:00", "2026-10-11 04:00:00", "2027-03-14 03:00:00", 
"2027-10-10 04:00:00", "2028-03-12 03:00:00", "2028-10-15 04:00:00", 
"2029-03-11 03:00:00", "2029-10-14 04:00:00", "2030-03-10 03:00:00", 
"2030-10-13 04:00:00", "2031-03-09 03:00:00", "2031-10-12 04:00:00", 
"2032-03-14 03:00:00", "2032-10-10 04:00:00", "2033-03-13 03:00:00", 
"2033-10-09 04:00:00", "2034-03-12 03:00:00", "2034-10-15 04:00:00", 
"2035-03-11 03:00:00", "2035-10-14 04:00:00", "2036-03-09 03:00:00", 
"2036-10-12 04:00:00", "2037-03-15 03:00:00"), offSet = c("-26248", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600"), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("EAST", "EASST", "EAST", "EASST", 
"EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", 
"EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", 
"EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", 
"EAST", "EASST", "EAST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST", "EASST", "EAST", "EASST", "EAST", "EASST", "EAST", 
"EASST", "EAST")), .Names = c("Easter", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -142L), class = "data.frame")
}

"Douala" <- function () {
structure(list(Douala = "1901-12-14 20:45:52", offSet = "2328", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Douala", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Shanghai" <- function () {
structure(list(Shanghai = c("1901-12-14 20:45:52", "1927-12-31 15:54:08", 
"1940-06-02 16:00:00", "1940-09-30 15:00:00", "1941-03-15 16:00:00", 
"1941-09-30 15:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00"
), offSet = c("29152", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400"), isdst = c("0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT")), .Names = c("Shanghai", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -17L), class = "data.frame")
}

"Harbin" <- function () {
structure(list(Harbin = c("1901-12-14 20:45:52", "1927-12-31 15:33:16", 
"1932-02-29 15:30:00", "1939-12-31 16:00:00", "1966-04-30 15:00:00", 
"1980-04-30 15:30:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00"
), offSet = c("30404", "30600", "28800", "32400", "30600", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400"), isdst = c("0", "0", "0", 
"0", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CST", "CST", "CST", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT")), .Names = c("Harbin", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -17L), class = "data.frame")
}

"Chongqing" <- function () {
structure(list(Chongqing = c("1901-12-14 20:45:52", "1927-12-31 16:53:40", 
"1980-04-30 17:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00"
), offSet = c("25580", "25200", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400"), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CST", "CST", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT")), .Names = c("Chongqing", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -14L), class = "data.frame")
}

"Urumqi" <- function () {
structure(list(Urumqi = c("1901-12-14 20:45:52", "1927-12-31 18:09:40", 
"1980-04-30 18:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00"
), offSet = c("21020", "21600", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400"), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CST", "CST", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT")), .Names = c("Urumqi", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-14L), class = "data.frame")
}

"Kashgar" <- function () {
structure(list(Kashgar = c("1901-12-14 20:45:52", "1927-12-31 18:56:04", 
"1939-12-31 18:30:00", "1980-04-30 19:00:00", "1986-05-03 16:00:00", 
"1986-09-13 15:00:00", "1987-04-11 16:00:00", "1987-09-12 15:00:00", 
"1988-04-09 16:00:00", "1988-09-10 15:00:00", "1989-04-15 16:00:00", 
"1989-09-16 15:00:00", "1990-04-14 16:00:00", "1990-09-15 15:00:00", 
"1991-04-13 16:00:00"), offSet = c("18236", "19800", "18000", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400"), isdst = c("0", 
"0", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CST", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT"
)), .Names = c("Kashgar", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-15L), class = "data.frame")
}

"Bogota" <- function () {
structure(list(Bogota = c("1901-12-14 20:45:52", "1914-11-23 04:56:20", 
"1992-05-03 05:00:00"), offSet = c("-17780", "-18000", "-14400"
), isdst = c("0", "0", "1"), TimeZone = c("COT", "COT", "COST"
)), .Names = c("Bogota", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Costa_Rica" <- function () {
structure(list(Costa_Rica = c("1901-12-14 20:45:52", "1921-01-15 05:36:20", 
"1979-02-25 06:00:00", "1979-06-03 05:00:00", "1980-02-24 06:00:00", 
"1980-06-01 05:00:00", "1991-01-19 06:00:00", "1991-07-01 05:00:00", 
"1992-01-18 06:00:00"), offSet = c("-20180", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Costa_Rica", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -9L), class = "data.frame")
}

"Havana" <- function () {
structure(list(Havana = c("1901-12-14 20:45:52", "1925-07-19 17:29:36", 
"1928-06-10 05:00:00", "1928-10-10 04:00:00", "1940-06-02 05:00:00", 
"1940-09-01 04:00:00", "1941-06-01 05:00:00", "1941-09-07 04:00:00", 
"1942-06-07 05:00:00", "1942-09-06 04:00:00", "1945-06-03 05:00:00", 
"1945-09-02 04:00:00", "1946-06-02 05:00:00", "1946-09-01 04:00:00", 
"1965-06-01 05:00:00", "1965-09-30 04:00:00", "1966-05-29 05:00:00", 
"1966-10-02 04:00:00", "1967-04-08 05:00:00", "1967-09-10 04:00:00", 
"1968-04-14 05:00:00", "1968-09-08 04:00:00", "1969-04-27 05:00:00", 
"1969-10-26 04:00:00", "1970-04-26 05:00:00", "1970-10-25 04:00:00", 
"1971-04-25 05:00:00", "1971-10-31 04:00:00", "1972-04-30 05:00:00", 
"1972-10-08 04:00:00", "1973-04-29 05:00:00", "1973-10-08 04:00:00", 
"1974-04-28 05:00:00", "1974-10-08 04:00:00", "1975-04-27 05:00:00", 
"1975-10-26 04:00:00", "1976-04-25 05:00:00", "1976-10-31 04:00:00", 
"1977-04-24 05:00:00", "1977-10-30 04:00:00", "1978-05-07 05:00:00", 
"1978-10-08 04:00:00", "1979-03-18 05:00:00", "1979-10-14 04:00:00", 
"1980-03-16 05:00:00", "1980-10-12 04:00:00", "1981-05-10 05:00:00", 
"1981-10-11 04:00:00", "1982-05-09 05:00:00", "1982-10-10 04:00:00", 
"1983-05-08 05:00:00", "1983-10-09 04:00:00", "1984-05-06 05:00:00", 
"1984-10-14 04:00:00", "1985-05-05 05:00:00", "1985-10-13 04:00:00", 
"1986-03-16 05:00:00", "1986-10-12 04:00:00", "1987-03-15 05:00:00", 
"1987-10-11 04:00:00", "1988-03-20 05:00:00", "1988-10-09 04:00:00", 
"1989-03-19 05:00:00", "1989-10-08 04:00:00", "1990-04-01 05:00:00", 
"1990-10-14 04:00:00", "1991-04-07 05:00:00", "1991-10-13 05:00:00", 
"1992-04-05 05:00:00", "1992-10-11 05:00:00", "1993-04-04 05:00:00", 
"1993-10-10 05:00:00", "1994-04-03 05:00:00", "1994-10-09 05:00:00", 
"1995-04-02 05:00:00", "1995-10-08 05:00:00", "1996-04-07 05:00:00", 
"1996-10-06 05:00:00", "1997-04-06 05:00:00", "1997-10-12 05:00:00", 
"1998-03-29 05:00:00", "1998-10-25 05:00:00", "1999-03-28 05:00:00", 
"1999-10-31 05:00:00", "2000-04-02 05:00:00", "2000-10-29 05:00:00", 
"2001-04-01 05:00:00", "2001-10-28 05:00:00", "2002-04-07 05:00:00", 
"2002-10-27 05:00:00", "2003-04-06 05:00:00", "2003-10-26 05:00:00", 
"2004-04-04 05:00:00", "2006-10-29 05:00:00", "2007-03-11 05:00:00", 
"2007-10-28 05:00:00", "2008-03-09 05:00:00", "2008-10-26 05:00:00", 
"2009-03-08 05:00:00", "2009-10-25 05:00:00", "2010-03-14 05:00:00", 
"2010-10-31 05:00:00", "2011-03-13 05:00:00", "2011-10-30 05:00:00", 
"2012-03-11 05:00:00", "2012-10-28 05:00:00", "2013-03-10 05:00:00", 
"2013-10-27 05:00:00", "2014-03-09 05:00:00", "2014-10-26 05:00:00", 
"2015-03-08 05:00:00", "2015-10-25 05:00:00", "2016-03-13 05:00:00", 
"2016-10-30 05:00:00", "2017-03-12 05:00:00", "2017-10-29 05:00:00", 
"2018-03-11 05:00:00", "2018-10-28 05:00:00", "2019-03-10 05:00:00", 
"2019-10-27 05:00:00", "2020-03-08 05:00:00", "2020-10-25 05:00:00", 
"2021-03-14 05:00:00", "2021-10-31 05:00:00", "2022-03-13 05:00:00", 
"2022-10-30 05:00:00", "2023-03-12 05:00:00", "2023-10-29 05:00:00", 
"2024-03-10 05:00:00", "2024-10-27 05:00:00", "2025-03-09 05:00:00", 
"2025-10-26 05:00:00", "2026-03-08 05:00:00", "2026-10-25 05:00:00", 
"2027-03-14 05:00:00", "2027-10-31 05:00:00", "2028-03-12 05:00:00", 
"2028-10-29 05:00:00", "2029-03-11 05:00:00", "2029-10-28 05:00:00", 
"2030-03-10 05:00:00", "2030-10-27 05:00:00", "2031-03-09 05:00:00", 
"2031-10-26 05:00:00", "2032-03-14 05:00:00", "2032-10-31 05:00:00", 
"2033-03-13 05:00:00", "2033-10-30 05:00:00", "2034-03-12 05:00:00", 
"2034-10-29 05:00:00", "2035-03-11 05:00:00", "2035-10-28 05:00:00", 
"2036-03-09 05:00:00", "2036-10-26 05:00:00", "2037-03-08 05:00:00"
), offSet = c("-19776", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT")), .Names = c("Havana", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-155L), class = "data.frame")
}

"Cape_Verde" <- function () {
structure(list(Cape_Verde = c("1901-12-14 20:45:52", "1907-01-01 01:34:04", 
"1942-09-01 02:00:00", "1945-10-15 01:00:00"), offSet = c("-5644", 
"-7200", "-3600", "-7200"), isdst = c("0", "0", "1", "0"), TimeZone = c("CVT", 
"CVT", "CVST", "CVT")), .Names = c("Cape_Verde", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Christmas" <- function () {
structure(list(Christmas = "1901-12-14 20:45:52", offSet = "25200", 
    isdst = "0", TimeZone = "CXT"), .Names = c("Christmas", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Nicosia" <- function () {
structure(list(Nicosia = c("1901-12-14 20:45:52", "1921-11-13 21:46:32", 
"1975-04-12 22:00:00", "1975-10-11 21:00:00", "1976-05-14 22:00:00", 
"1976-10-10 21:00:00", "1977-04-02 22:00:00", "1977-09-24 21:00:00", 
"1978-04-01 22:00:00", "1978-10-01 21:00:00", "1979-03-31 22:00:00", 
"1979-09-29 21:00:00", "1980-04-05 22:00:00", "1980-09-27 21:00:00", 
"1981-03-28 22:00:00", "1981-09-26 21:00:00", "1982-03-27 22:00:00", 
"1982-09-25 21:00:00", "1983-03-26 22:00:00", "1983-09-24 21:00:00", 
"1984-03-24 22:00:00", "1984-09-29 21:00:00", "1985-03-30 22:00:00", 
"1985-09-28 21:00:00", "1986-03-29 22:00:00", "1986-09-27 21:00:00", 
"1987-03-28 22:00:00", "1987-09-26 21:00:00", "1988-03-26 22:00:00", 
"1988-09-24 21:00:00", "1989-03-25 22:00:00", "1989-09-23 21:00:00", 
"1990-03-24 22:00:00", "1990-09-29 21:00:00", "1991-03-30 22:00:00", 
"1991-09-28 21:00:00", "1992-03-28 22:00:00", "1992-09-26 21:00:00", 
"1993-03-27 22:00:00", "1993-09-25 21:00:00", "1994-03-26 22:00:00", 
"1994-09-24 21:00:00", "1995-03-25 22:00:00", "1995-09-23 21:00:00", 
"1996-03-30 22:00:00", "1996-09-28 21:00:00", "1997-03-29 22:00:00", 
"1997-09-27 21:00:00", "1998-03-28 22:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("8008", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST"
)), .Names = c("Nicosia", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-127L), class = "data.frame")
}

"Prague" <- function () {
structure(list(Prague = c("1901-12-14 20:45:52", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1940-04-01 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-17 01:00:00", "1945-04-08 01:00:00", 
"1945-11-18 01:00:00", "1946-05-06 01:00:00", "1946-10-06 01:00:00", 
"1947-04-20 01:00:00", "1947-10-05 01:00:00", "1948-04-18 01:00:00", 
"1948-10-03 01:00:00", "1949-04-09 01:00:00", "1949-10-02 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST")), .Names = c("Prague", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -140L), class = "data.frame")
}

"Berlin" <- function () {
structure(list(Berlin = c("1901-12-14 20:45:52", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1940-04-01 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-04-02 01:00:00", 
"1945-05-24 00:00:00", "1945-09-24 00:00:00", "1945-11-18 01:00:00", 
"1946-04-14 01:00:00", "1946-10-07 01:00:00", "1947-04-06 01:00:00", 
"1947-05-11 01:00:00", "1947-06-29 00:00:00", "1947-10-05 01:00:00", 
"1948-04-18 01:00:00", "1948-10-03 01:00:00", "1949-04-10 01:00:00", 
"1949-10-02 01:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "10800", "7200", "3600", 
"7200", "3600", "7200", "10800", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", 
"1", "0", "1", "0", "1", "1", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CEST", "CEST", "CET", "CEST", 
"CET", "CEST", "CEST", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Berlin", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -142L), class = "data.frame")
}

"Djibouti" <- function () {
structure(list(Djibouti = "1901-12-14 20:45:52", offSet = "10356", 
    isdst = "0", TimeZone = "EAT"), .Names = c("Djibouti", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Copenhagen" <- function () {
structure(list(Copenhagen = c("1901-12-14 20:45:52", "1916-05-14 22:00:00", 
"1916-09-30 21:00:00", "1940-05-14 23:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-08-15 01:00:00", 
"1946-05-01 01:00:00", "1946-09-01 01:00:00", "1947-05-04 01:00:00", 
"1947-08-10 01:00:00", "1948-05-09 01:00:00", "1948-08-08 01:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST")), .Names = c("Copenhagen", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -132L), class = "data.frame")
}

"Dominica" <- function () {
structure(list(Dominica = "1901-12-14 20:45:52", offSet = "-14736", 
    isdst = "0", TimeZone = "AST"), .Names = c("Dominica", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Santo_Domingo" <- function () {
structure(list(Santo_Domingo = c("1901-12-14 20:45:52", "1933-04-01 16:40:00", 
"1966-10-30 05:00:00", "1967-02-28 04:00:00", "1969-10-26 05:00:00", 
"1970-02-21 04:30:00", "1970-10-25 05:00:00", "1971-01-20 04:30:00", 
"1971-10-31 05:00:00", "1972-01-21 04:30:00", "1972-10-29 05:00:00", 
"1973-01-21 04:30:00", "1973-10-28 05:00:00", "1974-01-21 04:30:00", 
"1974-10-27 05:00:00", "2000-10-29 06:00:00"), offSet = c("-16800", 
"-18000", "-14400", "-18000", "-16200", "-18000", "-16200", "-18000", 
"-16200", "-18000", "-16200", "-18000", "-16200", "-18000", "-14400", 
"-18000"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0"), TimeZone = c("AST", 
"AST", "EHDT", "AST", "EHDT", "AST", "EHDT", "AST", "EHDT", "AST", 
"EHDT", "AST", "EHDT", "AST", "AST", "AST")), .Names = c("Santo_Domingo", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -16L), class = "data.frame")
}

"Algiers" <- function () {
structure(list(Algiers = c("1901-12-14 20:45:52", "1911-03-10 23:50:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-06-21 23:00:00", 
"1939-09-11 23:00:00", "1939-11-19 00:00:00", "1940-02-25 02:00:00", 
"1944-04-03 01:00:00", "1944-10-08 00:00:00", "1945-04-02 01:00:00", 
"1945-09-15 23:00:00", "1946-10-06 23:00:00", "1956-01-29 00:00:00", 
"1963-04-13 23:00:00", "1971-04-25 23:00:00", "1971-09-26 23:00:00", 
"1977-10-20 23:00:00", "1978-03-24 00:00:00", "1978-09-22 01:00:00", 
"1979-10-25 23:00:00", "1980-04-25 00:00:00", "1980-10-31 01:00:00"
), offSet = c("561", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "7200", 
"3600", "7200", "3600", "0", "3600", "0", "3600", "0", "3600", 
"7200", "3600", "0", "3600", "0"), isdst = c("0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", 
"1", "0", "1", "0", "0", "0", "0", "1", "0", "0", "1", "0", "0", 
"1", "0"), TimeZone = c("CET", "CET", "WEST", "CET", "WEST", 
"CET", "WEST", "CET", "WEST", "CET", "WEST", "CET", "WEST", "CET", 
"WEST", "CET", "CET", "WEST", "CET", "WEST", "CET", "CET", "CET", 
"CET", "WEST", "CET", "CET", "WEST", "CET", "CET", "WEST", "CET"
)), .Names = c("Algiers", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-32L), class = "data.frame")
}

"Guayaquil" <- function () {
structure(list(Guayaquil = "1901-12-14 20:45:52", offSet = "-18840", 
    isdst = "0", TimeZone = "ECT"), .Names = c("Guayaquil", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Galapagos" <- function () {
structure(list(Galapagos = c("1901-12-14 20:45:52", "1931-01-01 05:58:24"
), offSet = c("-21504", "-18000"), isdst = c("0", "0"), TimeZone = c("GALT", 
"GALT")), .Names = c("Galapagos", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Tallinn" <- function () {
structure(list(Tallinn = c("1901-12-14 20:45:52", "1918-01-31 22:21:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1919-06-30 23:00:00", 
"1921-04-30 22:21:00", "1940-08-05 22:00:00", "1941-09-14 21:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-21 22:00:00", "1981-03-31 21:00:00", 
"1981-09-30 20:00:00", "1982-03-31 21:00:00", "1982-09-30 20:00:00", 
"1983-03-31 21:00:00", "1983-09-30 20:00:00", "1984-03-31 21:00:00", 
"1984-09-29 23:00:00", "1985-03-30 23:00:00", "1985-09-28 23:00:00", 
"1986-03-29 23:00:00", "1986-09-27 23:00:00", "1987-03-28 23:00:00", 
"1987-09-26 23:00:00", "1988-03-26 23:00:00", "1989-03-25 23:00:00", 
"1989-09-24 00:00:00", "1990-03-25 00:00:00", "1990-09-30 00:00:00", 
"1991-03-31 00:00:00", "1991-09-29 00:00:00", "1992-03-29 00:00:00", 
"1992-09-27 00:00:00", "1993-03-28 00:00:00", "1993-09-26 00:00:00", 
"1994-03-27 00:00:00", "1994-09-25 00:00:00", "1995-03-26 00:00:00", 
"1995-09-24 00:00:00", "1996-03-31 00:00:00", "1996-10-27 00:00:00", 
"1997-03-30 00:00:00", "1997-10-26 00:00:00", "1998-03-29 00:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("5940", 
"3600", "7200", "3600", "5940", "7200", "10800", "7200", "3600", 
"7200", "3600", "7200", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800"), isdst = c("0", "0", "1", "0", "0", "0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EET", "EEST", "EET", "EET", "EET", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST")), .Names = c("Tallinn", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -121L), class = "data.frame")
}

"Cairo" <- function () {
structure(list(Cairo = c("1901-12-14 20:45:52", "1940-07-14 22:00:00", 
"1940-09-30 21:00:00", "1941-04-14 22:00:00", "1941-09-15 21:00:00", 
"1942-03-31 22:00:00", "1942-10-26 21:00:00", "1943-03-31 22:00:00", 
"1943-10-31 21:00:00", "1944-03-31 22:00:00", "1944-10-31 21:00:00", 
"1945-04-15 22:00:00", "1945-10-31 21:00:00", "1957-05-09 22:00:00", 
"1957-09-30 21:00:00", "1958-04-30 22:00:00", "1958-09-30 21:00:00", 
"1959-04-30 23:00:00", "1959-09-30 00:00:00", "1960-04-30 23:00:00", 
"1960-09-30 00:00:00", "1961-04-30 23:00:00", "1961-09-30 00:00:00", 
"1962-04-30 23:00:00", "1962-09-30 00:00:00", "1963-04-30 23:00:00", 
"1963-09-30 00:00:00", "1964-04-30 23:00:00", "1964-09-30 00:00:00", 
"1965-04-30 23:00:00", "1965-09-30 00:00:00", "1966-04-30 23:00:00", 
"1966-10-01 00:00:00", "1967-04-30 23:00:00", "1967-10-01 00:00:00", 
"1968-04-30 23:00:00", "1968-10-01 00:00:00", "1969-04-30 23:00:00", 
"1969-10-01 00:00:00", "1970-04-30 23:00:00", "1970-10-01 00:00:00", 
"1971-04-30 23:00:00", "1971-10-01 00:00:00", "1972-04-30 23:00:00", 
"1972-10-01 00:00:00", "1973-04-30 23:00:00", "1973-10-01 00:00:00", 
"1974-04-30 23:00:00", "1974-10-01 00:00:00", "1975-04-30 23:00:00", 
"1975-10-01 00:00:00", "1976-04-30 23:00:00", "1976-10-01 00:00:00", 
"1977-04-30 23:00:00", "1977-10-01 00:00:00", "1978-04-30 23:00:00", 
"1978-10-01 00:00:00", "1979-04-30 23:00:00", "1979-10-01 00:00:00", 
"1980-04-30 23:00:00", "1980-10-01 00:00:00", "1981-04-30 23:00:00", 
"1981-10-01 00:00:00", "1982-07-24 23:00:00", "1982-10-01 00:00:00", 
"1983-07-11 23:00:00", "1983-10-01 00:00:00", "1984-04-30 23:00:00", 
"1984-10-01 00:00:00", "1985-04-30 23:00:00", "1985-10-01 00:00:00", 
"1986-04-30 23:00:00", "1986-10-01 00:00:00", "1987-04-30 23:00:00", 
"1987-10-01 00:00:00", "1988-04-30 23:00:00", "1988-10-01 00:00:00", 
"1989-05-05 23:00:00", "1989-10-01 00:00:00", "1990-04-30 23:00:00", 
"1990-10-01 00:00:00", "1991-04-30 23:00:00", "1991-10-01 00:00:00", 
"1992-04-30 23:00:00", "1992-10-01 00:00:00", "1993-04-30 23:00:00", 
"1993-10-01 00:00:00", "1994-04-30 23:00:00", "1994-10-01 00:00:00", 
"1995-04-27 22:00:00", "1995-09-28 21:00:00", "1996-04-25 22:00:00", 
"1996-09-26 21:00:00", "1997-04-24 22:00:00", "1997-09-25 21:00:00", 
"1998-04-23 22:00:00", "1998-09-24 21:00:00", "1999-04-29 22:00:00", 
"1999-09-30 21:00:00", "2000-04-27 22:00:00", "2000-09-28 21:00:00", 
"2001-04-26 22:00:00", "2001-09-27 21:00:00", "2002-04-25 22:00:00", 
"2002-09-26 21:00:00", "2003-04-24 22:00:00", "2003-09-25 21:00:00", 
"2004-04-29 22:00:00", "2004-09-30 21:00:00", "2005-04-28 22:00:00", 
"2005-09-29 21:00:00", "2006-04-27 22:00:00", "2006-09-21 21:00:00", 
"2007-04-26 22:00:00", "2007-09-06 21:00:00", "2008-04-24 22:00:00", 
"2008-08-28 21:00:00", "2009-04-23 22:00:00", "2009-08-27 21:00:00", 
"2010-04-29 22:00:00", "2010-08-26 21:00:00", "2011-04-28 22:00:00", 
"2011-08-25 21:00:00", "2012-04-26 22:00:00", "2012-08-30 21:00:00", 
"2013-04-25 22:00:00", "2013-08-29 21:00:00", "2014-04-24 22:00:00", 
"2014-08-28 21:00:00", "2015-04-23 22:00:00", "2015-08-27 21:00:00", 
"2016-04-28 22:00:00", "2016-08-25 21:00:00", "2017-04-27 22:00:00", 
"2017-08-31 21:00:00", "2018-04-26 22:00:00", "2018-08-30 21:00:00", 
"2019-04-25 22:00:00", "2019-08-29 21:00:00", "2020-04-23 22:00:00", 
"2020-08-27 21:00:00", "2021-04-29 22:00:00", "2021-08-26 21:00:00", 
"2022-04-28 22:00:00", "2022-08-25 21:00:00", "2023-04-27 22:00:00", 
"2023-08-31 21:00:00", "2024-04-25 22:00:00", "2024-08-29 21:00:00", 
"2025-04-24 22:00:00", "2025-08-28 21:00:00", "2026-04-23 22:00:00", 
"2026-08-27 21:00:00", "2027-04-29 22:00:00", "2027-08-26 21:00:00", 
"2028-04-27 22:00:00", "2028-08-31 21:00:00", "2029-04-26 22:00:00", 
"2029-08-30 21:00:00", "2030-04-25 22:00:00", "2030-08-29 21:00:00", 
"2031-04-24 22:00:00", "2031-08-28 21:00:00", "2032-04-29 22:00:00", 
"2032-08-26 21:00:00", "2033-04-28 22:00:00", "2033-08-25 21:00:00", 
"2034-04-27 22:00:00", "2034-08-31 21:00:00", "2035-04-26 22:00:00", 
"2035-08-30 21:00:00", "2036-04-24 22:00:00", "2036-08-28 21:00:00", 
"2037-04-23 22:00:00"), offSet = c("7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800"), isdst = c("0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST")), .Names = c("Cairo", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -174L), class = "data.frame")
}

"El_Aaiun" <- function () {
structure(list(El_Aaiun = c("1901-12-14 20:45:52", "1934-01-01 00:52:48"
), offSet = c("-3168", "-3600"), isdst = c("0", "0"), TimeZone = c("WET", 
"WET")), .Names = c("El_Aaiun", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Asmara" <- function () {
structure(list(Asmara = "1901-12-14 20:45:52", offSet = "9320", 
    isdst = "0", TimeZone = "EAT"), .Names = c("Asmara", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Madrid" <- function () {
structure(list(Madrid = c("1901-12-14 20:45:52", "1917-05-05 23:00:00", 
"1917-10-06 23:00:00", "1918-04-15 23:00:00", "1918-10-06 23:00:00", 
"1919-04-05 23:00:00", "1919-10-06 23:00:00", "1924-04-16 23:00:00", 
"1924-10-04 23:00:00", "1926-04-17 23:00:00", "1926-10-02 23:00:00", 
"1927-04-09 23:00:00", "1927-10-01 23:00:00", "1928-04-14 23:00:00", 
"1928-10-06 23:00:00", "1929-04-20 23:00:00", "1929-10-05 23:00:00", 
"1937-05-22 23:00:00", "1937-10-02 23:00:00", "1938-03-22 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-10-07 23:00:00", 
"1940-03-16 23:00:00", "1942-05-02 22:00:00", "1942-09-01 22:00:00", 
"1943-04-17 22:00:00", "1943-10-03 22:00:00", "1944-04-15 22:00:00", 
"1944-10-10 22:00:00", "1945-04-14 22:00:00", "1945-09-29 23:00:00", 
"1946-04-13 22:00:00", "1946-09-29 22:00:00", "1949-04-30 22:00:00", 
"1949-09-29 23:00:00", "1974-04-13 22:00:00", "1974-10-05 23:00:00", 
"1975-04-19 22:00:00", "1975-10-04 23:00:00", "1976-03-27 22:00:00", 
"1976-09-25 23:00:00", "1977-04-02 22:00:00", "1977-09-24 23:00:00", 
"1978-04-02 22:00:00", "1978-09-30 23:00:00", "1979-04-01 01:00:00", 
"1979-09-30 01:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "1", "1", 
"1", "1", "1", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CEST", "CEST", "CEST", "CEST", "CEST", 
"CEST", "CEST", "CEST", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
)), .Names = c("Madrid", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-163L), class = "data.frame")
}

"Ceuta" <- function () {
structure(list(Ceuta = c("1901-12-14 20:45:52", "1918-05-06 23:00:00", 
"1918-10-07 22:00:00", "1924-04-16 23:00:00", "1924-10-04 23:00:00", 
"1926-04-17 23:00:00", "1926-10-02 23:00:00", "1927-04-09 23:00:00", 
"1927-10-01 23:00:00", "1928-04-14 23:00:00", "1928-10-06 23:00:00", 
"1967-06-03 12:00:00", "1967-09-30 23:00:00", "1974-06-24 00:00:00", 
"1974-08-31 23:00:00", "1976-05-01 00:00:00", "1976-07-31 23:00:00", 
"1977-05-01 00:00:00", "1977-09-27 23:00:00", "1978-06-01 00:00:00", 
"1978-08-03 23:00:00", "1984-03-16 00:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200"), isdst = c("0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST")), .Names = c("Ceuta", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -125L), class = "data.frame")
}

"Canary" <- function () {
structure(list(Canary = c("1901-12-14 20:45:52", "1922-03-01 01:01:36", 
"1946-09-30 02:00:00", "1980-04-06 00:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("-3696", 
"-3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("WET", "WET", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST")), .Names = c("Canary", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -118L), class = "data.frame")
}

"Addis_Ababa" <- function () {
structure(list(Addis_Ababa = "1901-12-14 20:45:52", offSet = "9320", 
    isdst = "0", TimeZone = "EAT"), .Names = c("Addis_Ababa", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Helsinki" <- function () {
structure(list(Helsinki = c("1901-12-14 20:45:52", "1921-04-30 22:20:08", 
"1942-04-02 22:00:00", "1942-10-02 21:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("5992", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("EET", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Helsinki", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Fiji" <- function () {
structure(list(Fiji = c("1901-12-14 20:45:52", "1915-10-25 12:06:20", 
"1998-10-31 14:00:00", "1999-02-27 14:00:00", "1999-11-06 14:00:00"
), offSet = c("42820", "43200", "46800", "43200", "46800"), isdst = c("0", 
"0", "1", "0", "1"), TimeZone = c("FJT", "FJT", "FJST", "FJT", 
"FJST")), .Names = c("Fiji", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-5L), class = "data.frame")
}

"Stanley" <- function () {
structure(list(Stanley = c("1901-12-14 20:45:52", "1912-03-12 03:51:24", 
"1937-09-26 04:00:00", "1938-03-20 03:00:00", "1938-09-25 04:00:00", 
"1939-03-19 03:00:00", "1939-10-01 04:00:00", "1940-03-24 03:00:00", 
"1940-09-29 04:00:00", "1941-03-23 03:00:00", "1941-09-28 04:00:00", 
"1942-03-22 03:00:00", "1942-09-27 04:00:00", "1943-01-01 03:00:00", 
"1983-05-01 04:00:00", "1983-09-25 03:00:00", "1984-04-29 02:00:00", 
"1984-09-16 03:00:00", "1985-09-15 03:00:00", "1986-04-20 03:00:00", 
"1986-09-14 04:00:00", "1987-04-19 03:00:00", "1987-09-13 04:00:00", 
"1988-04-17 03:00:00", "1988-09-11 04:00:00", "1989-04-16 03:00:00", 
"1989-09-10 04:00:00", "1990-04-22 03:00:00", "1990-09-09 04:00:00", 
"1991-04-21 03:00:00", "1991-09-15 04:00:00", "1992-04-19 03:00:00", 
"1992-09-13 04:00:00", "1993-04-18 03:00:00", "1993-09-12 04:00:00", 
"1994-04-17 03:00:00", "1994-09-11 04:00:00", "1995-04-16 03:00:00", 
"1995-09-10 04:00:00", "1996-04-21 03:00:00", "1996-09-15 04:00:00", 
"1997-04-20 03:00:00", "1997-09-14 04:00:00", "1998-04-19 03:00:00", 
"1998-09-13 04:00:00", "1999-04-18 03:00:00", "1999-09-12 04:00:00", 
"2000-04-16 03:00:00", "2000-09-10 04:00:00", "2001-04-15 05:00:00", 
"2001-09-02 06:00:00", "2002-04-21 05:00:00", "2002-09-01 06:00:00", 
"2003-04-20 05:00:00", "2003-09-07 06:00:00", "2004-04-18 05:00:00", 
"2004-09-05 06:00:00", "2005-04-17 05:00:00", "2005-09-04 06:00:00", 
"2006-04-16 05:00:00", "2006-09-03 06:00:00", "2007-04-15 05:00:00", 
"2007-09-02 06:00:00", "2008-04-20 05:00:00", "2008-09-07 06:00:00", 
"2009-04-19 05:00:00", "2009-09-06 06:00:00", "2010-04-18 05:00:00", 
"2010-09-05 06:00:00", "2011-04-17 05:00:00", "2011-09-04 06:00:00", 
"2012-04-15 05:00:00", "2012-09-02 06:00:00", "2013-04-21 05:00:00", 
"2013-09-01 06:00:00", "2014-04-20 05:00:00", "2014-09-07 06:00:00", 
"2015-04-19 05:00:00", "2015-09-06 06:00:00", "2016-04-17 05:00:00", 
"2016-09-04 06:00:00", "2017-04-16 05:00:00", "2017-09-03 06:00:00", 
"2018-04-15 05:00:00", "2018-09-02 06:00:00", "2019-04-21 05:00:00", 
"2019-09-01 06:00:00", "2020-04-19 05:00:00", "2020-09-06 06:00:00", 
"2021-04-18 05:00:00", "2021-09-05 06:00:00", "2022-04-17 05:00:00", 
"2022-09-04 06:00:00", "2023-04-16 05:00:00", "2023-09-03 06:00:00", 
"2024-04-21 05:00:00", "2024-09-01 06:00:00", "2025-04-20 05:00:00", 
"2025-09-07 06:00:00", "2026-04-19 05:00:00", "2026-09-06 06:00:00", 
"2027-04-18 05:00:00", "2027-09-05 06:00:00", "2028-04-16 05:00:00", 
"2028-09-03 06:00:00", "2029-04-15 05:00:00", "2029-09-02 06:00:00", 
"2030-04-21 05:00:00", "2030-09-01 06:00:00", "2031-04-20 05:00:00", 
"2031-09-07 06:00:00", "2032-04-18 05:00:00", "2032-09-05 06:00:00", 
"2033-04-17 05:00:00", "2033-09-04 06:00:00", "2034-04-16 05:00:00", 
"2034-09-03 06:00:00", "2035-04-15 05:00:00", "2035-09-02 06:00:00", 
"2036-04-20 05:00:00", "2036-09-07 06:00:00", "2037-04-19 05:00:00"
), offSet = c("-13884", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"0", "1", "0", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("FKT", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKT", "FKST", "FKT", "FKST", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT")), .Names = c("Stanley", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-122L), class = "data.frame")
}

"Truk" <- function () {
structure(list(Truk = "1901-12-14 20:45:52", offSet = "36000", 
    isdst = "0", TimeZone = "TRUT"), .Names = c("Truk", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Ponape" <- function () {
structure(list(Ponape = "1901-12-14 20:45:52", offSet = "39600", 
    isdst = "0", TimeZone = "PONT"), .Names = c("Ponape", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Kosrae" <- function () {
structure(list(Kosrae = c("1901-12-14 20:45:52", "1969-09-30 13:00:00"
), offSet = c("39600", "43200"), isdst = c("0", "0"), TimeZone = c("KOST", 
"KOST")), .Names = c("Kosrae", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Faroe" <- function () {
structure(list(Faroe = c("1901-12-14 20:45:52", "1908-01-11 00:27:04", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("-1624", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("WET", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST")), .Names = c("Faroe", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -115L), class = "data.frame")
}

"Paris" <- function () {
structure(list(Paris = c("1901-12-14 20:45:52", "1911-03-10 23:51:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-10-25 23:00:00", 
"1922-03-25 23:00:00", "1922-10-07 23:00:00", "1923-05-26 23:00:00", 
"1923-10-06 23:00:00", "1924-03-29 23:00:00", "1924-10-04 23:00:00", 
"1925-04-04 23:00:00", "1925-10-03 23:00:00", "1926-04-17 23:00:00", 
"1926-10-02 23:00:00", "1927-04-09 23:00:00", "1927-10-01 23:00:00", 
"1928-04-14 23:00:00", "1928-10-06 23:00:00", "1929-04-20 23:00:00", 
"1929-10-05 23:00:00", "1930-04-12 23:00:00", "1930-10-04 23:00:00", 
"1931-04-18 23:00:00", "1931-10-03 23:00:00", "1932-04-02 23:00:00", 
"1932-10-01 23:00:00", "1933-03-25 23:00:00", "1933-10-07 23:00:00", 
"1934-04-07 23:00:00", "1934-10-06 23:00:00", "1935-03-30 23:00:00", 
"1935-10-05 23:00:00", "1936-04-18 23:00:00", "1936-10-03 23:00:00", 
"1937-04-03 23:00:00", "1937-10-02 23:00:00", "1938-03-26 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-11-18 23:00:00", 
"1940-02-25 02:00:00", "1940-06-14 22:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-07 23:00:00", "1945-04-02 01:00:00", "1945-09-16 01:00:00", 
"1976-03-28 00:00:00", "1976-09-25 23:00:00", "1977-04-03 01:00:00", 
"1977-09-25 01:00:00", "1978-04-02 01:00:00", "1978-10-01 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("561", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", 
"1", "0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
    "CEST", "CET", "CEST", "CET", "CEST", "CEST", "CET", "CEST", 
    "CET", "CEST", "CEST", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Paris", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-182L), class = "data.frame")
}

"Libreville" <- function () {
structure(list(Libreville = "1901-12-14 20:45:52", offSet = "2268", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Libreville", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"London" <- function () {
structure(list(London = c("1901-12-14 20:45:52", "1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-10-26 23:00:00", "1971-10-31 02:00:00", "1972-03-19 02:00:00", 
"1972-10-29 02:00:00", "1973-03-18 02:00:00", "1973-10-28 02:00:00", 
"1974-03-17 02:00:00", "1974-10-27 02:00:00", "1975-03-16 02:00:00", 
"1975-10-26 02:00:00", "1976-03-21 02:00:00", "1976-10-24 02:00:00", 
"1977-03-20 02:00:00", "1977-10-23 02:00:00", "1978-03-19 02:00:00", 
"1978-10-29 02:00:00", "1979-03-18 02:00:00", "1979-10-28 02:00:00", 
"1980-03-16 02:00:00", "1980-10-26 02:00:00", "1981-03-29 01:00:00", 
"1981-10-25 01:00:00", "1982-03-28 01:00:00", "1982-10-24 01:00:00", 
"1983-03-27 01:00:00", "1983-10-23 01:00:00", "1984-03-25 01:00:00", 
"1984-10-28 01:00:00", "1985-03-31 01:00:00", "1985-10-27 01:00:00", 
"1986-03-30 01:00:00", "1986-10-26 01:00:00", "1987-03-29 01:00:00", 
"1987-10-25 01:00:00", "1988-03-27 01:00:00", "1988-10-23 01:00:00", 
"1989-03-26 01:00:00", "1989-10-29 01:00:00", "1990-03-25 01:00:00", 
"1990-10-28 01:00:00", "1991-03-31 01:00:00", "1991-10-27 01:00:00", 
"1992-03-29 01:00:00", "1992-10-25 01:00:00", "1993-03-28 01:00:00", 
"1993-10-24 01:00:00", "1994-03-27 01:00:00", "1994-10-23 01:00:00", 
"1995-03-26 01:00:00", "1995-10-22 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "0", "1", 
"0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "BST", "BST", "BST", "BST", "BST", 
"BST", "BST", "BST", "BST", "BST", "GMT", "BST", "GMT", "BST", 
"BST", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "GMT", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST")), .Names = c("London", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -240L), class = "data.frame")
}

"Grenada" <- function () {
structure(list(Grenada = "1901-12-14 20:45:52", offSet = "-14820", 
    isdst = "0", TimeZone = "AST"), .Names = c("Grenada", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Tbilisi" <- function () {
structure(list(Tbilisi = c("1901-12-14 20:45:52", "1924-05-01 21:00:44", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-03-30 22:00:00", 
"1991-09-28 23:00:00", "1992-03-28 21:00:00", "1992-09-26 20:00:00", 
"1993-03-27 21:00:00", "1993-09-25 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 19:00:00", "1996-03-30 20:00:00", 
"1997-10-25 19:00:00", "1998-03-28 20:00:00", "1998-10-24 19:00:00", 
"1999-03-27 20:00:00", "1999-10-30 19:00:00", "2000-03-25 20:00:00", 
"2000-10-28 19:00:00", "2001-03-24 20:00:00", "2001-10-27 19:00:00", 
"2002-03-30 20:00:00", "2002-10-26 19:00:00", "2003-03-29 20:00:00", 
"2003-10-25 19:00:00", "2004-03-27 20:00:00", "2004-06-26 19:00:00", 
"2004-10-30 23:00:00"), offSet = c("10756", "10800", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "10800"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "1", "0", "1", "0", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "1", "0"), TimeZone = c("GET", "GET", "GET", "GEST", 
"GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", 
"GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", 
"GEST", "GET", "GEST", "GET", "GEST", "GET", "GET", "GEST", "GET", 
"GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", 
"GET", "GEST", "GET", "GEST", "GET", "GEST", "GEST", "GET")), .Names = c("Tbilisi", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -48L), class = "data.frame")
}

"Cayenne" <- function () {
structure(list(Cayenne = c("1901-12-14 20:45:52", "1911-07-01 03:29:20"
), offSet = c("-12560", "-14400"), isdst = c("0", "0"), TimeZone = c("GFT", 
"GFT")), .Names = c("Cayenne", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Guernsey" <- function () {
structure(list(Guernsey = c("1901-12-14 20:45:52", "1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-10-26 23:00:00", "1971-10-31 02:00:00", "1972-03-19 02:00:00", 
"1972-10-29 02:00:00", "1973-03-18 02:00:00", "1973-10-28 02:00:00", 
"1974-03-17 02:00:00", "1974-10-27 02:00:00", "1975-03-16 02:00:00", 
"1975-10-26 02:00:00", "1976-03-21 02:00:00", "1976-10-24 02:00:00", 
"1977-03-20 02:00:00", "1977-10-23 02:00:00", "1978-03-19 02:00:00", 
"1978-10-29 02:00:00", "1979-03-18 02:00:00", "1979-10-28 02:00:00", 
"1980-03-16 02:00:00", "1980-10-26 02:00:00", "1981-03-29 01:00:00", 
"1981-10-25 01:00:00", "1982-03-28 01:00:00", "1982-10-24 01:00:00", 
"1983-03-27 01:00:00", "1983-10-23 01:00:00", "1984-03-25 01:00:00", 
"1984-10-28 01:00:00", "1985-03-31 01:00:00", "1985-10-27 01:00:00", 
"1986-03-30 01:00:00", "1986-10-26 01:00:00", "1987-03-29 01:00:00", 
"1987-10-25 01:00:00", "1988-03-27 01:00:00", "1988-10-23 01:00:00", 
"1989-03-26 01:00:00", "1989-10-29 01:00:00", "1990-03-25 01:00:00", 
"1990-10-28 01:00:00", "1991-03-31 01:00:00", "1991-10-27 01:00:00", 
"1992-03-29 01:00:00", "1992-10-25 01:00:00", "1993-03-28 01:00:00", 
"1993-10-24 01:00:00", "1994-03-27 01:00:00", "1994-10-23 01:00:00", 
"1995-03-26 01:00:00", "1995-10-22 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "0", "1", 
"0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "BST", "BST", "BST", "BST", "BST", 
"BST", "BST", "BST", "BST", "BST", "GMT", "BST", "GMT", "BST", 
"BST", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "GMT", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST")), .Names = c("Guernsey", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -240L), class = "data.frame")
}

"Accra" <- function () {
structure(list(Accra = c("1901-12-14 20:45:52", "1918-01-01 00:00:52", 
"1936-09-01 00:00:00", "1936-12-30 23:40:00", "1937-09-01 00:00:00", 
"1937-12-30 23:40:00", "1938-09-01 00:00:00", "1938-12-30 23:40:00", 
"1939-09-01 00:00:00", "1939-12-30 23:40:00", "1940-09-01 00:00:00", 
"1940-12-30 23:40:00", "1941-09-01 00:00:00", "1941-12-30 23:40:00", 
"1942-09-01 00:00:00"), offSet = c("-52", "0", "1200", "0", "1200", 
"0", "1200", "0", "1200", "0", "1200", "0", "1200", "0", "1200"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("GMT", "GMT", "GHST", 
"GMT", "GHST", "GMT", "GHST", "GMT", "GHST", "GMT", "GHST", "GMT", 
"GHST", "GMT", "GHST")), .Names = c("Accra", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -15L), class = "data.frame")
}

"Gibraltar" <- function () {
structure(list(Gibraltar = c("1901-12-14 20:45:52", "1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "0", "3600", "0", "3600", "7200", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "0", "1", 
"0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CEST", "CEST", "CEST", "CEST", "CEST", "CEST", 
"CEST", "CEST", "CEST", "CEST", "CET", "CEST", "CET", "CEST", 
"CEST", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Gibraltar", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -197L), class = "data.frame")
}

"Godthab" <- function () {
structure(list(Godthab = c("1901-12-14 20:45:52", "1916-07-28 03:26:56", 
"1980-04-06 05:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("-12416", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("WGT", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST")), .Names = c("Godthab", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Danmarkshavn" <- function () {
structure(list(Danmarkshavn = c("1901-12-14 20:45:52", "1916-07-28 01:14:40", 
"1980-04-06 05:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00"), offSet = c("-4480", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0"), TimeZone = c("GMT", "GMT", 
"WGST", "GMT", "WGST", "GMT", "WGST", "GMT", "WGST", "GMT", "WGST", 
"GMT", "WGST", "GMT", "WGST", "GMT", "WGST", "GMT", "WGST", "GMT", 
"WGST", "GMT", "WGST", "GMT", "WGST", "GMT", "WGST", "GMT", "WGST", 
"GMT", "WGST", "GMT", "WGST", "GMT")), .Names = c("Danmarkshavn", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -34L), class = "data.frame")
}

"Scoresbysund" <- function () {
structure(list(Scoresbysund = c("1901-12-14 20:45:52", "1916-07-28 01:27:52", 
"1980-04-06 04:00:00", "1980-09-28 04:00:00", "1981-03-29 02:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("-5272", "-7200", "-3600", 
"-7200", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EGT", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST")), .Names = c("Scoresbysund", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Thule" <- function () {
structure(list(Thule = c("1901-12-14 20:45:52", "1916-07-28 04:35:08", 
"1991-03-31 06:00:00", "1991-09-29 05:00:00", "1992-03-29 06:00:00", 
"1992-09-27 05:00:00", "1993-04-04 06:00:00", "1993-10-31 05:00:00", 
"1994-04-03 06:00:00", "1994-10-30 05:00:00", "1995-04-02 06:00:00", 
"1995-10-29 05:00:00", "1996-04-07 06:00:00", "1996-10-27 05:00:00", 
"1997-04-06 06:00:00", "1997-10-26 05:00:00", "1998-04-05 06:00:00", 
"1998-10-25 05:00:00", "1999-04-04 06:00:00", "1999-10-31 05:00:00", 
"2000-04-02 06:00:00", "2000-10-29 05:00:00", "2001-04-01 06:00:00", 
"2001-10-28 05:00:00", "2002-04-07 06:00:00", "2002-10-27 05:00:00", 
"2003-04-06 06:00:00", "2003-10-26 05:00:00", "2004-04-04 06:00:00", 
"2004-10-31 05:00:00", "2005-04-03 06:00:00", "2005-10-30 05:00:00", 
"2006-04-02 06:00:00", "2006-10-29 05:00:00", "2007-03-11 06:00:00", 
"2007-11-04 05:00:00", "2008-03-09 06:00:00", "2008-11-02 05:00:00", 
"2009-03-08 06:00:00", "2009-11-01 05:00:00", "2010-03-14 06:00:00", 
"2010-11-07 05:00:00", "2011-03-13 06:00:00", "2011-11-06 05:00:00", 
"2012-03-11 06:00:00", "2012-11-04 05:00:00", "2013-03-10 06:00:00", 
"2013-11-03 05:00:00", "2014-03-09 06:00:00", "2014-11-02 05:00:00", 
"2015-03-08 06:00:00", "2015-11-01 05:00:00", "2016-03-13 06:00:00", 
"2016-11-06 05:00:00", "2017-03-12 06:00:00", "2017-11-05 05:00:00", 
"2018-03-11 06:00:00", "2018-11-04 05:00:00", "2019-03-10 06:00:00", 
"2019-11-03 05:00:00", "2020-03-08 06:00:00", "2020-11-01 05:00:00", 
"2021-03-14 06:00:00", "2021-11-07 05:00:00", "2022-03-13 06:00:00", 
"2022-11-06 05:00:00", "2023-03-12 06:00:00", "2023-11-05 05:00:00", 
"2024-03-10 06:00:00", "2024-11-03 05:00:00", "2025-03-09 06:00:00", 
"2025-11-02 05:00:00", "2026-03-08 06:00:00", "2026-11-01 05:00:00", 
"2027-03-14 06:00:00", "2027-11-07 05:00:00", "2028-03-12 06:00:00", 
"2028-11-05 05:00:00", "2029-03-11 06:00:00", "2029-11-04 05:00:00", 
"2030-03-10 06:00:00", "2030-11-03 05:00:00", "2031-03-09 06:00:00", 
"2031-11-02 05:00:00", "2032-03-14 06:00:00", "2032-11-07 05:00:00", 
"2033-03-13 06:00:00", "2033-11-06 05:00:00", "2034-03-12 06:00:00", 
"2034-11-05 05:00:00", "2035-03-11 06:00:00", "2035-11-04 05:00:00", 
"2036-03-09 06:00:00", "2036-11-02 05:00:00", "2037-03-08 06:00:00"
), offSet = c("-16508", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1"), TimeZone = c("AST", "AST", "ADT", "AST", "ADT", "AST", 
    "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
    "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
    "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
    "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
    "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
    "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT")), .Names = c("Thule", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -95L), class = "data.frame")
}

"Banjul" <- function () {
structure(list(Banjul = c("1901-12-14 20:45:52", "1935-01-01 01:06:36"
), offSet = c("-3996", "-3600"), isdst = c("0", "0"), TimeZone = c("GMT", 
"GMT")), .Names = c("Banjul", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Conakry" <- function () {
structure(list(Conakry = c("1901-12-14 20:45:52", "1912-01-01 00:54:52", 
"1934-02-26 00:00:00"), offSet = c("-3292", "0", "-3600"), isdst = c("0", 
"0", "0"), TimeZone = c("GMT", "GMT", "GMT")), .Names = c("Conakry", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Guadeloupe" <- function () {
structure(list(Guadeloupe = "1901-12-14 20:45:52", offSet = "-14768", 
    isdst = "0", TimeZone = "AST"), .Names = c("Guadeloupe", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Malabo" <- function () {
structure(list(Malabo = c("1901-12-14 20:45:52", "1911-12-31 23:24:52"
), offSet = c("2108", "0"), isdst = c("0", "0"), TimeZone = c("WAT", 
"WAT")), .Names = c("Malabo", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Athens" <- function () {
structure(list(Athens = c("1901-12-14 20:45:52", "1916-07-27 22:26:08", 
"1932-07-06 22:00:00", "1932-08-31 21:00:00", "1941-04-06 22:00:00", 
"1941-04-29 21:00:00", "1942-11-02 01:00:00", "1943-03-29 23:00:00", 
"1943-10-03 22:00:00", "1944-04-03 23:00:00", "1952-06-30 22:00:00", 
"1952-11-01 21:00:00", "1975-04-11 22:00:00", "1975-11-25 22:00:00", 
"1976-04-11 00:00:00", "1976-10-10 00:00:00", "1977-04-03 00:00:00", 
"1977-09-26 00:00:00", "1978-04-02 00:00:00", "1978-09-24 01:00:00", 
"1979-04-01 07:00:00", "1979-09-28 23:00:00", "1980-03-31 22:00:00", 
"1980-09-27 21:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("5692", "7200", "10800", "7200", "10800", "7200", 
"3600", "7200", "3600", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800"), isdst = c("0", "0", "1", "0", "1", 
"1", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("EET", "EET", "EEST", "EET", "EEST", 
"EEST", "EET", "EEST", "EET", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Athens", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -137L), class = "data.frame")
}

"South_Georgia" <- function () {
structure(list(South_Georgia = "1901-12-14 20:45:52", offSet = "-7200", 
    isdst = "0", TimeZone = "GST"), .Names = c("South_Georgia", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Guatemala" <- function () {
structure(list(Guatemala = c("1901-12-14 20:45:52", "1918-10-05 06:02:04", 
"1973-11-25 06:00:00", "1974-02-24 05:00:00", "1983-05-21 06:00:00", 
"1983-09-22 05:00:00", "1991-03-23 06:00:00", "1991-09-07 05:00:00", 
"2006-04-30 06:00:00"), offSet = c("-21724", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Guatemala", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -9L), class = "data.frame")
}

"Guam" <- function () {
structure(list(Guam = "1901-12-14 20:45:52", offSet = "36000", 
    isdst = "0", TimeZone = "ChST"), .Names = c("Guam", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Bissau" <- function () {
structure(list(Bissau = c("1901-12-14 20:45:52", "1911-05-26 01:02:20"
), offSet = c("-3740", "-3600"), isdst = c("0", "0"), TimeZone = c("GMT", 
"GMT")), .Names = c("Bissau", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Guyana" <- function () {
structure(list(Guyana = c("1901-12-14 20:45:52", "1915-03-01 03:52:40", 
"1975-07-31 03:45:00"), offSet = c("-13960", "-13500", "-10800"
), isdst = c("0", "0", "0"), TimeZone = c("GYT", "GYT", "GYT"
)), .Names = c("Guyana", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Hong_Kong" <- function () {
structure(list(Hong_Kong = c("1901-12-14 20:45:52", "1904-10-29 16:23:24", 
"1946-04-19 19:30:00", "1946-11-30 18:30:00", "1947-04-12 19:30:00", 
"1947-12-29 18:30:00", "1948-05-01 19:30:00", "1948-10-30 18:30:00", 
"1949-04-02 19:30:00", "1949-10-29 18:30:00", "1950-04-01 19:30:00", 
"1950-10-28 18:30:00", "1951-03-31 19:30:00", "1951-10-27 18:30:00", 
"1952-04-05 19:30:00", "1952-10-25 18:30:00", "1953-04-04 19:30:00", 
"1953-10-31 18:30:00", "1954-03-20 19:30:00", "1954-10-30 18:30:00", 
"1955-03-19 19:30:00", "1955-11-05 18:30:00", "1956-03-17 19:30:00", 
"1956-11-03 18:30:00", "1957-03-23 19:30:00", "1957-11-02 18:30:00", 
"1958-03-22 19:30:00", "1958-11-01 18:30:00", "1959-03-21 19:30:00", 
"1959-10-31 18:30:00", "1960-03-19 19:30:00", "1960-11-05 18:30:00", 
"1961-03-18 19:30:00", "1961-11-04 18:30:00", "1962-03-17 19:30:00", 
"1962-11-03 18:30:00", "1963-03-23 19:30:00", "1963-11-02 18:30:00", 
"1964-03-21 19:30:00", "1964-10-31 18:30:00", "1965-04-17 19:30:00", 
"1965-10-16 18:30:00", "1966-04-16 19:30:00", "1966-10-15 18:30:00", 
"1967-04-15 19:30:00", "1967-10-21 18:30:00", "1968-04-20 19:30:00", 
"1968-10-19 18:30:00", "1969-04-19 19:30:00", "1969-10-18 18:30:00", 
"1970-04-18 19:30:00", "1970-10-17 18:30:00", "1971-04-17 19:30:00", 
"1971-10-16 18:30:00", "1972-04-15 19:30:00", "1972-10-21 18:30:00", 
"1973-04-21 19:30:00", "1973-10-20 18:30:00", "1974-04-20 19:30:00", 
"1974-10-19 18:30:00", "1975-04-19 19:30:00", "1975-10-18 18:30:00", 
"1976-04-17 19:30:00", "1976-10-16 18:30:00", "1977-04-16 19:30:00", 
"1977-10-15 18:30:00", "1979-05-12 19:30:00", "1979-10-20 18:30:00", 
"1980-05-10 19:30:00"), offSet = c("27396", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("HKT", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
    "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST")), .Names = c("Hong_Kong", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -69L), class = "data.frame")
}

"Tegucigalpa" <- function () {
structure(list(Tegucigalpa = c("1901-12-14 20:45:52", "1921-04-01 05:48:52", 
"1987-05-03 06:00:00", "1987-09-27 05:00:00", "1988-05-01 06:00:00", 
"1988-09-25 05:00:00", "2006-05-07 06:00:00"), offSet = c("-20932", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1"), TimeZone = c("CST", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Tegucigalpa", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -7L), class = "data.frame")
}

"Zagreb" <- function () {
structure(list(Zagreb = c("1901-12-14 20:45:52", "1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Zagreb", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Port-au-Prince" <- function () {
structure(list("Port-au-Prince" = c("1901-12-14 20:45:52", "1917-01-24 16:49:00", 
"1983-05-08 05:00:00", "1983-10-30 04:00:00", "1984-04-29 05:00:00", 
"1984-10-28 04:00:00", "1985-04-28 05:00:00", "1985-10-27 04:00:00", 
"1986-04-27 05:00:00", "1986-10-26 04:00:00", "1987-04-26 05:00:00", 
"1987-10-25 04:00:00", "1988-04-03 06:00:00", "1988-10-30 06:00:00", 
"1989-04-02 06:00:00", "1989-10-29 06:00:00", "1990-04-01 06:00:00", 
"1990-10-28 06:00:00", "1991-04-07 06:00:00", "1991-10-27 06:00:00", 
"1992-04-05 06:00:00", "1992-10-25 06:00:00", "1993-04-04 06:00:00", 
"1993-10-31 06:00:00", "1994-04-03 06:00:00", "1994-10-30 06:00:00", 
"1995-04-02 06:00:00", "1995-10-29 06:00:00", "1996-04-07 06:00:00", 
"1996-10-27 06:00:00", "1997-04-06 06:00:00", "1997-10-26 06:00:00", 
"2005-04-03 05:00:00", "2005-10-30 04:00:00", "2006-04-02 05:00:00"
), offSet = c("-17340", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1"), TimeZone = c("EST", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT")), .Names = c("Port-au-Prince", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -35L), class = "data.frame")
}

"Budapest" <- function () {
structure(list(Budapest = c("1901-12-14 20:45:52", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-01 02:00:00", "1918-09-29 01:00:00", "1919-04-15 02:00:00", 
"1919-09-15 01:00:00", "1920-04-05 02:00:00", "1920-09-30 01:00:00", 
"1941-04-06 01:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-10-02 01:00:00", 
"1945-05-01 22:00:00", "1945-11-02 22:00:00", "1946-03-31 01:00:00", 
"1946-10-06 01:00:00", "1947-04-06 01:00:00", "1947-10-05 01:00:00", 
"1948-04-04 01:00:00", "1948-10-03 01:00:00", "1949-04-10 01:00:00", 
"1949-10-02 01:00:00", "1950-04-17 01:00:00", "1950-10-23 01:00:00", 
"1954-05-22 23:00:00", "1954-10-02 22:00:00", "1955-05-22 23:00:00", 
"1955-10-02 22:00:00", "1956-06-02 23:00:00", "1956-09-29 22:00:00", 
"1957-06-02 00:00:00", "1957-09-29 01:00:00", "1980-04-06 00:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200"), isdst = c("0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST")), .Names = c("Budapest", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -152L), class = "data.frame")
}

"Jakarta" <- function () {
structure(list(Jakarta = c("1901-12-14 20:45:52", "1923-12-31 16:40:00", 
"1932-10-31 16:40:00", "1942-03-22 16:30:00", "1945-09-22 15:00:00", 
"1948-04-30 16:30:00", "1950-04-30 16:00:00"), offSet = c("25632", 
"26400", "27000", "32400", "27000", "28800", "27000"), isdst = c("0", 
"0", "0", "0", "0", "0", "0"), TimeZone = c("WIT", "WIT", "WIT", 
"WIT", "WIT", "WIT", "WIT")), .Names = c("Jakarta", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -7L), class = "data.frame")
}

"Pontianak" <- function () {
structure(list(Pontianak = c("1901-12-14 20:45:52", "1932-10-31 16:42:40", 
"1942-01-28 16:30:00", "1945-09-22 15:00:00", "1948-04-30 16:30:00", 
"1950-04-30 16:00:00", "1963-12-31 16:30:00"), offSet = c("26240", 
"27000", "32400", "27000", "28800", "27000", "28800"), isdst = c("0", 
"0", "0", "0", "0", "0", "0"), TimeZone = c("WIT", "WIT", "WIT", 
"WIT", "WIT", "WIT", "WIT")), .Names = c("Pontianak", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -7L), class = "data.frame")
}

"Makassar" <- function () {
structure(list(Makassar = c("1901-12-14 20:45:52", "1932-10-31 16:02:24", 
"1942-02-08 16:00:00"), offSet = c("28656", "28800", "32400"), 
    isdst = c("0", "0", "0"), TimeZone = c("CIT", "CIT", "CIT"
    )), .Names = c("Makassar", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Jayapura" <- function () {
structure(list(Jayapura = c("1901-12-14 20:45:52", "1932-10-31 14:37:12", 
"1944-08-31 15:00:00"), offSet = c("33768", "32400", "34200"), 
    isdst = c("0", "0", "0"), TimeZone = c("EIT", "EIT", "EIT"
    )), .Names = c("Jayapura", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Dublin" <- function () {
structure(list(Dublin = c("1901-12-14 20:45:52", "1916-05-21 02:25:21", 
"1916-10-01 02:25:21", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1946-10-06 01:00:00", "1947-03-16 02:00:00", "1947-11-02 01:00:00", 
"1948-04-18 02:00:00", "1948-10-31 02:00:00", "1949-04-03 02:00:00", 
"1949-10-30 02:00:00", "1950-04-16 02:00:00", "1950-10-22 02:00:00", 
"1951-04-15 02:00:00", "1951-10-21 02:00:00", "1952-04-20 02:00:00", 
"1952-10-26 02:00:00", "1953-04-19 02:00:00", "1953-10-04 02:00:00", 
"1954-04-11 02:00:00", "1954-10-03 02:00:00", "1955-04-17 02:00:00", 
"1955-10-02 02:00:00", "1956-04-22 02:00:00", "1956-10-07 02:00:00", 
"1957-04-14 02:00:00", "1957-10-06 02:00:00", "1958-04-20 02:00:00", 
"1958-10-05 02:00:00", "1959-04-19 02:00:00", "1959-10-04 02:00:00", 
"1960-04-10 02:00:00", "1960-10-02 02:00:00", "1961-03-26 02:00:00", 
"1961-10-29 02:00:00", "1962-03-25 02:00:00", "1962-10-28 02:00:00", 
"1963-03-31 02:00:00", "1963-10-27 02:00:00", "1964-03-22 02:00:00", 
"1964-10-25 02:00:00", "1965-03-21 02:00:00", "1965-10-24 02:00:00", 
"1966-03-20 02:00:00", "1966-10-23 02:00:00", "1967-03-19 02:00:00", 
"1967-10-29 02:00:00", "1968-10-26 23:00:00", "1971-10-31 02:00:00", 
"1972-03-19 02:00:00", "1972-10-29 02:00:00", "1973-03-18 02:00:00", 
"1973-10-28 02:00:00", "1974-03-17 02:00:00", "1974-10-27 02:00:00", 
"1975-03-16 02:00:00", "1975-10-26 02:00:00", "1976-03-21 02:00:00", 
"1976-10-24 02:00:00", "1977-03-20 02:00:00", "1977-10-23 02:00:00", 
"1978-03-19 02:00:00", "1978-10-29 02:00:00", "1979-03-18 02:00:00", 
"1979-10-28 02:00:00", "1980-03-16 02:00:00", "1980-10-26 02:00:00", 
"1981-03-29 01:00:00", "1981-10-25 01:00:00", "1982-03-28 01:00:00", 
"1982-10-24 01:00:00", "1983-03-27 01:00:00", "1983-10-23 01:00:00", 
"1984-03-25 01:00:00", "1984-10-28 01:00:00", "1985-03-31 01:00:00", 
"1985-10-27 01:00:00", "1986-03-30 01:00:00", "1986-10-26 01:00:00", 
"1987-03-29 01:00:00", "1987-10-25 01:00:00", "1988-03-27 01:00:00", 
"1988-10-23 01:00:00", "1989-03-26 01:00:00", "1989-10-29 01:00:00", 
"1990-03-25 01:00:00", "1990-10-28 01:00:00", "1991-03-31 01:00:00", 
"1991-10-27 01:00:00", "1992-03-29 01:00:00", "1992-10-25 01:00:00", 
"1993-03-28 01:00:00", "1993-10-24 01:00:00", "1994-03-27 01:00:00", 
"1994-10-23 01:00:00", "1995-03-26 01:00:00", "1995-10-22 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("-1521", 
"2079", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "GMT", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", 
"IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", "GMT", "IST", 
"GMT", "IST", "GMT", "IST")), .Names = c("Dublin", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -226L), class = "data.frame")
}

"Jerusalem" <- function () {
structure(list(Jerusalem = c("1901-12-14 20:45:52", "1917-12-31 21:39:20", 
"1940-05-31 22:00:00", "1942-10-31 21:00:00", "1943-04-01 00:00:00", 
"1943-10-31 21:00:00", "1944-03-31 22:00:00", "1944-10-31 21:00:00", 
"1945-04-15 22:00:00", "1945-10-31 23:00:00", "1946-04-16 00:00:00", 
"1946-10-31 21:00:00", "1948-05-22 22:00:00", "1948-08-31 20:00:00", 
"1948-10-31 23:00:00", "1949-04-30 22:00:00", "1949-10-31 23:00:00", 
"1950-04-15 22:00:00", "1950-09-15 00:00:00", "1951-03-31 22:00:00", 
"1951-11-11 00:00:00", "1952-04-20 00:00:00", "1952-10-19 00:00:00", 
"1953-04-12 00:00:00", "1953-09-13 00:00:00", "1954-06-12 22:00:00", 
"1954-09-11 21:00:00", "1955-06-11 00:00:00", "1955-09-10 21:00:00", 
"1956-06-02 22:00:00", "1956-09-30 00:00:00", "1957-04-29 00:00:00", 
"1957-09-21 21:00:00", "1974-07-06 22:00:00", "1974-10-12 21:00:00", 
"1975-04-19 22:00:00", "1975-08-30 21:00:00", "1985-04-13 22:00:00", 
"1985-09-14 21:00:00", "1986-05-17 22:00:00", "1986-09-06 21:00:00", 
"1987-04-14 22:00:00", "1987-09-12 21:00:00", "1988-04-08 22:00:00", 
"1988-09-02 21:00:00", "1989-04-29 22:00:00", "1989-09-02 21:00:00", 
"1990-03-24 22:00:00", "1990-08-25 21:00:00", "1991-03-23 22:00:00", 
"1991-08-31 21:00:00", "1992-03-28 22:00:00", "1992-09-05 21:00:00", 
"1993-04-01 22:00:00", "1993-09-04 21:00:00", "1994-03-31 22:00:00", 
"1994-08-27 21:00:00", "1995-03-30 22:00:00", "1995-09-02 21:00:00", 
"1996-03-14 22:00:00", "1996-09-15 21:00:00", "1997-03-20 22:00:00", 
"1997-09-13 21:00:00", "1998-03-19 22:00:00", "1998-09-05 21:00:00", 
"1999-04-02 00:00:00", "1999-09-02 23:00:00", "2000-04-14 00:00:00", 
"2000-10-05 22:00:00", "2001-04-08 23:00:00", "2001-09-23 22:00:00", 
"2002-03-28 23:00:00", "2002-10-06 22:00:00", "2003-03-27 23:00:00", 
"2003-10-02 22:00:00", "2004-04-06 23:00:00", "2004-09-21 22:00:00", 
"2005-04-01 00:00:00", "2005-10-08 23:00:00", "2006-03-31 00:00:00", 
"2006-09-30 23:00:00", "2007-03-30 00:00:00", "2007-09-15 23:00:00", 
"2008-03-28 00:00:00", "2008-10-04 23:00:00", "2009-03-27 00:00:00", 
"2009-09-26 23:00:00", "2010-03-26 00:00:00", "2010-09-11 23:00:00", 
"2011-04-01 00:00:00", "2011-10-01 23:00:00", "2012-03-30 00:00:00", 
"2012-09-22 23:00:00", "2013-03-29 00:00:00", "2013-09-07 23:00:00", 
"2014-03-28 00:00:00", "2014-09-27 23:00:00", "2015-03-27 00:00:00", 
"2015-09-19 23:00:00", "2016-04-01 00:00:00", "2016-10-08 23:00:00", 
"2017-03-31 00:00:00", "2017-09-23 23:00:00", "2018-03-30 00:00:00", 
"2018-09-15 23:00:00", "2019-03-29 00:00:00", "2019-10-05 23:00:00", 
"2020-03-27 00:00:00", "2020-09-26 23:00:00", "2021-03-26 00:00:00", 
"2021-09-11 23:00:00", "2022-04-01 00:00:00", "2022-10-01 23:00:00", 
"2023-03-31 00:00:00", "2023-09-23 23:00:00", "2024-03-29 00:00:00", 
"2024-10-05 23:00:00", "2025-03-28 00:00:00", "2025-09-27 23:00:00", 
"2026-03-27 00:00:00", "2026-09-19 23:00:00", "2027-03-26 00:00:00", 
"2027-10-09 23:00:00", "2028-03-31 00:00:00", "2028-09-23 23:00:00", 
"2029-03-30 00:00:00", "2029-09-15 23:00:00", "2030-03-29 00:00:00", 
"2030-10-05 23:00:00", "2031-03-28 00:00:00", "2031-09-20 23:00:00", 
"2032-03-26 00:00:00", "2032-09-11 23:00:00", "2033-04-01 00:00:00", 
"2033-10-01 23:00:00", "2034-03-31 00:00:00", "2034-09-16 23:00:00", 
"2035-03-30 00:00:00", "2035-10-06 23:00:00", "2036-03-28 00:00:00", 
"2036-09-27 23:00:00", "2037-03-27 00:00:00"), offSet = c("8440", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "14400", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("IST", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT")), .Names = c("Jerusalem", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -142L), class = "data.frame")
}

"Isle_of_Man" <- function () {
structure(list(Isle_of_Man = c("1901-12-14 20:45:52", "1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-10-26 23:00:00", "1971-10-31 02:00:00", "1972-03-19 02:00:00", 
"1972-10-29 02:00:00", "1973-03-18 02:00:00", "1973-10-28 02:00:00", 
"1974-03-17 02:00:00", "1974-10-27 02:00:00", "1975-03-16 02:00:00", 
"1975-10-26 02:00:00", "1976-03-21 02:00:00", "1976-10-24 02:00:00", 
"1977-03-20 02:00:00", "1977-10-23 02:00:00", "1978-03-19 02:00:00", 
"1978-10-29 02:00:00", "1979-03-18 02:00:00", "1979-10-28 02:00:00", 
"1980-03-16 02:00:00", "1980-10-26 02:00:00", "1981-03-29 01:00:00", 
"1981-10-25 01:00:00", "1982-03-28 01:00:00", "1982-10-24 01:00:00", 
"1983-03-27 01:00:00", "1983-10-23 01:00:00", "1984-03-25 01:00:00", 
"1984-10-28 01:00:00", "1985-03-31 01:00:00", "1985-10-27 01:00:00", 
"1986-03-30 01:00:00", "1986-10-26 01:00:00", "1987-03-29 01:00:00", 
"1987-10-25 01:00:00", "1988-03-27 01:00:00", "1988-10-23 01:00:00", 
"1989-03-26 01:00:00", "1989-10-29 01:00:00", "1990-03-25 01:00:00", 
"1990-10-28 01:00:00", "1991-03-31 01:00:00", "1991-10-27 01:00:00", 
"1992-03-29 01:00:00", "1992-10-25 01:00:00", "1993-03-28 01:00:00", 
"1993-10-24 01:00:00", "1994-03-27 01:00:00", "1994-10-23 01:00:00", 
"1995-03-26 01:00:00", "1995-10-22 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "0", "1", 
"0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "BST", "BST", "BST", "BST", "BST", 
"BST", "BST", "BST", "BST", "BST", "GMT", "BST", "GMT", "BST", 
"BST", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "GMT", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST")), .Names = c("Isle_of_Man", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -240L), class = "data.frame")
}

"Calcutta" <- function () {
structure(list(Calcutta = c("1901-12-14 20:45:52", "1941-09-30 18:06:40", 
"1942-05-14 17:30:00", "1942-08-31 18:30:00"), offSet = c("21200", 
"23400", "19800", "23400"), isdst = c("0", "0", "0", "1"), TimeZone = c("IST", 
"IST", "IST", "IST")), .Names = c("Calcutta", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Chagos" <- function () {
structure(list(Chagos = c("1901-12-14 20:45:52", "1906-12-31 19:10:20"
), offSet = c("17380", "18000"), isdst = c("0", "0"), TimeZone = c("IOT", 
"IOT")), .Names = c("Chagos", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Baghdad" <- function () {
structure(list(Baghdad = c("1901-12-14 20:45:52", "1917-12-31 21:02:24", 
"1982-04-30 21:00:00", "1982-09-30 20:00:00", "1983-03-30 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-30 20:00:00", 
"1985-03-31 21:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1990-09-29 22:00:00", 
"1991-04-01 00:00:00", "1991-10-01 00:00:00", "1992-04-01 00:00:00", 
"1992-10-01 00:00:00", "1993-04-01 00:00:00", "1993-10-01 00:00:00", 
"1994-04-01 00:00:00", "1994-10-01 00:00:00", "1995-04-01 00:00:00", 
"1995-10-01 00:00:00", "1996-04-01 00:00:00", "1996-10-01 00:00:00", 
"1997-04-01 00:00:00", "1997-10-01 00:00:00", "1998-04-01 00:00:00", 
"1998-10-01 00:00:00", "1999-04-01 00:00:00", "1999-10-01 00:00:00", 
"2000-04-01 00:00:00", "2000-10-01 00:00:00", "2001-04-01 00:00:00", 
"2001-10-01 00:00:00", "2002-04-01 00:00:00", "2002-10-01 00:00:00", 
"2003-04-01 00:00:00", "2003-10-01 00:00:00", "2004-04-01 00:00:00", 
"2004-10-01 00:00:00", "2005-04-01 00:00:00", "2005-10-01 00:00:00", 
"2006-04-01 00:00:00", "2006-10-01 00:00:00", "2007-04-01 00:00:00", 
"2007-10-01 00:00:00", "2008-04-01 00:00:00", "2008-10-01 00:00:00", 
"2009-04-01 00:00:00", "2009-10-01 00:00:00", "2010-04-01 00:00:00", 
"2010-10-01 00:00:00", "2011-04-01 00:00:00", "2011-10-01 00:00:00", 
"2012-04-01 00:00:00", "2012-10-01 00:00:00", "2013-04-01 00:00:00", 
"2013-10-01 00:00:00", "2014-04-01 00:00:00", "2014-10-01 00:00:00", 
"2015-04-01 00:00:00", "2015-10-01 00:00:00", "2016-04-01 00:00:00", 
"2016-10-01 00:00:00", "2017-04-01 00:00:00", "2017-10-01 00:00:00", 
"2018-04-01 00:00:00", "2018-10-01 00:00:00", "2019-04-01 00:00:00", 
"2019-10-01 00:00:00", "2020-04-01 00:00:00", "2020-10-01 00:00:00", 
"2021-04-01 00:00:00", "2021-10-01 00:00:00", "2022-04-01 00:00:00", 
"2022-10-01 00:00:00", "2023-04-01 00:00:00", "2023-10-01 00:00:00", 
"2024-04-01 00:00:00", "2024-10-01 00:00:00", "2025-04-01 00:00:00", 
"2025-10-01 00:00:00", "2026-04-01 00:00:00", "2026-10-01 00:00:00", 
"2027-04-01 00:00:00", "2027-10-01 00:00:00", "2028-04-01 00:00:00", 
"2028-10-01 00:00:00", "2029-04-01 00:00:00", "2029-10-01 00:00:00", 
"2030-04-01 00:00:00", "2030-10-01 00:00:00", "2031-04-01 00:00:00", 
"2031-10-01 00:00:00", "2032-04-01 00:00:00", "2032-10-01 00:00:00", 
"2033-04-01 00:00:00", "2033-10-01 00:00:00", "2034-04-01 00:00:00", 
"2034-10-01 00:00:00", "2035-04-01 00:00:00", "2035-10-01 00:00:00", 
"2036-04-01 00:00:00", "2036-10-01 00:00:00", "2037-04-01 00:00:00"
), offSet = c("10656", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("AST", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT")), .Names = c("Baghdad", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -113L), class = "data.frame")
}

"Tehran" <- function () {
structure(list(Tehran = c("1901-12-14 20:45:52", "1945-12-31 20:34:16", 
"1977-10-31 20:30:00", "1978-03-20 20:00:00", "1978-10-20 19:00:00", 
"1978-12-31 20:00:00", "1979-03-20 20:30:00", "1979-09-18 19:30:00", 
"1980-03-20 20:30:00", "1980-09-22 19:30:00", "1991-05-02 20:30:00", 
"1991-09-21 19:30:00", "1992-03-21 20:30:00", "1992-09-21 19:30:00", 
"1993-03-21 20:30:00", "1993-09-21 19:30:00", "1994-03-21 20:30:00", 
"1994-09-21 19:30:00", "1995-03-21 20:30:00", "1995-09-21 19:30:00", 
"1996-03-20 20:30:00", "1996-09-20 19:30:00", "1997-03-21 20:30:00", 
"1997-09-21 19:30:00", "1998-03-21 20:30:00", "1998-09-21 19:30:00", 
"1999-03-21 20:30:00", "1999-09-21 19:30:00", "2000-03-20 20:30:00", 
"2000-09-20 19:30:00", "2001-03-21 20:30:00", "2001-09-21 19:30:00", 
"2002-03-21 20:30:00", "2002-09-21 19:30:00", "2003-03-21 20:30:00", 
"2003-09-21 19:30:00", "2004-03-20 20:30:00", "2004-09-20 19:30:00", 
"2005-03-21 20:30:00", "2005-09-21 19:30:00", "2008-03-20 20:30:00", 
"2008-09-20 19:30:00", "2009-03-21 20:30:00", "2009-09-21 19:30:00", 
"2010-03-21 20:30:00", "2010-09-21 19:30:00", "2011-03-21 20:30:00", 
"2011-09-21 19:30:00", "2012-03-20 20:30:00", "2012-09-20 19:30:00", 
"2013-03-21 20:30:00", "2013-09-21 19:30:00", "2014-03-21 20:30:00", 
"2014-09-21 19:30:00", "2015-03-21 20:30:00", "2015-09-21 19:30:00", 
"2016-03-20 20:30:00", "2016-09-20 19:30:00", "2017-03-21 20:30:00", 
"2017-09-21 19:30:00", "2018-03-21 20:30:00", "2018-09-21 19:30:00", 
"2019-03-21 20:30:00", "2019-09-21 19:30:00", "2020-03-20 20:30:00", 
"2020-09-20 19:30:00", "2021-03-21 20:30:00", "2021-09-21 19:30:00", 
"2022-03-21 20:30:00", "2022-09-21 19:30:00", "2023-03-21 20:30:00", 
"2023-09-21 19:30:00", "2024-03-20 20:30:00", "2024-09-20 19:30:00", 
"2025-03-21 20:30:00", "2025-09-21 19:30:00", "2026-03-21 20:30:00", 
"2026-09-21 19:30:00", "2027-03-21 20:30:00", "2027-09-21 19:30:00", 
"2028-03-20 20:30:00", "2028-09-20 19:30:00", "2029-03-20 20:30:00", 
"2029-09-20 19:30:00", "2030-03-21 20:30:00", "2030-09-21 19:30:00", 
"2031-03-21 20:30:00", "2031-09-21 19:30:00", "2032-03-20 20:30:00", 
"2032-09-20 19:30:00", "2033-03-20 20:30:00", "2033-09-20 19:30:00", 
"2034-03-21 20:30:00", "2034-09-21 19:30:00", "2035-03-21 20:30:00", 
"2035-09-21 19:30:00", "2036-03-20 20:30:00", "2036-09-20 19:30:00", 
"2037-03-20 20:30:00"), offSet = c("12344", "12600", "14400", 
"18000", "14400", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200", "12600", "16200", 
"12600", "16200", "12600", "16200", "12600", "16200", "12600", 
"16200", "12600", "16200", "12600", "16200"), isdst = c("0", 
"0", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("IRST", "IRST", 
"IRST", "IRDT", "IRST", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", 
"IRDT")), .Names = c("Tehran", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-99L), class = "data.frame")
}

"Reykjavik" <- function () {
structure(list(Reykjavik = c("1901-12-14 20:45:52", "1908-01-01 01:27:48", 
"1917-02-20 00:00:00", "1917-10-21 01:00:00", "1918-02-20 00:00:00", 
"1918-11-16 01:00:00", "1939-04-30 00:00:00", "1939-11-29 02:00:00", 
"1940-02-25 03:00:00", "1940-11-03 02:00:00", "1941-03-02 02:00:00", 
"1941-11-02 02:00:00", "1942-03-08 02:00:00", "1942-10-25 02:00:00", 
"1943-03-07 02:00:00", "1943-10-24 02:00:00", "1944-03-05 02:00:00", 
"1944-10-22 02:00:00", "1945-03-04 02:00:00", "1945-10-28 02:00:00", 
"1946-03-03 02:00:00", "1946-10-27 02:00:00", "1947-04-06 02:00:00", 
"1947-10-26 02:00:00", "1948-04-04 02:00:00", "1948-10-24 02:00:00", 
"1949-04-03 02:00:00", "1949-10-30 02:00:00", "1950-04-02 02:00:00", 
"1950-10-22 02:00:00", "1951-04-01 02:00:00", "1951-10-28 02:00:00", 
"1952-04-06 02:00:00", "1952-10-26 02:00:00", "1953-04-05 02:00:00", 
"1953-10-25 02:00:00", "1954-04-04 02:00:00", "1954-10-24 02:00:00", 
"1955-04-03 02:00:00", "1955-10-23 02:00:00", "1956-04-01 02:00:00", 
"1956-10-28 02:00:00", "1957-04-07 02:00:00", "1957-10-27 02:00:00", 
"1958-04-06 02:00:00", "1958-10-26 02:00:00", "1959-04-05 02:00:00", 
"1959-10-25 02:00:00", "1960-04-03 02:00:00", "1960-10-23 02:00:00", 
"1961-04-02 02:00:00", "1961-10-22 02:00:00", "1962-04-01 02:00:00", 
"1962-10-28 02:00:00", "1963-04-07 02:00:00", "1963-10-27 02:00:00", 
"1964-04-05 02:00:00", "1964-10-25 02:00:00", "1965-04-04 02:00:00", 
"1965-10-24 02:00:00", "1966-04-03 02:00:00", "1966-10-23 02:00:00", 
"1967-04-02 02:00:00", "1967-10-29 02:00:00"), offSet = c("-5268", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0"), TimeZone = c("GMT", "GMT", "ISST", "GMT", "ISST", 
"GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", 
"ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", 
"GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", 
"ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", 
"GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", 
"ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", "GMT", "ISST", 
"GMT", "ISST", "GMT", "ISST", "GMT")), .Names = c("Reykjavik", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -64L), class = "data.frame")
}

"Rome" <- function () {
structure(list(Rome = c("1901-12-14 20:45:52", "1916-06-02 23:00:00", 
"1916-09-30 23:00:00", "1917-03-31 23:00:00", "1917-09-29 23:00:00", 
"1918-03-09 23:00:00", "1918-10-05 23:00:00", "1919-03-01 23:00:00", 
"1919-10-04 23:00:00", "1920-03-20 23:00:00", "1920-09-18 23:00:00", 
"1940-06-14 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-09-16 23:00:00", 
"1945-04-02 01:00:00", "1945-09-14 23:00:00", "1946-03-17 01:00:00", 
"1946-10-06 01:00:00", "1947-03-15 23:00:00", "1947-10-04 23:00:00", 
"1948-02-29 01:00:00", "1948-10-03 01:00:00", "1966-05-21 23:00:00", 
"1966-09-24 22:00:00", "1967-05-27 23:00:00", "1967-09-23 22:00:00", 
"1968-05-25 23:00:00", "1968-09-21 22:00:00", "1969-05-31 23:00:00", 
"1969-09-27 22:00:00", "1970-05-30 23:00:00", "1970-09-26 22:00:00", 
"1971-05-22 23:00:00", "1971-09-25 23:00:00", "1972-05-27 23:00:00", 
"1972-09-30 22:00:00", "1973-06-02 23:00:00", "1973-09-29 22:00:00", 
"1974-05-25 23:00:00", "1974-09-28 22:00:00", "1975-05-31 23:00:00", 
"1975-09-27 23:00:00", "1976-05-29 23:00:00", "1976-09-25 23:00:00", 
"1977-05-21 23:00:00", "1977-09-24 23:00:00", "1978-05-27 23:00:00", 
"1978-09-30 23:00:00", "1979-05-26 23:00:00", "1979-09-29 23:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Rome", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -168L), class = "data.frame")
}

"Jersey" <- function () {
structure(list(Jersey = c("1901-12-14 20:45:52", "1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-10-26 23:00:00", "1971-10-31 02:00:00", "1972-03-19 02:00:00", 
"1972-10-29 02:00:00", "1973-03-18 02:00:00", "1973-10-28 02:00:00", 
"1974-03-17 02:00:00", "1974-10-27 02:00:00", "1975-03-16 02:00:00", 
"1975-10-26 02:00:00", "1976-03-21 02:00:00", "1976-10-24 02:00:00", 
"1977-03-20 02:00:00", "1977-10-23 02:00:00", "1978-03-19 02:00:00", 
"1978-10-29 02:00:00", "1979-03-18 02:00:00", "1979-10-28 02:00:00", 
"1980-03-16 02:00:00", "1980-10-26 02:00:00", "1981-03-29 01:00:00", 
"1981-10-25 01:00:00", "1982-03-28 01:00:00", "1982-10-24 01:00:00", 
"1983-03-27 01:00:00", "1983-10-23 01:00:00", "1984-03-25 01:00:00", 
"1984-10-28 01:00:00", "1985-03-31 01:00:00", "1985-10-27 01:00:00", 
"1986-03-30 01:00:00", "1986-10-26 01:00:00", "1987-03-29 01:00:00", 
"1987-10-25 01:00:00", "1988-03-27 01:00:00", "1988-10-23 01:00:00", 
"1989-03-26 01:00:00", "1989-10-29 01:00:00", "1990-03-25 01:00:00", 
"1990-10-28 01:00:00", "1991-03-31 01:00:00", "1991-10-27 01:00:00", 
"1992-03-29 01:00:00", "1992-10-25 01:00:00", "1993-03-28 01:00:00", 
"1993-10-24 01:00:00", "1994-03-27 01:00:00", "1994-10-23 01:00:00", 
"1995-03-26 01:00:00", "1995-10-22 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "0", 
"3600", "0", "3600", "7200", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "0", "1", 
"0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "BST", "BST", "BST", "BST", "BST", 
"BST", "BST", "BST", "BST", "BST", "GMT", "BST", "GMT", "BST", 
"BST", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "GMT", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", 
"GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", "BST", "GMT", 
"BST", "GMT", "BST", "GMT", "BST")), .Names = c("Jersey", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -240L), class = "data.frame")
}

"Jamaica" <- function () {
structure(list(Jamaica = c("1901-12-14 20:45:52", "1912-02-01 05:07:12", 
"1974-04-28 07:00:00", "1974-10-27 06:00:00", "1975-02-23 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00"), offSet = c("-18432", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("EST", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT"
)), .Names = c("Jamaica", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-21L), class = "data.frame")
}

"Amman" <- function () {
structure(list(Amman = c("1901-12-14 20:45:52", "1930-12-31 21:36:16", 
"1973-06-05 22:00:00", "1973-09-30 21:00:00", "1974-04-30 22:00:00", 
"1974-09-30 21:00:00", "1975-04-30 22:00:00", "1975-09-30 21:00:00", 
"1976-04-30 22:00:00", "1976-10-31 21:00:00", "1977-04-30 22:00:00", 
"1977-09-30 21:00:00", "1978-04-29 22:00:00", "1978-09-29 21:00:00", 
"1985-03-31 22:00:00", "1985-09-30 21:00:00", "1986-04-03 22:00:00", 
"1986-10-02 21:00:00", "1987-04-02 22:00:00", "1987-10-01 21:00:00", 
"1988-03-31 22:00:00", "1988-10-06 21:00:00", "1989-05-07 22:00:00", 
"1989-10-05 21:00:00", "1990-04-26 22:00:00", "1990-10-04 21:00:00", 
"1991-04-16 22:00:00", "1991-09-26 21:00:00", "1992-04-09 22:00:00", 
"1992-10-01 21:00:00", "1993-04-01 22:00:00", "1993-09-30 21:00:00", 
"1994-03-31 22:00:00", "1994-09-15 21:00:00", "1995-04-06 22:00:00", 
"1995-09-14 22:00:00", "1996-04-04 22:00:00", "1996-09-19 22:00:00", 
"1997-04-03 22:00:00", "1997-09-18 22:00:00", "1998-04-02 22:00:00", 
"1998-09-17 22:00:00", "1999-06-30 22:00:00", "1999-09-29 22:00:00", 
"2000-03-29 22:00:00", "2000-09-27 22:00:00", "2001-03-28 22:00:00", 
"2001-09-26 22:00:00", "2002-03-27 22:00:00", "2002-09-25 22:00:00", 
"2003-03-26 22:00:00", "2003-10-23 22:00:00", "2004-03-24 22:00:00", 
"2004-10-14 22:00:00", "2005-03-30 22:00:00", "2005-09-29 22:00:00", 
"2006-03-29 22:00:00", "2006-10-26 22:00:00", "2007-03-28 22:00:00", 
"2007-10-25 22:00:00", "2008-03-26 22:00:00", "2008-10-30 22:00:00", 
"2009-03-25 22:00:00", "2009-10-29 22:00:00", "2010-03-24 22:00:00", 
"2010-10-28 22:00:00", "2011-03-30 22:00:00", "2011-10-27 22:00:00", 
"2012-03-28 22:00:00", "2012-10-25 22:00:00", "2013-03-27 22:00:00", 
"2013-10-24 22:00:00", "2014-03-26 22:00:00", "2014-10-30 22:00:00", 
"2015-03-25 22:00:00", "2015-10-29 22:00:00", "2016-03-30 22:00:00", 
"2016-10-27 22:00:00", "2017-03-29 22:00:00", "2017-10-26 22:00:00", 
"2018-03-28 22:00:00", "2018-10-25 22:00:00", "2019-03-27 22:00:00", 
"2019-10-24 22:00:00", "2020-03-25 22:00:00", "2020-10-29 22:00:00", 
"2021-03-24 22:00:00", "2021-10-28 22:00:00", "2022-03-30 22:00:00", 
"2022-10-27 22:00:00", "2023-03-29 22:00:00", "2023-10-26 22:00:00", 
"2024-03-27 22:00:00", "2024-10-24 22:00:00", "2025-03-26 22:00:00", 
"2025-10-30 22:00:00", "2026-03-25 22:00:00", "2026-10-29 22:00:00", 
"2027-03-24 22:00:00", "2027-10-28 22:00:00", "2028-03-29 22:00:00", 
"2028-10-26 22:00:00", "2029-03-28 22:00:00", "2029-10-25 22:00:00", 
"2030-03-27 22:00:00", "2030-10-24 22:00:00", "2031-03-26 22:00:00", 
"2031-10-30 22:00:00", "2032-03-24 22:00:00", "2032-10-28 22:00:00", 
"2033-03-30 22:00:00", "2033-10-27 22:00:00", "2034-03-29 22:00:00", 
"2034-10-26 22:00:00", "2035-03-28 22:00:00", "2035-10-25 22:00:00", 
"2036-03-26 22:00:00", "2036-10-30 22:00:00", "2037-03-25 22:00:00"
), offSet = c("8624", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800"), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("EET", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Amman", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -119L), class = "data.frame")
}

"Tokyo" <- function () {
structure(list(Tokyo = c("1901-12-14 20:45:52", "1948-05-01 17:00:00", 
"1948-09-10 16:00:00", "1949-04-02 17:00:00", "1949-09-09 16:00:00", 
"1950-05-06 17:00:00", "1950-09-08 16:00:00", "1951-05-05 17:00:00"
), offSet = c("32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000"), isdst = c("0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("JST", "JDT", "JST", "JDT", "JST", "JDT", 
"JST", "JDT")), .Names = c("Tokyo", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -8L), class = "data.frame")
}

"Nairobi" <- function () {
structure(list(Nairobi = c("1901-12-14 20:45:52", "1928-06-30 21:32:44", 
"1929-12-31 21:00:00", "1939-12-31 21:30:00"), offSet = c("8836", 
"10800", "9000", "9885"), isdst = c("0", "0", "0", "0"), TimeZone = c("EAT", 
"EAT", "EAT", "EAT")), .Names = c("Nairobi", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Bishkek" <- function () {
structure(list(Bishkek = c("1901-12-14 20:45:52", "1924-05-01 19:01:36", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-03-30 20:00:00", 
"1991-08-30 20:00:00", "1992-04-11 19:00:00", "1992-09-26 18:00:00", 
"1993-04-10 19:00:00", "1993-09-25 18:00:00", "1994-04-09 19:00:00", 
"1994-09-24 18:00:00", "1995-04-08 19:00:00", "1995-09-23 18:00:00", 
"1996-04-06 19:00:00", "1996-09-28 18:00:00", "1997-03-29 21:30:00", 
"1997-10-25 20:30:00", "1998-03-28 21:30:00", "1998-10-24 20:30:00", 
"1999-03-27 21:30:00", "1999-10-30 20:30:00", "2000-03-25 21:30:00", 
"2000-10-28 20:30:00", "2001-03-24 21:30:00", "2001-10-27 20:30:00", 
"2002-03-30 21:30:00", "2002-10-26 20:30:00", "2003-03-29 21:30:00", 
"2003-10-25 20:30:00", "2004-03-27 21:30:00", "2004-10-30 20:30:00"
), offSet = c("17904", "18000", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000"), isdst = c("0", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0"), TimeZone = c("KGT", "KGT", "KGT", "KGST", 
"KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", 
"KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", 
"KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", 
"KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", 
"KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", 
"KGT")), .Names = c("Bishkek", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-50L), class = "data.frame")
}

"Phnom_Penh" <- function () {
structure(list(Phnom_Penh = c("1901-12-14 20:45:52", "1906-06-08 17:00:20", 
"1911-03-10 16:54:40", "1912-04-30 17:00:00"), offSet = c("25180", 
"25580", "25200", "28800"), isdst = c("0", "0", "0", "0"), TimeZone = c("ICT", 
"ICT", "ICT", "ICT")), .Names = c("Phnom_Penh", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Tarawa" <- function () {
structure(list(Tarawa = "1901-12-14 20:45:52", offSet = "43200", 
    isdst = "0", TimeZone = "GILT"), .Names = c("Tarawa", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Enderbury" <- function () {
structure(list(Enderbury = c("1901-12-14 20:45:52", "1979-10-01 12:00:00"
), offSet = c("-43200", "-39600"), isdst = c("0", "0"), TimeZone = c("PHOT", 
"PHOT")), .Names = c("Enderbury", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Kiritimati" <- function () {
structure(list(Kiritimati = c("1901-12-14 20:45:52", "1979-10-01 10:40:00"
), offSet = c("-38400", "-36000"), isdst = c("0", "0"), TimeZone = c("LINT", 
"LINT")), .Names = c("Kiritimati", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Comoro" <- function () {
structure(list(Comoro = "1901-12-14 20:45:52", offSet = "10384", 
    isdst = "0", TimeZone = "EAT"), .Names = c("Comoro", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"St_Kitts" <- function () {
structure(list(St_Kitts = "1901-12-14 20:45:52", offSet = "-15052", 
    isdst = "0", TimeZone = "AST"), .Names = c("St_Kitts", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Pyongyang" <- function () {
structure(list(Pyongyang = c("1901-12-14 20:45:52", "1904-11-30 15:30:00", 
"1927-12-31 15:00:00", "1931-12-31 15:30:00", "1954-03-20 15:00:00"
), offSet = c("30600", "32400", "30600", "32400", "28800"), isdst = c("0", 
"0", "0", "0", "0"), TimeZone = c("KST", "KST", "KST", "KST", 
"KST")), .Names = c("Pyongyang", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -5L), class = "data.frame")
}

"Seoul" <- function () {
structure(list(Seoul = c("1901-12-14 20:45:52", "1904-11-30 15:30:00", 
"1927-12-31 15:00:00", "1931-12-31 15:30:00", "1954-03-20 15:00:00", 
"1960-05-14 16:00:00", "1960-09-12 15:00:00", "1961-08-09 16:00:00", 
"1968-09-30 15:30:00", "1987-05-09 15:00:00", "1987-10-10 14:00:00", 
"1988-05-07 15:00:00"), offSet = c("30600", "32400", "30600", 
"32400", "28800", "32400", "28800", "30600", "32400", "36000", 
"32400", "36000"), isdst = c("0", "0", "0", "0", "0", "1", "0", 
"0", "0", "1", "0", "1"), TimeZone = c("KST", "KST", "KST", "KST", 
"KST", "KDT", "KST", "KST", "KST", "KDT", "KST", "KDT")), .Names = c("Seoul", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -12L), class = "data.frame")
}

"Kuwait" <- function () {
structure(list(Kuwait = "1901-12-14 20:45:52", offSet = "11516", 
    isdst = "0", TimeZone = "AST"), .Names = c("Kuwait", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Cayman" <- function () {
structure(list(Cayman = "1901-12-14 20:45:52", offSet = "-18432", 
    isdst = "0", TimeZone = "EST"), .Names = c("Cayman", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Almaty" <- function () {
structure(list(Almaty = c("1901-12-14 20:45:52", "1924-05-01 18:52:12", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1990-09-29 20:00:00", 
"1992-03-28 17:00:00", "1992-09-26 16:00:00", "1993-03-27 20:00:00", 
"1993-09-25 20:00:00", "1994-03-26 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 20:00:00", "1996-03-30 20:00:00", 
"1996-10-26 20:00:00", "1997-03-29 20:00:00", "1997-10-25 20:00:00", 
"1998-03-28 20:00:00", "1998-10-24 20:00:00", "1999-03-27 20:00:00", 
"1999-10-30 20:00:00", "2000-03-25 20:00:00", "2000-10-28 20:00:00", 
"2001-03-24 20:00:00", "2001-10-27 20:00:00", "2002-03-30 20:00:00", 
"2002-10-26 20:00:00", "2003-03-29 20:00:00", "2003-10-25 20:00:00", 
"2004-03-27 20:00:00"), offSet = c("18468", "18000", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("ALMT", "ALMT", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST")), .Names = c("Almaty", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -48L), class = "data.frame")
}

"Qyzylorda" <- function () {
structure(list(Qyzylorda = c("1901-12-14 20:45:52", "1924-05-01 19:38:08", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1990-09-29 21:00:00", "1992-01-18 21:00:00", "1992-03-28 17:00:00", 
"1992-09-26 16:00:00", "1993-03-27 20:00:00", "1993-09-25 20:00:00", 
"1994-03-26 20:00:00", "1994-09-24 20:00:00", "1995-03-25 20:00:00", 
"1995-09-23 20:00:00", "1996-03-30 20:00:00", "1996-10-26 20:00:00", 
"1997-03-29 20:00:00", "1997-10-25 20:00:00", "1998-03-28 20:00:00", 
"1998-10-24 20:00:00", "1999-03-27 20:00:00", "1999-10-30 20:00:00", 
"2000-03-25 20:00:00", "2000-10-28 20:00:00", "2001-03-24 20:00:00", 
"2001-10-27 20:00:00", "2002-03-30 20:00:00", "2002-10-26 20:00:00", 
"2003-03-29 20:00:00", "2003-10-25 20:00:00", "2004-03-27 20:00:00"
), offSet = c("15712", "14400", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("QYZT", "QYZT", 
"QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", 
"QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", 
"QYZT", "QYZST", "QYZT", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", 
"QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", 
"QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", 
"QYZST", "QYZT", "QYZST", "QYZT", "QYZST")), .Names = c("Qyzylorda", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -47L), class = "data.frame")
}

"Aqtobe" <- function () {
structure(list(Aqtobe = c("1901-12-14 20:45:52", "1924-05-01 20:11:20", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1990-09-29 21:00:00", "1992-03-28 18:00:00", "1992-09-26 17:00:00", 
"1993-03-27 21:00:00", "1993-09-25 21:00:00", "1994-03-26 21:00:00", 
"1994-09-24 21:00:00", "1995-03-25 21:00:00", "1995-09-23 21:00:00", 
"1996-03-30 21:00:00", "1996-10-26 21:00:00", "1997-03-29 21:00:00", 
"1997-10-25 21:00:00", "1998-03-28 21:00:00", "1998-10-24 21:00:00", 
"1999-03-27 21:00:00", "1999-10-30 21:00:00", "2000-03-25 21:00:00", 
"2000-10-28 21:00:00", "2001-03-24 21:00:00", "2001-10-27 21:00:00", 
"2002-03-30 21:00:00", "2002-10-26 21:00:00", "2003-03-29 21:00:00", 
"2003-10-25 21:00:00", "2004-03-27 21:00:00"), offSet = c("13720", 
"14400", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("AQTT", "AQTT", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST")), .Names = c("Aqtobe", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -46L), class = "data.frame")
}

"Aqtau" <- function () {
structure(list(Aqtau = c("1901-12-14 20:45:52", "1924-05-01 20:38:56", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1990-09-29 21:00:00", "1992-03-28 18:00:00", "1992-09-26 17:00:00", 
"1993-03-27 21:00:00", "1993-09-25 21:00:00", "1994-03-26 21:00:00", 
"1995-03-25 21:00:00", "1995-09-23 22:00:00", "1996-03-30 22:00:00", 
"1996-10-26 22:00:00", "1997-03-29 22:00:00", "1997-10-25 22:00:00", 
"1998-03-28 22:00:00", "1998-10-24 22:00:00", "1999-03-27 22:00:00", 
"1999-10-30 22:00:00", "2000-03-25 22:00:00", "2000-10-28 22:00:00", 
"2001-03-24 22:00:00", "2001-10-27 22:00:00", "2002-03-30 22:00:00", 
"2002-10-26 22:00:00", "2003-03-29 22:00:00", "2003-10-25 22:00:00", 
"2004-03-27 22:00:00", "2004-10-30 22:00:00"), offSet = c("12064", 
"14400", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0"), TimeZone = c("AQTT", "AQTT", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTST", "AQTT", "AQTST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", 
"AQTT")), .Names = c("Aqtau", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-46L), class = "data.frame")
}

"Oral" <- function () {
structure(list(Oral = c("1901-12-14 20:45:52", "1924-05-01 20:34:36", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1989-03-25 21:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1990-09-29 22:00:00", 
"1992-03-28 19:00:00", "1992-09-26 18:00:00", "1993-03-27 22:00:00", 
"1993-09-25 22:00:00", "1994-03-26 22:00:00", "1994-09-24 22:00:00", 
"1995-03-25 22:00:00", "1995-09-23 22:00:00", "1996-03-30 22:00:00", 
"1996-10-26 22:00:00", "1997-03-29 22:00:00", "1997-10-25 22:00:00", 
"1998-03-28 22:00:00", "1998-10-24 22:00:00", "1999-03-27 22:00:00", 
"1999-10-30 22:00:00", "2000-03-25 22:00:00", "2000-10-28 22:00:00", 
"2001-03-24 22:00:00", "2001-10-27 22:00:00", "2002-03-30 22:00:00", 
"2002-10-26 22:00:00", "2003-03-29 22:00:00", "2003-10-25 22:00:00", 
"2004-03-27 22:00:00", "2004-10-30 22:00:00"), offSet = c("12324", 
"14400", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0"), TimeZone = c("ORAT", "ORAT", "ORAT", "ORAST", "ORAT", 
"ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", 
"ORAST", "ORAT", "ORAST", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", 
"ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", 
"ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", 
"ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", 
"ORAT")), .Names = c("Oral", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-46L), class = "data.frame")
}

"Vientiane" <- function () {
structure(list(Vientiane = c("1901-12-14 20:45:52", "1906-06-08 17:09:36", 
"1911-03-10 16:54:40", "1912-04-30 17:00:00"), offSet = c("24624", 
"25580", "25200", "28800"), isdst = c("0", "0", "0", "0"), TimeZone = c("ICT", 
"ICT", "ICT", "ICT")), .Names = c("Vientiane", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Beirut" <- function () {
structure(list(Beirut = c("1901-12-14 20:45:52", "1920-03-27 22:00:00", 
"1920-10-24 21:00:00", "1921-04-02 22:00:00", "1921-10-02 21:00:00", 
"1922-03-25 22:00:00", "1922-10-07 21:00:00", "1923-04-21 22:00:00", 
"1923-09-15 21:00:00", "1957-04-30 22:00:00", "1957-09-30 21:00:00", 
"1958-04-30 22:00:00", "1958-09-30 21:00:00", "1959-04-30 22:00:00", 
"1959-09-30 21:00:00", "1960-04-30 22:00:00", "1960-09-30 21:00:00", 
"1961-04-30 22:00:00", "1961-09-30 21:00:00", "1972-06-21 22:00:00", 
"1972-09-30 21:00:00", "1973-04-30 22:00:00", "1973-09-30 21:00:00", 
"1974-04-30 22:00:00", "1974-09-30 21:00:00", "1975-04-30 22:00:00", 
"1975-09-30 21:00:00", "1976-04-30 22:00:00", "1976-09-30 21:00:00", 
"1977-04-30 22:00:00", "1977-09-30 21:00:00", "1978-04-29 22:00:00", 
"1978-09-29 21:00:00", "1984-04-30 22:00:00", "1984-10-15 21:00:00", 
"1985-04-30 22:00:00", "1985-10-15 21:00:00", "1986-04-30 22:00:00", 
"1986-10-15 21:00:00", "1987-04-30 22:00:00", "1987-10-15 21:00:00", 
"1988-05-31 22:00:00", "1988-10-15 21:00:00", "1989-05-09 22:00:00", 
"1989-10-15 21:00:00", "1990-04-30 22:00:00", "1990-10-15 21:00:00", 
"1991-04-30 22:00:00", "1991-10-15 21:00:00", "1992-04-30 22:00:00", 
"1992-10-03 21:00:00", "1993-03-27 22:00:00", "1993-09-25 21:00:00", 
"1994-03-26 22:00:00", "1994-09-24 21:00:00", "1995-03-25 22:00:00", 
"1995-09-23 21:00:00", "1996-03-30 22:00:00", "1996-09-28 21:00:00", 
"1997-03-29 22:00:00", "1997-09-27 21:00:00", "1998-03-28 22:00:00", 
"1998-09-26 21:00:00", "1999-03-27 22:00:00", "1999-10-30 21:00:00", 
"2000-03-25 22:00:00", "2000-10-28 21:00:00", "2001-03-24 22:00:00", 
"2001-10-27 21:00:00", "2002-03-30 22:00:00", "2002-10-26 21:00:00", 
"2003-03-29 22:00:00", "2003-10-25 21:00:00", "2004-03-27 22:00:00", 
"2004-10-30 21:00:00", "2005-03-26 22:00:00", "2005-10-29 21:00:00", 
"2006-03-25 22:00:00", "2006-10-28 21:00:00", "2007-03-24 22:00:00", 
"2007-10-27 21:00:00", "2008-03-29 22:00:00", "2008-10-25 21:00:00", 
"2009-03-28 22:00:00", "2009-10-24 21:00:00", "2010-03-27 22:00:00", 
"2010-10-30 21:00:00", "2011-03-26 22:00:00", "2011-10-29 21:00:00", 
"2012-03-24 22:00:00", "2012-10-27 21:00:00", "2013-03-30 22:00:00", 
"2013-10-26 21:00:00", "2014-03-29 22:00:00", "2014-10-25 21:00:00", 
"2015-03-28 22:00:00", "2015-10-24 21:00:00", "2016-03-26 22:00:00", 
"2016-10-29 21:00:00", "2017-03-25 22:00:00", "2017-10-28 21:00:00", 
"2018-03-24 22:00:00", "2018-10-27 21:00:00", "2019-03-30 22:00:00", 
"2019-10-26 21:00:00", "2020-03-28 22:00:00", "2020-10-24 21:00:00", 
"2021-03-27 22:00:00", "2021-10-30 21:00:00", "2022-03-26 22:00:00", 
"2022-10-29 21:00:00", "2023-03-25 22:00:00", "2023-10-28 21:00:00", 
"2024-03-30 22:00:00", "2024-10-26 21:00:00", "2025-03-29 22:00:00", 
"2025-10-25 21:00:00", "2026-03-28 22:00:00", "2026-10-24 21:00:00", 
"2027-03-27 22:00:00", "2027-10-30 21:00:00", "2028-03-25 22:00:00", 
"2028-10-28 21:00:00", "2029-03-24 22:00:00", "2029-10-27 21:00:00", 
"2030-03-30 22:00:00", "2030-10-26 21:00:00", "2031-03-29 22:00:00", 
"2031-10-25 21:00:00", "2032-03-27 22:00:00", "2032-10-30 21:00:00", 
"2033-03-26 22:00:00", "2033-10-29 21:00:00", "2034-03-25 22:00:00", 
"2034-10-28 21:00:00", "2035-03-24 22:00:00", "2035-10-27 21:00:00", 
"2036-03-29 22:00:00", "2036-10-25 21:00:00", "2037-03-28 22:00:00"
), offSet = c("7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST")), .Names = c("Beirut", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -140L), class = "data.frame")
}

"St_Lucia" <- function () {
structure(list(St_Lucia = "1901-12-14 20:45:52", offSet = "-14640", 
    isdst = "0", TimeZone = "AST"), .Names = c("St_Lucia", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Vaduz" <- function () {
structure(list(Vaduz = c("1901-12-14 20:45:52", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Vaduz", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -114L), class = "data.frame")
}

"Colombo" <- function () {
structure(list(Colombo = c("1901-12-14 20:45:52", "1905-12-31 18:40:28", 
"1942-01-04 18:30:00", "1942-08-31 18:00:00", "1945-10-15 19:30:00", 
"1996-05-24 18:30:00", "1996-10-25 18:00:00"), offSet = c("19172", 
"19800", "21600", "23400", "19800", "23400", "21600"), isdst = c("0", 
"0", "1", "1", "0", "0", "0"), TimeZone = c("IST", "IST", "IST", 
"IST", "IST", "IST", "IST")), .Names = c("Colombo", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -7L), class = "data.frame")
}

"Monrovia" <- function () {
structure(list(Monrovia = c("1901-12-14 20:45:52", "1919-03-01 00:43:08"
), offSet = c("-2588", "-2670"), isdst = c("0", "0"), TimeZone = c("GMT", 
"GMT")), .Names = c("Monrovia", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Maseru" <- function () {
structure(list(Maseru = c("1901-12-14 20:45:52", "1903-02-28 22:10:00", 
"1943-09-19 00:00:00"), offSet = c("6600", "7200", "10800"), 
    isdst = c("0", "0", "1"), TimeZone = c("SAST", "SAST", "SAST"
    )), .Names = c("Maseru", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Vilnius" <- function () {
structure(list(Vilnius = c("1901-12-14 20:45:52", "1916-12-31 22:36:00", 
"1919-10-09 22:24:24", "1920-07-11 23:00:00", "1920-10-08 22:00:00", 
"1940-08-02 23:00:00", "1941-06-23 21:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-07-31 22:00:00", "1981-03-31 21:00:00", "1981-09-30 20:00:00", 
"1982-03-31 21:00:00", "1982-09-30 20:00:00", "1983-03-31 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-29 23:00:00", 
"1985-03-30 23:00:00", "1985-09-28 23:00:00", "1986-03-29 23:00:00", 
"1986-09-27 23:00:00", "1987-03-28 23:00:00", "1987-09-26 23:00:00", 
"1988-03-26 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1989-09-23 23:00:00", "1990-03-24 23:00:00", "1991-03-30 23:00:00", 
"1991-09-29 00:00:00", "1992-03-29 00:00:00", "1992-09-27 00:00:00", 
"1993-03-28 00:00:00", "1993-09-26 00:00:00", "1994-03-27 00:00:00", 
"1994-09-25 00:00:00", "1995-03-26 00:00:00", "1995-09-24 00:00:00", 
"1996-03-31 00:00:00", "1996-10-27 00:00:00", "1997-03-30 00:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-10-31 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("5040", "5736", "3600", "7200", "3600", "10800", 
"7200", "3600", "7200", "3600", "7200", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "3600", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800"), isdst = c("0", "0", "0", "0", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1"), TimeZone = c("EET", "EET", "EET", "EET", "EET", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EEST", "EET", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST")), .Names = c("Vilnius", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Luxembourg" <- function () {
structure(list(Luxembourg = c("1901-12-14 20:45:52", "1904-05-31 23:35:24", 
"1916-05-14 22:00:00", "1916-09-30 23:00:00", "1917-04-28 22:00:00", 
"1917-09-16 23:00:00", "1918-04-15 01:00:00", "1918-09-16 01:00:00", 
"1918-11-24 23:00:00", "1919-03-01 23:00:00", "1919-10-05 02:00:00", 
"1920-02-14 23:00:00", "1920-10-24 01:00:00", "1921-03-14 23:00:00", 
"1921-10-26 01:00:00", "1922-03-25 23:00:00", "1922-10-08 00:00:00", 
"1923-04-21 23:00:00", "1923-10-07 01:00:00", "1924-03-29 23:00:00", 
"1924-10-05 00:00:00", "1925-04-05 23:00:00", "1925-10-04 00:00:00", 
"1926-04-17 23:00:00", "1926-10-03 00:00:00", "1927-04-09 23:00:00", 
"1927-10-02 00:00:00", "1928-04-14 23:00:00", "1928-10-07 00:00:00", 
"1929-04-20 23:00:00", "1929-10-06 02:00:00", "1930-04-13 02:00:00", 
"1930-10-05 02:00:00", "1931-04-19 02:00:00", "1931-10-04 02:00:00", 
"1932-04-03 02:00:00", "1932-10-02 02:00:00", "1933-03-26 02:00:00", 
"1933-10-08 02:00:00", "1934-04-08 02:00:00", "1934-10-07 02:00:00", 
"1935-03-31 02:00:00", "1935-10-06 02:00:00", "1936-04-19 02:00:00", 
"1936-10-04 02:00:00", "1937-04-04 02:00:00", "1937-10-03 02:00:00", 
"1938-03-27 02:00:00", "1938-10-02 02:00:00", "1939-04-16 02:00:00", 
"1939-11-19 02:00:00", "1940-02-25 02:00:00", "1940-05-14 02:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-18 01:00:00", "1945-04-02 01:00:00", 
"1945-09-16 01:00:00", "1946-05-19 01:00:00", "1946-10-07 01:00:00", 
"1977-04-03 01:00:00", "1977-09-25 01:00:00", "1978-04-02 01:00:00", 
"1978-10-01 01:00:00", "1979-04-01 01:00:00", "1979-09-30 01:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("1476", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200"), isdst = c("0", "0", "1", "0", "1", "0", "1", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST")), .Names = c("Luxembourg", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -183L), class = "data.frame")
}

"Riga" <- function () {
structure(list(Riga = c("1901-12-14 20:45:52", "1918-04-15 00:23:36", 
"1918-09-16 00:23:36", "1919-04-01 00:23:36", "1919-05-22 00:23:36", 
"1926-05-10 22:23:36", "1940-08-04 22:00:00", "1941-06-30 21:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1944-10-12 23:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1989-03-25 23:00:00", "1989-09-24 00:00:00", "1990-03-25 00:00:00", 
"1990-09-30 00:00:00", "1991-03-31 00:00:00", "1991-09-29 00:00:00", 
"1992-03-29 00:00:00", "1992-09-27 00:00:00", "1993-03-28 00:00:00", 
"1993-09-26 00:00:00", "1994-03-27 00:00:00", "1994-09-25 00:00:00", 
"1995-03-26 00:00:00", "1995-09-24 00:00:00", "1996-03-31 00:00:00", 
"1996-09-29 00:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("5784", 
"9384", "5784", "9384", "5784", "7200", "10800", "7200", "3600", 
"7200", "3600", "7200", "3600", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800"), isdst = c("0", "1", 
"0", "1", "0", "0", "0", "1", "0", "1", "0", "1", "0", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("EET", "EEST", "EET", 
"EEST", "EET", "EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST")), .Names = c("Riga", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -124L), class = "data.frame")
}

"Tripoli" <- function () {
structure(list(Tripoli = c("1901-12-14 20:45:52", "1919-12-31 23:07:16", 
"1951-10-14 01:00:00", "1951-12-31 22:00:00", "1953-10-09 01:00:00", 
"1953-12-31 22:00:00", "1955-09-29 23:00:00", "1955-12-31 22:00:00", 
"1958-12-31 23:00:00", "1981-12-31 22:00:00", "1982-03-31 23:00:00", 
"1982-09-30 22:00:00", "1983-03-31 23:00:00", "1983-09-30 22:00:00", 
"1984-03-31 23:00:00", "1984-09-30 22:00:00", "1985-04-05 23:00:00", 
"1985-09-30 22:00:00", "1986-04-03 23:00:00", "1986-10-02 22:00:00", 
"1987-03-31 23:00:00", "1987-09-30 22:00:00", "1988-03-31 23:00:00", 
"1988-09-30 22:00:00", "1989-03-31 23:00:00", "1989-09-30 22:00:00", 
"1990-05-03 23:00:00", "1996-09-29 22:00:00"), offSet = c("3164", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600"), isdst = c("0", "0", "1", "0", "1", "0", 
"1", "0", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "0", "0"), TimeZone = c("EET", 
"EET", "CEST", "EET", "CEST", "EET", "CEST", "EET", "EET", "EET", 
"CEST", "EET", "CEST", "EET", "CEST", "EET", "CEST", "EET", "CEST", 
"EET", "CEST", "EET", "CEST", "EET", "CEST", "EET", "EET", "EET"
)), .Names = c("Tripoli", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-28L), class = "data.frame")
}

"Casablanca" <- function () {
structure(list(Casablanca = c("1901-12-14 20:45:52", "1913-10-26 00:30:20", 
"1939-09-12 00:00:00", "1939-11-18 23:00:00", "1940-02-25 00:00:00", 
"1945-11-17 23:00:00", "1950-06-11 00:00:00", "1950-10-28 23:00:00", 
"1967-06-03 12:00:00", "1967-09-30 23:00:00", "1974-06-24 00:00:00", 
"1974-08-31 23:00:00", "1976-05-01 00:00:00", "1976-07-31 23:00:00", 
"1977-05-01 00:00:00", "1977-09-27 23:00:00", "1978-06-01 00:00:00", 
"1978-08-03 23:00:00", "1984-03-16 00:00:00"), offSet = c("-1820", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "0"), TimeZone = c("WET", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WET")), .Names = c("Casablanca", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -19L), class = "data.frame")
}

"Monaco" <- function () {
structure(list(Monaco = c("1901-12-14 20:45:52", "1911-03-10 23:50:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-10-25 23:00:00", 
"1922-03-25 23:00:00", "1922-10-07 23:00:00", "1923-05-26 23:00:00", 
"1923-10-06 23:00:00", "1924-03-29 23:00:00", "1924-10-04 23:00:00", 
"1925-04-04 23:00:00", "1925-10-03 23:00:00", "1926-04-17 23:00:00", 
"1926-10-02 23:00:00", "1927-04-09 23:00:00", "1927-10-01 23:00:00", 
"1928-04-14 23:00:00", "1928-10-06 23:00:00", "1929-04-20 23:00:00", 
"1929-10-05 23:00:00", "1930-04-12 23:00:00", "1930-10-04 23:00:00", 
"1931-04-18 23:00:00", "1931-10-03 23:00:00", "1932-04-02 23:00:00", 
"1932-10-01 23:00:00", "1933-03-25 23:00:00", "1933-10-07 23:00:00", 
"1934-04-07 23:00:00", "1934-10-06 23:00:00", "1935-03-30 23:00:00", 
"1935-10-05 23:00:00", "1936-04-18 23:00:00", "1936-10-03 23:00:00", 
"1937-04-03 23:00:00", "1937-10-02 23:00:00", "1938-03-26 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-11-18 23:00:00", 
"1940-02-25 02:00:00", "1941-05-04 23:00:00", "1941-10-05 22:00:00", 
"1942-03-08 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-10-07 23:00:00", 
"1945-04-02 01:00:00", "1945-09-16 01:00:00", "1976-03-28 00:00:00", 
"1976-09-25 23:00:00", "1977-04-03 01:00:00", "1977-09-25 01:00:00", 
"1978-04-02 01:00:00", "1978-10-01 01:00:00", "1979-04-01 01:00:00", 
"1979-09-30 01:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("561", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "1", "1", 
"1", "1", "1", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("CET", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CEST", 
"CEST", "CEST", "CEST", "CEST", "CEST", "CEST", "CEST", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Monaco", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -184L), class = "data.frame")
}

"Chisinau" <- function () {
structure(list(Chisinau = c("1901-12-14 20:45:52", "1918-02-14 22:05:00", 
"1931-07-23 22:15:36", "1932-05-20 22:00:00", "1932-10-01 22:00:00", 
"1933-04-01 22:00:00", "1933-09-30 22:00:00", "1934-04-07 22:00:00", 
"1934-10-06 22:00:00", "1935-04-06 22:00:00", "1935-10-05 22:00:00", 
"1936-04-04 22:00:00", "1936-10-03 22:00:00", "1937-04-03 22:00:00", 
"1937-10-02 22:00:00", "1938-04-02 22:00:00", "1938-10-01 22:00:00", 
"1939-04-01 22:00:00", "1939-09-30 22:00:00", "1940-08-14 22:00:00", 
"1941-07-16 21:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-08-23 22:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1988-09-24 23:00:00", "1989-03-25 23:00:00", "1989-09-23 23:00:00", 
"1990-05-05 21:00:00", "1991-03-31 00:00:00", "1991-09-29 00:00:00", 
"1992-03-28 22:00:00", "1992-09-26 21:00:00", "1993-03-27 22:00:00", 
"1993-09-25 21:00:00", "1994-03-26 22:00:00", "1994-09-24 21:00:00", 
"1995-03-25 22:00:00", "1995-09-23 21:00:00", "1996-03-30 22:00:00", 
"1996-10-26 21:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("6900", "6264", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "3600", "7200", "3600", "7200", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800"
), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST")), .Names = c("Chisinau", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -138L), class = "data.frame")
}

"Podgorica" <- function () {
structure(list(Podgorica = c("1901-12-14 20:45:52", "1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Podgorica", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -118L), class = "data.frame")
}

"Marigot" <- function () {
structure(list(Marigot = "1901-12-14 20:45:52", offSet = "-14768", 
    isdst = "0", TimeZone = "AST"), .Names = c("Marigot", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Antananarivo" <- function () {
structure(list(Antananarivo = c("1901-12-14 20:45:52", "1911-06-30 20:49:56", 
"1954-02-27 20:00:00"), offSet = c("11404", "10800", "14400"), 
    isdst = c("0", "0", "1"), TimeZone = c("EAT", "EAT", "EAST"
    )), .Names = c("Antananarivo", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -3L), class = "data.frame")
}

"Majuro" <- function () {
structure(list(Majuro = "1901-12-14 20:45:52", offSet = "39600", 
    isdst = "0", TimeZone = "MHT"), .Names = c("Majuro", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Kwajalein" <- function () {
structure(list(Kwajalein = c("1901-12-14 20:45:52", "1969-09-30 13:00:00"
), offSet = c("39600", "-43200"), isdst = c("0", "0"), TimeZone = c("MHT", 
"MHT")), .Names = c("Kwajalein", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Skopje" <- function () {
structure(list(Skopje = c("1901-12-14 20:45:52", "1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Skopje", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Bamako" <- function () {
structure(list(Bamako = c("1901-12-14 20:45:52", "1912-01-01 00:32:00", 
"1934-02-26 00:00:00"), offSet = c("-1920", "0", "-3600"), isdst = c("0", 
"0", "0"), TimeZone = c("GMT", "GMT", "GMT")), .Names = c("Bamako", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Rangoon" <- function () {
structure(list(Rangoon = c("1901-12-14 20:45:52", "1919-12-31 17:35:24", 
"1942-04-30 17:30:00"), offSet = c("23076", "23400", "32400"), 
    isdst = c("0", "0", "0"), TimeZone = c("MMT", "MMT", "MMT"
    )), .Names = c("Rangoon", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Ulaanbaatar" <- function () {
structure(list(Ulaanbaatar = c("1901-12-14 20:45:52", "1905-07-31 16:52:28", 
"1977-12-31 17:00:00", "1983-03-31 16:00:00", "1983-09-30 15:00:00", 
"1984-03-31 16:00:00", "1984-09-29 15:00:00", "1985-03-30 16:00:00", 
"1985-09-28 15:00:00", "1986-03-29 16:00:00", "1986-09-27 15:00:00", 
"1987-03-28 16:00:00", "1987-09-26 15:00:00", "1988-03-26 16:00:00", 
"1988-09-24 15:00:00", "1989-03-25 16:00:00", "1989-09-23 15:00:00", 
"1990-03-24 16:00:00", "1990-09-29 15:00:00", "1991-03-30 16:00:00", 
"1991-09-28 15:00:00", "1992-03-28 16:00:00", "1992-09-26 15:00:00", 
"1993-03-27 16:00:00", "1993-09-25 15:00:00", "1994-03-26 16:00:00", 
"1994-09-24 15:00:00", "1995-03-25 16:00:00", "1995-09-23 15:00:00", 
"1996-03-30 16:00:00", "1996-09-28 15:00:00", "1997-03-29 16:00:00", 
"1997-09-27 15:00:00", "1998-03-28 16:00:00", "1998-09-26 15:00:00", 
"2001-04-27 18:00:00", "2001-09-28 17:00:00", "2002-03-29 18:00:00", 
"2002-09-27 17:00:00", "2003-03-28 18:00:00", "2003-09-26 17:00:00", 
"2004-03-26 18:00:00", "2004-09-24 17:00:00", "2005-03-25 18:00:00", 
"2005-09-23 17:00:00", "2006-03-24 18:00:00"), offSet = c("25652", 
"25200", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("ULAT", "ULAT", "ULAT", "ULAST", "ULAT", 
"ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", 
"ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", 
"ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", 
"ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", 
"ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", 
"ULAST")), .Names = c("Ulaanbaatar", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -46L), class = "data.frame")
}

"Hovd" <- function () {
structure(list(Hovd = c("1901-12-14 20:45:52", "1905-07-31 17:53:24", 
"1977-12-31 18:00:00", "1983-03-31 17:00:00", "1983-09-30 16:00:00", 
"1984-03-31 17:00:00", "1984-09-29 16:00:00", "1985-03-30 17:00:00", 
"1985-09-28 16:00:00", "1986-03-29 17:00:00", "1986-09-27 16:00:00", 
"1987-03-28 17:00:00", "1987-09-26 16:00:00", "1988-03-26 17:00:00", 
"1988-09-24 16:00:00", "1989-03-25 17:00:00", "1989-09-23 16:00:00", 
"1990-03-24 17:00:00", "1990-09-29 16:00:00", "1991-03-30 17:00:00", 
"1991-09-28 16:00:00", "1992-03-28 17:00:00", "1992-09-26 16:00:00", 
"1993-03-27 17:00:00", "1993-09-25 16:00:00", "1994-03-26 17:00:00", 
"1994-09-24 16:00:00", "1995-03-25 17:00:00", "1995-09-23 16:00:00", 
"1996-03-30 17:00:00", "1996-09-28 16:00:00", "1997-03-29 17:00:00", 
"1997-09-27 16:00:00", "1998-03-28 17:00:00", "1998-09-26 16:00:00", 
"2001-04-27 19:00:00", "2001-09-28 18:00:00", "2002-03-29 19:00:00", 
"2002-09-27 18:00:00", "2003-03-28 19:00:00", "2003-09-26 18:00:00", 
"2004-03-26 19:00:00", "2004-09-24 18:00:00", "2005-03-25 19:00:00", 
"2005-09-23 18:00:00", "2006-03-24 19:00:00"), offSet = c("21996", 
"21600", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("HOVT", "HOVT", "HOVT", "HOVST", "HOVT", 
"HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", 
"HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", 
"HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", 
"HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", 
"HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", 
"HOVST")), .Names = c("Hovd", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-46L), class = "data.frame")
}

"Choibalsan" <- function () {
structure(list(Choibalsan = c("1901-12-14 20:45:52", "1905-07-31 16:22:00", 
"1977-12-31 17:00:00", "1983-03-31 16:00:00", "1983-09-30 14:00:00", 
"1984-03-31 15:00:00", "1984-09-29 14:00:00", "1985-03-30 15:00:00", 
"1985-09-28 14:00:00", "1986-03-29 15:00:00", "1986-09-27 14:00:00", 
"1987-03-28 15:00:00", "1987-09-26 14:00:00", "1988-03-26 15:00:00", 
"1988-09-24 14:00:00", "1989-03-25 15:00:00", "1989-09-23 14:00:00", 
"1990-03-24 15:00:00", "1990-09-29 14:00:00", "1991-03-30 15:00:00", 
"1991-09-28 14:00:00", "1992-03-28 15:00:00", "1992-09-26 14:00:00", 
"1993-03-27 15:00:00", "1993-09-25 14:00:00", "1994-03-26 15:00:00", 
"1994-09-24 14:00:00", "1995-03-25 15:00:00", "1995-09-23 14:00:00", 
"1996-03-30 15:00:00", "1996-09-28 14:00:00", "1997-03-29 15:00:00", 
"1997-09-27 14:00:00", "1998-03-28 15:00:00", "1998-09-26 14:00:00", 
"2001-04-27 17:00:00", "2001-09-28 16:00:00", "2002-03-29 17:00:00", 
"2002-09-27 16:00:00", "2003-03-28 17:00:00", "2003-09-26 16:00:00", 
"2004-03-26 17:00:00", "2004-09-24 16:00:00", "2005-03-25 17:00:00", 
"2005-09-23 16:00:00", "2006-03-24 17:00:00"), offSet = c("27480", 
"25200", "28800", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000"), isdst = c("0", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("CHOT", "CHOT", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST")), .Names = c("Choibalsan", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -46L), class = "data.frame")
}

"Macau" <- function () {
structure(list(Macau = c("1901-12-14 20:45:52", "1911-12-31 16:25:40", 
"1961-03-18 19:30:00", "1961-11-04 18:30:00", "1962-03-17 19:30:00", 
"1962-11-03 18:30:00", "1963-03-16 16:00:00", "1963-11-02 18:30:00", 
"1964-03-21 19:30:00", "1964-10-31 18:30:00", "1965-03-20 16:00:00", 
"1965-10-30 15:00:00", "1966-04-16 19:30:00", "1966-10-15 18:30:00", 
"1967-04-15 19:30:00", "1967-10-21 18:30:00", "1968-04-20 19:30:00", 
"1968-10-19 18:30:00", "1969-04-19 19:30:00", "1969-10-18 18:30:00", 
"1970-04-18 19:30:00", "1970-10-17 18:30:00", "1971-04-17 19:30:00", 
"1971-10-16 18:30:00", "1972-04-15 16:00:00", "1972-10-14 15:00:00", 
"1973-04-14 16:00:00", "1973-10-20 15:00:00", "1974-04-20 16:00:00", 
"1974-10-19 18:30:00", "1975-04-19 19:30:00", "1975-10-18 18:30:00", 
"1976-04-17 19:30:00", "1976-10-16 18:30:00", "1977-04-16 19:30:00", 
"1977-10-15 18:30:00", "1978-04-15 16:00:00", "1978-10-14 15:00:00", 
"1979-04-14 16:00:00", "1979-10-20 15:00:00", "1980-04-19 16:00:00"
), offSet = c("27260", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1"), TimeZone = c("CST", "CST", "MOST", 
"CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", 
"MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", 
"CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", 
"MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", "CST", "MOST", 
"CST", "MOST")), .Names = c("Macau", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -41L), class = "data.frame")
}

"Saipan" <- function () {
structure(list(Saipan = "1901-12-14 20:45:52", offSet = "32400", 
    isdst = "0", TimeZone = "ChST"), .Names = c("Saipan", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Martinique" <- function () {
structure(list(Martinique = c("1901-12-14 20:45:52", "1911-05-01 04:04:20", 
"1980-04-06 04:00:00"), offSet = c("-14660", "-14400", "-10800"
), isdst = c("0", "0", "1"), TimeZone = c("AST", "AST", "ADT"
)), .Names = c("Martinique", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Nouakchott" <- function () {
structure(list(Nouakchott = c("1901-12-14 20:45:52", "1912-01-01 01:03:48", 
"1934-02-26 00:00:00"), offSet = c("-3828", "0", "-3600"), isdst = c("0", 
"0", "0"), TimeZone = c("GMT", "GMT", "GMT")), .Names = c("Nouakchott", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Montserrat" <- function () {
structure(list(Montserrat = "1901-12-14 20:45:52", offSet = "-14932", 
    isdst = "0", TimeZone = "AST"), .Names = c("Montserrat", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Malta" <- function () {
structure(list(Malta = c("1901-12-14 20:45:52", "1916-06-02 23:00:00", 
"1916-09-30 23:00:00", "1917-03-31 23:00:00", "1917-09-29 23:00:00", 
"1918-03-09 23:00:00", "1918-10-05 23:00:00", "1919-03-01 23:00:00", 
"1919-10-04 23:00:00", "1920-03-20 23:00:00", "1920-09-18 23:00:00", 
"1940-06-14 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-10-02 01:00:00", 
"1945-04-02 01:00:00", "1945-09-14 23:00:00", "1946-03-17 01:00:00", 
"1946-10-06 01:00:00", "1947-03-15 23:00:00", "1947-10-04 23:00:00", 
"1948-02-29 01:00:00", "1948-10-03 01:00:00", "1966-05-21 23:00:00", 
"1966-09-24 22:00:00", "1967-05-27 23:00:00", "1967-09-23 22:00:00", 
"1968-05-25 23:00:00", "1968-09-21 22:00:00", "1969-05-31 23:00:00", 
"1969-09-27 22:00:00", "1970-05-30 23:00:00", "1970-09-26 22:00:00", 
"1971-05-22 23:00:00", "1971-09-25 23:00:00", "1972-05-27 23:00:00", 
"1972-09-30 22:00:00", "1973-03-30 23:00:00", "1973-09-28 23:00:00", 
"1974-04-20 23:00:00", "1974-09-15 23:00:00", "1975-04-20 01:00:00", 
"1975-09-21 00:00:00", "1976-04-18 01:00:00", "1976-09-19 00:00:00", 
"1977-04-17 01:00:00", "1977-09-18 00:00:00", "1978-04-16 01:00:00", 
"1978-09-17 00:00:00", "1979-04-15 01:00:00", "1979-09-16 00:00:00", 
"1980-03-31 01:00:00", "1980-09-21 00:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200"), isdst = c("0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Malta", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -168L), class = "data.frame")
}

"Mauritius" <- function () {
structure(list(Mauritius = "1901-12-14 20:45:52", offSet = "13800", 
    isdst = "0", TimeZone = "MUT"), .Names = c("Mauritius", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Maldives" <- function () {
structure(list(Maldives = "1901-12-14 20:45:52", offSet = "17640", 
    isdst = "0", TimeZone = "MVT"), .Names = c("Maldives", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Blantyre" <- function () {
structure(list(Blantyre = "1901-12-14 20:45:52", offSet = "8400", 
    isdst = "0", TimeZone = "CAT"), .Names = c("Blantyre", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Mexico_City" <- function () {
structure(list(Mexico_City = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1939-02-05 06:00:00", 
"1939-06-25 05:00:00", "1940-12-09 06:00:00", "1941-04-01 05:00:00", 
"1943-12-16 06:00:00", "1944-05-01 05:00:00", "1950-02-12 06:00:00", 
"1950-07-30 05:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2000-04-02 08:00:00", "2000-10-29 07:00:00", "2001-05-06 08:00:00", 
"2001-09-30 07:00:00", "2002-04-07 08:00:00", "2002-10-27 07:00:00", 
"2003-04-06 08:00:00", "2003-10-26 07:00:00", "2004-04-04 08:00:00", 
"2004-10-31 07:00:00", "2005-04-03 08:00:00", "2005-10-30 07:00:00", 
"2006-04-02 08:00:00", "2006-10-29 07:00:00", "2007-04-01 08:00:00", 
"2007-10-28 07:00:00", "2008-04-06 08:00:00", "2008-10-26 07:00:00", 
"2009-04-05 08:00:00", "2009-10-25 07:00:00", "2010-04-04 08:00:00", 
"2010-10-31 07:00:00", "2011-04-03 08:00:00", "2011-10-30 07:00:00", 
"2012-04-01 08:00:00", "2012-10-28 07:00:00", "2013-04-07 08:00:00", 
"2013-10-27 07:00:00", "2014-04-06 08:00:00", "2014-10-26 07:00:00", 
"2015-04-05 08:00:00", "2015-10-25 07:00:00", "2016-04-03 08:00:00", 
"2016-10-30 07:00:00", "2017-04-02 08:00:00", "2017-10-29 07:00:00", 
"2018-04-01 08:00:00", "2018-10-28 07:00:00", "2019-04-07 08:00:00", 
"2019-10-27 07:00:00", "2020-04-05 08:00:00", "2020-10-25 07:00:00", 
"2021-04-04 08:00:00", "2021-10-31 07:00:00", "2022-04-03 08:00:00", 
"2022-10-30 07:00:00", "2023-04-02 08:00:00", "2023-10-29 07:00:00", 
"2024-04-07 08:00:00", "2024-10-27 07:00:00", "2025-04-06 08:00:00", 
"2025-10-26 07:00:00", "2026-04-05 08:00:00", "2026-10-25 07:00:00", 
"2027-04-04 08:00:00", "2027-10-31 07:00:00", "2028-04-02 08:00:00", 
"2028-10-29 07:00:00", "2029-04-01 08:00:00", "2029-10-28 07:00:00", 
"2030-04-07 08:00:00", "2030-10-27 07:00:00", "2031-04-06 08:00:00", 
"2031-10-26 07:00:00", "2032-04-04 08:00:00", "2032-10-31 07:00:00", 
"2033-04-03 08:00:00", "2033-10-30 07:00:00", "2034-04-02 08:00:00", 
"2034-10-29 07:00:00", "2035-04-01 08:00:00", "2035-10-28 07:00:00", 
"2036-04-06 08:00:00", "2036-10-26 07:00:00", "2037-04-05 08:00:00"
), offSet = c("-23796", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000"), isdst = c("0", "0", "0", "0", "0", "0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CST", "CST", "CST", "CST", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT")), .Names = c("Mexico_City", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -98L), class = "data.frame")
}

"Cancun" <- function () {
structure(list(Cancun = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1981-12-23 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-08-02 06:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00"), offSet = c("-20824", "-21600", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000"
), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CST", "CST", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Cancun", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -87L), class = "data.frame")
}

"Merida" <- function () {
structure(list(Merida = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1981-12-23 06:00:00", "1982-12-02 05:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00"), offSet = c("-21508", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000"
), isdst = c("0", "0", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CST", "CST", "CST", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Merida", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -87L), class = "data.frame")
}

"Monterrey" <- function () {
structure(list(Monterrey = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00"), offSet = c("-24076", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000", "-21600", "-18000"
), isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CST", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT")), .Names = c("Monterrey", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -87L), class = "data.frame")
}

"Mazatlan" <- function () {
structure(list(Mazatlan = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1942-04-24 06:00:00", 
"1949-01-14 07:00:00", "1970-01-01 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-05-06 09:00:00", "2001-09-30 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-04-01 09:00:00", "2007-10-28 08:00:00", "2008-04-06 09:00:00", 
"2008-10-26 08:00:00", "2009-04-05 09:00:00", "2009-10-25 08:00:00", 
"2010-04-04 09:00:00", "2010-10-31 08:00:00", "2011-04-03 09:00:00", 
"2011-10-30 08:00:00", "2012-04-01 09:00:00", "2012-10-28 08:00:00", 
"2013-04-07 09:00:00", "2013-10-27 08:00:00", "2014-04-06 09:00:00", 
"2014-10-26 08:00:00", "2015-04-05 09:00:00", "2015-10-25 08:00:00", 
"2016-04-03 09:00:00", "2016-10-30 08:00:00", "2017-04-02 09:00:00", 
"2017-10-29 08:00:00", "2018-04-01 09:00:00", "2018-10-28 08:00:00", 
"2019-04-07 09:00:00", "2019-10-27 08:00:00", "2020-04-05 09:00:00", 
"2020-10-25 08:00:00", "2021-04-04 09:00:00", "2021-10-31 08:00:00", 
"2022-04-03 09:00:00", "2022-10-30 08:00:00", "2023-04-02 09:00:00", 
"2023-10-29 08:00:00", "2024-04-07 09:00:00", "2024-10-27 08:00:00", 
"2025-04-06 09:00:00", "2025-10-26 08:00:00", "2026-04-05 09:00:00", 
"2026-10-25 08:00:00", "2027-04-04 09:00:00", "2027-10-31 08:00:00", 
"2028-04-02 09:00:00", "2028-10-29 08:00:00", "2029-04-01 09:00:00", 
"2029-10-28 08:00:00", "2030-04-07 09:00:00", "2030-10-27 08:00:00", 
"2031-04-06 09:00:00", "2031-10-26 08:00:00", "2032-04-04 09:00:00", 
"2032-10-31 08:00:00", "2033-04-03 09:00:00", "2033-10-30 08:00:00", 
"2034-04-02 09:00:00", "2034-10-29 08:00:00", "2035-04-01 09:00:00", 
"2035-10-28 08:00:00", "2036-04-06 09:00:00", "2036-10-26 08:00:00", 
"2037-04-05 09:00:00"), offSet = c("-25540", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-28800", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600"), 
    isdst = c("0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("MST", 
    "MST", "MST", "MST", "MST", "MST", "MST", "MST", "MST", "MST", 
    "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
    "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
    "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
    "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
    "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
    "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
    "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
    "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
    "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
    "MST", "MDT")), .Names = c("Mazatlan", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -93L), class = "data.frame")
}

"Chihuahua" <- function () {
structure(list(Chihuahua = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1998-04-05 09:00:00", 
"1998-10-25 08:00:00", "1999-04-04 09:00:00", "1999-10-31 08:00:00", 
"2000-04-02 09:00:00", "2000-10-29 08:00:00", "2001-05-06 09:00:00", 
"2001-09-30 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-04-01 09:00:00", 
"2007-10-28 08:00:00", "2008-04-06 09:00:00", "2008-10-26 08:00:00", 
"2009-04-05 09:00:00", "2009-10-25 08:00:00", "2010-04-04 09:00:00", 
"2010-10-31 08:00:00", "2011-04-03 09:00:00", "2011-10-30 08:00:00", 
"2012-04-01 09:00:00", "2012-10-28 08:00:00", "2013-04-07 09:00:00", 
"2013-10-27 08:00:00", "2014-04-06 09:00:00", "2014-10-26 08:00:00", 
"2015-04-05 09:00:00", "2015-10-25 08:00:00", "2016-04-03 09:00:00", 
"2016-10-30 08:00:00", "2017-04-02 09:00:00", "2017-10-29 08:00:00", 
"2018-04-01 09:00:00", "2018-10-28 08:00:00", "2019-04-07 09:00:00", 
"2019-10-27 08:00:00", "2020-04-05 09:00:00", "2020-10-25 08:00:00", 
"2021-04-04 09:00:00", "2021-10-31 08:00:00", "2022-04-03 09:00:00", 
"2022-10-30 08:00:00", "2023-04-02 09:00:00", "2023-10-29 08:00:00", 
"2024-04-07 09:00:00", "2024-10-27 08:00:00", "2025-04-06 09:00:00", 
"2025-10-26 08:00:00", "2026-04-05 09:00:00", "2026-10-25 08:00:00", 
"2027-04-04 09:00:00", "2027-10-31 08:00:00", "2028-04-02 09:00:00", 
"2028-10-29 08:00:00", "2029-04-01 09:00:00", "2029-10-28 08:00:00", 
"2030-04-07 09:00:00", "2030-10-27 08:00:00", "2031-04-06 09:00:00", 
"2031-10-26 08:00:00", "2032-04-04 09:00:00", "2032-10-31 08:00:00", 
"2033-04-03 09:00:00", "2033-10-30 08:00:00", "2034-04-02 09:00:00", 
"2034-10-29 08:00:00", "2035-04-01 09:00:00", "2035-10-28 08:00:00", 
"2036-04-06 09:00:00", "2036-10-26 08:00:00", "2037-04-05 09:00:00"
), offSet = c("-25460", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-18000", "-21600", "-18000", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-21600", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600", "-25200", "-21600"
), isdst = c("0", "0", "0", "0", "0", "0", "0", "1", "0", "1", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("MST", "MST", "MST", "MST", "MST", "MST", 
"MST", "MDT", "MST", "MDT", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT")), .Names = c("Chihuahua", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -89L), class = "data.frame")
}

"Hermosillo" <- function () {
structure(list(Hermosillo = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1942-04-24 06:00:00", 
"1949-01-14 07:00:00", "1970-01-01 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00"), offSet = c("-26632", "-25200", "-21600", 
"-25200", "-21600", "-25200", "-21600", "-25200", "-28800", "-25200", 
"-21600", "-25200", "-21600", "-25200", "-21600"), isdst = c("0", 
"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("MST", "MST", "MST", "MST", "MST", "MST", 
"MST", "MST", "MST", "MST", "MDT", "MST", "MDT", "MST", "MDT"
)), .Names = c("Hermosillo", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-15L), class = "data.frame")
}

"Tijuana" <- function () {
structure(list(Tijuana = c("1901-12-14 20:45:52", "1922-01-01 08:00:00", 
"1924-01-01 07:00:00", "1927-06-11 07:00:00", "1930-11-15 07:00:00", 
"1931-04-01 08:00:00", "1931-09-30 07:00:00", "1942-04-24 08:00:00", 
"1945-11-12 07:00:00", "1948-04-05 08:00:00", "1949-01-14 07:00:00", 
"1954-04-25 10:00:00", "1954-09-26 09:00:00", "1955-04-24 10:00:00", 
"1955-09-25 09:00:00", "1956-04-29 10:00:00", "1956-09-30 09:00:00", 
"1957-04-28 10:00:00", "1957-09-29 09:00:00", "1958-04-27 10:00:00", 
"1958-09-28 09:00:00", "1959-04-26 10:00:00", "1959-09-27 09:00:00", 
"1960-04-24 10:00:00", "1960-09-25 09:00:00", "1976-04-25 10:00:00", 
"1976-10-31 09:00:00", "1977-04-24 10:00:00", "1977-10-30 09:00:00", 
"1978-04-30 10:00:00", "1978-10-29 09:00:00", "1979-04-29 10:00:00", 
"1979-10-28 09:00:00", "1980-04-27 10:00:00", "1980-10-26 09:00:00", 
"1981-04-26 10:00:00", "1981-10-25 09:00:00", "1982-04-25 10:00:00", 
"1982-10-31 09:00:00", "1983-04-24 10:00:00", "1983-10-30 09:00:00", 
"1984-04-29 10:00:00", "1984-10-28 09:00:00", "1985-04-28 10:00:00", 
"1985-10-27 09:00:00", "1986-04-27 10:00:00", "1986-10-26 09:00:00", 
"1987-04-05 10:00:00", "1987-10-25 09:00:00", "1988-04-03 10:00:00", 
"1988-10-30 09:00:00", "1989-04-02 10:00:00", "1989-10-29 09:00:00", 
"1990-04-01 10:00:00", "1990-10-28 09:00:00", "1991-04-07 10:00:00", 
"1991-10-27 09:00:00", "1992-04-05 10:00:00", "1992-10-25 09:00:00", 
"1993-04-04 10:00:00", "1993-10-31 09:00:00", "1994-04-03 10:00:00", 
"1994-10-30 09:00:00", "1995-04-02 10:00:00", "1995-10-29 09:00:00", 
"1996-04-07 10:00:00", "1996-10-27 09:00:00", "1997-04-06 10:00:00", 
"1997-10-26 09:00:00", "1998-04-05 10:00:00", "1998-10-25 09:00:00", 
"1999-04-04 10:00:00", "1999-10-31 09:00:00", "2000-04-02 10:00:00", 
"2000-10-29 09:00:00", "2001-04-01 10:00:00", "2001-10-28 09:00:00", 
"2002-04-07 10:00:00", "2002-10-27 09:00:00", "2003-04-06 10:00:00", 
"2003-10-26 09:00:00", "2004-04-04 10:00:00", "2004-10-31 09:00:00", 
"2005-04-03 10:00:00", "2005-10-30 09:00:00", "2006-04-02 10:00:00", 
"2006-10-29 09:00:00", "2007-04-01 10:00:00", "2007-10-28 09:00:00", 
"2008-04-06 10:00:00", "2008-10-26 09:00:00", "2009-04-05 10:00:00", 
"2009-10-25 09:00:00", "2010-04-04 10:00:00", "2010-10-31 09:00:00", 
"2011-04-03 10:00:00", "2011-10-30 09:00:00", "2012-04-01 10:00:00", 
"2012-10-28 09:00:00", "2013-04-07 10:00:00", "2013-10-27 09:00:00", 
"2014-04-06 10:00:00", "2014-10-26 09:00:00", "2015-04-05 10:00:00", 
"2015-10-25 09:00:00", "2016-04-03 10:00:00", "2016-10-30 09:00:00", 
"2017-04-02 10:00:00", "2017-10-29 09:00:00", "2018-04-01 10:00:00", 
"2018-10-28 09:00:00", "2019-04-07 10:00:00", "2019-10-27 09:00:00", 
"2020-04-05 10:00:00", "2020-10-25 09:00:00", "2021-04-04 10:00:00", 
"2021-10-31 09:00:00", "2022-04-03 10:00:00", "2022-10-30 09:00:00", 
"2023-04-02 10:00:00", "2023-10-29 09:00:00", "2024-04-07 10:00:00", 
"2024-10-27 09:00:00", "2025-04-06 10:00:00", "2025-10-26 09:00:00", 
"2026-04-05 10:00:00", "2026-10-25 09:00:00", "2027-04-04 10:00:00", 
"2027-10-31 09:00:00", "2028-04-02 10:00:00", "2028-10-29 09:00:00", 
"2029-04-01 10:00:00", "2029-10-28 09:00:00", "2030-04-07 10:00:00", 
"2030-10-27 09:00:00", "2031-04-06 10:00:00", "2031-10-26 09:00:00", 
"2032-04-04 10:00:00", "2032-10-31 09:00:00", "2033-04-03 10:00:00", 
"2033-10-30 09:00:00", "2034-04-02 10:00:00", "2034-10-29 09:00:00", 
"2035-04-01 10:00:00", "2035-10-28 09:00:00", "2036-04-06 10:00:00", 
"2036-10-26 09:00:00", "2037-04-05 10:00:00"), offSet = c("-28084", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200", 
"-28800", "-25200", "-28800", "-25200", "-28800", "-25200", "-28800", 
"-25200", "-28800", "-25200", "-28800", "-25200", "-28800", "-25200"
), isdst = c("0", "0", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("PST", 
"PST", "PST", "PST", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT")), .Names = c("Tijuana", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -148L), class = "data.frame")
}

"Kuala_Lumpur" <- function () {
structure(list(Kuala_Lumpur = c("1901-12-14 20:45:52", "1905-05-31 17:04:35", 
"1935-12-31 16:40:00", "1941-08-31 16:40:00", "1942-02-15 16:30:00", 
"1945-09-11 15:00:00"), offSet = c("24925", "25200", "26400", 
"27000", "32400", "27000"), isdst = c("0", "0", "0", "0", "0", 
"0"), TimeZone = c("MYT", "MYT", "MYT", "MYT", "MYT", "MYT")), .Names = c("Kuala_Lumpur", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -6L), class = "data.frame")
}

"Kuching" <- function () {
structure(list(Kuching = c("1901-12-14 20:45:52", "1926-02-28 16:38:40", 
"1932-12-31 16:30:00", "1935-09-13 16:00:00", "1935-12-13 15:40:00", 
"1936-09-13 16:00:00", "1936-12-13 15:40:00", "1937-09-13 16:00:00", 
"1937-12-13 15:40:00", "1938-09-13 16:00:00", "1938-12-13 15:40:00", 
"1939-09-13 16:00:00", "1939-12-13 15:40:00", "1940-09-13 16:00:00", 
"1940-12-13 15:40:00", "1941-09-13 16:00:00", "1941-12-13 15:40:00", 
"1942-02-15 16:00:00"), offSet = c("26480", "27000", "28800", 
"30000", "28800", "30000", "28800", "30000", "28800", "30000", 
"28800", "30000", "28800", "30000", "28800", "30000", "28800", 
"32400"), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "0"), TimeZone = c("MYT", 
"MYT", "MYT", "BORTST", "MYT", "BORTST", "MYT", "BORTST", "MYT", 
"BORTST", "MYT", "BORTST", "MYT", "BORTST", "MYT", "BORTST", 
"MYT", "MYT")), .Names = c("Kuching", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -18L), class = "data.frame")
}

"Maputo" <- function () {
structure(list(Maputo = "1901-12-14 20:45:52", offSet = "7820", 
    isdst = "0", TimeZone = "CAT"), .Names = c("Maputo", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Windhoek" <- function () {
structure(list(Windhoek = c("1901-12-14 20:45:52", "1903-02-28 22:30:00", 
"1942-09-20 00:00:00", "1943-03-20 23:00:00", "1994-04-02 22:00:00", 
"1994-09-04 01:00:00", "1995-04-02 00:00:00", "1995-09-03 01:00:00", 
"1996-04-07 00:00:00", "1996-09-01 01:00:00", "1997-04-06 00:00:00", 
"1997-09-07 01:00:00", "1998-04-05 00:00:00", "1998-09-06 01:00:00", 
"1999-04-04 00:00:00", "1999-09-05 01:00:00", "2000-04-02 00:00:00", 
"2000-09-03 01:00:00", "2001-04-01 00:00:00", "2001-09-02 01:00:00", 
"2002-04-07 00:00:00", "2002-09-01 01:00:00", "2003-04-06 00:00:00", 
"2003-09-07 01:00:00", "2004-04-04 00:00:00", "2004-09-05 01:00:00", 
"2005-04-03 00:00:00", "2005-09-04 01:00:00", "2006-04-02 00:00:00", 
"2006-09-03 01:00:00", "2007-04-01 00:00:00", "2007-09-02 01:00:00", 
"2008-04-06 00:00:00", "2008-09-07 01:00:00", "2009-04-05 00:00:00", 
"2009-09-06 01:00:00", "2010-04-04 00:00:00", "2010-09-05 01:00:00", 
"2011-04-03 00:00:00", "2011-09-04 01:00:00", "2012-04-01 00:00:00", 
"2012-09-02 01:00:00", "2013-04-07 00:00:00", "2013-09-01 01:00:00", 
"2014-04-06 00:00:00", "2014-09-07 01:00:00", "2015-04-05 00:00:00", 
"2015-09-06 01:00:00", "2016-04-03 00:00:00", "2016-09-04 01:00:00", 
"2017-04-02 00:00:00", "2017-09-03 01:00:00", "2018-04-01 00:00:00", 
"2018-09-02 01:00:00", "2019-04-07 00:00:00", "2019-09-01 01:00:00", 
"2020-04-05 00:00:00", "2020-09-06 01:00:00", "2021-04-04 00:00:00", 
"2021-09-05 01:00:00", "2022-04-03 00:00:00", "2022-09-04 01:00:00", 
"2023-04-02 00:00:00", "2023-09-03 01:00:00", "2024-04-07 00:00:00", 
"2024-09-01 01:00:00", "2025-04-06 00:00:00", "2025-09-07 01:00:00", 
"2026-04-05 00:00:00", "2026-09-06 01:00:00", "2027-04-04 00:00:00", 
"2027-09-05 01:00:00", "2028-04-02 00:00:00", "2028-09-03 01:00:00", 
"2029-04-01 00:00:00", "2029-09-02 01:00:00", "2030-04-07 00:00:00", 
"2030-09-01 01:00:00", "2031-04-06 00:00:00", "2031-09-07 01:00:00", 
"2032-04-04 00:00:00", "2032-09-05 01:00:00", "2033-04-03 00:00:00", 
"2033-09-04 01:00:00", "2034-04-02 00:00:00", "2034-09-03 01:00:00", 
"2035-04-01 00:00:00", "2035-09-02 01:00:00", "2036-04-06 00:00:00", 
"2036-09-07 01:00:00", "2037-04-05 00:00:00"), offSet = c("5400", 
"7200", "10800", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600"), isdst = c("0", "0", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("WAT", "WAT", "WAST", 
"WAT", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT")), .Names = c("Windhoek", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -91L), class = "data.frame")
}

"Noumea" <- function () {
structure(list(Noumea = c("1901-12-14 20:45:52", "1912-01-12 12:54:12", 
"1977-12-03 13:00:00", "1978-02-26 12:00:00", "1978-12-02 13:00:00", 
"1979-02-26 12:00:00", "1996-11-30 15:00:00"), offSet = c("39948", 
"39600", "43200", "39600", "43200", "39600", "43200"), isdst = c("0", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("NCT", "NCT", "NCST", 
"NCT", "NCST", "NCT", "NCST")), .Names = c("Noumea", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -7L), class = "data.frame")
}

"Niamey" <- function () {
structure(list(Niamey = c("1901-12-14 20:45:52", "1911-12-31 23:51:32", 
"1934-02-26 01:00:00"), offSet = c("508", "-3600", "0"), isdst = c("0", 
"0", "0"), TimeZone = c("WAT", "WAT", "WAT")), .Names = c("Niamey", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -3L), class = "data.frame")
}

"Norfolk" <- function () {
structure(list(Norfolk = "1901-12-14 20:45:52", offSet = "40320", 
    isdst = "0", TimeZone = "NFT"), .Names = c("Norfolk", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Lagos" <- function () {
structure(list(Lagos = "1901-12-14 20:45:52", offSet = "816", 
    isdst = "0", TimeZone = "WAT"), .Names = c("Lagos", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Managua" <- function () {
structure(list(Managua = c("1901-12-14 20:45:52", "1934-06-23 05:45:12", 
"1973-05-01 06:00:00", "1975-02-16 05:00:00", "1979-03-18 06:00:00", 
"1979-06-25 05:00:00", "1980-03-16 06:00:00", "1980-06-23 05:00:00", 
"1992-01-01 10:00:00", "1992-09-24 05:00:00", "1993-01-01 06:00:00", 
"1997-01-01 05:00:00", "2005-04-10 06:00:00", "2005-10-02 05:00:00", 
"2006-04-30 08:00:00"), offSet = c("-20712", "-21600", "-18000", 
"-21600", "-18000", "-21600", "-18000", "-21600", "-18000", "-21600", 
"-18000", "-21600", "-18000", "-21600", "-18000"), isdst = c("0", 
"0", "0", "0", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", 
"1"), TimeZone = c("CST", "CST", "CST", "CST", "CDT", "CST", 
"CDT", "CST", "CST", "CST", "CST", "CST", "CDT", "CST", "CDT"
)), .Names = c("Managua", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-15L), class = "data.frame")
}

"Amsterdam" <- function () {
structure(list(Amsterdam = c("1901-12-14 20:45:52", "1916-04-30 23:40:28", 
"1916-09-30 22:40:28", "1917-04-16 01:40:28", "1917-09-17 01:40:28", 
"1918-04-01 01:40:28", "1918-09-30 01:40:28", "1919-04-07 01:40:28", 
"1919-09-29 01:40:28", "1920-04-05 01:40:28", "1920-09-27 01:40:28", 
"1921-04-04 01:40:28", "1921-09-26 01:40:28", "1922-03-26 01:40:28", 
"1922-10-08 01:40:28", "1923-06-01 01:40:28", "1923-10-07 01:40:28", 
"1924-03-30 01:40:28", "1924-10-05 01:40:28", "1925-06-05 01:40:28", 
"1925-10-04 01:40:28", "1926-05-15 01:40:28", "1926-10-03 01:40:28", 
"1927-05-15 01:40:28", "1927-10-02 01:40:28", "1928-05-15 01:40:28", 
"1928-10-07 01:40:28", "1929-05-15 01:40:28", "1929-10-06 01:40:28", 
"1930-05-15 01:40:28", "1930-10-05 01:40:28", "1931-05-15 01:40:28", 
"1931-10-04 01:40:28", "1932-05-22 01:40:28", "1932-10-02 01:40:28", 
"1933-05-15 01:40:28", "1933-10-08 01:40:28", "1934-05-15 01:40:28", 
"1934-10-07 01:40:28", "1935-05-15 01:40:28", "1935-10-06 01:40:28", 
"1936-05-15 01:40:28", "1936-10-04 01:40:28", "1937-05-22 01:40:28", 
"1937-06-30 22:40:28", "1937-10-03 01:40:00", "1938-05-15 01:40:00", 
"1938-10-02 01:40:00", "1939-05-15 01:40:00", "1939-10-08 01:40:00", 
"1940-05-15 23:40:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-10-02 01:00:00", 
"1945-04-02 01:00:00", "1945-09-16 01:00:00", "1977-04-03 01:00:00", 
"1977-09-25 01:00:00", "1978-04-02 01:00:00", "1978-10-01 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("1172", "4772", "1172", "4772", "1172", "4772", 
"1172", "4772", "1172", "4772", "1172", "4772", "1172", "4772", 
"1172", "4772", "1172", "4772", "1172", "4772", "1172", "4772", 
"1172", "4772", "1172", "4772", "1172", "4772", "1172", "4772", 
"1172", "4772", "1172", "4772", "1172", "4772", "1172", "4772", 
"1172", "4772", "1172", "4772", "1172", "4772", "4800", "1200", 
"4800", "1200", "4800", "1200", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST")), .Names = c("Amsterdam", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -179L), class = "data.frame")
}

"Oslo" <- function () {
structure(list(Oslo = c("1901-12-14 20:45:52", "1916-05-22 00:00:00", 
"1916-09-29 22:00:00", "1940-08-10 22:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-10-01 01:00:00", 
"1959-03-15 01:00:00", "1959-09-20 01:00:00", "1960-03-20 01:00:00", 
"1960-09-18 01:00:00", "1961-03-19 01:00:00", "1961-09-17 01:00:00", 
"1962-03-18 01:00:00", "1962-09-16 01:00:00", "1963-03-17 01:00:00", 
"1963-09-15 01:00:00", "1964-03-15 01:00:00", "1964-09-20 01:00:00", 
"1965-04-25 01:00:00", "1965-09-19 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST")), .Names = c("Oslo", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -140L), class = "data.frame")
}

"Katmandu" <- function () {
structure(list(Katmandu = c("1901-12-14 20:45:52", "1919-12-31 18:18:44"
), offSet = c("20476", "19800"), isdst = c("0", "0"), TimeZone = c("NPT", 
"NPT")), .Names = c("Katmandu", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Nauru" <- function () {
structure(list(Nauru = c("1901-12-14 20:45:52", "1921-01-14 12:52:20", 
"1942-03-14 12:30:00", "1944-08-14 15:00:00"), offSet = c("40060", 
"41400", "32400", "41400"), isdst = c("0", "0", "0", "0"), TimeZone = c("NRT", 
"NRT", "NRT", "NRT")), .Names = c("Nauru", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -4L), class = "data.frame")
}

"Niue" <- function () {
structure(list(Niue = c("1901-12-14 20:45:52", "1951-01-01 11:20:00"
), offSet = c("-40800", "-41400"), isdst = c("0", "0"), TimeZone = c("NUT", 
"NUT")), .Names = c("Niue", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Auckland" <- function () {
structure(list(Auckland = c("1901-12-14 20:45:52", "1927-11-05 14:30:00", 
"1928-03-03 13:30:00", "1928-10-13 14:30:00", "1929-03-16 14:00:00", 
"1929-10-12 14:30:00", "1930-03-15 14:00:00", "1930-10-11 14:30:00", 
"1931-03-14 14:00:00", "1931-10-10 14:30:00", "1932-03-19 14:00:00", 
"1932-10-08 14:30:00", "1933-03-18 14:00:00", "1933-10-07 14:30:00", 
"1934-04-28 14:00:00", "1934-09-29 14:30:00", "1935-04-27 14:00:00", 
"1935-09-28 14:30:00", "1936-04-25 14:00:00", "1936-09-26 14:30:00", 
"1937-04-24 14:00:00", "1937-09-25 14:30:00", "1938-04-23 14:00:00", 
"1938-09-24 14:30:00", "1939-04-29 14:00:00", "1939-09-23 14:30:00", 
"1940-04-27 14:00:00", "1945-12-31 12:00:00", "1974-11-02 14:00:00", 
"1975-02-22 14:00:00", "1975-10-25 14:00:00", "1976-03-06 14:00:00", 
"1976-10-30 14:00:00", "1977-03-05 14:00:00", "1977-10-29 14:00:00", 
"1978-03-04 14:00:00", "1978-10-28 14:00:00", "1979-03-03 14:00:00", 
"1979-10-27 14:00:00", "1980-03-01 14:00:00", "1980-10-25 14:00:00", 
"1981-02-28 14:00:00", "1981-10-24 14:00:00", "1982-03-06 14:00:00", 
"1982-10-30 14:00:00", "1983-03-05 14:00:00", "1983-10-29 14:00:00", 
"1984-03-03 14:00:00", "1984-10-27 14:00:00", "1985-03-02 14:00:00", 
"1985-10-26 14:00:00", "1986-03-01 14:00:00", "1986-10-25 14:00:00", 
"1987-02-28 14:00:00", "1987-10-24 14:00:00", "1988-03-05 14:00:00", 
"1988-10-29 14:00:00", "1989-03-04 14:00:00", "1989-10-07 14:00:00", 
"1990-03-17 14:00:00", "1990-10-06 14:00:00", "1991-03-16 14:00:00", 
"1991-10-05 14:00:00", "1992-03-14 14:00:00", "1992-10-03 14:00:00", 
"1993-03-20 14:00:00", "1993-10-02 14:00:00", "1994-03-19 14:00:00", 
"1994-10-01 14:00:00", "1995-03-18 14:00:00", "1995-09-30 14:00:00", 
"1996-03-16 14:00:00", "1996-10-05 14:00:00", "1997-03-15 14:00:00", 
"1997-10-04 14:00:00", "1998-03-14 14:00:00", "1998-10-03 14:00:00", 
"1999-03-20 14:00:00", "1999-10-02 14:00:00", "2000-03-18 14:00:00", 
"2000-09-30 14:00:00", "2001-03-17 14:00:00", "2001-10-06 14:00:00", 
"2002-03-16 14:00:00", "2002-10-05 14:00:00", "2003-03-15 14:00:00", 
"2003-10-04 14:00:00", "2004-03-20 14:00:00", "2004-10-02 14:00:00", 
"2005-03-19 14:00:00", "2005-10-01 14:00:00", "2006-03-18 14:00:00", 
"2006-09-30 14:00:00", "2007-03-17 14:00:00", "2007-09-29 14:00:00", 
"2008-04-05 14:00:00", "2008-09-27 14:00:00", "2009-04-04 14:00:00", 
"2009-09-26 14:00:00", "2010-04-03 14:00:00", "2010-09-25 14:00:00", 
"2011-04-02 14:00:00", "2011-09-24 14:00:00", "2012-03-31 14:00:00", 
"2012-09-29 14:00:00", "2013-04-06 14:00:00", "2013-09-28 14:00:00", 
"2014-04-05 14:00:00", "2014-09-27 14:00:00", "2015-04-04 14:00:00", 
"2015-09-26 14:00:00", "2016-04-02 14:00:00", "2016-09-24 14:00:00", 
"2017-04-01 14:00:00", "2017-09-23 14:00:00", "2018-03-31 14:00:00", 
"2018-09-29 14:00:00", "2019-04-06 14:00:00", "2019-09-28 14:00:00", 
"2020-04-04 14:00:00", "2020-09-26 14:00:00", "2021-04-03 14:00:00", 
"2021-09-25 14:00:00", "2022-04-02 14:00:00", "2022-09-24 14:00:00", 
"2023-04-01 14:00:00", "2023-09-23 14:00:00", "2024-04-06 14:00:00", 
"2024-09-28 14:00:00", "2025-04-05 14:00:00", "2025-09-27 14:00:00", 
"2026-04-04 14:00:00", "2026-09-26 14:00:00", "2027-04-03 14:00:00", 
"2027-09-25 14:00:00", "2028-04-01 14:00:00", "2028-09-23 14:00:00", 
"2029-03-31 14:00:00", "2029-09-29 14:00:00", "2030-04-06 14:00:00", 
"2030-09-28 14:00:00", "2031-04-05 14:00:00", "2031-09-27 14:00:00", 
"2032-04-03 14:00:00", "2032-09-25 14:00:00", "2033-04-02 14:00:00", 
"2033-09-24 14:00:00", "2034-04-01 14:00:00", "2034-09-23 14:00:00", 
"2035-03-31 14:00:00", "2035-09-29 14:00:00", "2036-04-05 14:00:00", 
"2036-09-27 14:00:00", "2037-04-04 14:00:00"), offSet = c("41400", 
"45000", "41400", "43200", "41400", "43200", "41400", "43200", 
"41400", "43200", "41400", "43200", "41400", "43200", "41400", 
"43200", "41400", "43200", "41400", "43200", "41400", "43200", 
"41400", "43200", "41400", "43200", "41400", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200"), isdst = c("0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("NZST", 
"NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", 
"NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", 
"NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", 
"NZDT", "NZST", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST")), .Names = c("Auckland", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -154L), class = "data.frame")
}

"Chatham" <- function () {
structure(list(Chatham = c("1901-12-14 20:45:52", "1956-12-31 11:46:12", 
"1974-11-02 14:00:00", "1975-02-22 14:00:00", "1975-10-25 14:00:00", 
"1976-03-06 14:00:00", "1976-10-30 14:00:00", "1977-03-05 14:00:00", 
"1977-10-29 14:00:00", "1978-03-04 14:00:00", "1978-10-28 14:00:00", 
"1979-03-03 14:00:00", "1979-10-27 14:00:00", "1980-03-01 14:00:00", 
"1980-10-25 14:00:00", "1981-02-28 14:00:00", "1981-10-24 14:00:00", 
"1982-03-06 14:00:00", "1982-10-30 14:00:00", "1983-03-05 14:00:00", 
"1983-10-29 14:00:00", "1984-03-03 14:00:00", "1984-10-27 14:00:00", 
"1985-03-02 14:00:00", "1985-10-26 14:00:00", "1986-03-01 14:00:00", 
"1986-10-25 14:00:00", "1987-02-28 14:00:00", "1987-10-24 14:00:00", 
"1988-03-05 14:00:00", "1988-10-29 14:00:00", "1989-03-04 14:00:00", 
"1989-10-07 14:00:00", "1990-03-17 14:00:00", "1990-10-06 14:00:00", 
"1991-03-16 14:00:00", "1991-10-05 14:00:00", "1992-03-14 14:00:00", 
"1992-10-03 14:00:00", "1993-03-20 14:00:00", "1993-10-02 14:00:00", 
"1994-03-19 14:00:00", "1994-10-01 14:00:00", "1995-03-18 14:00:00", 
"1995-09-30 14:00:00", "1996-03-16 14:00:00", "1996-10-05 14:00:00", 
"1997-03-15 14:00:00", "1997-10-04 14:00:00", "1998-03-14 14:00:00", 
"1998-10-03 14:00:00", "1999-03-20 14:00:00", "1999-10-02 14:00:00", 
"2000-03-18 14:00:00", "2000-09-30 14:00:00", "2001-03-17 14:00:00", 
"2001-10-06 14:00:00", "2002-03-16 14:00:00", "2002-10-05 14:00:00", 
"2003-03-15 14:00:00", "2003-10-04 14:00:00", "2004-03-20 14:00:00", 
"2004-10-02 14:00:00", "2005-03-19 14:00:00", "2005-10-01 14:00:00", 
"2006-03-18 14:00:00", "2006-09-30 14:00:00", "2007-03-17 14:00:00", 
"2007-09-29 14:00:00", "2008-04-05 14:00:00", "2008-09-27 14:00:00", 
"2009-04-04 14:00:00", "2009-09-26 14:00:00", "2010-04-03 14:00:00", 
"2010-09-25 14:00:00", "2011-04-02 14:00:00", "2011-09-24 14:00:00", 
"2012-03-31 14:00:00", "2012-09-29 14:00:00", "2013-04-06 14:00:00", 
"2013-09-28 14:00:00", "2014-04-05 14:00:00", "2014-09-27 14:00:00", 
"2015-04-04 14:00:00", "2015-09-26 14:00:00", "2016-04-02 14:00:00", 
"2016-09-24 14:00:00", "2017-04-01 14:00:00", "2017-09-23 14:00:00", 
"2018-03-31 14:00:00", "2018-09-29 14:00:00", "2019-04-06 14:00:00", 
"2019-09-28 14:00:00", "2020-04-04 14:00:00", "2020-09-26 14:00:00", 
"2021-04-03 14:00:00", "2021-09-25 14:00:00", "2022-04-02 14:00:00", 
"2022-09-24 14:00:00", "2023-04-01 14:00:00", "2023-09-23 14:00:00", 
"2024-04-06 14:00:00", "2024-09-28 14:00:00", "2025-04-05 14:00:00", 
"2025-09-27 14:00:00", "2026-04-04 14:00:00", "2026-09-26 14:00:00", 
"2027-04-03 14:00:00", "2027-09-25 14:00:00", "2028-04-01 14:00:00", 
"2028-09-23 14:00:00", "2029-03-31 14:00:00", "2029-09-29 14:00:00", 
"2030-04-06 14:00:00", "2030-09-28 14:00:00", "2031-04-05 14:00:00", 
"2031-09-27 14:00:00", "2032-04-03 14:00:00", "2032-09-25 14:00:00", 
"2033-04-02 14:00:00", "2033-09-24 14:00:00", "2034-04-01 14:00:00", 
"2034-09-23 14:00:00", "2035-03-31 14:00:00", "2035-09-29 14:00:00", 
"2036-04-05 14:00:00", "2036-09-27 14:00:00", "2037-04-04 14:00:00"
), offSet = c("44028", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900", "49500", "45900", "49500", "45900", 
"49500", "45900", "49500", "45900", "49500", "45900", "49500", 
"45900", "49500", "45900"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0"), TimeZone = c("CHAST", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", 
"CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", 
"CHAST", "CHADT", "CHAST", "CHADT", "CHAST", "CHADT", "CHAST"
)), .Names = c("Chatham", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-128L), class = "data.frame")
}

"Muscat" <- function () {
structure(list(Muscat = "1901-12-14 20:45:52", offSet = "14060", 
    isdst = "0", TimeZone = "GST"), .Names = c("Muscat", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Panama" <- function () {
structure(list(Panama = "1901-12-14 20:45:52", offSet = "-19176", 
    isdst = "0", TimeZone = "EST"), .Names = c("Panama", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Lima" <- function () {
structure(list(Lima = c("1901-12-14 20:45:52", "1908-07-28 05:08:36", 
"1938-01-01 05:00:00", "1938-04-01 04:00:00", "1938-09-25 05:00:00", 
"1939-03-26 04:00:00", "1939-09-24 05:00:00", "1940-03-24 04:00:00", 
"1986-01-01 05:00:00", "1986-04-01 04:00:00", "1987-01-01 05:00:00", 
"1987-04-01 04:00:00", "1990-01-01 05:00:00", "1990-04-01 04:00:00", 
"1994-01-01 05:00:00"), offSet = c("-18516", "-18000", "-14400", 
"-18000", "-14400", "-18000", "-14400", "-18000", "-14400", "-18000", 
"-14400", "-18000", "-14400", "-18000", "-14400"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1"), TimeZone = c("PET", "PET", "PEST", "PET", "PEST", "PET", 
"PEST", "PET", "PEST", "PET", "PEST", "PET", "PEST", "PET", "PEST"
)), .Names = c("Lima", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-15L), class = "data.frame")
}

"Tahiti" <- function () {
structure(list(Tahiti = "1901-12-14 20:45:52", offSet = "-35896", 
    isdst = "0", TimeZone = "TAHT"), .Names = c("Tahiti", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Marquesas" <- function () {
structure(list(Marquesas = "1901-12-14 20:45:52", offSet = "-33480", 
    isdst = "0", TimeZone = "MART"), .Names = c("Marquesas", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Gambier" <- function () {
structure(list(Gambier = "1901-12-14 20:45:52", offSet = "-32388", 
    isdst = "0", TimeZone = "GAMT"), .Names = c("Gambier", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Port_Moresby" <- function () {
structure(list(Port_Moresby = "1901-12-14 20:45:52", offSet = "36000", 
    isdst = "0", TimeZone = "PGT"), .Names = c("Port_Moresby", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Manila" <- function () {
structure(list(Manila = c("1901-12-14 20:45:52", "1936-10-31 16:00:00", 
"1937-01-31 15:00:00", "1942-04-30 16:00:00", "1944-10-31 15:00:00", 
"1954-04-11 16:00:00", "1954-06-30 15:00:00", "1978-03-21 16:00:00"
), offSet = c("28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400"), isdst = c("0", "1", "0", "0", "0", "1", "0", 
"1"), TimeZone = c("PHT", "PHST", "PHT", "PHT", "PHT", "PHST", 
"PHT", "PHST")), .Names = c("Manila", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -8L), class = "data.frame")
}

"Karachi" <- function () {
structure(list(Karachi = c("1901-12-14 20:45:52", "1906-12-31 19:31:48", 
"1942-08-31 18:30:00", "1945-10-14 17:30:00", "1951-09-29 18:30:00", 
"2002-04-06 19:01:00"), offSet = c("16092", "19800", "23400", 
"19800", "18000", "21600"), isdst = c("0", "0", "1", "0", "0", 
"1"), TimeZone = c("PKT", "PKT", "PKST", "PKT", "PKT", "PKST"
)), .Names = c("Karachi", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-6L), class = "data.frame")
}

"Warsaw" <- function () {
structure(list(Warsaw = c("1901-12-14 20:45:52", "1915-08-04 22:36:00", 
"1916-04-30 22:00:00", "1916-09-30 23:00:00", "1917-04-16 01:00:00", 
"1917-09-17 01:00:00", "1918-09-16 01:00:00", "1919-04-15 00:00:00", 
"1919-09-16 00:00:00", "1922-05-31 22:00:00", "1940-06-23 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-04 00:00:00", "1945-04-28 23:00:00", 
"1945-10-31 22:00:00", "1946-04-13 23:00:00", "1946-10-07 01:00:00", 
"1947-05-04 01:00:00", "1947-10-05 01:00:00", "1948-04-18 01:00:00", 
"1948-10-03 01:00:00", "1949-04-10 01:00:00", "1949-10-02 01:00:00", 
"1957-06-02 00:00:00", "1957-09-29 00:00:00", "1958-03-30 00:00:00", 
"1958-09-28 00:00:00", "1959-05-31 00:00:00", "1959-10-04 00:00:00", 
"1960-04-03 00:00:00", "1960-10-02 00:00:00", "1961-05-28 00:00:00", 
"1961-10-01 00:00:00", "1962-05-27 00:00:00", "1962-09-30 00:00:00", 
"1963-05-26 00:00:00", "1963-09-29 00:00:00", "1964-05-31 00:00:00", 
"1964-09-27 00:00:00", "1977-04-03 00:00:00", "1977-09-25 00:00:00", 
"1978-04-02 00:00:00", "1978-10-01 00:00:00", "1979-04-01 00:00:00", 
"1979-09-30 00:00:00", "1980-04-06 00:00:00", "1980-09-28 00:00:00", 
"1981-03-29 00:00:00", "1981-09-27 00:00:00", "1982-03-28 00:00:00", 
"1982-09-26 00:00:00", "1983-03-27 00:00:00", "1983-09-25 00:00:00", 
"1984-03-25 00:00:00", "1984-09-30 00:00:00", "1985-03-31 00:00:00", 
"1985-09-29 00:00:00", "1986-03-30 00:00:00", "1986-09-28 00:00:00", 
"1987-03-29 00:00:00", "1987-09-27 00:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("5040", 
"3600", "7200", "3600", "7200", "3600", "7200", "10800", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200"), isdst = c("0", "0", "1", "0", "1", "0", "0", 
"1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("CET", "CET", "CEST", "CET", "CEST", "CET", "CET", 
"CEST", "CET", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST")), .Names = c("Warsaw", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -163L), class = "data.frame")
}

"Miquelon" <- function () {
structure(list(Miquelon = c("1901-12-14 20:45:52", "1911-05-15 03:44:40", 
"1980-05-01 04:00:00", "1987-04-05 05:00:00", "1987-10-25 04:00:00", 
"1988-04-03 05:00:00", "1988-10-30 04:00:00", "1989-04-02 05:00:00", 
"1989-10-29 04:00:00", "1990-04-01 05:00:00", "1990-10-28 04:00:00", 
"1991-04-07 05:00:00", "1991-10-27 04:00:00", "1992-04-05 05:00:00", 
"1992-10-25 04:00:00", "1993-04-04 05:00:00", "1993-10-31 04:00:00", 
"1994-04-03 05:00:00", "1994-10-30 04:00:00", "1995-04-02 05:00:00", 
"1995-10-29 04:00:00", "1996-04-07 05:00:00", "1996-10-27 04:00:00", 
"1997-04-06 05:00:00", "1997-10-26 04:00:00", "1998-04-05 05:00:00", 
"1998-10-25 04:00:00", "1999-04-04 05:00:00", "1999-10-31 04:00:00", 
"2000-04-02 05:00:00", "2000-10-29 04:00:00", "2001-04-01 05:00:00", 
"2001-10-28 04:00:00", "2002-04-07 05:00:00", "2002-10-27 04:00:00", 
"2003-04-06 05:00:00", "2003-10-26 04:00:00", "2004-04-04 05:00:00", 
"2004-10-31 04:00:00", "2005-04-03 05:00:00", "2005-10-30 04:00:00", 
"2006-04-02 05:00:00", "2006-10-29 04:00:00", "2007-03-11 05:00:00", 
"2007-11-04 04:00:00", "2008-03-09 05:00:00", "2008-11-02 04:00:00", 
"2009-03-08 05:00:00", "2009-11-01 04:00:00", "2010-03-14 05:00:00", 
"2010-11-07 04:00:00", "2011-03-13 05:00:00", "2011-11-06 04:00:00", 
"2012-03-11 05:00:00", "2012-11-04 04:00:00", "2013-03-10 05:00:00", 
"2013-11-03 04:00:00", "2014-03-09 05:00:00", "2014-11-02 04:00:00", 
"2015-03-08 05:00:00", "2015-11-01 04:00:00", "2016-03-13 05:00:00", 
"2016-11-06 04:00:00", "2017-03-12 05:00:00", "2017-11-05 04:00:00", 
"2018-03-11 05:00:00", "2018-11-04 04:00:00", "2019-03-10 05:00:00", 
"2019-11-03 04:00:00", "2020-03-08 05:00:00", "2020-11-01 04:00:00", 
"2021-03-14 05:00:00", "2021-11-07 04:00:00", "2022-03-13 05:00:00", 
"2022-11-06 04:00:00", "2023-03-12 05:00:00", "2023-11-05 04:00:00", 
"2024-03-10 05:00:00", "2024-11-03 04:00:00", "2025-03-09 05:00:00", 
"2025-11-02 04:00:00", "2026-03-08 05:00:00", "2026-11-01 04:00:00", 
"2027-03-14 05:00:00", "2027-11-07 04:00:00", "2028-03-12 05:00:00", 
"2028-11-05 04:00:00", "2029-03-11 05:00:00", "2029-11-04 04:00:00", 
"2030-03-10 05:00:00", "2030-11-03 04:00:00", "2031-03-09 05:00:00", 
"2031-11-02 04:00:00", "2032-03-14 05:00:00", "2032-11-07 04:00:00", 
"2033-03-13 05:00:00", "2033-11-06 04:00:00", "2034-03-12 05:00:00", 
"2034-11-05 04:00:00", "2035-03-11 05:00:00", "2035-11-04 04:00:00", 
"2036-03-09 05:00:00", "2036-11-02 04:00:00", "2037-03-08 05:00:00"
), offSet = c("-13480", "-14400", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200", "-10800", "-7200", "-10800", "-7200", "-10800", "-7200", 
"-10800", "-7200", "-10800", "-7200", "-10800", "-7200", "-10800", 
"-7200"), isdst = c("0", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("PMST", "PMST", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", 
"PMST", "PMDT", "PMST", "PMDT")), .Names = c("Miquelon", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -104L), class = "data.frame")
}

"Pitcairn" <- function () {
structure(list(Pitcairn = "1901-12-14 20:45:52", offSet = "-30600", 
    isdst = "0", TimeZone = "PST"), .Names = c("Pitcairn", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Puerto_Rico" <- function () {
structure(list(Puerto_Rico = c("1901-12-14 20:45:52", "1942-05-03 04:00:00"
), offSet = c("-14400", "-10800"), isdst = c("0", "1"), TimeZone = c("AST", 
"APT")), .Names = c("Puerto_Rico", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -2L), class = "data.frame")
}

"Gaza" <- function () {
structure(list(Gaza = c("1901-12-14 20:45:52", "1940-05-31 22:00:00", 
"1942-10-31 21:00:00", "1943-04-01 00:00:00", "1943-10-31 21:00:00", 
"1944-03-31 22:00:00", "1944-10-31 21:00:00", "1945-04-15 22:00:00", 
"1945-10-31 23:00:00", "1946-04-16 00:00:00", "1946-10-31 21:00:00", 
"1957-05-09 22:00:00", "1957-09-30 21:00:00", "1958-04-30 22:00:00", 
"1958-09-30 21:00:00", "1959-04-30 23:00:00", "1959-09-30 00:00:00", 
"1960-04-30 23:00:00", "1960-09-30 00:00:00", "1961-04-30 23:00:00", 
"1961-09-30 00:00:00", "1962-04-30 23:00:00", "1962-09-30 00:00:00", 
"1963-04-30 23:00:00", "1963-09-30 00:00:00", "1964-04-30 23:00:00", 
"1964-09-30 00:00:00", "1965-04-30 23:00:00", "1965-09-30 00:00:00", 
"1966-04-30 23:00:00", "1966-10-01 00:00:00", "1967-04-30 23:00:00", 
"1967-06-04 21:00:00", "1974-07-06 22:00:00", "1974-10-12 21:00:00", 
"1975-04-19 22:00:00", "1975-08-30 21:00:00", "1985-04-13 22:00:00", 
"1985-09-14 21:00:00", "1986-05-17 22:00:00", "1986-09-06 21:00:00", 
"1987-04-14 22:00:00", "1987-09-12 21:00:00", "1988-04-08 22:00:00", 
"1988-09-02 21:00:00", "1989-04-29 22:00:00", "1989-09-02 21:00:00", 
"1990-03-24 22:00:00", "1990-08-25 21:00:00", "1991-03-23 22:00:00", 
"1991-08-31 21:00:00", "1992-03-28 22:00:00", "1992-09-05 21:00:00", 
"1993-04-01 22:00:00", "1993-09-04 21:00:00", "1994-03-31 22:00:00", 
"1994-08-27 21:00:00", "1995-03-30 22:00:00", "1995-09-02 21:00:00", 
"1996-04-04 22:00:00", "1996-09-19 22:00:00", "1997-04-03 22:00:00", 
"1997-09-18 22:00:00", "1998-04-02 22:00:00", "1998-09-17 22:00:00", 
"1999-04-15 22:00:00", "1999-10-14 21:00:00", "2000-04-20 22:00:00", 
"2000-10-19 21:00:00", "2001-04-19 22:00:00", "2001-10-18 21:00:00", 
"2002-04-18 22:00:00", "2002-10-17 21:00:00", "2003-04-17 22:00:00", 
"2003-10-16 21:00:00", "2004-04-15 22:00:00", "2004-09-30 22:00:00", 
"2005-04-14 22:00:00", "2005-10-03 23:00:00", "2006-03-31 22:00:00", 
"2006-09-21 21:00:00", "2007-03-31 22:00:00", "2007-09-12 23:00:00", 
"2008-03-31 22:00:00", "2008-09-10 23:00:00", "2009-03-31 22:00:00", 
"2009-09-09 23:00:00", "2010-03-31 22:00:00", "2010-09-08 23:00:00", 
"2011-03-31 22:00:00", "2011-09-07 23:00:00", "2012-03-31 22:00:00", 
"2012-09-12 23:00:00", "2013-03-31 22:00:00", "2013-09-11 23:00:00", 
"2014-03-31 22:00:00", "2014-09-10 23:00:00", "2015-03-31 22:00:00", 
"2015-09-09 23:00:00", "2016-03-31 22:00:00", "2016-09-07 23:00:00", 
"2017-03-31 22:00:00", "2017-09-13 23:00:00", "2018-03-31 22:00:00", 
"2018-09-12 23:00:00", "2019-03-31 22:00:00", "2019-09-11 23:00:00", 
"2020-03-31 22:00:00", "2020-09-09 23:00:00", "2021-03-31 22:00:00", 
"2021-09-08 23:00:00", "2022-03-31 22:00:00", "2022-09-07 23:00:00", 
"2023-03-31 22:00:00", "2023-09-13 23:00:00", "2024-03-31 22:00:00", 
"2024-09-11 23:00:00", "2025-03-31 22:00:00", "2025-09-10 23:00:00", 
"2026-03-31 22:00:00", "2026-09-09 23:00:00", "2027-03-31 22:00:00", 
"2027-09-08 23:00:00", "2028-03-31 22:00:00", "2028-09-13 23:00:00", 
"2029-03-31 22:00:00", "2029-09-12 23:00:00", "2030-03-31 22:00:00", 
"2030-09-11 23:00:00", "2031-03-31 22:00:00", "2031-09-10 23:00:00", 
"2032-03-31 22:00:00", "2032-09-08 23:00:00", "2033-03-31 22:00:00", 
"2033-09-07 23:00:00", "2034-03-31 22:00:00", "2034-09-13 23:00:00", 
"2035-03-31 22:00:00", "2035-09-12 23:00:00", "2036-03-31 22:00:00", 
"2036-09-10 23:00:00", "2037-03-31 22:00:00"), offSet = c("7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Gaza", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -142L), class = "data.frame")
}

"Lisbon" <- function () {
structure(list(Lisbon = c("1901-12-14 20:45:52", "1912-01-01 00:36:32", 
"1916-06-17 23:00:00", "1916-11-01 00:00:00", "1917-02-28 23:00:00", 
"1917-10-14 23:00:00", "1918-03-01 23:00:00", "1918-10-14 23:00:00", 
"1919-02-28 23:00:00", "1919-10-14 23:00:00", "1920-02-29 23:00:00", 
"1920-10-14 23:00:00", "1921-02-28 23:00:00", "1921-10-14 23:00:00", 
"1924-04-16 23:00:00", "1924-10-14 23:00:00", "1926-04-17 23:00:00", 
"1926-10-02 23:00:00", "1927-04-09 23:00:00", "1927-10-01 23:00:00", 
"1928-04-14 23:00:00", "1928-10-06 23:00:00", "1929-04-20 23:00:00", 
"1929-10-05 23:00:00", "1931-04-18 23:00:00", "1931-10-03 23:00:00", 
"1932-04-02 23:00:00", "1932-10-01 23:00:00", "1934-04-07 23:00:00", 
"1934-10-06 23:00:00", "1935-03-30 23:00:00", "1935-10-05 23:00:00", 
"1936-04-18 23:00:00", "1936-10-03 23:00:00", "1937-04-03 23:00:00", 
"1937-10-02 23:00:00", "1938-03-26 23:00:00", "1938-10-01 23:00:00", 
"1939-04-15 23:00:00", "1939-11-18 23:00:00", "1940-02-24 23:00:00", 
"1940-10-05 23:00:00", "1941-04-05 23:00:00", "1941-10-05 23:00:00", 
"1942-03-14 23:00:00", "1942-04-25 22:00:00", "1942-08-15 22:00:00", 
"1942-10-24 23:00:00", "1943-03-13 23:00:00", "1943-04-17 22:00:00", 
"1943-08-28 22:00:00", "1943-10-30 23:00:00", "1944-03-11 23:00:00", 
"1944-04-22 22:00:00", "1944-08-26 22:00:00", "1944-10-28 23:00:00", 
"1945-03-10 23:00:00", "1945-04-21 22:00:00", "1945-08-25 22:00:00", 
"1945-10-27 23:00:00", "1946-04-06 23:00:00", "1946-10-05 23:00:00", 
"1947-04-06 02:00:00", "1947-10-05 02:00:00", "1948-04-04 02:00:00", 
"1948-10-03 02:00:00", "1949-04-03 02:00:00", "1949-10-02 02:00:00", 
"1951-04-01 02:00:00", "1951-10-07 02:00:00", "1952-04-06 02:00:00", 
"1952-10-05 02:00:00", "1953-04-05 02:00:00", "1953-10-04 02:00:00", 
"1954-04-04 02:00:00", "1954-10-03 02:00:00", "1955-04-03 02:00:00", 
"1955-10-02 02:00:00", "1956-04-01 02:00:00", "1956-10-07 02:00:00", 
"1957-04-07 02:00:00", "1957-10-06 02:00:00", "1958-04-06 02:00:00", 
"1958-10-05 02:00:00", "1959-04-05 02:00:00", "1959-10-04 02:00:00", 
"1960-04-03 02:00:00", "1960-10-02 02:00:00", "1961-04-02 02:00:00", 
"1961-10-01 02:00:00", "1962-04-01 02:00:00", "1962-10-07 02:00:00", 
"1963-04-07 02:00:00", "1963-10-06 02:00:00", "1964-04-05 02:00:00", 
"1964-10-04 02:00:00", "1965-04-04 02:00:00", "1965-10-03 02:00:00", 
"1966-04-03 02:00:00", "1976-09-26 00:00:00", "1977-03-27 00:00:00", 
"1977-09-25 00:00:00", "1978-04-02 00:00:00", "1978-10-01 00:00:00", 
"1979-04-01 00:00:00", "1979-09-30 01:00:00", "1980-03-30 00:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 02:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("-2192", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "7200", "3600", "0", "3600", "7200", "3600", "0", "3600", 
"7200", "3600", "0", "3600", "7200", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", 
"3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "1", "1", "0", "1", "1", "1", "0", "1", 
"1", "1", "0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "0", 
"1", "0", "1", "0", "1", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("WET", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WEST", 
"WEST", "WET", "WEST", "WEST", "WEST", "WET", "WEST", "WEST", 
"WEST", "WET", "WEST", "WEST", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WET", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST")), .Names = c("Lisbon", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -219L), class = "data.frame")
}

"Madeira" <- function () {
structure(list(Madeira = c("1901-12-14 20:45:52", "1911-05-24 01:07:36", 
"1916-06-18 00:00:00", "1916-11-01 01:00:00", "1917-03-01 00:00:00", 
"1917-10-15 00:00:00", "1918-03-02 00:00:00", "1918-10-15 00:00:00", 
"1919-03-01 00:00:00", "1919-10-15 00:00:00", "1920-03-01 00:00:00", 
"1920-10-15 00:00:00", "1921-03-01 00:00:00", "1921-10-15 00:00:00", 
"1924-04-17 00:00:00", "1924-10-15 00:00:00", "1926-04-18 00:00:00", 
"1926-10-03 00:00:00", "1927-04-10 00:00:00", "1927-10-02 00:00:00", 
"1928-04-15 00:00:00", "1928-10-07 00:00:00", "1929-04-21 00:00:00", 
"1929-10-06 00:00:00", "1931-04-19 00:00:00", "1931-10-04 00:00:00", 
"1932-04-03 00:00:00", "1932-10-02 00:00:00", "1934-04-08 00:00:00", 
"1934-10-07 00:00:00", "1935-03-31 00:00:00", "1935-10-06 00:00:00", 
"1936-04-19 00:00:00", "1936-10-04 00:00:00", "1937-04-04 00:00:00", 
"1937-10-03 00:00:00", "1938-03-27 00:00:00", "1938-10-02 00:00:00", 
"1939-04-16 00:00:00", "1939-11-19 00:00:00", "1940-02-25 00:00:00", 
"1940-10-06 00:00:00", "1941-04-06 00:00:00", "1941-10-06 00:00:00", 
"1942-03-15 00:00:00", "1942-04-25 23:00:00", "1942-08-15 23:00:00", 
"1942-10-25 00:00:00", "1943-03-14 00:00:00", "1943-04-17 23:00:00", 
"1943-08-28 23:00:00", "1943-10-31 00:00:00", "1944-03-12 00:00:00", 
"1944-04-22 23:00:00", "1944-08-26 23:00:00", "1944-10-29 00:00:00", 
"1945-03-11 00:00:00", "1945-04-21 23:00:00", "1945-08-25 23:00:00", 
"1945-10-28 00:00:00", "1946-04-07 00:00:00", "1946-10-06 00:00:00", 
"1947-04-06 03:00:00", "1947-10-05 03:00:00", "1948-04-04 03:00:00", 
"1948-10-03 03:00:00", "1949-04-03 03:00:00", "1949-10-02 03:00:00", 
"1951-04-01 03:00:00", "1951-10-07 03:00:00", "1952-04-06 03:00:00", 
"1952-10-05 03:00:00", "1953-04-05 03:00:00", "1953-10-04 03:00:00", 
"1954-04-04 03:00:00", "1954-10-03 03:00:00", "1955-04-03 03:00:00", 
"1955-10-02 03:00:00", "1956-04-01 03:00:00", "1956-10-07 03:00:00", 
"1957-04-07 03:00:00", "1957-10-06 03:00:00", "1958-04-06 03:00:00", 
"1958-10-05 03:00:00", "1959-04-05 03:00:00", "1959-10-04 03:00:00", 
"1960-04-03 03:00:00", "1960-10-02 03:00:00", "1961-04-02 03:00:00", 
"1961-10-01 03:00:00", "1962-04-01 03:00:00", "1962-10-07 03:00:00", 
"1963-04-07 03:00:00", "1963-10-06 03:00:00", "1964-04-05 03:00:00", 
"1964-10-04 03:00:00", "1965-04-04 03:00:00", "1965-10-03 03:00:00", 
"1966-04-03 03:00:00", "1977-03-27 00:00:00", "1977-09-25 00:00:00", 
"1978-04-02 00:00:00", "1978-10-01 00:00:00", "1979-04-01 00:00:00", 
"1979-09-30 01:00:00", "1980-03-30 00:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 02:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("-4056", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "3600", 
"0", "-3600", "0", "3600", "0", "-3600", "0", "3600", "0", "-3600", 
"0", "3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600", "0", "3600", 
"0", "3600", "0", "3600", "0", "3600", "0", "3600"), isdst = c("0", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "1", "1", "0", "1", "1", "1", "0", "1", 
"1", "1", "0", "1", "1", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("WET", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WEST", 
"WEST", "WET", "WEST", "WEST", "WEST", "WET", "WEST", "WEST", 
"WEST", "WET", "WEST", "WEST", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST")), .Names = c("Madeira", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -220L), class = "data.frame")
}

"Azores" <- function () {
structure(list(Azores = c("1901-12-14 20:45:52", "1911-05-24 01:54:32", 
"1916-06-18 01:00:00", "1916-11-01 02:00:00", "1917-03-01 01:00:00", 
"1917-10-15 01:00:00", "1918-03-02 01:00:00", "1918-10-15 01:00:00", 
"1919-03-01 01:00:00", "1919-10-15 01:00:00", "1920-03-01 01:00:00", 
"1920-10-15 01:00:00", "1921-03-01 01:00:00", "1921-10-15 01:00:00", 
"1924-04-17 01:00:00", "1924-10-15 01:00:00", "1926-04-18 01:00:00", 
"1926-10-03 01:00:00", "1927-04-10 01:00:00", "1927-10-02 01:00:00", 
"1928-04-15 01:00:00", "1928-10-07 01:00:00", "1929-04-21 01:00:00", 
"1929-10-06 01:00:00", "1931-04-19 01:00:00", "1931-10-04 01:00:00", 
"1932-04-03 01:00:00", "1932-10-02 01:00:00", "1934-04-08 01:00:00", 
"1934-10-07 01:00:00", "1935-03-31 01:00:00", "1935-10-06 01:00:00", 
"1936-04-19 01:00:00", "1936-10-04 01:00:00", "1937-04-04 01:00:00", 
"1937-10-03 01:00:00", "1938-03-27 01:00:00", "1938-10-02 01:00:00", 
"1939-04-16 01:00:00", "1939-11-19 01:00:00", "1940-02-25 01:00:00", 
"1940-10-06 01:00:00", "1941-04-06 01:00:00", "1941-10-06 01:00:00", 
"1942-03-15 01:00:00", "1942-04-26 00:00:00", "1942-08-16 00:00:00", 
"1942-10-25 01:00:00", "1943-03-14 01:00:00", "1943-04-18 00:00:00", 
"1943-08-29 00:00:00", "1943-10-31 01:00:00", "1944-03-12 01:00:00", 
"1944-04-23 00:00:00", "1944-08-27 00:00:00", "1944-10-29 01:00:00", 
"1945-03-11 01:00:00", "1945-04-22 00:00:00", "1945-08-26 00:00:00", 
"1945-10-28 01:00:00", "1946-04-07 01:00:00", "1946-10-06 01:00:00", 
"1947-04-06 04:00:00", "1947-10-05 04:00:00", "1948-04-04 04:00:00", 
"1948-10-03 04:00:00", "1949-04-03 04:00:00", "1949-10-02 04:00:00", 
"1951-04-01 04:00:00", "1951-10-07 04:00:00", "1952-04-06 04:00:00", 
"1952-10-05 04:00:00", "1953-04-05 04:00:00", "1953-10-04 04:00:00", 
"1954-04-04 04:00:00", "1954-10-03 04:00:00", "1955-04-03 04:00:00", 
"1955-10-02 04:00:00", "1956-04-01 04:00:00", "1956-10-07 04:00:00", 
"1957-04-07 04:00:00", "1957-10-06 04:00:00", "1958-04-06 04:00:00", 
"1958-10-05 04:00:00", "1959-04-05 04:00:00", "1959-10-04 04:00:00", 
"1960-04-03 04:00:00", "1960-10-02 04:00:00", "1961-04-02 04:00:00", 
"1961-10-01 04:00:00", "1962-04-01 04:00:00", "1962-10-07 04:00:00", 
"1963-04-07 04:00:00", "1963-10-06 04:00:00", "1964-04-05 04:00:00", 
"1964-10-04 04:00:00", "1965-04-04 04:00:00", "1965-10-03 04:00:00", 
"1966-04-03 04:00:00", "1977-03-27 01:00:00", "1977-09-25 01:00:00", 
"1978-04-02 01:00:00", "1978-10-01 01:00:00", "1979-04-01 01:00:00", 
"1979-09-30 02:00:00", "1980-03-30 01:00:00", "1980-09-28 02:00:00", 
"1981-03-29 02:00:00", "1981-09-27 02:00:00", "1982-03-28 02:00:00", 
"1982-09-26 02:00:00", "1983-03-27 03:00:00", "1983-09-25 02:00:00", 
"1984-03-25 02:00:00", "1984-09-30 02:00:00", "1985-03-31 02:00:00", 
"1985-09-29 02:00:00", "1986-03-30 02:00:00", "1986-09-28 02:00:00", 
"1987-03-29 02:00:00", "1987-09-27 02:00:00", "1988-03-27 02:00:00", 
"1988-09-25 02:00:00", "1989-03-26 02:00:00", "1989-09-24 02:00:00", 
"1990-03-25 02:00:00", "1990-09-30 02:00:00", "1991-03-31 02:00:00", 
"1991-09-29 02:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00"
), offSet = c("-6872", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "0", "-3600", "-7200", "-3600", 
"0", "-3600", "-7200", "-3600", "0", "-3600", "-7200", "-3600", 
"0", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "-7200", 
"-3600", "-7200", "-3600", "-7200", "-3600", "-7200", "-3600", 
"-7200", "-3600", "-7200", "-3600", "-7200", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", 
"-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", 
"0", "-3600", "0", "-3600", "0", "-3600", "0", "-3600", "0"), 
    isdst = c("0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", 
    "1", "0", "1", "1", "1", "0", "1", "1", "1", "0", "1", "1", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
    "1", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
    "0", "1", "0", "1"), TimeZone = c("AZOT", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOST", "AZOST", "AZOT", "AZOST", "AZOST", "AZOST", "AZOT", 
    "AZOST", "AZOST", "AZOST", "AZOT", "AZOST", "AZOST", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
    "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
    "AZOST", "AZOT", "AZOST", "AZOT", "AZOST")), .Names = c("Azores", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -218L), class = "data.frame")
}

"Palau" <- function () {
structure(list(Palau = "1901-12-14 20:45:52", offSet = "32400", 
    isdst = "0", TimeZone = "PWT"), .Names = c("Palau", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Asuncion" <- function () {
structure(list(Asuncion = c("1901-12-14 20:45:52", "1931-10-10 03:50:40", 
"1972-10-01 04:00:00", "1974-04-01 03:00:00", "1975-10-01 04:00:00", 
"1976-03-01 03:00:00", "1976-10-01 04:00:00", "1977-03-01 03:00:00", 
"1977-10-01 04:00:00", "1978-03-01 03:00:00", "1978-10-01 04:00:00", 
"1979-04-01 03:00:00", "1979-10-01 04:00:00", "1980-04-01 03:00:00", 
"1980-10-01 04:00:00", "1981-04-01 03:00:00", "1981-10-01 04:00:00", 
"1982-04-01 03:00:00", "1982-10-01 04:00:00", "1983-04-01 03:00:00", 
"1983-10-01 04:00:00", "1984-04-01 03:00:00", "1984-10-01 04:00:00", 
"1985-04-01 03:00:00", "1985-10-01 04:00:00", "1986-04-01 03:00:00", 
"1986-10-01 04:00:00", "1987-04-01 03:00:00", "1987-10-01 04:00:00", 
"1988-04-01 03:00:00", "1988-10-01 04:00:00", "1989-04-01 03:00:00", 
"1989-10-22 04:00:00", "1990-04-01 03:00:00", "1990-10-01 04:00:00", 
"1991-04-01 03:00:00", "1991-10-06 04:00:00", "1992-03-01 03:00:00", 
"1992-10-05 04:00:00", "1993-03-31 03:00:00", "1993-10-01 04:00:00", 
"1994-02-27 03:00:00", "1994-10-01 04:00:00", "1995-02-26 03:00:00", 
"1995-10-01 04:00:00", "1996-03-01 03:00:00", "1996-10-06 04:00:00", 
"1997-02-23 03:00:00", "1997-10-05 04:00:00", "1998-03-01 03:00:00", 
"1998-10-04 04:00:00", "1999-03-07 03:00:00", "1999-10-03 04:00:00", 
"2000-03-05 03:00:00", "2000-10-01 04:00:00", "2001-03-04 03:00:00", 
"2001-10-07 04:00:00", "2002-04-07 03:00:00", "2002-09-01 04:00:00", 
"2003-04-06 03:00:00", "2003-09-07 04:00:00", "2004-04-04 03:00:00", 
"2004-10-17 04:00:00", "2005-03-13 03:00:00", "2005-10-16 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-21 04:00:00", "2008-03-09 03:00:00", "2008-10-19 04:00:00", 
"2009-03-08 03:00:00", "2009-10-18 04:00:00", "2010-03-14 03:00:00", 
"2010-10-17 04:00:00", "2011-03-13 03:00:00", "2011-10-16 04:00:00", 
"2012-03-11 03:00:00", "2012-10-21 04:00:00", "2013-03-10 03:00:00", 
"2013-10-20 04:00:00", "2014-03-09 03:00:00", "2014-10-19 04:00:00", 
"2015-03-08 03:00:00", "2015-10-18 04:00:00", "2016-03-13 03:00:00", 
"2016-10-16 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-21 04:00:00", "2019-03-10 03:00:00", 
"2019-10-20 04:00:00", "2020-03-08 03:00:00", "2020-10-18 04:00:00", 
"2021-03-14 03:00:00", "2021-10-17 04:00:00", "2022-03-13 03:00:00", 
"2022-10-16 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-20 04:00:00", "2025-03-09 03:00:00", 
"2025-10-19 04:00:00", "2026-03-08 03:00:00", "2026-10-18 04:00:00", 
"2027-03-14 03:00:00", "2027-10-17 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-21 04:00:00", 
"2030-03-10 03:00:00", "2030-10-20 04:00:00", "2031-03-09 03:00:00", 
"2031-10-19 04:00:00", "2032-03-14 03:00:00", "2032-10-17 04:00:00", 
"2033-03-13 03:00:00", "2033-10-16 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-21 04:00:00", 
"2036-03-09 03:00:00", "2036-10-19 04:00:00", "2037-03-08 03:00:00"
), offSet = c("-13840", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400", "-10800", "-14400", "-10800", 
"-14400", "-10800", "-14400", "-10800", "-14400", "-10800", "-14400", 
"-10800", "-14400", "-10800", "-14400"), isdst = c("0", "0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0"), TimeZone = c("PYT", 
"PYT", "PYT", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT")), .Names = c("Asuncion", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -128L), class = "data.frame")
}

"Qatar" <- function () {
structure(list(Qatar = c("1901-12-14 20:45:52", "1919-12-31 20:33:52"
), offSet = c("12368", "14400"), isdst = c("0", "0"), TimeZone = c("AST", 
"AST")), .Names = c("Qatar", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Reunion" <- function () {
structure(list(Reunion = "1901-12-14 20:45:52", offSet = "13312", 
    isdst = "0", TimeZone = "RET"), .Names = c("Reunion", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -1L), class = "data.frame")
}

"Bucharest" <- function () {
structure(list(Bucharest = c("1901-12-14 20:45:52", "1931-07-23 22:15:36", 
"1932-05-20 22:00:00", "1932-10-01 22:00:00", "1933-04-01 22:00:00", 
"1933-09-30 22:00:00", "1934-04-07 22:00:00", "1934-10-06 22:00:00", 
"1935-04-06 22:00:00", "1935-10-05 22:00:00", "1936-04-04 22:00:00", 
"1936-10-03 22:00:00", "1937-04-03 22:00:00", "1937-10-02 22:00:00", 
"1938-04-02 22:00:00", "1938-10-01 22:00:00", "1939-04-01 22:00:00", 
"1939-09-30 22:00:00", "1979-05-26 22:00:00", "1979-09-29 21:00:00", 
"1980-04-05 21:00:00", "1980-09-27 22:00:00", "1981-03-29 00:00:00", 
"1981-09-27 00:00:00", "1982-03-28 00:00:00", "1982-09-26 00:00:00", 
"1983-03-27 00:00:00", "1983-09-25 00:00:00", "1984-03-25 00:00:00", 
"1984-09-30 00:00:00", "1985-03-31 00:00:00", "1985-09-29 00:00:00", 
"1986-03-30 00:00:00", "1986-09-28 00:00:00", "1987-03-29 00:00:00", 
"1987-09-27 00:00:00", "1988-03-27 00:00:00", "1988-09-25 00:00:00", 
"1989-03-26 00:00:00", "1989-09-24 00:00:00", "1990-03-25 00:00:00", 
"1990-09-30 00:00:00", "1991-03-30 22:00:00", "1991-09-28 22:00:00", 
"1992-03-28 22:00:00", "1992-09-26 22:00:00", "1993-03-27 22:00:00", 
"1993-09-25 22:00:00", "1994-03-26 22:00:00", "1994-09-24 21:00:00", 
"1995-03-25 22:00:00", "1995-09-23 21:00:00", "1996-03-30 22:00:00", 
"1996-10-26 21:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00"), offSet = c("6264", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800", "7200", "10800", "7200", "10800", "7200", 
"10800", "7200", "10800"), isdst = c("0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"
), TimeZone = c("EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST")), .Names = c("Bucharest", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -135L), class = "data.frame")
}

"Belgrade" <- function () {
structure(list(Belgrade = c("1901-12-14 20:45:52", "1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00"), offSet = c("3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200", "3600", "7200", "3600", 
"7200", "3600", "7200", "3600", "7200"), isdst = c("0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), 
    TimeZone = c("CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
    "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST"
    )), .Names = c("Belgrade", "offSet", "isdst", "TimeZone"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Kaliningrad" <- function () {
structure(list(Kaliningrad = c("1901-12-14 20:45:52", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1940-04-01 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1944-12-31 23:00:00", 
"1945-04-28 22:00:00", "1945-10-31 21:00:00", "1945-12-31 22:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1988-09-24 23:00:00", "1989-03-25 23:00:00", "1989-09-23 23:00:00", 
"1990-03-24 23:00:00", "1991-03-30 23:00:00", "1991-09-29 00:00:00", 
"1992-03-28 21:00:00", "1992-09-26 20:00:00", "1993-03-28 00:00:00", 
"1993-09-26 00:00:00", "1994-03-27 00:00:00", "1994-09-25 00:00:00", 
"1995-03-26 00:00:00", "1995-09-24 00:00:00", "1996-03-31 00:00:00", 
"1996-10-27 00:00:00", "1997-03-30 00:00:00", "1997-10-26 00:00:00", 
"1998-03-29 00:00:00", "1998-10-25 00:00:00", "1999-03-28 00:00:00", 
"1999-10-31 00:00:00", "2000-03-26 00:00:00", "2000-10-29 00:00:00", 
"2001-03-25 00:00:00", "2001-10-28 00:00:00", "2002-03-31 00:00:00", 
"2002-10-27 00:00:00", "2003-03-30 00:00:00", "2003-10-26 00:00:00", 
"2004-03-28 00:00:00", "2004-10-31 00:00:00", "2005-03-27 00:00:00", 
"2005-10-30 00:00:00", "2006-03-26 00:00:00", "2006-10-29 00:00:00", 
"2007-03-25 00:00:00", "2007-10-28 00:00:00", "2008-03-30 00:00:00", 
"2008-10-26 00:00:00", "2009-03-29 00:00:00", "2009-10-25 00:00:00", 
"2010-03-28 00:00:00", "2010-10-31 00:00:00", "2011-03-27 00:00:00", 
"2011-10-30 00:00:00", "2012-03-25 00:00:00", "2012-10-28 00:00:00", 
"2013-03-31 00:00:00", "2013-10-27 00:00:00", "2014-03-30 00:00:00", 
"2014-10-26 00:00:00", "2015-03-29 00:00:00", "2015-10-25 00:00:00", 
"2016-03-27 00:00:00", "2016-10-30 00:00:00", "2017-03-26 00:00:00", 
"2017-10-29 00:00:00", "2018-03-25 00:00:00", "2018-10-28 00:00:00", 
"2019-03-31 00:00:00", "2019-10-27 00:00:00", "2020-03-29 00:00:00", 
"2020-10-25 00:00:00", "2021-03-28 00:00:00", "2021-10-31 00:00:00", 
"2022-03-27 00:00:00", "2022-10-30 00:00:00", "2023-03-26 00:00:00", 
"2023-10-29 00:00:00", "2024-03-31 00:00:00", "2024-10-27 00:00:00", 
"2025-03-30 00:00:00", "2025-10-26 00:00:00", "2026-03-29 00:00:00", 
"2026-10-25 00:00:00", "2027-03-28 00:00:00", "2027-10-31 00:00:00", 
"2028-03-26 00:00:00", "2028-10-29 00:00:00", "2029-03-25 00:00:00", 
"2029-10-28 00:00:00", "2030-03-31 00:00:00", "2030-10-27 00:00:00", 
"2031-03-30 00:00:00", "2031-10-26 00:00:00", "2032-03-28 00:00:00", 
"2032-10-31 00:00:00", "2033-03-27 00:00:00", "2033-10-30 00:00:00", 
"2034-03-26 00:00:00", "2034-10-29 00:00:00", "2035-03-25 00:00:00", 
"2035-10-28 00:00:00", "2036-03-30 00:00:00", "2036-10-26 00:00:00", 
"2037-03-29 00:00:00"), offSet = c("3600", "7200", "3600", "7200", 
"3600", "7200", "3600", "7200", "3600", "7200", "3600", "7200", 
"3600", "7200", "10800", "7200", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800", 
"7200", "10800", "7200", "10800", "7200", "10800", "7200", "10800"
), isdst = c("0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "0", "1", "0", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EET", 
"EEST", "EET", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST")), .Names = c("Kaliningrad", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -129L), class = "data.frame")
}

"Moscow" <- function () {
structure(list(Moscow = c("1901-12-14 20:45:52", "1916-07-02 21:30:00", 
"1917-07-01 20:29:12", "1917-12-27 20:29:12", "1918-05-31 19:29:12", 
"1918-09-15 20:29:12", "1919-05-31 19:29:12", "1919-06-30 21:29:12", 
"1919-08-15 20:00:00", "1921-02-14 20:00:00", "1921-03-20 19:00:00", 
"1921-08-31 19:00:00", "1921-09-30 20:00:00", "1922-09-30 21:00:00", 
"1930-06-20 22:00:00", "1981-03-31 21:00:00", "1981-09-30 20:00:00", 
"1982-03-31 21:00:00", "1982-09-30 20:00:00", "1983-03-31 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-29 23:00:00", 
"1985-03-30 23:00:00", "1985-09-28 23:00:00", "1986-03-29 23:00:00", 
"1986-09-27 23:00:00", "1987-03-28 23:00:00", "1987-09-26 23:00:00", 
"1988-03-26 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1989-09-23 23:00:00", "1990-03-24 23:00:00", "1991-03-30 23:00:00", 
"1991-09-29 00:00:00", "1992-01-19 00:00:00", "1992-03-28 20:00:00", 
"1992-09-26 19:00:00", "1993-03-27 23:00:00", "1993-09-25 23:00:00", 
"1994-03-26 23:00:00", "1994-09-24 23:00:00", "1995-03-25 23:00:00", 
"1995-09-23 23:00:00", "1996-03-30 23:00:00", "1996-10-26 23:00:00", 
"1997-03-29 23:00:00", "1997-10-25 23:00:00", "1998-03-28 23:00:00", 
"1998-10-24 23:00:00", "1999-03-27 23:00:00", "1999-10-30 23:00:00", 
"2000-03-25 23:00:00", "2000-10-28 23:00:00", "2001-03-24 23:00:00", 
"2001-10-27 23:00:00", "2002-03-30 23:00:00", "2002-10-26 23:00:00", 
"2003-03-29 23:00:00", "2003-10-25 23:00:00", "2004-03-27 23:00:00", 
"2004-10-30 23:00:00", "2005-03-26 23:00:00", "2005-10-29 23:00:00", 
"2006-03-25 23:00:00", "2006-10-28 23:00:00", "2007-03-24 23:00:00", 
"2007-10-27 23:00:00", "2008-03-29 23:00:00", "2008-10-25 23:00:00", 
"2009-03-28 23:00:00", "2009-10-24 23:00:00", "2010-03-27 23:00:00", 
"2010-10-30 23:00:00", "2011-03-26 23:00:00", "2011-10-29 23:00:00", 
"2012-03-24 23:00:00", "2012-10-27 23:00:00", "2013-03-30 23:00:00", 
"2013-10-26 23:00:00", "2014-03-29 23:00:00", "2014-10-25 23:00:00", 
"2015-03-28 23:00:00", "2015-10-24 23:00:00", "2016-03-26 23:00:00", 
"2016-10-29 23:00:00", "2017-03-25 23:00:00", "2017-10-28 23:00:00", 
"2018-03-24 23:00:00", "2018-10-27 23:00:00", "2019-03-30 23:00:00", 
"2019-10-26 23:00:00", "2020-03-28 23:00:00", "2020-10-24 23:00:00", 
"2021-03-27 23:00:00", "2021-10-30 23:00:00", "2022-03-26 23:00:00", 
"2022-10-29 23:00:00", "2023-03-25 23:00:00", "2023-10-28 23:00:00", 
"2024-03-30 23:00:00", "2024-10-26 23:00:00", "2025-03-29 23:00:00", 
"2025-10-25 23:00:00", "2026-03-28 23:00:00", "2026-10-24 23:00:00", 
"2027-03-27 23:00:00", "2027-10-30 23:00:00", "2028-03-25 23:00:00", 
"2028-10-28 23:00:00", "2029-03-24 23:00:00", "2029-10-27 23:00:00", 
"2030-03-30 23:00:00", "2030-10-26 23:00:00", "2031-03-29 23:00:00", 
"2031-10-25 23:00:00", "2032-03-27 23:00:00", "2032-10-30 23:00:00", 
"2033-03-26 23:00:00", "2033-10-29 23:00:00", "2034-03-25 23:00:00", 
"2034-10-28 23:00:00", "2035-03-24 23:00:00", "2035-10-27 23:00:00", 
"2036-03-29 23:00:00", "2036-10-25 23:00:00", "2037-03-28 23:00:00"
), offSet = c("9000", "9048", "12648", "9048", "16248", "12648", 
"16248", "14400", "10800", "14400", "18000", "14400", "10800", 
"7200", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "7200", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400"), isdst = c("0", "0", "1", "0", "1", 
"1", "1", "1", "0", "1", "1", "1", "0", "0", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("MSK", "MSK", "MSD", 
"MSK", "MSD", "MSD", "MSD", "MSD", "MSK", "MSD", "MSD", "MSD", 
"MSK", "MSK", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSD", "MSK", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", 
"MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD", 
"MSK", "MSD", "MSK", "MSD", "MSK", "MSD", "MSK", "MSD")), .Names = c("Moscow", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -128L), class = "data.frame")
}

"Volgograd" <- function () {
structure(list(Volgograd = c("1901-12-14 20:45:52", "1920-01-02 21:02:20", 
"1930-06-20 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1989-03-25 22:00:00", "1989-09-23 23:00:00", 
"1990-03-24 23:00:00", "1990-09-29 23:00:00", "1992-03-28 22:00:00", 
"1992-09-26 19:00:00", "1993-03-27 23:00:00", "1993-09-25 23:00:00", 
"1994-03-26 23:00:00", "1994-09-24 23:00:00", "1995-03-25 23:00:00", 
"1995-09-23 23:00:00", "1996-03-30 23:00:00", "1996-10-26 23:00:00", 
"1997-03-29 23:00:00", "1997-10-25 23:00:00", "1998-03-28 23:00:00", 
"1998-10-24 23:00:00", "1999-03-27 23:00:00", "1999-10-30 23:00:00", 
"2000-03-25 23:00:00", "2000-10-28 23:00:00", "2001-03-24 23:00:00", 
"2001-10-27 23:00:00", "2002-03-30 23:00:00", "2002-10-26 23:00:00", 
"2003-03-29 23:00:00", "2003-10-25 23:00:00", "2004-03-27 23:00:00", 
"2004-10-30 23:00:00", "2005-03-26 23:00:00", "2005-10-29 23:00:00", 
"2006-03-25 23:00:00", "2006-10-28 23:00:00", "2007-03-24 23:00:00", 
"2007-10-27 23:00:00", "2008-03-29 23:00:00", "2008-10-25 23:00:00", 
"2009-03-28 23:00:00", "2009-10-24 23:00:00", "2010-03-27 23:00:00", 
"2010-10-30 23:00:00", "2011-03-26 23:00:00", "2011-10-29 23:00:00", 
"2012-03-24 23:00:00", "2012-10-27 23:00:00", "2013-03-30 23:00:00", 
"2013-10-26 23:00:00", "2014-03-29 23:00:00", "2014-10-25 23:00:00", 
"2015-03-28 23:00:00", "2015-10-24 23:00:00", "2016-03-26 23:00:00", 
"2016-10-29 23:00:00", "2017-03-25 23:00:00", "2017-10-28 23:00:00", 
"2018-03-24 23:00:00", "2018-10-27 23:00:00", "2019-03-30 23:00:00", 
"2019-10-26 23:00:00", "2020-03-28 23:00:00", "2020-10-24 23:00:00", 
"2021-03-27 23:00:00", "2021-10-30 23:00:00", "2022-03-26 23:00:00", 
"2022-10-29 23:00:00", "2023-03-25 23:00:00", "2023-10-28 23:00:00", 
"2024-03-30 23:00:00", "2024-10-26 23:00:00", "2025-03-29 23:00:00", 
"2025-10-25 23:00:00", "2026-03-28 23:00:00", "2026-10-24 23:00:00", 
"2027-03-27 23:00:00", "2027-10-30 23:00:00", "2028-03-25 23:00:00", 
"2028-10-28 23:00:00", "2029-03-24 23:00:00", "2029-10-27 23:00:00", 
"2030-03-30 23:00:00", "2030-10-26 23:00:00", "2031-03-29 23:00:00", 
"2031-10-25 23:00:00", "2032-03-27 23:00:00", "2032-10-30 23:00:00", 
"2033-03-26 23:00:00", "2033-10-29 23:00:00", "2034-03-25 23:00:00", 
"2034-10-28 23:00:00", "2035-03-24 23:00:00", "2035-10-27 23:00:00", 
"2036-03-29 23:00:00", "2036-10-25 23:00:00", "2037-03-28 23:00:00"
), offSet = c("10660", "10800", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400", "10800", "14400", "10800", "14400", "10800", 
"14400", "10800", "14400", "10800", "14400", "10800", "14400", 
"10800", "14400"), isdst = c("0", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1"), TimeZone = c("VOLT", "VOLT", "VOLT", "VOLST", "VOLT", 
"VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", 
"VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", "VOLT", "VOLST", 
"VOLT", "VOLST", "VOLT", "VOLST")), .Names = c("Volgograd", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -113L), class = "data.frame")
}

"Samara" <- function () {
structure(list(Samara = c("1901-12-14 20:45:52", "1919-06-30 22:39:24", 
"1930-06-20 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1989-03-25 22:00:00", "1989-09-23 23:00:00", 
"1990-03-24 23:00:00", "1991-09-29 00:00:00", "1991-10-20 00:00:00", 
"1992-03-28 19:00:00", "1992-09-26 18:00:00", "1993-03-27 22:00:00", 
"1993-09-25 22:00:00", "1994-03-26 22:00:00", "1994-09-24 22:00:00", 
"1995-03-25 22:00:00", "1995-09-23 22:00:00", "1996-03-30 22:00:00", 
"1996-10-26 22:00:00", "1997-03-29 22:00:00", "1997-10-25 22:00:00", 
"1998-03-28 22:00:00", "1998-10-24 22:00:00", "1999-03-27 22:00:00", 
"1999-10-30 22:00:00", "2000-03-25 22:00:00", "2000-10-28 22:00:00", 
"2001-03-24 22:00:00", "2001-10-27 22:00:00", "2002-03-30 22:00:00", 
"2002-10-26 22:00:00", "2003-03-29 22:00:00", "2003-10-25 22:00:00", 
"2004-03-27 22:00:00", "2004-10-30 22:00:00", "2005-03-26 22:00:00", 
"2005-10-29 22:00:00", "2006-03-25 22:00:00", "2006-10-28 22:00:00", 
"2007-03-24 22:00:00", "2007-10-27 22:00:00", "2008-03-29 22:00:00", 
"2008-10-25 22:00:00", "2009-03-28 22:00:00", "2009-10-24 22:00:00", 
"2010-03-27 22:00:00", "2010-10-30 22:00:00", "2011-03-26 22:00:00", 
"2011-10-29 22:00:00", "2012-03-24 22:00:00", "2012-10-27 22:00:00", 
"2013-03-30 22:00:00", "2013-10-26 22:00:00", "2014-03-29 22:00:00", 
"2014-10-25 22:00:00", "2015-03-28 22:00:00", "2015-10-24 22:00:00", 
"2016-03-26 22:00:00", "2016-10-29 22:00:00", "2017-03-25 22:00:00", 
"2017-10-28 22:00:00", "2018-03-24 22:00:00", "2018-10-27 22:00:00", 
"2019-03-30 22:00:00", "2019-10-26 22:00:00", "2020-03-28 22:00:00", 
"2020-10-24 22:00:00", "2021-03-27 22:00:00", "2021-10-30 22:00:00", 
"2022-03-26 22:00:00", "2022-10-29 22:00:00", "2023-03-25 22:00:00", 
"2023-10-28 22:00:00", "2024-03-30 22:00:00", "2024-10-26 22:00:00", 
"2025-03-29 22:00:00", "2025-10-25 22:00:00", "2026-03-28 22:00:00", 
"2026-10-24 22:00:00", "2027-03-27 22:00:00", "2027-10-30 22:00:00", 
"2028-03-25 22:00:00", "2028-10-28 22:00:00", "2029-03-24 22:00:00", 
"2029-10-27 22:00:00", "2030-03-30 22:00:00", "2030-10-26 22:00:00", 
"2031-03-29 22:00:00", "2031-10-25 22:00:00", "2032-03-27 22:00:00", 
"2032-10-30 22:00:00", "2033-03-26 22:00:00", "2033-10-29 22:00:00", 
"2034-03-25 22:00:00", "2034-10-28 22:00:00", "2035-03-24 22:00:00", 
"2035-10-27 22:00:00", "2036-03-29 22:00:00", "2036-10-25 22:00:00", 
"2037-03-28 22:00:00"), offSet = c("12036", "10800", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "10800", "14400", "10800", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000", "14400", 
"18000", "14400", "18000", "14400", "18000", "14400", "18000", 
"14400", "18000", "14400", "18000", "14400", "18000"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "1", "0", "1", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("SAMT", 
"SAMT", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMST", "SAMT", "SAMST", "SAMT", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST")), .Names = c("Samara", "offSet", "isdst", "TimeZone"
), row.names = c(NA, -114L), class = "data.frame")
}

"Yekaterinburg" <- function () {
structure(list(Yekaterinburg = c("1901-12-14 20:45:52", "1919-07-14 23:57:36", 
"1930-06-20 20:00:00", "1981-03-31 19:00:00", "1981-09-30 18:00:00", 
"1982-03-31 19:00:00", "1982-09-30 18:00:00", "1983-03-31 19:00:00", 
"1983-09-30 18:00:00", "1984-03-31 19:00:00", "1984-09-29 21:00:00", 
"1985-03-30 21:00:00", "1985-09-28 21:00:00", "1986-03-29 21:00:00", 
"1986-09-27 21:00:00", "1987-03-28 21:00:00", "1987-09-26 21:00:00", 
"1988-03-26 21:00:00", "1988-09-24 21:00:00", "1989-03-25 21:00:00", 
"1989-09-23 21:00:00", "1990-03-24 21:00:00", "1991-03-30 21:00:00", 
"1991-09-28 22:00:00", "1992-01-18 22:00:00", "1992-03-28 18:00:00", 
"1992-09-26 17:00:00", "1993-03-27 21:00:00", "1993-09-25 21:00:00", 
"1994-03-26 21:00:00", "1994-09-24 21:00:00", "1995-03-25 21:00:00", 
"1995-09-23 21:00:00", "1996-03-30 21:00:00", "1996-10-26 21:00:00", 
"1997-03-29 21:00:00", "1997-10-25 21:00:00", "1998-03-28 21:00:00", 
"1998-10-24 21:00:00", "1999-03-27 21:00:00", "1999-10-30 21:00:00", 
"2000-03-25 21:00:00", "2000-10-28 21:00:00", "2001-03-24 21:00:00", 
"2001-10-27 21:00:00", "2002-03-30 21:00:00", "2002-10-26 21:00:00", 
"2003-03-29 21:00:00", "2003-10-25 21:00:00", "2004-03-27 21:00:00", 
"2004-10-30 21:00:00", "2005-03-26 21:00:00", "2005-10-29 21:00:00", 
"2006-03-25 21:00:00", "2006-10-28 21:00:00", "2007-03-24 21:00:00", 
"2007-10-27 21:00:00", "2008-03-29 21:00:00", "2008-10-25 21:00:00", 
"2009-03-28 21:00:00", "2009-10-24 21:00:00", "2010-03-27 21:00:00", 
"2010-10-30 21:00:00", "2011-03-26 21:00:00", "2011-10-29 21:00:00", 
"2012-03-24 21:00:00", "2012-10-27 21:00:00", "2013-03-30 21:00:00", 
"2013-10-26 21:00:00", "2014-03-29 21:00:00", "2014-10-25 21:00:00", 
"2015-03-28 21:00:00", "2015-10-24 21:00:00", "2016-03-26 21:00:00", 
"2016-10-29 21:00:00", "2017-03-25 21:00:00", "2017-10-28 21:00:00", 
"2018-03-24 21:00:00", "2018-10-27 21:00:00", "2019-03-30 21:00:00", 
"2019-10-26 21:00:00", "2020-03-28 21:00:00", "2020-10-24 21:00:00", 
"2021-03-27 21:00:00", "2021-10-30 21:00:00", "2022-03-26 21:00:00", 
"2022-10-29 21:00:00", "2023-03-25 21:00:00", "2023-10-28 21:00:00", 
"2024-03-30 21:00:00", "2024-10-26 21:00:00", "2025-03-29 21:00:00", 
"2025-10-25 21:00:00", "2026-03-28 21:00:00", "2026-10-24 21:00:00", 
"2027-03-27 21:00:00", "2027-10-30 21:00:00", "2028-03-25 21:00:00", 
"2028-10-28 21:00:00", "2029-03-24 21:00:00", "2029-10-27 21:00:00", 
"2030-03-30 21:00:00", "2030-10-26 21:00:00", "2031-03-29 21:00:00", 
"2031-10-25 21:00:00", "2032-03-27 21:00:00", "2032-10-30 21:00:00", 
"2033-03-26 21:00:00", "2033-10-29 21:00:00", "2034-03-25 21:00:00", 
"2034-10-28 21:00:00", "2035-03-24 21:00:00", "2035-10-27 21:00:00", 
"2036-03-29 21:00:00", "2036-10-25 21:00:00", "2037-03-28 21:00:00"
), offSet = c("14544", "14400", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "14400", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600", "18000", "21600", 
"18000", "21600", "18000", "21600", "18000", "21600", "18000", 
"21600", "18000", "21600", "18000", "21600"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("YEKT", 
"YEKT", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKST", "YEKT", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST")), .Names = c("Yekaterinburg", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Omsk" <- function () {
structure(list(Omsk = c("1901-12-14 20:45:52", "1919-11-13 19:06:24", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-03-30 20:00:00", 
"1991-09-28 21:00:00", "1992-01-18 21:00:00", "1992-03-28 17:00:00", 
"1992-09-26 16:00:00", "1993-03-27 20:00:00", "1993-09-25 20:00:00", 
"1994-03-26 20:00:00", "1994-09-24 20:00:00", "1995-03-25 20:00:00", 
"1995-09-23 20:00:00", "1996-03-30 20:00:00", "1996-10-26 20:00:00", 
"1997-03-29 20:00:00", "1997-10-25 20:00:00", "1998-03-28 20:00:00", 
"1998-10-24 20:00:00", "1999-03-27 20:00:00", "1999-10-30 20:00:00", 
"2000-03-25 20:00:00", "2000-10-28 20:00:00", "2001-03-24 20:00:00", 
"2001-10-27 20:00:00", "2002-03-30 20:00:00", "2002-10-26 20:00:00", 
"2003-03-29 20:00:00", "2003-10-25 20:00:00", "2004-03-27 20:00:00", 
"2004-10-30 20:00:00", "2005-03-26 20:00:00", "2005-10-29 20:00:00", 
"2006-03-25 20:00:00", "2006-10-28 20:00:00", "2007-03-24 20:00:00", 
"2007-10-27 20:00:00", "2008-03-29 20:00:00", "2008-10-25 20:00:00", 
"2009-03-28 20:00:00", "2009-10-24 20:00:00", "2010-03-27 20:00:00", 
"2010-10-30 20:00:00", "2011-03-26 20:00:00", "2011-10-29 20:00:00", 
"2012-03-24 20:00:00", "2012-10-27 20:00:00", "2013-03-30 20:00:00", 
"2013-10-26 20:00:00", "2014-03-29 20:00:00", "2014-10-25 20:00:00", 
"2015-03-28 20:00:00", "2015-10-24 20:00:00", "2016-03-26 20:00:00", 
"2016-10-29 20:00:00", "2017-03-25 20:00:00", "2017-10-28 20:00:00", 
"2018-03-24 20:00:00", "2018-10-27 20:00:00", "2019-03-30 20:00:00", 
"2019-10-26 20:00:00", "2020-03-28 20:00:00", "2020-10-24 20:00:00", 
"2021-03-27 20:00:00", "2021-10-30 20:00:00", "2022-03-26 20:00:00", 
"2022-10-29 20:00:00", "2023-03-25 20:00:00", "2023-10-28 20:00:00", 
"2024-03-30 20:00:00", "2024-10-26 20:00:00", "2025-03-29 20:00:00", 
"2025-10-25 20:00:00", "2026-03-28 20:00:00", "2026-10-24 20:00:00", 
"2027-03-27 20:00:00", "2027-10-30 20:00:00", "2028-03-25 20:00:00", 
"2028-10-28 20:00:00", "2029-03-24 20:00:00", "2029-10-27 20:00:00", 
"2030-03-30 20:00:00", "2030-10-26 20:00:00", "2031-03-29 20:00:00", 
"2031-10-25 20:00:00", "2032-03-27 20:00:00", "2032-10-30 20:00:00", 
"2033-03-26 20:00:00", "2033-10-29 20:00:00", "2034-03-25 20:00:00", 
"2034-10-28 20:00:00", "2035-03-24 20:00:00", "2035-10-27 20:00:00", 
"2036-03-29 20:00:00", "2036-10-25 20:00:00", "2037-03-28 20:00:00"
), offSet = c("17616", "18000", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "18000", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("OMST", 
"OMST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMSST", "OMST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST")), .Names = c("Omsk", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Novosibirsk" <- function () {
structure(list(Novosibirsk = c("1901-12-14 20:45:52", "1919-12-14 00:28:20", 
"1930-06-20 18:00:00", "1981-03-31 17:00:00", "1981-09-30 16:00:00", 
"1982-03-31 17:00:00", "1982-09-30 16:00:00", "1983-03-31 17:00:00", 
"1983-09-30 16:00:00", "1984-03-31 17:00:00", "1984-09-29 19:00:00", 
"1985-03-30 19:00:00", "1985-09-28 19:00:00", "1986-03-29 19:00:00", 
"1986-09-27 19:00:00", "1987-03-28 19:00:00", "1987-09-26 19:00:00", 
"1988-03-26 19:00:00", "1988-09-24 19:00:00", "1989-03-25 19:00:00", 
"1989-09-23 19:00:00", "1990-03-24 19:00:00", "1991-03-30 19:00:00", 
"1991-09-28 20:00:00", "1992-01-18 20:00:00", "1992-03-28 16:00:00", 
"1992-09-26 15:00:00", "1993-03-27 19:00:00", "1993-05-22 16:00:00", 
"1993-09-25 20:00:00", "1994-03-26 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 20:00:00", "1996-03-30 20:00:00", 
"1996-10-26 20:00:00", "1997-03-29 20:00:00", "1997-10-25 20:00:00", 
"1998-03-28 20:00:00", "1998-10-24 20:00:00", "1999-03-27 20:00:00", 
"1999-10-30 20:00:00", "2000-03-25 20:00:00", "2000-10-28 20:00:00", 
"2001-03-24 20:00:00", "2001-10-27 20:00:00", "2002-03-30 20:00:00", 
"2002-10-26 20:00:00", "2003-03-29 20:00:00", "2003-10-25 20:00:00", 
"2004-03-27 20:00:00", "2004-10-30 20:00:00", "2005-03-26 20:00:00", 
"2005-10-29 20:00:00", "2006-03-25 20:00:00", "2006-10-28 20:00:00", 
"2007-03-24 20:00:00", "2007-10-27 20:00:00", "2008-03-29 20:00:00", 
"2008-10-25 20:00:00", "2009-03-28 20:00:00", "2009-10-24 20:00:00", 
"2010-03-27 20:00:00", "2010-10-30 20:00:00", "2011-03-26 20:00:00", 
"2011-10-29 20:00:00", "2012-03-24 20:00:00", "2012-10-27 20:00:00", 
"2013-03-30 20:00:00", "2013-10-26 20:00:00", "2014-03-29 20:00:00", 
"2014-10-25 20:00:00", "2015-03-28 20:00:00", "2015-10-24 20:00:00", 
"2016-03-26 20:00:00", "2016-10-29 20:00:00", "2017-03-25 20:00:00", 
"2017-10-28 20:00:00", "2018-03-24 20:00:00", "2018-10-27 20:00:00", 
"2019-03-30 20:00:00", "2019-10-26 20:00:00", "2020-03-28 20:00:00", 
"2020-10-24 20:00:00", "2021-03-27 20:00:00", "2021-10-30 20:00:00", 
"2022-03-26 20:00:00", "2022-10-29 20:00:00", "2023-03-25 20:00:00", 
"2023-10-28 20:00:00", "2024-03-30 20:00:00", "2024-10-26 20:00:00", 
"2025-03-29 20:00:00", "2025-10-25 20:00:00", "2026-03-28 20:00:00", 
"2026-10-24 20:00:00", "2027-03-27 20:00:00", "2027-10-30 20:00:00", 
"2028-03-25 20:00:00", "2028-10-28 20:00:00", "2029-03-24 20:00:00", 
"2029-10-27 20:00:00", "2030-03-30 20:00:00", "2030-10-26 20:00:00", 
"2031-03-29 20:00:00", "2031-10-25 20:00:00", "2032-03-27 20:00:00", 
"2032-10-30 20:00:00", "2033-03-26 20:00:00", "2033-10-29 20:00:00", 
"2034-03-25 20:00:00", "2034-10-28 20:00:00", "2035-03-24 20:00:00", 
"2035-10-27 20:00:00", "2036-03-29 20:00:00", "2036-10-25 20:00:00", 
"2037-03-28 20:00:00"), offSet = c("19900", "21600", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "21600", 
"25200", "28800", "25200", "28800", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200", "21600", "25200", "21600", "25200", "21600", 
"25200", "21600", "25200", "21600", "25200", "21600", "25200", 
"21600", "25200"), isdst = c("0", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "1", "0", "0", "1", "0", "1", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1"), TimeZone = c("NOVT", "NOVT", "NOVT", 
"NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVT", "NOVST", "NOVST", "NOVT", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST")), .Names = c("Novosibirsk", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -117L), class = "data.frame")
}

"Krasnoyarsk" <- function () {
structure(list(Krasnoyarsk = c("1901-12-14 20:45:52", "1920-01-05 17:48:40", 
"1930-06-20 18:00:00", "1981-03-31 17:00:00", "1981-09-30 16:00:00", 
"1982-03-31 17:00:00", "1982-09-30 16:00:00", "1983-03-31 17:00:00", 
"1983-09-30 16:00:00", "1984-03-31 17:00:00", "1984-09-29 19:00:00", 
"1985-03-30 19:00:00", "1985-09-28 19:00:00", "1986-03-29 19:00:00", 
"1986-09-27 19:00:00", "1987-03-28 19:00:00", "1987-09-26 19:00:00", 
"1988-03-26 19:00:00", "1988-09-24 19:00:00", "1989-03-25 19:00:00", 
"1989-09-23 19:00:00", "1990-03-24 19:00:00", "1991-03-30 19:00:00", 
"1991-09-28 20:00:00", "1992-01-18 20:00:00", "1992-03-28 16:00:00", 
"1992-09-26 15:00:00", "1993-03-27 19:00:00", "1993-09-25 19:00:00", 
"1994-03-26 19:00:00", "1994-09-24 19:00:00", "1995-03-25 19:00:00", 
"1995-09-23 19:00:00", "1996-03-30 19:00:00", "1996-10-26 19:00:00", 
"1997-03-29 19:00:00", "1997-10-25 19:00:00", "1998-03-28 19:00:00", 
"1998-10-24 19:00:00", "1999-03-27 19:00:00", "1999-10-30 19:00:00", 
"2000-03-25 19:00:00", "2000-10-28 19:00:00", "2001-03-24 19:00:00", 
"2001-10-27 19:00:00", "2002-03-30 19:00:00", "2002-10-26 19:00:00", 
"2003-03-29 19:00:00", "2003-10-25 19:00:00", "2004-03-27 19:00:00", 
"2004-10-30 19:00:00", "2005-03-26 19:00:00", "2005-10-29 19:00:00", 
"2006-03-25 19:00:00", "2006-10-28 19:00:00", "2007-03-24 19:00:00", 
"2007-10-27 19:00:00", "2008-03-29 19:00:00", "2008-10-25 19:00:00", 
"2009-03-28 19:00:00", "2009-10-24 19:00:00", "2010-03-27 19:00:00", 
"2010-10-30 19:00:00", "2011-03-26 19:00:00", "2011-10-29 19:00:00", 
"2012-03-24 19:00:00", "2012-10-27 19:00:00", "2013-03-30 19:00:00", 
"2013-10-26 19:00:00", "2014-03-29 19:00:00", "2014-10-25 19:00:00", 
"2015-03-28 19:00:00", "2015-10-24 19:00:00", "2016-03-26 19:00:00", 
"2016-10-29 19:00:00", "2017-03-25 19:00:00", "2017-10-28 19:00:00", 
"2018-03-24 19:00:00", "2018-10-27 19:00:00", "2019-03-30 19:00:00", 
"2019-10-26 19:00:00", "2020-03-28 19:00:00", "2020-10-24 19:00:00", 
"2021-03-27 19:00:00", "2021-10-30 19:00:00", "2022-03-26 19:00:00", 
"2022-10-29 19:00:00", "2023-03-25 19:00:00", "2023-10-28 19:00:00", 
"2024-03-30 19:00:00", "2024-10-26 19:00:00", "2025-03-29 19:00:00", 
"2025-10-25 19:00:00", "2026-03-28 19:00:00", "2026-10-24 19:00:00", 
"2027-03-27 19:00:00", "2027-10-30 19:00:00", "2028-03-25 19:00:00", 
"2028-10-28 19:00:00", "2029-03-24 19:00:00", "2029-10-27 19:00:00", 
"2030-03-30 19:00:00", "2030-10-26 19:00:00", "2031-03-29 19:00:00", 
"2031-10-25 19:00:00", "2032-03-27 19:00:00", "2032-10-30 19:00:00", 
"2033-03-26 19:00:00", "2033-10-29 19:00:00", "2034-03-25 19:00:00", 
"2034-10-28 19:00:00", "2035-03-24 19:00:00", "2035-10-27 19:00:00", 
"2036-03-29 19:00:00", "2036-10-25 19:00:00", "2037-03-28 19:00:00"
), offSet = c("22280", "21600", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "21600", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800", "25200", "28800", 
"25200", "28800", "25200", "28800", "25200", "28800", "25200", 
"28800", "25200", "28800", "25200", "28800"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("KRAT", 
"KRAT", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAST", "KRAT", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST")), .Names = c("Krasnoyarsk", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Irkutsk" <- function () {
structure(list(Irkutsk = c("1901-12-14 20:45:52", "1920-01-24 17:02:40", 
"1930-06-20 17:00:00", "1981-03-31 16:00:00", "1981-09-30 15:00:00", 
"1982-03-31 16:00:00", "1982-09-30 15:00:00", "1983-03-31 16:00:00", 
"1983-09-30 15:00:00", "1984-03-31 16:00:00", "1984-09-29 18:00:00", 
"1985-03-30 18:00:00", "1985-09-28 18:00:00", "1986-03-29 18:00:00", 
"1986-09-27 18:00:00", "1987-03-28 18:00:00", "1987-09-26 18:00:00", 
"1988-03-26 18:00:00", "1988-09-24 18:00:00", "1989-03-25 18:00:00", 
"1989-09-23 18:00:00", "1990-03-24 18:00:00", "1991-03-30 18:00:00", 
"1991-09-28 19:00:00", "1992-01-18 19:00:00", "1992-03-28 15:00:00", 
"1992-09-26 14:00:00", "1993-03-27 18:00:00", "1993-09-25 18:00:00", 
"1994-03-26 18:00:00", "1994-09-24 18:00:00", "1995-03-25 18:00:00", 
"1995-09-23 18:00:00", "1996-03-30 18:00:00", "1996-10-26 18:00:00", 
"1997-03-29 18:00:00", "1997-10-25 18:00:00", "1998-03-28 18:00:00", 
"1998-10-24 18:00:00", "1999-03-27 18:00:00", "1999-10-30 18:00:00", 
"2000-03-25 18:00:00", "2000-10-28 18:00:00", "2001-03-24 18:00:00", 
"2001-10-27 18:00:00", "2002-03-30 18:00:00", "2002-10-26 18:00:00", 
"2003-03-29 18:00:00", "2003-10-25 18:00:00", "2004-03-27 18:00:00", 
"2004-10-30 18:00:00", "2005-03-26 18:00:00", "2005-10-29 18:00:00", 
"2006-03-25 18:00:00", "2006-10-28 18:00:00", "2007-03-24 18:00:00", 
"2007-10-27 18:00:00", "2008-03-29 18:00:00", "2008-10-25 18:00:00", 
"2009-03-28 18:00:00", "2009-10-24 18:00:00", "2010-03-27 18:00:00", 
"2010-10-30 18:00:00", "2011-03-26 18:00:00", "2011-10-29 18:00:00", 
"2012-03-24 18:00:00", "2012-10-27 18:00:00", "2013-03-30 18:00:00", 
"2013-10-26 18:00:00", "2014-03-29 18:00:00", "2014-10-25 18:00:00", 
"2015-03-28 18:00:00", "2015-10-24 18:00:00", "2016-03-26 18:00:00", 
"2016-10-29 18:00:00", "2017-03-25 18:00:00", "2017-10-28 18:00:00", 
"2018-03-24 18:00:00", "2018-10-27 18:00:00", "2019-03-30 18:00:00", 
"2019-10-26 18:00:00", "2020-03-28 18:00:00", "2020-10-24 18:00:00", 
"2021-03-27 18:00:00", "2021-10-30 18:00:00", "2022-03-26 18:00:00", 
"2022-10-29 18:00:00", "2023-03-25 18:00:00", "2023-10-28 18:00:00", 
"2024-03-30 18:00:00", "2024-10-26 18:00:00", "2025-03-29 18:00:00", 
"2025-10-25 18:00:00", "2026-03-28 18:00:00", "2026-10-24 18:00:00", 
"2027-03-27 18:00:00", "2027-10-30 18:00:00", "2028-03-25 18:00:00", 
"2028-10-28 18:00:00", "2029-03-24 18:00:00", "2029-10-27 18:00:00", 
"2030-03-30 18:00:00", "2030-10-26 18:00:00", "2031-03-29 18:00:00", 
"2031-10-25 18:00:00", "2032-03-27 18:00:00", "2032-10-30 18:00:00", 
"2033-03-26 18:00:00", "2033-10-29 18:00:00", "2034-03-25 18:00:00", 
"2034-10-28 18:00:00", "2035-03-24 18:00:00", "2035-10-27 18:00:00", 
"2036-03-29 18:00:00", "2036-10-25 18:00:00", "2037-03-28 18:00:00"
), offSet = c("25040", "25200", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "25200", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400", "28800", "32400", 
"28800", "32400", "28800", "32400", "28800", "32400", "28800", 
"32400", "28800", "32400", "28800", "32400"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("IRKT", 
"IRKT", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKST", "IRKT", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST")), .Names = c("Irkutsk", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Yakutsk" <- function () {
structure(list(Yakutsk = c("1901-12-14 20:45:52", "1919-12-14 15:21:20", 
"1930-06-20 16:00:00", "1981-03-31 15:00:00", "1981-09-30 14:00:00", 
"1982-03-31 15:00:00", "1982-09-30 14:00:00", "1983-03-31 15:00:00", 
"1983-09-30 14:00:00", "1984-03-31 15:00:00", "1984-09-29 17:00:00", 
"1985-03-30 17:00:00", "1985-09-28 17:00:00", "1986-03-29 17:00:00", 
"1986-09-27 17:00:00", "1987-03-28 17:00:00", "1987-09-26 17:00:00", 
"1988-03-26 17:00:00", "1988-09-24 17:00:00", "1989-03-25 17:00:00", 
"1989-09-23 17:00:00", "1990-03-24 17:00:00", "1991-03-30 17:00:00", 
"1991-09-28 18:00:00", "1992-01-18 18:00:00", "1992-03-28 14:00:00", 
"1992-09-26 13:00:00", "1993-03-27 17:00:00", "1993-09-25 17:00:00", 
"1994-03-26 17:00:00", "1994-09-24 17:00:00", "1995-03-25 17:00:00", 
"1995-09-23 17:00:00", "1996-03-30 17:00:00", "1996-10-26 17:00:00", 
"1997-03-29 17:00:00", "1997-10-25 17:00:00", "1998-03-28 17:00:00", 
"1998-10-24 17:00:00", "1999-03-27 17:00:00", "1999-10-30 17:00:00", 
"2000-03-25 17:00:00", "2000-10-28 17:00:00", "2001-03-24 17:00:00", 
"2001-10-27 17:00:00", "2002-03-30 17:00:00", "2002-10-26 17:00:00", 
"2003-03-29 17:00:00", "2003-10-25 17:00:00", "2004-03-27 17:00:00", 
"2004-10-30 17:00:00", "2005-03-26 17:00:00", "2005-10-29 17:00:00", 
"2006-03-25 17:00:00", "2006-10-28 17:00:00", "2007-03-24 17:00:00", 
"2007-10-27 17:00:00", "2008-03-29 17:00:00", "2008-10-25 17:00:00", 
"2009-03-28 17:00:00", "2009-10-24 17:00:00", "2010-03-27 17:00:00", 
"2010-10-30 17:00:00", "2011-03-26 17:00:00", "2011-10-29 17:00:00", 
"2012-03-24 17:00:00", "2012-10-27 17:00:00", "2013-03-30 17:00:00", 
"2013-10-26 17:00:00", "2014-03-29 17:00:00", "2014-10-25 17:00:00", 
"2015-03-28 17:00:00", "2015-10-24 17:00:00", "2016-03-26 17:00:00", 
"2016-10-29 17:00:00", "2017-03-25 17:00:00", "2017-10-28 17:00:00", 
"2018-03-24 17:00:00", "2018-10-27 17:00:00", "2019-03-30 17:00:00", 
"2019-10-26 17:00:00", "2020-03-28 17:00:00", "2020-10-24 17:00:00", 
"2021-03-27 17:00:00", "2021-10-30 17:00:00", "2022-03-26 17:00:00", 
"2022-10-29 17:00:00", "2023-03-25 17:00:00", "2023-10-28 17:00:00", 
"2024-03-30 17:00:00", "2024-10-26 17:00:00", "2025-03-29 17:00:00", 
"2025-10-25 17:00:00", "2026-03-28 17:00:00", "2026-10-24 17:00:00", 
"2027-03-27 17:00:00", "2027-10-30 17:00:00", "2028-03-25 17:00:00", 
"2028-10-28 17:00:00", "2029-03-24 17:00:00", "2029-10-27 17:00:00", 
"2030-03-30 17:00:00", "2030-10-26 17:00:00", "2031-03-29 17:00:00", 
"2031-10-25 17:00:00", "2032-03-27 17:00:00", "2032-10-30 17:00:00", 
"2033-03-26 17:00:00", "2033-10-29 17:00:00", "2034-03-25 17:00:00", 
"2034-10-28 17:00:00", "2035-03-24 17:00:00", "2035-10-27 17:00:00", 
"2036-03-29 17:00:00", "2036-10-25 17:00:00", "2037-03-28 17:00:00"
), offSet = c("31120", "28800", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "28800", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000", "32400", "36000", 
"32400", "36000", "32400", "36000", "32400", "36000", "32400", 
"36000", "32400", "36000", "32400", "36000"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("YAKT", 
"YAKT", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKST", "YAKT", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST")), .Names = c("Yakutsk", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Vladivostok" <- function () {
structure(list(Vladivostok = c("1901-12-14 20:45:52", "1922-11-14 15:12:16", 
"1930-06-20 15:00:00", "1981-03-31 14:00:00", "1981-09-30 13:00:00", 
"1982-03-31 14:00:00", "1982-09-30 13:00:00", "1983-03-31 14:00:00", 
"1983-09-30 13:00:00", "1984-03-31 14:00:00", "1984-09-29 16:00:00", 
"1985-03-30 16:00:00", "1985-09-28 16:00:00", "1986-03-29 16:00:00", 
"1986-09-27 16:00:00", "1987-03-28 16:00:00", "1987-09-26 16:00:00", 
"1988-03-26 16:00:00", "1988-09-24 16:00:00", "1989-03-25 16:00:00", 
"1989-09-23 16:00:00", "1990-03-24 16:00:00", "1991-03-30 16:00:00", 
"1991-09-28 17:00:00", "1992-01-18 17:00:00", "1992-03-28 13:00:00", 
"1992-09-26 12:00:00", "1993-03-27 16:00:00", "1993-09-25 16:00:00", 
"1994-03-26 16:00:00", "1994-09-24 16:00:00", "1995-03-25 16:00:00", 
"1995-09-23 16:00:00", "1996-03-30 16:00:00", "1996-10-26 16:00:00", 
"1997-03-29 16:00:00", "1997-10-25 16:00:00", "1998-03-28 16:00:00", 
"1998-10-24 16:00:00", "1999-03-27 16:00:00", "1999-10-30 16:00:00", 
"2000-03-25 16:00:00", "2000-10-28 16:00:00", "2001-03-24 16:00:00", 
"2001-10-27 16:00:00", "2002-03-30 16:00:00", "2002-10-26 16:00:00", 
"2003-03-29 16:00:00", "2003-10-25 16:00:00", "2004-03-27 16:00:00", 
"2004-10-30 16:00:00", "2005-03-26 16:00:00", "2005-10-29 16:00:00", 
"2006-03-25 16:00:00", "2006-10-28 16:00:00", "2007-03-24 16:00:00", 
"2007-10-27 16:00:00", "2008-03-29 16:00:00", "2008-10-25 16:00:00", 
"2009-03-28 16:00:00", "2009-10-24 16:00:00", "2010-03-27 16:00:00", 
"2010-10-30 16:00:00", "2011-03-26 16:00:00", "2011-10-29 16:00:00", 
"2012-03-24 16:00:00", "2012-10-27 16:00:00", "2013-03-30 16:00:00", 
"2013-10-26 16:00:00", "2014-03-29 16:00:00", "2014-10-25 16:00:00", 
"2015-03-28 16:00:00", "2015-10-24 16:00:00", "2016-03-26 16:00:00", 
"2016-10-29 16:00:00", "2017-03-25 16:00:00", "2017-10-28 16:00:00", 
"2018-03-24 16:00:00", "2018-10-27 16:00:00", "2019-03-30 16:00:00", 
"2019-10-26 16:00:00", "2020-03-28 16:00:00", "2020-10-24 16:00:00", 
"2021-03-27 16:00:00", "2021-10-30 16:00:00", "2022-03-26 16:00:00", 
"2022-10-29 16:00:00", "2023-03-25 16:00:00", "2023-10-28 16:00:00", 
"2024-03-30 16:00:00", "2024-10-26 16:00:00", "2025-03-29 16:00:00", 
"2025-10-25 16:00:00", "2026-03-28 16:00:00", "2026-10-24 16:00:00", 
"2027-03-27 16:00:00", "2027-10-30 16:00:00", "2028-03-25 16:00:00", 
"2028-10-28 16:00:00", "2029-03-24 16:00:00", "2029-10-27 16:00:00", 
"2030-03-30 16:00:00", "2030-10-26 16:00:00", "2031-03-29 16:00:00", 
"2031-10-25 16:00:00", "2032-03-27 16:00:00", "2032-10-30 16:00:00", 
"2033-03-26 16:00:00", "2033-10-29 16:00:00", "2034-03-25 16:00:00", 
"2034-10-28 16:00:00", "2035-03-24 16:00:00", "2035-10-27 16:00:00", 
"2036-03-29 16:00:00", "2036-10-25 16:00:00", "2037-03-28 16:00:00"
), offSet = c("31664", "32400", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "32400", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("VLAT", 
"VLAT", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAST", "VLAT", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST")), .Names = c("Vladivostok", "offSet", 
"isdst", "TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Sakhalin" <- function () {
structure(list(Sakhalin = c("1901-12-14 20:45:52", "1905-08-22 14:29:12", 
"1945-08-24 15:00:00", "1981-03-31 13:00:00", "1981-09-30 12:00:00", 
"1982-03-31 13:00:00", "1982-09-30 12:00:00", "1983-03-31 13:00:00", 
"1983-09-30 12:00:00", "1984-03-31 13:00:00", "1984-09-29 15:00:00", 
"1985-03-30 15:00:00", "1985-09-28 15:00:00", "1986-03-29 15:00:00", 
"1986-09-27 15:00:00", "1987-03-28 15:00:00", "1987-09-26 15:00:00", 
"1988-03-26 15:00:00", "1988-09-24 15:00:00", "1989-03-25 15:00:00", 
"1989-09-23 15:00:00", "1990-03-24 15:00:00", "1991-03-30 15:00:00", 
"1991-09-28 16:00:00", "1992-01-18 16:00:00", "1992-03-28 12:00:00", 
"1992-09-26 11:00:00", "1993-03-27 15:00:00", "1993-09-25 15:00:00", 
"1994-03-26 15:00:00", "1994-09-24 15:00:00", "1995-03-25 15:00:00", 
"1995-09-23 15:00:00", "1996-03-30 15:00:00", "1997-03-29 15:00:00", 
"1997-10-25 16:00:00", "1998-03-28 16:00:00", "1998-10-24 16:00:00", 
"1999-03-27 16:00:00", "1999-10-30 16:00:00", "2000-03-25 16:00:00", 
"2000-10-28 16:00:00", "2001-03-24 16:00:00", "2001-10-27 16:00:00", 
"2002-03-30 16:00:00", "2002-10-26 16:00:00", "2003-03-29 16:00:00", 
"2003-10-25 16:00:00", "2004-03-27 16:00:00", "2004-10-30 16:00:00", 
"2005-03-26 16:00:00", "2005-10-29 16:00:00", "2006-03-25 16:00:00", 
"2006-10-28 16:00:00", "2007-03-24 16:00:00", "2007-10-27 16:00:00", 
"2008-03-29 16:00:00", "2008-10-25 16:00:00", "2009-03-28 16:00:00", 
"2009-10-24 16:00:00", "2010-03-27 16:00:00", "2010-10-30 16:00:00", 
"2011-03-26 16:00:00", "2011-10-29 16:00:00", "2012-03-24 16:00:00", 
"2012-10-27 16:00:00", "2013-03-30 16:00:00", "2013-10-26 16:00:00", 
"2014-03-29 16:00:00", "2014-10-25 16:00:00", "2015-03-28 16:00:00", 
"2015-10-24 16:00:00", "2016-03-26 16:00:00", "2016-10-29 16:00:00", 
"2017-03-25 16:00:00", "2017-10-28 16:00:00", "2018-03-24 16:00:00", 
"2018-10-27 16:00:00", "2019-03-30 16:00:00", "2019-10-26 16:00:00", 
"2020-03-28 16:00:00", "2020-10-24 16:00:00", "2021-03-27 16:00:00", 
"2021-10-30 16:00:00", "2022-03-26 16:00:00", "2022-10-29 16:00:00", 
"2023-03-25 16:00:00", "2023-10-28 16:00:00", "2024-03-30 16:00:00", 
"2024-10-26 16:00:00", "2025-03-29 16:00:00", "2025-10-25 16:00:00", 
"2026-03-28 16:00:00", "2026-10-24 16:00:00", "2027-03-27 16:00:00", 
"2027-10-30 16:00:00", "2028-03-25 16:00:00", "2028-10-28 16:00:00", 
"2029-03-24 16:00:00", "2029-10-27 16:00:00", "2030-03-30 16:00:00", 
"2030-10-26 16:00:00", "2031-03-29 16:00:00", "2031-10-25 16:00:00", 
"2032-03-27 16:00:00", "2032-10-30 16:00:00", "2033-03-26 16:00:00", 
"2033-10-29 16:00:00", "2034-03-25 16:00:00", "2034-10-28 16:00:00", 
"2035-03-24 16:00:00", "2035-10-27 16:00:00", "2036-03-29 16:00:00", 
"2036-10-25 16:00:00", "2037-03-28 16:00:00"), offSet = c("34248", 
"32400", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "36000", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600", "36000", "39600", "36000", "39600", "36000", 
"39600", "36000", "39600", "36000", "39600", "36000", "39600", 
"36000", "39600"), isdst = c("0", "0", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "1", "0", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1"), TimeZone = c("SAKT", "SAKT", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKST", "SAKT", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST")), .Names = c("Sakhalin", 
"offSet", "isdst", "TimeZone"), row.names = c(NA, -115L), class = "data.frame")
}

"Magadan" <- function () {
structure(list(Magadan = c("1901-12-14 20:45:52", "1924-05-01 13:56:48", 
"1930-06-20 14:00:00", "1981-03-31 13:00:00", "1981-09-30 12:00:00", 
"1982-03-31 13:00:00", "1982-09-30 12:00:00", "1983-03-31 13:00:00", 
"1983-09-30 12:00:00", "1984-03-31 13:00:00", "1984-09-29 15:00:00", 
"1985-03-30 15:00:00", "1985-09-28 15:00:00", "1986-03-29 15:00:00", 
"1986-09-27 15:00:00", "1987-03-28 15:00:00", "1987-09-26 15:00:00", 
"1988-03-26 15:00:00", "1988-09-24 15:00:00", "1989-03-25 15:00:00", 
"1989-09-23 15:00:00", "1990-03-24 15:00:00", "1991-03-30 15:00:00", 
"1991-09-28 16:00:00", "1992-01-18 16:00:00", "1992-03-28 12:00:00", 
"1992-09-26 11:00:00", "1993-03-27 15:00:00", "1993-09-25 15:00:00", 
"1994-03-26 15:00:00", "1994-09-24 15:00:00", "1995-03-25 15:00:00", 
"1995-09-23 15:00:00", "1996-03-30 15:00:00", "1996-10-26 15:00:00", 
"1997-03-29 15:00:00", "1997-10-25 15:00:00", "1998-03-28 15:00:00", 
"1998-10-24 15:00:00", "1999-03-27 15:00:00", "1999-10-30 15:00:00", 
"2000-03-25 15:00:00", "2000-10-28 15:00:00", "2001-03-24 15:00:00", 
"2001-10-27 15:00:00", "2002-03-30 15:00:00", "2002-10-26 15:00:00", 
"2003-03-29 15:00:00", "2003-10-25 15:00:00", "2004-03-27 15:00:00", 
"2004-10-30 15:00:00", "2005-03-26 15:00:00", "2005-10-29 15:00:00", 
"2006-03-25 15:00:00", "2006-10-28 15:00:00", "2007-03-24 15:00:00", 
"2007-10-27 15:00:00", "2008-03-29 15:00:00", "2008-10-25 15:00:00", 
"2009-03-28 15:00:00", "2009-10-24 15:00:00", "2010-03-27 15:00:00", 
"2010-10-30 15:00:00", "2011-03-26 15:00:00", "2011-10-29 15:00:00", 
"2012-03-24 15:00:00", "2012-10-27 15:00:00", "2013-03-30 15:00:00", 
"2013-10-26 15:00:00", "2014-03-29 15:00:00", "2014-10-25 15:00:00", 
"2015-03-28 15:00:00", "2015-10-24 15:00:00", "2016-03-26 15:00:00", 
"2016-10-29 15:00:00", "2017-03-25 15:00:00", "2017-10-28 15:00:00", 
"2018-03-24 15:00:00", "2018-10-27 15:00:00", "2019-03-30 15:00:00", 
"2019-10-26 15:00:00", "2020-03-28 15:00:00", "2020-10-24 15:00:00", 
"2021-03-27 15:00:00", "2021-10-30 15:00:00", "2022-03-26 15:00:00", 
"2022-10-29 15:00:00", "2023-03-25 15:00:00", "2023-10-28 15:00:00", 
"2024-03-30 15:00:00", "2024-10-26 15:00:00", "2025-03-29 15:00:00", 
"2025-10-25 15:00:00", "2026-03-28 15:00:00", "2026-10-24 15:00:00", 
"2027-03-27 15:00:00", "2027-10-30 15:00:00", "2028-03-25 15:00:00", 
"2028-10-28 15:00:00", "2029-03-24 15:00:00", "2029-10-27 15:00:00", 
"2030-03-30 15:00:00", "2030-10-26 15:00:00", "2031-03-29 15:00:00", 
"2031-10-25 15:00:00", "2032-03-27 15:00:00", "2032-10-30 15:00:00", 
"2033-03-26 15:00:00", "2033-10-29 15:00:00", "2034-03-25 15:00:00", 
"2034-10-28 15:00:00", "2035-03-24 15:00:00", "2035-10-27 15:00:00", 
"2036-03-29 15:00:00", "2036-10-25 15:00:00", "2037-03-28 15:00:00"
), offSet = c("36192", "36000", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "36000", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200", "39600", "43200", 
"39600", "43200", "39600", "43200", "39600", "43200", "39600", 
"43200", "39600", "43200", "39600", "43200"), isdst = c("0", 
"0", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "1", "0", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", 
"0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1", "0", 
"1", "0", "1", "0", "1", "0", "1", "0", "1", "0", "1"), TimeZone = c("MAGT", 
"MAGT", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGST", "MAGT", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST")), .Names = c("Magadan", "offSet", "isdst", 
"TimeZone"), row.names = c(NA, -116L), class = "data.frame")
}

"Kamchatka" <- function () {
structure(list(Kamchatka = c("1901-12-14 20:45:52", "1922-11-09 13:25:24", 
"1930-06-20 13:00:00", "1981-03-31 12:00:00", "1981-09-30 11:00:00", 
"1982-03-31 12:00:00", "1982-09-30 11:00:00", "1983-03-31 12:00:00", 
"1983-09-30 11:00:00", "1984-03-31 12:00:00", "1984-09-29 14:00:00", 
"1985-03-30 14:00:00", "1985-09-28 14:00:00", "1986-03-29 14:00:00", 
"1986-09-27 14:00:00", "1987-03-28 14:00:00", "1987-09-26 14:00:00", 
"1988-03-26 14:00:00", "1988-09-24 14:00:00", "1989-03-25 14:00:00", 
"1989-09-23 14:00:00", "1990-03-24 14:00:00", "1991-03-30 14:00:00", 
"1991-09-28 15:00:00", "1992-01-18 15:00:00", "1992-03-28 11:00:00", 
"1992-09-26 10:00:00", "1993-03-27 14:00:00", "1993-09-25 14:00:00", 
"1994-03-26 14:00:00", "1994-09-24 14:00:00", "1995-03-25 14:00:00", 
"1995-09-23 14:00:00", "1996-03-30 14:00:00", "1996-10-26 14:00:00", 
"1997-03-29 14:00:00", "1997-10-25 14:00:00", "1998-03-28 14:00:00", 
"1998-10-24 14:00:00", "1999-03-27 14:00:00", "1999-10-30 14:00:00", 
"2000-03-25 14:00:00", "2000-10-28 14:00:00", "2001-03-24 14:00:00", 
"2001-10-27 14:00:00", "2002-03-30 14:00:00", "2002-10-26 14:00:00", 
"2003-03-29 14:00:00", "2003-10-25 14:00:00", "2004-03-27 14:00:00", 
"2004-10-30 14:00:00", "2005-03-26 14:00:00", "2005-10-29 14:00:00", 
"2006-03-25 14:00:00", "2006-10-28 14:00:00", "2007-03-24 14:00:00", 
"2007-10-27 14:00:00", "2008-03-29 14:00:00", "2008-10-25 14:00:00", 
"2009-03-28 14:00:00", "2009-10-24 14:00:00", "2010-03-27 14:00:00", 
"2010-10-30 14:00:00", "2011-03-26 14:00:00", "2011-10-29 14:00:00", 
"2012-03-24 14:00:00", "2012-10-27 14:00:00", "2013-03-30 14:00:00", 
"2013-10-26 14:00:00", "2014-03-29 14:00:00", "2014-10-25 14:00:00", 
"2015-03-28 14:00:00", "2015-10-24 14:00:00", "2016-03-26 14:00:00", 
"2016-10-29 14:00:00", "2017-03-25 14:00:00", "2017-10-28 14:00:00", 
"2018-03-24 14:00:00", "2018-10-27 14:00:00", "2019-03-30 14:00:00", 
"2019-10-26 14:00:00", "2020-03-28 14:00:00", "2020-10-24 14:00:00", 
"2021-03-27 14:00:00", "2021-10-30 14:00:00", "2022-03-26 14:00:00", 
"2022-10-29 14:00:00", "2023-03-25 14:00:00", "2023-10-28 14:00:00", 
"2024-03-30 14:00:00", "2024-10-26 14:00:00", "2025-03-29 14:00:00", 
"2025-10-25 14:00:00", "2026-03-28 14:00:00", "2026-10-24 14:00:00", 
"2027-03-27 14:00:00", "2027-10-30 14:00:00", "2028-03-25 14:00:00", 
"2028-10-28 14:00:00", "2029-03-24 14:00:00", "2029-10-27 14:00:00", 
"2030-03-30 14:00:00", "2030-10-26 14:00:00", "2031-03-29 14:00:00", 
"2031-10-25 14:00:00", "2032-03-27 14:00:00", "2032-10-30 14:00:00", 
"2033-03-26 14:00:00", "2033-10-29 14:00:00", "2034-03-25 14:00:00", 
"2034-10-28 14:00:00", "2035-03-24 14:00:00", "2035-10-27 14:00:00", 
"2036-03-29 14:00:00", "2036-10-25 14:00:00", "2037-03-28 14:00:00"
), offSet = c("38076", "39600", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "39600", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800", "43200", "46800", 
"43200", "46800", "43200", "46800", "43200", "46800", "43200", 
"46800", "43200", "46800", "43200", "46800"), isdst 