% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-social.R
\name{FirebaseSocial}
\alias{FirebaseSocial}
\title{Social}
\description{
Use social sites for authentication.
}
\examples{
library(shiny)
library(firebase)

# define signin
signin <- modalDialog(
  title = "Login",
  actionButton("google", "Google", icon = icon("google"), class = "btn-danger"),
  actionButton("github", "Github", icon = icon("github")),
  footer = NULL
)

ui <- fluidPage(
  useFirebase()
)

server <- function(input, output) {
  showModal(signin)

  f <- FirebaseSocial$new()

  observeEvent(input$google, {
    f$launch_google()
  })

  observeEvent(input$github, {
    f$launch_github()
  })
}

\dontrun{shinyApp(ui, server)}

}
\section{Super class}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{FirebaseSocial}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_scope}{\code{FirebaseSocial$set_scope()}}
\item \href{#method-launch_google}{\code{FirebaseSocial$launch_google()}}
\item \href{#method-launch_github}{\code{FirebaseSocial$launch_github()}}
\item \href{#method-launch_facebook}{\code{FirebaseSocial$launch_facebook()}}
\item \href{#method-launch_twitter}{\code{FirebaseSocial$launch_twitter()}}
\item \href{#method-clone}{\code{FirebaseSocial$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="delete_user">}\href{../../firebase/html/Firebase.html#method-delete_user}{\code{firebase::Firebase$delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_delete_user">}\href{../../firebase/html/Firebase.html#method-get_delete_user}{\code{firebase::Firebase$get_delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_sign_out">}\href{../../firebase/html/Firebase.html#method-get_sign_out}{\code{firebase::Firebase$get_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_signed_in">}\href{../../firebase/html/Firebase.html#method-get_signed_in}{\code{firebase::Firebase$get_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_signed_up">}\href{../../firebase/html/Firebase.html#method-get_signed_up}{\code{firebase::Firebase$get_signed_up()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="initialize">}\href{../../firebase/html/Firebase.html#method-initialize}{\code{firebase::Firebase$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="is_signed_in">}\href{../../firebase/html/Firebase.html#method-is_signed_in}{\code{firebase::Firebase$is_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="req_sign_in">}\href{../../firebase/html/Firebase.html#method-req_sign_in}{\code{firebase::Firebase$req_sign_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="req_sign_out">}\href{../../firebase/html/Firebase.html#method-req_sign_out}{\code{firebase::Firebase$req_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="set_language_code">}\href{../../firebase/html/Firebase.html#method-set_language_code}{\code{firebase::Firebase$set_language_code()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="sign_out">}\href{../../firebase/html/Firebase.html#method-sign_out}{\code{firebase::Firebase$sign_out()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_scope"></a>}}
\if{latex}{\out{\hypertarget{method-set_scope}{}}}
\subsection{Method \code{set_scope()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$set_scope(scope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{Google scope.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the scope to request from Google.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-launch_google"></a>}}
\if{latex}{\out{\hypertarget{method-launch_google}{}}}
\subsection{Method \code{launch_google()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$launch_google(flow = c("popup", "redirect"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{Authentication flow, either popup or redirect.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launch sign in with Google.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-launch_github"></a>}}
\if{latex}{\out{\hypertarget{method-launch_github}{}}}
\subsection{Method \code{launch_github()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$launch_github(flow = c("popup", "redirect"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{Authentication flow, either popup or redirect.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launch sign in with Github.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-launch_facebook"></a>}}
\if{latex}{\out{\hypertarget{method-launch_facebook}{}}}
\subsection{Method \code{launch_facebook()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$launch_facebook(flow = c("popup", "redirect"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{Authentication flow, either popup or redirect.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launch sign in with Facebook.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-launch_twitter"></a>}}
\if{latex}{\out{\hypertarget{method-launch_twitter}{}}}
\subsection{Method \code{launch_twitter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$launch_twitter(flow = c("popup", "redirect"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow}}{Authentication flow, either popup or redirect.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Launch sign in with Facebook.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseSocial$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
