% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-phone.R
\name{FirebasePhone}
\alias{FirebasePhone}
\title{Phone}
\description{
Use mobile phone numbers to authenticate users.
}
\section{Super classes}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{\link[firebase:FirebaseAuth]{firebase::FirebaseAuth}} -> \code{FirebasePhone}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FirebasePhone$new()}}
\item \href{#method-verify}{\code{FirebasePhone$verify()}}
\item \href{#method-get_recaptcha}{\code{FirebasePhone$get_recaptcha()}}
\item \href{#method-confirm}{\code{FirebasePhone$confirm()}}
\item \href{#method-get_verification}{\code{FirebasePhone$get_verification()}}
\item \href{#method-get_confirmation}{\code{FirebasePhone$get_confirmation()}}
\item \href{#method-clone}{\code{FirebasePhone$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="expose_app">}\href{../../firebase/html/Firebase.html#method-expose_app}{\code{firebase::Firebase$expose_app()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="clear">}\href{../../firebase/html/FirebaseAuth.html#method-clear}{\code{firebase::FirebaseAuth$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="delete_user">}\href{../../firebase/html/FirebaseAuth.html#method-delete_user}{\code{firebase::FirebaseAuth$delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="expose_auth">}\href{../../firebase/html/FirebaseAuth.html#method-expose_auth}{\code{firebase::FirebaseAuth$expose_auth()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_access_token">}\href{../../firebase/html/FirebaseAuth.html#method-get_access_token}{\code{firebase::FirebaseAuth$get_access_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_delete_user">}\href{../../firebase/html/FirebaseAuth.html#method-get_delete_user}{\code{firebase::FirebaseAuth$get_delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_id_token">}\href{../../firebase/html/FirebaseAuth.html#method-get_id_token}{\code{firebase::FirebaseAuth$get_id_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_sign_out">}\href{../../firebase/html/FirebaseAuth.html#method-get_sign_out}{\code{firebase::FirebaseAuth$get_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_in">}\href{../../firebase/html/FirebaseAuth.html#method-get_signed_in}{\code{firebase::FirebaseAuth$get_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_up">}\href{../../firebase/html/FirebaseAuth.html#method-get_signed_up}{\code{firebase::FirebaseAuth$get_signed_up()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="is_signed_in">}\href{../../firebase/html/FirebaseAuth.html#method-is_signed_in}{\code{firebase::FirebaseAuth$is_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="print">}\href{../../firebase/html/FirebaseAuth.html#method-print}{\code{firebase::FirebaseAuth$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_in">}\href{../../firebase/html/FirebaseAuth.html#method-req_sign_in}{\code{firebase::FirebaseAuth$req_sign_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_out">}\href{../../firebase/html/FirebaseAuth.html#method-req_sign_out}{\code{firebase::FirebaseAuth$req_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="request_id_token">}\href{../../firebase/html/FirebaseAuth.html#method-request_id_token}{\code{firebase::FirebaseAuth$request_id_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="set_language_code">}\href{../../firebase/html/FirebaseAuth.html#method-set_language_code}{\code{firebase::FirebaseAuth$set_language_code()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="sign_out">}\href{../../firebase/html/FirebaseAuth.html#method-sign_out}{\code{firebase::FirebaseAuth$sign_out()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$new(
  persistence = c("session", "local", "memory"),
  config_path = "firebase.rds",
  language_code = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persistence}}{How the auth should persit: \code{none}, the user has to sign in at every visit,
\code{session} will only persist in current tab, \code{local} persist even when window is closed.}

\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{language_code}}{Sets the language to use for the UI.
Supported languages are listed \href{https://github.com/firebase/firebaseui-web/blob/master/LANGUAGES.md}{here}.
Set to \code{browser} to use the default browser language of the user.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialiases Firebase Phone

Initialises the Firebase application client-side.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-verify"></a>}}
\if{latex}{\out{\hypertarget{method-verify}{}}}
\subsection{Method \code{verify()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$verify(number, id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{Phone number of the user.}

\item{\code{id}}{Id of the button that triggers verification.
If this is \code{NULL} the user has to go through the recaptcha,
if not \code{NULL} is invisible.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Verify a phhone number
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_recaptcha"></a>}}
\if{latex}{\out{\hypertarget{method-get_recaptcha}{}}}
\subsection{Method \code{get_recaptcha()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_recaptcha()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Results from the recaptcha
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-confirm"></a>}}
\if{latex}{\out{\hypertarget{method-confirm}{}}}
\subsection{Method \code{confirm()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$confirm(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{Confirmation code received by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Confirm a code
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_verification"></a>}}
\if{latex}{\out{\hypertarget{method-get_verification}{}}}
\subsection{Method \code{get_verification()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_verification()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Verification
}

\subsection{Returns}{
A list with a boolean (\code{success}) indicating
whether the operation was successful and a \code{response}
contianing the response from Firebase.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_confirmation"></a>}}
\if{latex}{\out{\hypertarget{method-get_confirmation}{}}}
\subsection{Method \code{get_confirmation()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_confirmation()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Confirmation
}

\subsection{Returns}{
A list with a boolean (\code{success}) indicating
whether the operation was successful and a \code{response}
contianing the response from Firebase.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
