% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logos.r
\name{ggfortify}
\alias{ggfortify}
\title{Convert sequence data to a format suitable for logo plots}
\usage{
ggfortify(data, sequences, treatment = NULL, weight = NULL,
  method = "shannon")
}
\arguments{
\item{data}{data frame with the sequences}

\item{sequences}{variable containing the sequences}

\item{treatment}{co-variate(s) used in collecting sequence data}

\item{weight}{numeric variable of weights}

\item{method}{either "shannon" or "frequency" for Shannon information or relative frequency of element by position.}
}
\value{
data frame with position, element and information value
}
\description{
Convert sequence data to a format suitable for logo plots
}
\examples{
\donttest{
library(ggplot2)
data(sequences)

ggplot(data = ggfortify(sequences, "peptide", treatment = "class")) +
  geom_logo(aes(x = class, y = bits, fill = Water, label = element)) + 
  facet_wrap(~position)
  
ggplot(data = ggfortify(sequences, "peptide", treatment = "class")) +
  geom_logo(aes(x = class, y = bits, fill = Polarity, label = element)) + 
  facet_wrap(~position, ncol = 18) + 
  theme(legend.position = "bottom")
}
}

