% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spraster.R
\name{fortify.Raster}
\alias{fortify.Raster}
\title{Turn a Raster into a data.frame}
\usage{
\method{fortify}{Raster}(model, data = NULL, format = c("wide", "long"),
  ...)
}
\arguments{
\item{model}{A \code{Raster} object}

\item{data}{Unused}

\item{format}{Use 'long' to get values in a single column; otherwise
values are in one column per band.}

\item{...}{Not used by this method}
}
\value{
A data.frame with columns, x and y as coordinates in the projection
  of the Raster,
}
\description{
Like others in the \link[ggplot2]{fortify} family, this method coerces its
input into a \code{data.frame}. Each band in the raster is a column in the data frame,
alongside x and y coordinate columns. This is the format required for input to
\link[ggplot2]{geom_raster}, such that a \code{Raster} object can be passed directly
to geom_raster without a conversion function. Band columns are named band1, band2, band3,
etc., for use in creating a mapping.
}
\examples{
# use with ggplot()
df <- fortify(longlake_osm)
ggplot(df, aes(x, y, fill = band1)) + geom_raster() +
  coord_fixed()
\donttest{
# identical usage with ggraster()
ggraster(longlake_osm, aes(fill = band1))

# use long format to facet by band
dflong <- fortify(longlake_osm, format = "long")
ggplot(dflong, aes(x, y, fill = value)) +
  geom_raster() + facet_wrap(~band) +
  coord_fixed()


# can use on other raster types as well
x <- rosm::osm.raster("gatineau qc")
ggraster(x, aes(fill = band1))
df <- fortify(x, format = "long")
ggplot(df, aes(x, y, fill = value)) +
  geom_raster() + facet_wrap(~band) +
  coord_fixed()
}

}

