% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-map-tile.R
\docType{data}
\name{annotation_map_tile}
\alias{annotation_map_tile}
\alias{GeomMapTile}
\title{Add background OSM tiles}
\format{An object of class \code{GeomMapTile} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.}
\usage{
annotation_map_tile(type = "osm", zoom = NULL, zoomin = -2,
  forcedownload = FALSE, cachedir = NULL, progress = c("text", "none"),
  quiet = TRUE, interpolate = TRUE, data = NULL, mapping = NULL)

GeomMapTile
}
\arguments{
\item{type}{The map type}

\item{zoom}{The zoom level (overrides zoomin)}

\item{zoomin}{Delta on default zoom}

\item{forcedownload}{Re-download cached tiles?}

\item{cachedir}{Specify cache directory}

\item{progress}{Use progress = "none" to suppress progress and zoom output}

\item{quiet}{Use quiet = FALSE to see which URLs are downloaded}

\item{interpolate}{Parameter for raster}

\item{data, mapping}{Specify data and mapping to use this geom with facets}
}
\value{
A ggplot2 layer
}
\description{
Uses \link[rosm]{osm.image} to add background tiles.
}
\examples{
load_longlake_data()

ggplot() +
  annotation_map_tile(zoom = 13, cachedir = system.file("rosm.cache", package = "ggspatial")) +
  geom_sf(data = longlake_waterdf, fill = NA, col = "grey50")

}
\keyword{datasets}
