% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/remote.r
\docType{methods}
\name{remote_add}
\alias{remote_add}
\alias{remote_add,git_repository,character,character-method}
\title{Add a remote to a repo}
\usage{
remote_add(repo, name, url)

\S4method{remote_add}{git_repository,character,character}(repo, name, url)
}
\arguments{
\item{repo}{The repository to add the remote to}

\item{name}{Short name of the remote repository}

\item{url}{URL of the remote repository}
}
\value{
NULL, invisibly
}
\description{
Add a remote to a repo
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Add a remote
remote_add(repo, "playground", "https://example.org/git2r/playground")
remotes(repo)
remote_url(repo, "playground")

## Rename a remote
remote_rename(repo, "playground", "foobar")
remotes(repo)
remote_url(repo, "foobar")

## Remove a remote
remote_remove(repo, "foobar")
remotes(repo)
}
}
\keyword{methods}

