% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob.r
\docType{methods}
\name{hashfile}
\alias{hashfile}
\alias{hashfile,character-method}
\title{Determine the sha from a blob in a file}
\usage{
hashfile(path)

\S4method{hashfile}{character}(path)
}
\arguments{
\item{path}{The path vector with files to hash.}
}
\value{
A vector with the sha for each file in path.
}
\description{
The blob is not written to the object database.
}
\examples{
\dontrun{
## Create a file. NOTE: The line endings from writeLines gives
## LF (line feed) on Unix/Linux and CRLF (carriage return, line feed)
## on Windows. The example use writeChar to have more control.
path <- tempfile()
f <- file(path, "wb")
writeChar("Hello, world!\\n", f, eos = NULL)
close(f)

## Generate hash
hashfile(path)
identical(hashfile(path), hash("Hello, world!\\n"))
}
}
\keyword{methods}
