% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/note.r
\docType{methods}
\name{note_remove}
\alias{note_remove}
\alias{note_remove,git_note-method}
\title{Remove the note for an object}
\usage{
note_remove(note, author = default_signature(note@repo),
  committer = default_signature(note@repo))

\S4method{note_remove}{git_note}(note, author = default_signature(note@repo),
  committer = default_signature(note@repo))
}
\arguments{
\item{note}{The note to remove}

\item{author}{Signature of the notes commit author.}

\item{committer}{Signature of the notes commit committer.}
}
\value{
invisible NULL
}
\description{
Remove the note for an object
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "Commit message 1")


## Create note in default namespace
note_1 <- note_create(commit_1, "Note-1")

## Create note in named (review) namespace
note_2 <- note_create(commit_1, "Note-2", ref="refs/notes/review")

## List notes in default namespace
notes(repo)

## List notes in 'review' namespace
notes(repo, "review")

## Remove notes
note_remove(note_1)
note_remove(note_2)

## List notes in default namespace
notes(repo)

## List notes in 'review' namespace
notes(repo, "review")
}
}
\keyword{methods}

