% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.version.R
\name{get.version}
\alias{get.version}
\title{Get version from date}
\usage{
get.version(pkg, date, patch = c("current", "max"))
}
\arguments{
\item{pkg}{character string with name of target package to load (and install if needed),
need not be in quotes.}

\item{date}{character string  (yyyy-mm-dd), or date value, with the date which determines the
version of the package, and all dependencies, to be loaded (and installed if needed).}

\item{patch}{Either \code{"current"} for the exact current version of the \code{pkg}
at the specified date, or \code{"max"} for the version with the same major and
minor but maximal patch version numbers.}
}
\value{
most recent package version available on requested date (if source
and binary package versions do not match, the most recent of the two versions is returned.
}
\description{
Get version from date
}
\seealso{
\code{\link[=get.R.pkg.date]{get.R.pkg.date()}} for the opposite operation: determining date
for a given version.
}
