% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Fdelta}
\alias{gsw_Fdelta}
\title{Ratio of Absolute to Preformed Salinity, minus 1}
\usage{
gsw_Fdelta(p, longitude, latitude)
}
\arguments{
\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
(S/Sstar)-1 [ unitless ]
}
\description{
Ratio of Absolute to Preformed Salinity, minus 1
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
p <- c(         10,   50,  125,  250,  600, 1000)
latitude <- c(   4,    4,    4,    4,    4,    4)
longitude <- c(188,  188,  188,  188,  188,  188)
r <- gsw_Fdelta(p, longitude, latitude)
stopifnot(all.equal(r/1e-3, c(0.006472309923452, 0.010352848168433, 0.025541937543450,
                              0.104348729347986, 0.218678084205081, 0.365415366571266)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Fdelta.html}
}
