% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_frazil_properties_potential}
\alias{gsw_frazil_properties_potential}
\title{Properties of Frazil ice i.t.o. potential enthalpy}
\usage{
gsw_frazil_properties_potential(SA_bulk, h_pot_bulk, p)
}
\arguments{
\item{SA_bulk}{Absolute Salinity of a combination of seawater and ice [ g/kg ]}

\item{h_pot_bulk}{potential enthalpy of a mixture of seawater and ice [ J/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
a list containing \code{SA_final}, \code{h_final} and \code{w_Ih_final}.
}
\description{
Calculation of Absolute Salinity, Conservative Temperature, and ice mass fraction
based on bulk Absolute Salinity, bulk potential enthalpy, and pressure
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA_bulk <- c(     34.7118,   34.8915,   35.0256,   34.8472,   34.7366,   34.7324)
h_pot_bulk <- c(-4.5544e4, -4.6033e4, -4.5830e4, -4.5589e4, -4.4948e4, -4.4027e4)
p <- c(                 10,        50,       125,       250,       600,      1000)
r <- gsw_frazil_properties_potential(SA_bulk, h_pot_bulk, p)
stopifnot(all.equal(r$SA_final, c(39.098258701462051, 39.343217598625756, 39.434254585716296,
                                  39.159536295126657, 38.820511558004590, 38.542322667924459)))
stopifnot(all.equal(r$CT_final, c(-2.155553336670014, -2.200844802695826, -2.264077329325076,
                                  -2.344567015865174, -2.598559540430464, -2.900814843304696)))
stopifnot(all.equal(r$w_Ih_final, c(0.112190640891586, 0.113150826758543, 0.111797588975174,
                                    0.110122251260246, 0.105199838799201, 0.098850365110330)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_frazil_properties_potential.html}
}
\seealso{
Other things related to enthalpy: 
\code{\link{gsw_CT_from_enthalpy}()},
\code{\link{gsw_dynamic_enthalpy}()},
\code{\link{gsw_enthalpy_CT_exact}()},
\code{\link{gsw_enthalpy_diff}()},
\code{\link{gsw_enthalpy_first_derivatives_CT_exact}()},
\code{\link{gsw_enthalpy_first_derivatives}()},
\code{\link{gsw_enthalpy_ice}()},
\code{\link{gsw_enthalpy_t_exact}()},
\code{\link{gsw_enthalpy}()},
\code{\link{gsw_frazil_properties_potential_poly}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice_poly}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice}()},
\code{\link{gsw_pot_enthalpy_ice_freezing_poly}()},
\code{\link{gsw_pot_enthalpy_ice_freezing}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice}()},
\code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_specvol_first_derivatives}()}
}
\concept{things related to enthalpy}
