% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_frazil_ratios_adiabatic_poly}
\alias{gsw_frazil_ratios_adiabatic_poly}
\title{Ratios of SA, CT and p changes when Frazil Ice Forms (polynomial form)}
\usage{
gsw_frazil_ratios_adiabatic_poly(SA, p, w_Ih)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{w_Ih}{initial mass fraction (ice) / (water + ice)}
}
\value{
a list containing \code{dSA_dCT_frazil}, \code{dSA_dP_frazil} and \code{dCT_dP_frazil}.
}
\description{
Ratios of changes in \code{SA}, \code{CT} and \code{p} that occur
when frazil ice forms due to changes in pressure upon
the mixture of seawater and ice.
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(  34.7118,   34.8915,   35.0256,   34.8472,   34.7366,   34.7324)
p <- c(        10,        50,       125,       250,       600,      1000)
w_Ih <- c(    0.9,      0.84,       0.4,      0.25,      0.05,      0.01)
r <- gsw_frazil_ratios_adiabatic_poly(SA, p, w_Ih)
stopifnot(all.equal(r$dSA_dCT_frazil,
    c(3.035308957896530, 1.932631198810934, 0.613220785586734,
     0.516106221687200, 0.436657158542033, 0.425827675768018)))
stopifnot(all.equal(r$dSA_dP_frazil/1e-6,
    c(-0.197512213108610, -0.133280971893621, -0.045599951957139,
      -0.038820466574251, -0.033548047632788, -0.033352365425407)))
stopifnot(all.equal(r$dCT_dP_frazil/1e-7,
    c(-0.650715350062703, -0.689634794137768, -0.743613932027895,
     -0.752179782823459, -0.768292629045686, -0.783236208526200)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_frazil_ratios_adiabatic_poly.html}
}
