% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_conv1d.R
\name{har_conv1d}
\alias{har_conv1d}
\title{Conv1D}
\usage{
har_conv1d(preprocess = NA, input_size = NA, epochs = 10000L)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{epochs}{maximum number of epochs}
}
\value{
a \code{har_conv1d} object.
}
\description{
Creates a time series prediction object that uses the Conv1D.
It wraps the pytorch library.
}
\examples{
\donttest{
library(daltoolbox)
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- har_conv1d(ts_norm_gminmax(), input_size=4, epochs = 10000L)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
}
