% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcd_hddm.R
\name{hcd_hddm}
\alias{hcd_hddm}
\title{Adapted Hoeffding Drift Detection Method (HDDM) method}
\usage{
hcd_hddm(
  drift_confidence = 0.001,
  warning_confidence = 0.005,
  two_side_option = TRUE
)
}
\arguments{
\item{drift_confidence}{Confidence to the drift}

\item{warning_confidence}{Confidence to the warning}

\item{two_side_option}{Option to monitor error increments and decrements (two-sided) or only increments (one-sided)}
}
\value{
\code{hcp_hddm} object
}
\description{
is a drift detection method based on the Hoeffding’s inequality. HDDM_A uses the average as estimator.  \url{doi:10.1109/TKDE.2014.2345382}.
}
\examples{
library(daltoolbox)
library(harbinger)
library(ggplot2)

set.seed(6)

#loading the example database
data(har_examples)

#Using example 1
dataset <- har_examples$example1
cut_index <- 60
srange <- cut_index:row.names(dataset)[nrow(dataset)]
drift_size <- nrow(dataset[srange,])
dataset[srange, 'serie'] <- dataset[srange, 'serie'] + rnorm(drift_size, mean=0, sd=0.5)
head(dataset)

plot(x=row.names(dataset), y=dataset$serie, type='l')

# setting up time series regression model
model <- hanct_kmeans()

# fitting the model
model <- fit(model, dataset$serie)

# making detection using hact_kmeans
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

# Drift test

drift_evaluation <- data.frame(!(detection$event == dataset$event)) * 1
drift_evaluation[cut_index:nrow(drift_evaluation),] = 1
model <- fit(hcd_hddm(drift_confidence=10^-30), drift_evaluation)
detection_drift <- detect(model, drift_evaluation)

grf <- har_plot(model, dataset$serie, detection_drift)
grf <- grf + ylab("value")
grf <- grf

plot(grf)

}
