% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.VariableAnalysis}
\alias{plot.VariableAnalysis}
\title{Function to plot variable importance.}
\usage{
\method{plot}{VariableAnalysis}(x, ...)
}
\arguments{
\item{x}{(\code{VariableAnalysis}) The variable importance object to plot.
It could be the return of function \code{\link{variable_analysis}}.}

\item{...}{Not used.}
}
\value{
A \code{patchwork} of \code{ggplot2} figure of variable importance
according to multiple metrics.
}
\description{
Display informative and detailed figures of variable importance.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

mod <- isotree_po(
  occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 50,
  sample_rate = 0.8, ndim = 1L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

var_analysis <- variable_analysis(
  model = mod$model,
  pts_occ = mod$pts_occ,
  pts_occ_test = mod$pts_occ_test,
  variables = mod$variables)
plot(var_analysis)
}

}
\seealso{
\code{\link{variable_analysis}}, \code{\link{print.VariableAnalysis}}
}
