% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dt2bib.R
\name{write_dt2bib}
\alias{write_dt2bib}
\title{Export a BibTeX \code{data.table} to a .bib file.}
\usage{
write_dt2bib(dt, file = tempfile(fileext = ".bib"))
}
\arguments{
\item{dt}{\code{data.table}, in the format as returned by \code{\link{read_bib2dt}}.}

\item{file}{character, file path to write the .bib file.}
}
\value{
\code{file} as a character string, invisibly.
}
\description{
The BibTeX \code{data.table} is written to a .bib file.
}
\examples{
# Read from .bib file:
require(journalabbr)
file <- system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
bib <- read_bib2dt(file)

# Write to .bib file:
write_dt2bib(bib, file = tempfile(fileext = ".bib"))

}
